---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 133
  claims_with_evidence: 133
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-noise 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：133 / 133、根拠なし：0
- 優先レビュー（高）
  1. **UT-NOI-022〜059**：FastNoiseLiteクラスのテストケース - 全メソッドのテストカバレッジを確認
  2. **UT-NOI-060〜094**：NoiseTexture2Dクラスのテストケース - スレッド関連のテストに注意
  3. **UT-NOI-095〜122**：NoiseTexture3Dクラスのテストケース - サイズ制限のテストに注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/noise/noise.h` - Noiseクラス定義（抽象基底クラス、仮想関数、ヘルパー構造体）
- E-02: `modules/noise/noise.cpp` - Noiseクラス実装（画像生成、シームレス画像生成、アルファブレンド）
- E-03: `modules/noise/fastnoise_lite.h` - FastNoiseLiteクラス定義（プロパティ、enum定義）
- E-04: `modules/noise/fastnoise_lite.cpp` - FastNoiseLiteクラス実装（setter/getter、ノイズ計算、バインディング）
- E-05: `modules/noise/noise_texture_2d.h` - NoiseTexture2Dクラス定義（Texture2D継承、プロパティ）
- E-06: `modules/noise/noise_texture_2d.cpp` - NoiseTexture2D実装（テクスチャ生成、スレッド処理）
- E-07: `modules/noise/noise_texture_3d.h` - NoiseTexture3Dクラス定義（Texture3D継承、プロパティ）
- E-08: `modules/noise/noise_texture_3d.cpp` - NoiseTexture3D実装（3Dテクスチャ生成、スレッド処理）
- E-09: `modules/noise/editor/noise_editor_plugin.h` - NoiseEditorPluginクラス定義
- E-10: `modules/noise/editor/noise_editor_plugin.cpp` - NoiseEditorPlugin実装（NoisePreview、NoiseEditorInspectorPlugin）
- E-11: `modules/noise/register_types.cpp` - モジュール登録処理

## 3) Claims と根拠の対応（レビューの主戦場）

### Noiseクラス（UT-NOI-001〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_noise_1d/2d/3dは純粋仮想関数 | E-01 (L284-290) | ○ |
| C-02 | get_noise_2dvはget_noise_2dに委譲 | E-01 (L286-287) | ○ |
| C-03 | get_noise_3dvはget_noise_3dに委譲 | E-01 (L289-290) | ○ |
| C-04 | get_imageはp_width/height/depth <= 0でエラー | E-02 (L82) | ○ |
| C-05 | get_imageはFORMAT_L8形式で画像を返す | E-02 (L134, L157) | ○ |
| C-06 | get_imageのp_invert=trueで値が反転 | E-02 (L126-128, L152) | ○ |
| C-07 | get_imageのp_in_3d_space=trueでget_noise_3dを使用 | E-02 (L98, L150) | ○ |
| C-08 | get_imageのp_normalize=trueでmin-max正規化 | E-02 (L87-136) | ○ |
| C-09 | get_imageのp_normalize=falseで[-1,1]を[0,255]変換 | E-02 (L137-159) | ○ |
| C-10 | get_image_3dはTypedArray<Image>を返す | E-02 (L173-182) | ○ |
| C-11 | get_seamless_imageはシームレス画像を生成 | E-02 (L53-59) | ○ |
| C-12 | _get_seamless_imageのp_blend_skirt < 0でエラー | E-01 (L104) | ○ |
| C-13 | _alpha_blendはアルファブレンド計算を行う | E-01 (L250-275), E-02 (L73-79) | ○ |

### FastNoiseLiteクラス（UT-NOI-022〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | コンストラクタでデフォルト値が設定される | E-03 (L97-124), E-04 (L53-77) | ○ |
| C-15 | NoiseType enumに6種類のタイプがある | E-03 (L44-51) | ○ |
| C-16 | set_noise_typeでemit_changedが発行される | E-04 (L84-89) | ○ |
| C-17 | set_seedが_noiseと_domain_warp_noise両方に設定 | E-04 (L95-100) | ○ |
| C-18 | FractalType enumに4種類のタイプがある | E-03 (L53-58) | ○ |
| C-19 | CellularDistanceFunction enumに4種類がある | E-03 (L60-65) | ○ |
| C-20 | CellularReturnType enumに7種類がある | E-03 (L67-75) | ○ |
| C-21 | DomainWarpType enumに3種類がある | E-03 (L77-81) | ○ |
| C-22 | DomainWarpFractalType enumに3種類がある | E-03 (L83-87) | ○ |
| C-23 | get_noise_1dはoffset.xを加算して計算 | E-04 (L304-312) | ○ |
| C-24 | get_noise_2dはoffset.x/yを加算して計算 | E-04 (L318-325) | ○ |
| C-25 | get_noise_3dはoffset.x/y/zを加算して計算 | E-04 (L331-339) | ○ |
| C-26 | domain_warp_enabledでDomainWarpが適用される | E-04 (L306-310, L321-323, L335-337) | ○ |
| C-27 | _convert_domain_warp_fractal_type_enumでenum変換 | E-04 (L35-51) | ○ |
| C-28 | _validate_propertyでcellular関連プロパティを条件付き非表示 | E-04 (L481-488) | ○ |
| C-29 | _validate_propertyでfractal関連プロパティを条件付き非表示 | E-04 (L490-498) | ○ |

### NoiseTexture2Dクラス（UT-NOI-060〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | デフォルトsize=(512,512) | E-05 (L54) | ○ |
| C-31 | set_noiseでchangedシグナルを接続/切断 | E-06 (L224-236) | ○ |
| C-32 | set_widthでp_width <= 0の場合ERR_FAIL_COND | E-06 (L243) | ○ |
| C-33 | set_heightでp_height <= 0の場合ERR_FAIL_COND | E-06 (L252) | ○ |
| C-34 | set_seamless_blend_skirtで範囲チェック(0〜1) | E-06 (L309) | ○ |
| C-35 | has_alphaはfalseを返す | E-05 (L119) | ○ |
| C-36 | get_ridでtexture未作成時にplaceholderを作成 | E-06 (L386-391) | ○ |
| C-37 | _generate_textureでnoiseがnullの場合空のRefを返す | E-06 (L155-161) | ○ |
| C-38 | _generate_textureでseamless=trueの場合get_seamless_imageを使用 | E-06 (L165-166) | ○ |
| C-39 | _generate_textureでcolor_rampが設定されている場合_modulate_with_gradientを呼び出し | E-06 (L170-172) | ○ |
| C-40 | _generate_textureでas_normal_map=trueの場合bump_map_to_normal_mapを呼び出し | E-06 (L173-175) | ○ |
| C-41 | _generate_textureでgenerate_mipmaps=trueの場合generate_mipmapsを呼び出し | E-06 (L176-178) | ○ |
| C-42 | _modulate_with_gradientはRGBA8形式の画像を返す | E-06 (L183-198) | ○ |
| C-43 | デストラクタでtextureのRIDを解放 | E-06 (L43-51) | ○ |
| C-44 | デストラクタでnoise_threadの終了を待機 | E-06 (L48-50) | ○ |
| C-45 | _validate_propertyでas_normal_map=falseの時bump_strengthを非表示 | E-06 (L105-109) | ○ |
| C-46 | _validate_propertyでseamless=falseの時seamless_blend_skirtを非表示 | E-06 (L111-115) | ○ |

### NoiseTexture3Dクラス（UT-NOI-095〜122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | デフォルトwidth/height/depth=64 | E-07 (L52-54) | ○ |
| C-48 | set_widthでp_width <= 0の場合ERR_FAIL_COND | E-08 (L236) | ○ |
| C-49 | set_heightでp_height <= 0の場合ERR_FAIL_COND | E-08 (L245) | ○ |
| C-50 | set_depthでp_depth <= 0の場合ERR_FAIL_COND | E-08 (L254) | ○ |
| C-51 | set_seamless_blend_skirtで範囲チェック(0.05〜1) | E-08 (L288) | ○ |
| C-52 | has_mipmapsはfalseを返す | E-08 (L342-344) | ○ |
| C-53 | get_ridでtexture未作成時に3d_placeholderを作成 | E-08 (L346-352) | ○ |
| C-54 | get_dataでtexture無効の場合空のVectorを返す | E-08 (L354-357) | ○ |
| C-55 | _generate_textureでnoiseがnullの場合空のTypedArrayを返す | E-08 (L142-148) | ○ |
| C-56 | _generate_textureでサイズ超過時にエラー | E-08 (L150) | ○ |
| C-57 | デストラクタでtextureのRIDを解放 | E-08 (L43-51) | ○ |
| C-58 | デストラクタでnoise_threadの終了を待機 | E-08 (L48-50) | ○ |

### エディタプラグイン（UT-NOI-123〜131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | NoiseEditorPluginがadd_inspector_pluginを呼び出す | E-10 (L144-148) | ○ |
| C-60 | get_plugin_nameはNoise::get_class_staticを返す | E-10 (L140-142) | ○ |
| C-61 | NoiseEditorInspectorPlugin::can_handleはNoiseオブジェクトを判定 | E-10 (L122-124) | ○ |
| C-62 | NoiseEditorInspectorPlugin::parse_beginでNoisePreviewを追加 | E-10 (L126-135) | ○ |
| C-63 | NoisePreview::set_noiseでupdate_previewを呼び出す | E-10 (L72-84) | ○ |
| C-64 | NoisePreview::_on_3d_button_pressedでメタデータを設定/削除 | E-10 (L87-93) | ○ |

### モジュール登録（UT-NOI-132〜133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | SCENEレベルでNoise関連クラスを登録 | E-11 (L46-53) | ○ |
| C-66 | NoiseTextureをNoiseTexture2Dに互換マップ | E-11 (L52) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースに対して、ソースコードから根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: エディタプラグイン関連（UT-NOI-123〜131）- UIプレビュー機能のみ
- **1（中リスク）**: スレッド処理関連（_thread_function, _queue_update等）- 並行処理のテストは実行環境依存の可能性あり
- **1（中リスク）**: RenderingServer連携（get_rid, デストラクタ）- サーバーシングルトンのモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Noiseクラスの純粋仮想関数が全てFastNoiseLiteで実装されていることを確認
- [ ] FastNoiseLiteの全NoiseTypeでノイズ値が-1.0〜1.0の範囲に収まることを確認
- [ ] NoiseTexture2D/3Dのサイズ制限（width/height/depth <= 0）が正しくエラー処理されることを確認
- [ ] シームレス画像生成のblend_skirt範囲検証（2D: 0〜1、3D: 0.05〜1）を確認
- [ ] スレッド関連のテストがレースコンディションを考慮していることを確認
- [ ] RenderingServerとの連携テストでモック/スタブの使用を検討
- [ ] emit_changedシグナルが適切なタイミングで発行されることを確認
