---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 121
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-objectdb_profiler単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：121 / 125、根拠なし：4
- 優先レビュー（高）
  1. **UT-ODP-013, UT-ODP-014**：バージョン文字列フォーマットの詳細確認
  2. **UT-ODP-119**：TreeSortAndFilterBar::applyのnull安全性
  3. **UT-ODP-057**：ファイル名重複回避のサフィックス生成ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/objectdb_profiler/snapshot_collector.h` (L35-53)
- E-02: `modules/objectdb_profiler/snapshot_collector.cpp` (L41-176)
- E-03: `modules/objectdb_profiler/register_types.h` (L35-36)
- E-04: `modules/objectdb_profiler/register_types.cpp` (L39-54)
- E-05: `modules/objectdb_profiler/editor/snapshot_data.h` (L37-94)
- E-06: `modules/objectdb_profiler/editor/snapshot_data.cpp` (L42-361)
- E-07: `modules/objectdb_profiler/editor/objectdb_profiler_plugin.h` (L40-65)
- E-08: `modules/objectdb_profiler/editor/objectdb_profiler_plugin.cpp` (L35-66)
- E-09: `modules/objectdb_profiler/editor/objectdb_profiler_panel.h` (L43-103)
- E-10: `modules/objectdb_profiler/editor/objectdb_profiler_panel.cpp` (L58-479)
- E-11: `modules/objectdb_profiler/editor/data_viewers/snapshot_view.h` (L40-55)
- E-12: `modules/objectdb_profiler/editor/data_viewers/snapshot_view.cpp` (L35-68)
- E-13: `modules/objectdb_profiler/editor/data_viewers/summary_view.h` (L41-72)
- E-14: `modules/objectdb_profiler/editor/data_viewers/summary_view.cpp` (L41-274)
- E-15: `modules/objectdb_profiler/editor/data_viewers/class_view.h` (L39-74)
- E-16: `modules/objectdb_profiler/editor/data_viewers/class_view.cpp` (L39-286)
- E-17: `modules/objectdb_profiler/editor/data_viewers/object_view.h` (L40-63)
- E-18: `modules/objectdb_profiler/editor/data_viewers/object_view.cpp` (L38-263)
- E-19: `modules/objectdb_profiler/editor/data_viewers/node_view.h` (L41-86)
- E-20: `modules/objectdb_profiler/editor/data_viewers/node_view.cpp` (L39-276)
- E-21: `modules/objectdb_profiler/editor/data_viewers/refcounted_view.h` (L40-61)
- E-22: `modules/objectdb_profiler/editor/data_viewers/refcounted_view.cpp` (L38-324)
- E-23: `modules/objectdb_profiler/editor/data_viewers/shared_controls.h` (L40-127)
- E-24: `modules/objectdb_profiler/editor/data_viewers/shared_controls.cpp` (L41-241)

## 3) Claims と根拠の対応（レビューの主戦場）

### SnapshotCollector クラス（UT-ODP-001 〜 UT-ODP-016）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SnapshotCollector::initializeでpending_snapshotsクリアとキャプチャ登録 | E-02 (L41-44) | ○ |
| C-02 | SnapshotCollector::deinitializeでキャプチャ解除とクリア | E-02 (L46-49) | ○ |
| C-03 | snapshot_objectsでObjectDBの全オブジェクトをスナップショット | E-02 (L51-126) | ○ |
| C-04 | RefCountedの参照カウント取得 | E-02 (L90-93) | ○ |
| C-05 | Nodeのノード情報取得（name, parent, children） | E-02 (L95-109) | ○ |
| C-06 | 削除済みオブジェクトのスキップ | E-02 (L74-77) | ○ |
| C-07 | EditorInterfaceのスキップ | E-02 (L79-83) | ○ |
| C-08 | スナップショットコンテキストにメモリ情報設定 | E-02 (L115-118) | ○ |
| C-09 | request_prepare_snapshotメッセージ処理 | E-02 (L130-150) | ○ |
| C-10 | request_snapshot_chunkメッセージ処理 | E-02 (L152-163) | ○ |
| C-11 | 最終チャンク後のスナップショット削除 | E-02 (L161-163) | ○ |
| C-12 | 未知メッセージでr_captured=false | E-02 (L164-166) | ○ |
| C-13 | get_godot_version_stringのフォーマット | E-02 (L170-176) | △ |
| C-14 | バージョンハッシュの含有 | E-02 (L171-174) | △ |
| C-15 | SnapshotDataTransportObjectデフォルトコンストラクタ | E-01 (L36-37) | ○ |
| C-16 | SnapshotDataTransportObjectのObjectコンストラクタ | E-01 (L38-39) | ○ |

### SnapshotDataObject クラス（UT-ODP-017 〜 UT-ODP-035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | SceneDebuggerObjectからの構築 | E-06 (L42-91) | ○ |
| C-18 | リソースパスからのロード | E-06 (L51-73) | ○ |
| C-19 | ネストリソースの親先行ロード | E-06 (L57-65) | ○ |
| C-20 | スクリプトプロパティでのプレースホルダ作成 | E-06 (L75-86) | ○ |
| C-21 | _getでのプロパティ取得 | E-06 (L93-105) | ○ |
| C-22 | Metadata/プレフィックスの正規化 | E-06 (L96-98) | ○ |
| C-23 | 存在しないプロパティでfalse | E-06 (L99-101) | ○ |
| C-24 | _get_property_listでのscriptスキップ | E-06 (L107-117) | ○ |
| C-25 | get_node_pathでのパス構築 | E-06 (L123-145) | ○ |
| C-26 | 非Nodeで空文字返却 | E-06 (L124-126) | ○ |
| C-27 | スクリプト付きオブジェクトの名前生成 | E-06 (L157-180) | ○ |
| C-28 | 継承スクリプトチェーンの名前含有 | E-06 (L163-176) | ○ |
| C-29 | is_refcountedでRefCounted判定 | E-06 (L182-184) | ○ |
| C-30 | 非RefCountedでfalse | E-06 (L182-184) | ○ |
| C-31 | is_nodeでNode判定 | E-06 (L186-188) | ○ |
| C-32 | is_classでの継承関係判定 | E-06 (L190-192) | ○ |
| C-33 | get_unique_outbound_references | E-06 (L204-206) | ○ |
| C-34 | get_unique_inbound_references | E-06 (L208-210) | ○ |
| C-35 | _is_read_onlyで常にtrue | E-05 (L75) | ○ |

### GameStateSnapshot クラス（UT-ODP-036 〜 UT-ODP-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | create_refでの圧縮バッファからの生成 | E-06 (L321-355) | ○ |
| C-37 | 解凍失敗でnullptr | E-06 (L329-330) | ○ |
| C-38 | 空配列でnullptr | E-06 (L332-333) | ○ |
| C-39 | 先頭非Dictionaryでnullptr | E-06 (L334-335) | ○ |
| C-40 | recompute_referencesでのoutbound計算 | E-06 (L283-295) | ○ |
| C-41 | recompute_referencesでのinbound計算 | E-06 (L297-302) | ○ |
| C-42 | RefCounted循環参照の検出 | E-06 (L305-318) | ○ |
| C-43 | WeakRefの循環検出除外 | E-06 (L273, L306) | ○ |
| C-44 | _get_outbound_referencesでINT/OBJECT処理 | E-06 (L215-222) | ○ |
| C-45 | Dictionaryからの再帰的参照抽出 | E-06 (L224-232) | ○ |
| C-46 | Arrayからの再帰的参照抽出 | E-06 (L234-241) | ○ |
| C-47 | 存在しないObjectIDの無視 | E-06 (L218-220) | ○ |
| C-48 | デストラクタでの全オブジェクト解放 | E-06 (L357-361) | ○ |

### ObjectDBProfilerPanel クラス（UT-ODP-049 〜 UT-ODP-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタでのUI初期化 | E-10 (L346-429) | ○ |
| C-50 | 既存スナップショットファイルのロード | E-10 (L421-428) | ○ |
| C-51 | set_enabledでボタン活性化 | E-10 (L261-264) | ○ |
| C-52 | set_enabledでボタン非活性化 | E-10 (L261-264) | ○ |
| C-53 | snapshot_preparedでチャンク要求 | E-10 (L85-93) | ○ |
| C-54 | snapshot_chunkでデータ蓄積 | E-10 (L95-104) | ○ |
| C-55 | 全チャンク後のreceive_snapshot呼び出し | E-10 (L106-109) | ○ |
| C-56 | receive_snapshotでファイル保存 | E-10 (L114-141) | ○ |
| C-57 | 重複ファイル名の回避 | E-10 (L124-127) | △ |
| C-58 | キャッシュヒット時の返却 | E-10 (L196-198) | ○ |
| C-59 | キャッシュミス時のファイルロード | E-10 (L200-217) | ○ |
| C-60 | ファイル不存在時のnullptr | E-10 (L206-207) | ○ |
| C-61 | show_snapshotでのスナップショットとdiff表示 | E-10 (L220-230) | ○ |
| C-62 | clear_snapshotでの表示クリア | E-10 (L243-259) | ○ |
| C-63 | ブレイク中の直接スナップショット開始 | E-10 (L62-65) | ○ |
| C-64 | 実行中のブレイク後スナップショット | E-10 (L65-69) | ○ |
| C-65 | _to_mbでのMB変換 | E-10 (L477-479) | ○ |
| C-66 | Renameで編集モード | E-10 (L301-303) | ○ |
| C-67 | Deleteでファイルとリスト削除 | E-10 (L289-299) | ○ |
| C-68 | 有効な名前でのリネーム成功 | E-10 (L334-340) | ○ |
| C-69 | 無効な名前でのリネーム拒否 | E-10 (L328-332) | ○ |

### ObjectDBProfilerPlugin / ObjectDBProfilerDebuggerPlugin クラス（UT-ODP-070 〜 UT-ODP-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | コンストラクタでのデバッガプラグインインスタンス化 | E-08 (L53-55) | ○ |
| C-71 | ENTER_TREEでプラグイン追加 | E-08 (L57-61) | ○ |
| C-72 | EXIT_TREEでプラグイン削除 | E-08 (L62-64) | ○ |
| C-73 | snapshotキャプチャでtrue | E-08 (L35-37) | ○ |
| C-74 | 他キャプチャでfalse | E-08 (L35-37) | ○ |
| C-75 | メッセージのパネル転送 | E-08 (L39-42) | ○ |
| C-76 | パネルnull時のfalse返却 | E-08 (L40) | ○ |
| C-77 | setup_sessionでのパネル作成 | E-08 (L44-51) | ○ |

### SnapshotView クラス（UT-ODP-078 〜 UT-ODP-081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | show_snapshotでのデータ設定 | E-12 (L43-47) | ○ |
| C-79 | clear_snapshotでの子ノードキューフリー | E-12 (L35-41) | ○ |
| C-80 | is_showing_snapshotでの同一性判定 | E-12 (L49-51) | ○ |
| C-81 | _get_children_recursiveでの再帰取得 | E-12 (L53-68) | ○ |

### SnapshotSummaryView クラス（UT-ODP-082 〜 UT-ODP-087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | show_snapshotでの概要blurb生成 | E-14 (L96-122) | ○ |
| C-83 | diff時の両方blurb生成 | E-14 (L104-121) | ○ |
| C-84 | clear_snapshotでのblurbクリア | E-14 (L124-132) | ○ |
| C-85 | _push_node_blurbでの孤児ノード検出 | E-14 (L191-215) | ○ |
| C-86 | _push_refcounted_blurbでの循環参照検出 | E-14 (L217-244) | ○ |
| C-87 | _push_object_blurbでの孤立オブジェクト検出 | E-14 (L246-274) | ○ |

### SnapshotClassView クラス（UT-ODP-088 〜 UT-ODP-094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | show_snapshotでのクラス階層ツリー構築 | E-16 (L63-175) | ○ |
| C-89 | _add_objects_to_class_mapでのクラスマップ構築 | E-16 (L193-217) | ○ |
| C-90 | _class_selectedでのオブジェクトリスト更新 | E-16 (L235-237) | ○ |
| C-91 | _object_selectedでのインスペクタ表示 | E-16 (L219-233) | ○ |
| C-92 | ClassData::instance_countでのカウント | E-16 (L39-47) | ○ |
| C-93 | ClassData::get_recursive_instance_countでの再帰カウント | E-16 (L49-57) | ○ |
| C-94 | get_recursive_instance_countでのキャッシュ利用 | E-16 (L50-51) | ○ |

### SnapshotObjectView クラス（UT-ODP-095 〜 UT-ODP-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | show_snapshotでの全オブジェクトリスト表示 | E-18 (L42-133) | ○ |
| C-96 | _object_selectedでの詳細表示 | E-18 (L156-213) | ○ |
| C-97 | _reference_selectedでの対象選択 | E-18 (L215-229) | ○ |

### SnapshotNodeView クラス（UT-ODP-098 〜 UT-ODP-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | show_snapshotでのノードツリー構築 | E-20 (L43-85) | ○ |
| C-99 | _add_snapshot_to_treeでの孤児ノードグループ化 | E-20 (L152-178) | ○ |
| C-100 | _toggle_diff_modeでのモード切替 | E-20 (L141-144) | ○ |
| C-101 | _add_item_to_treeでの追加ノード緑背景 | E-20 (L208-209) | ○ |
| C-102 | _add_item_to_treeでの削除ノード赤背景 | E-20 (L210-211) | ○ |
| C-103 | 両方存在ノードの背景クリア | E-20 (L201-203) | ○ |
| C-104 | 複数スナップショットでの選択メニュー | E-20 (L134-138) | ○ |

### SnapshotRefCountedView クラス（UT-ODP-105 〜 UT-ODP-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | show_snapshotでのRefCountedフィルタリング | E-22 (L42-141) | ○ |
| C-106 | _insert_dataでの参照カウント計算 | E-22 (L147-186) | ○ |
| C-107 | 循環参照のみ時の赤背景 | E-22 (L179-184) | ○ |
| C-108 | _refcounted_selectedでの詳細パネル表示 | E-22 (L188-311) | ○ |
| C-109 | 重複参照プロパティのマーク | E-22 (L266-286) | ○ |

### TreeSortAndFilterBar クラス（UT-ODP-110 〜 UT-ODP-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | コンストラクタでのUI初期化 | E-24 (L167-186) | ○ |
| C-111 | add_sort_optionでのオプション追加 | E-24 (L199-218) | ○ |
| C-112 | _apply_filterでのフィルタリング | E-24 (L62-104) | ○ |
| C-113 | 子マッチ時の親disabled色 | E-24 (L97-99) | ○ |
| C-114 | _apply_sortでの数値ソート | E-24 (L137-143) | ○ |
| C-115 | _apply_sortでのアルファベットソート | E-24 (L130-136) | ○ |
| C-116 | 降順ソートでのreverse | E-24 (L133-136, L141-143) | ○ |
| C-117 | clear_filterでのクリア | E-24 (L220-222) | ○ |
| C-118 | applyでのソートとフィルタ適用 | E-24 (L234-241) | ○ |
| C-119 | applyでのnull安全 | E-24 (L235-237) | △ |

### その他UI クラス（UT-ODP-120 〜 UT-ODP-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | SpanningHeaderコンストラクタ | E-24 (L41-51) | ○ |
| C-121 | DarkPanelContainerコンストラクタ | E-24 (L53-60) | ○ |
| C-122 | SummaryBlurbコンストラクタ | E-14 (L134-153) | ○ |

### モジュール初期化（UT-ODP-123 〜 UT-ODP-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | SCENE_LEVELでコレクタ初期化 | E-04 (L39-42) | ○ |
| C-124 | EDITOR_LEVELでプラグイン追加 | E-04 (L43-47) | ○ |
| C-125 | SCENE_LEVELでコレクタ終了処理 | E-04 (L50-53) | ○ |

## 4) 不足情報（Unknown / Missing）

### バージョン文字列フォーマット（C-13, C-14）
- GODOT_VERSION_FULL_BUILD、GODOT_VERSION_HASHの定義がcore/version.hにあり、本モジュールからはincludeされているが、実際の値は確認不可
- 候補：core/version.h / core/version_generated.gen.h / ビルド時定義

### ファイル名サフィックス生成（C-57）
- サフィックス生成ロジックは`'0' + i`で実装されているが、10以上の場合の動作が不明
- 候補：テスト時に10回以上の重複を検証

### null安全性（C-119）
- managed_tree->get_root()がnullの場合の動作は実装で明示的に処理されているが、単体テストでの検証が必要
- 候補：モックTreeでの検証

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2 (高) | 循環参照検出（UT-ODP-042, UT-ODP-086, UT-ODP-107） | メモリリーク検出の中核機能であり、誤検出/検出漏れが運用に影響 |
| 1 (中) | ファイルI/O関連（UT-ODP-056 〜 UT-ODP-060） | ファイルシステムの状態に依存するため、環境差異に注意 |
| 1 (中) | 圧縮/解凍処理（UT-ODP-036 〜 UT-ODP-039） | バッファサイズやデータ形式の不整合でクラッシュの可能性 |
| 0 (低) | UI表示関連（UT-ODP-082 〜 UT-ODP-122） | 機能的影響は限定的 |

## 6) レビュアーチェックリスト（最小）

- [ ] 循環参照検出ロジック（_get_rc_cycles）がWeakRefを正しく除外しているか
- [ ] スナップショットの圧縮/解凍が大規模データ（数万オブジェクト）で正しく動作するか
- [ ] ファイル名重複回避ロジックが10回以上の重複に対応できるか
- [ ] マルチスレッド環境でのObjectDB::debug_objectsの安全性
- [ ] リソースキャッシュのメモリ使用量が許容範囲内か
- [ ] エディタ固有機能（TOOLS_ENABLED）の条件分岐が正しく実装されているか
