---
generated_at: 2026-01-23 16:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-raycast 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-RAY-019**: filter_functionのアルファテスト不合格時の動作 - コードは確認できるが、threshold値128の妥当性は要確認
  2. **UT-RAY-071**: _get_jitterのジッターパターン - フレーム番号に応じたパターンの妥当性は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/raycast/lightmap_raycaster_embree.h` - LightmapRaycasterEmbreeクラスの定義
- E-02: `modules/raycast/lightmap_raycaster_embree.cpp` - LightmapRaycasterEmbreeクラスの実装
- E-03: `modules/raycast/static_raycaster_embree.h` - StaticRaycasterEmbreeクラスの定義
- E-04: `modules/raycast/static_raycaster_embree.cpp` - StaticRaycasterEmbreeクラスの実装
- E-05: `modules/raycast/raycast_occlusion_cull.h` - RaycastOcclusionCullクラスの定義
- E-06: `modules/raycast/raycast_occlusion_cull.cpp` - RaycastOcclusionCullクラスの実装
- E-07: `modules/raycast/register_types.h` - モジュール登録関数の宣言
- E-08: `modules/raycast/register_types.cpp` - モジュール登録関数の実装

## 3) Claims と根拠の対応（レビューの主戦場）

### LightmapRaycasterEmbreeクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | intersect(Ray&)は交差時にtrueを返却しgeomIDを設定する | E-02 (line 71-79) | ○ |
| C-02 | intersect(Ray&)は交差なし時にfalseを返却しgeomIDがRTC_INVALID_GEOMETRY_ID | E-02 (line 78) | ○ |
| C-03 | intersect(Vector<Ray>&)は各レイに対して個別にintersectを呼び出す | E-02 (line 81-86) | ○ |
| C-04 | intersect(Vector<Ray>&)は空配列で正常終了する | E-02 (line 81-86: forループが0回実行) | ○ |
| C-05 | add_meshは頂点数が3の倍数でない場合ERR_FAIL_COND | E-02 (line 125) | ○ |
| C-06 | add_meshは頂点数とUV数が一致しない場合ERR_FAIL_COND | E-02 (line 126) | ○ |
| C-07 | add_meshは法線配列が空でなく頂点数と一致しない場合ERR_FAIL_COND | E-02 (line 127) | ○ |
| C-08 | add_meshは法線配列が空の場合も正常に処理される | E-02 (line 140-143: if条件で法線バッファ設定をスキップ) | ○ |
| C-09 | set_mesh_alpha_textureは有効なImageで設定される | E-02 (line 88-95) | ○ |
| C-10 | set_mesh_alpha_textureは無効なImageで何も設定されない | E-02 (line 89: is_valid()とget_size()チェック) | ○ |
| C-11 | commitはrtcCommitSceneを呼び出す | E-02 (line 152-154) | ○ |
| C-12 | set_mesh_filterは指定メッシュをdisableする | E-02 (line 156-162) | ○ |
| C-13 | clear_mesh_filterは全メッシュをenableする | E-02 (line 164-170) | ○ |
| C-14 | AlphaTextureData::sampleはバイリニア補間を行う | E-02 (line 101-116) | ○ |
| C-15 | AlphaTextureData::sampleはCLAMPで境界処理する | E-02 (line 110-111) | ○ |
| C-16 | filter_functionはアルファ>=128で有効 | E-02 (line 62) | ○ |
| C-17 | filter_functionはアルファ<128で無効化 | E-02 (line 62-64) | ○ |
| C-18 | コンストラクタはSSE2設定とデバイス/シーン初期化を行う | E-02 (line 176-185) | ○ |
| C-19 | デストラクタはシーンとデバイスを解放する | E-02 (line 187-195) | ○ |
| C-20 | create_embree_raycasterは新しいインスタンスを生成する | E-02 (line 39-41) | ○ |
| C-21 | make_default_raycasterはcreate_functionを設定する | E-02 (line 43-45) | ○ |

### StaticRaycasterEmbreeクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | intersect(Ray&)は交差時にtrueを返却する | E-04 (line 55-63) | ○ |
| C-23 | intersect(Ray&)は交差なし時にfalseを返却する | E-04 (line 62) | ○ |
| C-24 | intersect(Vector<Ray>&)は各レイに対して個別にintersectを呼び出す | E-04 (line 65-70) | ○ |
| C-25 | add_meshはインデックス配列ありで正常に処理される | E-04 (line 86-89) | ○ |
| C-26 | add_meshはインデックス配列なしで連続インデックスを生成する | E-04 (line 80-85) | ○ |
| C-27 | add_meshはインデックス配列が空で頂点数が3の倍数でない場合ERR_FAIL_COND | E-04 (line 81) | ○ |
| C-28 | commitはrtcCommitSceneを呼び出す | E-04 (line 96-98) | ○ |
| C-29 | set_mesh_filterは指定メッシュをdisableする | E-04 (line 100-106) | ○ |
| C-30 | clear_mesh_filterは全メッシュをenableする | E-04 (line 108-114) | ○ |
| C-31 | コンストラクタは静的デバイスを再利用する | E-04 (line 126-129) | ○ |
| C-32 | デストラクタはシーンを解放する | E-04 (line 134-138) | ○ |
| C-33 | freeは静的デバイスを解放する | E-04 (line 49-53) | ○ |

### RaycastOcclusionCullクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | occluder_allocateはRIDを割り当てる | E-06 (line 196-198) | ○ |
| C-35 | occluder_initializeはOccluderインスタンスを作成する | E-06 (line 200-203) | ○ |
| C-36 | is_occluderは有効なRIDでtrueを返却する | E-06 (line 192-194) | ○ |
| C-37 | occluder_set_meshは頂点とインデックスを設定する | E-06 (line 205-224) | ○ |
| C-38 | occluder_set_meshは無効なRIDでERR_FAIL_NULL | E-06 (line 207) | ○ |
| C-39 | free_occluderはOccluderを削除しRIDを解放する | E-06 (line 226-231) | ○ |
| C-40 | add_scenarioはscenariosにシナリオを追加する | E-06 (line 235-238) | ○ |
| C-41 | add_scenarioは既存RIDでERR_FAIL_COND | E-06 (line 236) | ○ |
| C-42 | remove_scenarioはシナリオを削除する | E-06 (line 240-245) | ○ |
| C-43 | scenario_set_instanceはインスタンスを追加/更新する | E-06 (line 247-296) | ○ |
| C-44 | scenario_remove_instanceはインスタンスをremoved_instancesに追加する | E-06 (line 298-315) | ○ |
| C-45 | add_bufferはbuffersにバッファを追加する | E-06 (line 508-511) | ○ |
| C-46 | remove_bufferはバッファを削除する | E-06 (line 513-516) | ○ |
| C-47 | buffer_set_scenarioはscenario_ridを設定する | E-06 (line 518-522) | ○ |
| C-48 | buffer_set_sizeはバッファをリサイズする | E-06 (line 524-527) | ○ |
| C-49 | buffer_get_ptrは存在しない場合nullptrを返却する | E-06 (line 620-625) | ○ |
| C-50 | buffer_updateはレイキャストとソートを実行する | E-06 (line 594-618) | ○ |
| C-51 | buffer_get_debug_textureはデバッグテクスチャを返却する | E-06 (line 627-630) | ○ |
| C-52 | set_build_qualityは品質を設定し全シナリオをdirtyにする | E-06 (line 634-644) | ○ |
| C-53 | _init_embreeはSSE2設定とデバイス初期化を行う | E-06 (line 646-654) | ○ |
| C-54 | _get_jitterはジッター無効時にゼロベクトルを返却する | E-06 (line 530-532) | ○ |
| C-55 | _get_jitterはバッファサイズ0でゼロベクトルを返却する | E-06 (line 535-537) | ○ |
| C-56 | _get_jitterはフレーム番号に応じたジッターを返却する | E-06 (line 539-580) | △ |
| C-57 | コンストラクタはシングルトンと設定を初期化する | E-06 (line 656-661) | ○ |
| C-58 | デストラクタは全リソースを解放する | E-06 (line 663-673) | ○ |

### RaycastHZBufferクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | clearはバッファをクリアする | E-06 (line 43-54) | ○ |
| C-60 | resizeはバッファをリサイズする | E-06 (line 56-81) | ○ |
| C-61 | resizeはサイズ空でclearを呼び出す | E-06 (line 57-60) | ○ |
| C-62 | resizeは同サイズで早期リターンする | E-06 (line 62-64) | ○ |
| C-63 | update_camera_raysはカメラレイを生成する | E-06 (line 83-105) | ○ |
| C-64 | _generate_camera_raysは透視/正射投影を区別する | E-06 (line 134-145) | ○ |
| C-65 | sort_raysはtfar値をmips[0]に格納する | E-06 (line 161-182) | ○ |
| C-66 | sort_raysは空バッファでERR_FAIL_COND | E-06 (line 162) | ○ |
| C-67 | デストラクタはバッファを解放する | E-06 (line 184-188) | ○ |

### Scenarioクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | updateはシナリオを更新する | E-06 (line 403-476) | ○ |
| C-69 | updateはdirty=falseで早期リターンする | E-06 (line 419-421) | ○ |
| C-70 | raycastはレイキャストを実行する | E-06 (line 488-504) | ○ |
| C-71 | raycastはデバイス未初期化で早期リターンする | E-06 (line 490-491) | ○ |
| C-72 | raycastはシーン未構築で早期リターンする | E-06 (line 494-496) | ○ |
| C-73 | freeはリソースを解放する | E-06 (line 379-394) | ○ |
| C-74 | _transform_vertices_rangeは頂点を変換する | E-06 (line 368-377) | ○ |

### ユーティリティ関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | blerpはバイリニア補間を計算する | E-02 (line 97-99) | ○ |
| C-76 | blerpはtx=0,ty=0でc00を返却する | E-02 (line 98: Math::lerp特性) | ○ |
| C-77 | blerpはtx=1,ty=1でc11を返却する | E-02 (line 98: Math::lerp特性) | ○ |

### モジュール登録関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | initialize_raycast_moduleはSCENEレベルで初期化する | E-08 (line 39-49) | ○ |
| C-79 | initialize_raycast_moduleはSCENE以外で早期リターンする | E-08 (line 40-42) | ○ |
| C-80 | uninitialize_raycast_moduleはリソースを解放する | E-08 (line 51-62) | ○ |
| C-81 | uninitialize_raycast_moduleはSCENE以外で早期リターンする | E-08 (line 52-54) | ○ |

### InstanceID構造体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | hashはmurmur3ハッシュを計算する | E-05 (line 84-87) | ○ |
| C-83 | operator==は同一IDで等価となる | E-05 (line 88-91) | ○ |
| C-84 | operator==は異なるIDで非等価となる | E-05 (line 88-91) | ○ |

### filter_function詳細

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | アルファ閾値128の妥当性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **アルファ閾値128の設計根拠**: `filter_function`内でアルファ値128を閾値として使用しているが、この値の選定理由に関するドキュメントが見つからない
  - 候補：設計書 / コードコメント / Embreeドキュメント

- **ジッターパターンの設計根拠**: `_get_jitter`関数内の9フレームサイクルのジッターパターンおよび0.66の乗数の選定理由
  - 候補：レンダリング設計書 / コードコメント（line 576-579に一部説明あり）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - モジュール登録関数、ユーティリティ関数、InstanceID構造体
- **1: 中リスク** - バッファ管理、メッシュフィルタ機能、ジッター計算
- **2: 高リスク** - レイキャスト交差判定、Embreeリソース管理、マルチスレッド処理

### 高リスク項目の詳細

1. **レイキャスト交差判定（UT-RAY-001〜004, UT-RAY-024〜026）**
   - Embree APIへの依存が高く、Embreeのバージョンアップ時に動作が変わる可能性
   - RTCRayHit構造体のメモリレイアウトに依存

2. **Embreeリソース管理（UT-RAY-020〜021, UT-RAY-033〜036, UT-RAY-070, UT-RAY-075）**
   - リソースリークの可能性
   - デストラクタでのnullチェック漏れ

3. **マルチスレッド処理（UT-RAY-084〜088）**
   - commit_threadの同期処理
   - WorkerThreadPoolとの連携

## 6) レビュアーチェックリスト（最小）

- [ ] Embree4 APIの使用方法が正しいか確認（rtcIntersect1, rtcIntersect16等）
- [ ] メモリアライメント（64バイト）が適切に処理されているか確認
- [ ] マルチスレッド処理でデータ競合がないか確認
- [ ] ERR_FAIL_CONDによるエラー処理が適切か確認
- [ ] リソース解放漏れがないか確認（シーン、デバイス、バッファ）
- [ ] アルファテスト閾値128の妥当性を設計者に確認
- [ ] ジッターパターンの意図を設計者に確認
