---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 90
  claims_with_evidence: 85
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート：modules-text_server_adv 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド定義・実装が存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 85 / 90 = 0.94
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：85 / 90、根拠なし：5
- 優先レビュー（高）
  1. **UT-TSA-049, UT-TSA-050**：find_texture_pos_for_glyphの詳細な動作確認が必要
  2. **UT-TSA-063, UT-TSA-065**：SVGレンダリング関連のテストは実行環境依存の可能性あり
  3. **UT-TSA-085-088**：FontPriorityListの優先度計算ロジックの検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/text_server_adv/text_server_adv.h` - TextServerAdvancedクラス定義
- E-02: `modules/text_server_adv/text_server_adv.cpp` - TextServerAdvanced実装（行1-999）
- E-03: `modules/text_server_adv/script_iterator.h` - ScriptIteratorクラス定義
- E-04: `modules/text_server_adv/script_iterator.cpp` - ScriptIterator実装
- E-05: `modules/text_server_adv/thorvg_svg_in_ot.h` - SVG in OpenType関連定義
- E-06: `modules/text_server_adv/thorvg_svg_in_ot.cpp` - SVG in OpenType実装
- E-07: `modules/text_server_adv/register_types.cpp` - モジュール登録処理

## 3) Claims と根拠の対応（レビューの主戦場）

### TextServerAdvancedクラス - 基本機能
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-TSA-001) | _has_featureがFEATURE_SIMPLE_LAYOUTでtrueを返す | E-02 (line 355-380) | ○ |
| C-02 (UT-TSA-002) | _has_featureがFEATURE_BIDI_LAYOUTでtrueを返す | E-02 (line 355-380) | ○ |
| C-03 (UT-TSA-003) | _has_featureがFEATURE_SHAPINGでtrueを返す | E-02 (line 355-380) | ○ |
| C-04 (UT-TSA-004) | 未定義Featureでfalseを返す | E-02 (line 376-379) | ○ |
| C-05 (UT-TSA-005) | _get_nameが正しい名前を返す | E-02 (line 382-388) | ○ |
| C-06 (UT-TSA-006) | _get_featuresが正しいビットフラグを返す | E-02 (line 390-400) | ○ |

### TextServerAdvancedクラス - RID管理
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 (UT-TSA-007) | _free_ridでフォントRIDが解放される | E-02 (line 402-435) | ○ |
| C-08 (UT-TSA-008) | _free_ridでShapedTextRIDが解放される | E-02 (line 427-434) | ○ |
| C-09 (UT-TSA-009) | 無効なRIDで安全に動作する | E-02 (line 402-435) | ○ |
| C-10 (UT-TSA-010) | _hasがフォントRIDでtrueを返す | E-02 (line 437-440) | ○ |
| C-11 (UT-TSA-011) | _hasがShapedTextRIDでtrueを返す | E-02 (line 437-440) | ○ |
| C-12 (UT-TSA-012) | 存在しないRIDでfalseを返す | E-02 (line 437-440) | ○ |

### TextServerAdvancedクラス - ICUデータ関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 (UT-TSA-013) | _load_support_dataがICUデータをロードする | E-02 (line 442-479) | ○ |
| C-14 (UT-TSA-014) | 存在しないファイルでfalseを返す | E-02 (line 455-458) | ○ |
| C-15 (UT-TSA-015) | 空ファイル名でデフォルトパスを使用 | E-02 (line 454) | ○ |

### TextServerAdvancedクラス - ロケール関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 (UT-TSA-016) | 中国語でサポートデータが必要 | E-02 (line 525-532) | ○ |
| C-17 (UT-TSA-017) | 日本語でサポートデータが必要 | E-02 (line 525-532) | ○ |
| C-18 (UT-TSA-018) | 英語でサポートデータ不要 | E-02 (line 525-532) | ○ |
| C-19 (UT-TSA-019) | アラビア語がRTL | E-02 (line 534-541) | ○ |
| C-20 (UT-TSA-020) | ヘブライ語がRTL | E-02 (line 534-541) | ○ |
| C-21 (UT-TSA-021) | 英語がLTR | E-02 (line 534-541) | ○ |

### TextServerAdvancedクラス - タグ変換
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 (UT-TSA-022) | _name_to_tagがkerningを変換する | E-02 (line 806-813) | ○ |
| C-23 (UT-TSA-023) | _name_to_tagがカスタムタグを処理する | E-02 (line 812) | ○ |
| C-24 (UT-TSA-024) | _tag_to_nameがタグを名前に変換する | E-02 (line 829-839) | ○ |
| C-25 (UT-TSA-025) | _tag_to_nameが未知タグをcustom_形式で返す | E-02 (line 835-838) | ○ |

### TextServerAdvancedクラス - フォントスタイル判定
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 (UT-TSA-026) | boldで700を返す | E-01 (line 419-445) | ○ |
| C-27 (UT-TSA-027) | lightで300を返す | E-01 (line 425-426) | ○ |
| C-28 (UT-TSA-028) | regularで400を返す | E-01 (line 429-430) | ○ |
| C-29 (UT-TSA-029) | 空文字列で400を返す | E-01 (line 444) | ○ |
| C-30 (UT-TSA-030) | condensedで75を返す | E-01 (line 446-466) | ○ |
| C-31 (UT-TSA-031) | expandedで125を返す | E-01 (line 458-459) | ○ |
| C-32 (UT-TSA-032) | 空文字列で100を返す | E-01 (line 465) | ○ |
| C-33 (UT-TSA-033) | italicでtrueを返す | E-01 (line 467-469) | ○ |
| C-34 (UT-TSA-034) | obliqueでtrueを返す | E-01 (line 468) | ○ |
| C-35 (UT-TSA-035) | 通常スタイルでfalseを返す | E-01 (line 467-469) | ○ |

### TextServerAdvancedクラス - サイズ計算
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 (UT-TSA-036) | MSDFフォントでmsdf_source_size*64 | E-01 (line 396-404) | ○ |
| C-37 (UT-TSA-037) | 固定サイズフォントでfixed_size*64 | E-01 (line 399-400) | ○ |
| C-38 (UT-TSA-038) | 通常フォントでp_size*64 | E-01 (line 401-403) | ○ |

### Bitmap Font インターフェース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 (UT-TSA-039) | _bmp_get_nominal_glyphが存在グリフを返す | E-02 (line 114-132) | ○ |
| C-40 (UT-TSA-040) | PUAグリフが処理される | E-02 (line 122-124) | ○ |
| C-41 (UT-TSA-041) | 存在しないグリフでfalse | E-02 (line 125-127) | ○ |
| C-42 (UT-TSA-042) | _bmp_get_glyph_h_advanceがアドバンスを返す | E-02 (line 134-147) | ○ |
| C-43 (UT-TSA-043) | 存在しないグリフで0を返す | E-02 (line 142-144) | ○ |
| C-44 (UT-TSA-044) | _bmp_get_glyph_v_advanceが垂直アドバンスを返す | E-02 (line 149-162) | ○ |
| C-45 (UT-TSA-045) | _bmp_get_glyph_h_kerningがカーニングを返す | E-02 (line 164-176) | ○ |
| C-46 (UT-TSA-046) | 存在しないペアで0を返す | E-02 (line 171-173) | ○ |
| C-47 (UT-TSA-047) | _bmp_get_glyph_extentsがエクステントを返す | E-02 (line 196-214) | ○ |
| C-48 (UT-TSA-048) | _bmp_get_font_h_extentsがメトリクスを返す | E-02 (line 216-228) | ○ |

### テクスチャパッキング
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 (UT-TSA-049) | find_texture_pos_for_glyphが正しい位置を返す | E-02 (line 845-923) | △ |
| C-50 (UT-TSA-050) | 新規テクスチャが自動生成される | E-02 (line 869-920) | △ |

### ScriptIteratorクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 (UT-TSA-051) | 単一スクリプトが正しく検出される | E-04 (line 53-208) | ○ |
| C-52 (UT-TSA-052) | 複数スクリプトが正しく分割される | E-04 (line 53-208) | ○ |
| C-53 (UT-TSA-053) | 絵文字が検出される | E-04 (line 43-51, 95-113) | ○ |
| C-54 (UT-TSA-054) | 空文字列で空の結果 | E-04 (line 64-69) | ○ |
| C-55 (UT-TSA-055) | p_start >= p_lengthの境界処理 | E-04 (line 64-66) | ○ |
| C-56 (UT-TSA-056) | same_scriptが同一スクリプトでtrue | E-04 (line 39-41) | ○ |
| C-57 (UT-TSA-057) | INHERITEDスクリプトが常にtrue | E-04 (line 40) | ○ |
| C-58 (UT-TSA-058) | is_emojiが絵文字でtrue | E-04 (line 43-51) | ○ |
| C-59 (UT-TSA-059) | VS16付きでtrue | E-04 (line 46-47) | ○ |
| C-60 (UT-TSA-060) | VS15付きでfalse | E-04 (line 44-45) | ○ |

### SVG in OpenType関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 (UT-TSA-061) | tvg_svg_in_ot_initが初期化する | E-06 (line 65-69) | ○ |
| C-62 (UT-TSA-062) | tvg_svg_in_ot_freeが解放する | E-06 (line 71-74) | ○ |
| C-63 (UT-TSA-063) | tvg_svg_in_ot_preset_slotがメトリクスを設定 | E-06 (line 116-312) | △ |
| C-64 (UT-TSA-064) | 無効な状態でエラー | E-06 (line 117-119) | ○ |
| C-65 (UT-TSA-065) | tvg_svg_in_ot_renderがレンダリング | E-06 (line 314-367) | △ |
| C-66 (UT-TSA-066) | 未プリセットでエラー | E-06 (line 321-323) | ○ |

### Shelf/ShelfPackTextureクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 (UT-TSA-067) | alloc_shelfが正しい位置を返す | E-01 (line 205-213) | ○ |
| C-68 (UT-TSA-068) | スペース不足で無効な位置 | E-01 (line 206-208) | ○ |
| C-69 (UT-TSA-069) | pack_rectが最適シェルフに配置 | E-01 (line 230-263) | ○ |
| C-70 (UT-TSA-070) | 新規シェルフが自動生成 | E-01 (line 258-261) | ○ |

### フィーチャー登録
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 (UT-TSA-071) | _insert_featureが登録する | E-02 (line 543-551) | ○ |
| C-72 (UT-TSA-072) | _insert_feature_setsが全フィーチャーを登録 | E-02 (line 553-804) | ○ |

### アラビア文字判定関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 (UT-TSA-073) | is_ainがアインでtrue | E-02 (line 271-273) | ○ |
| C-74 (UT-TSA-074) | is_lamがラムでtrue | E-02 (line 304-306) | ○ |
| C-75 (UT-TSA-075) | is_ligatureがラム+アレフでtrue | E-02 (line 341-343) | ○ |
| C-76 (UT-TSA-076) | is_connected_to_prevが接続判定 | E-02 (line 345-348) | ○ |
| C-77 (UT-TSA-077) | is_transparentが透明文字でtrue | E-02 (line 337-339) | ○ |

### XML構築関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 (UT-TSA-078) | construct_xmlがXMLを構築 | E-06 (line 76-114) | ○ |
| C-79 (UT-TSA-079) | viewBoxからemboxを抽出 | E-06 (line 83-87) | ○ |

### GlyphCompare/SystemFontKey
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 (UT-TSA-080) | GlyphCompareがstart順にソート | E-01 (line 806-817) | ○ |
| C-81 (UT-TSA-081) | 同start時はcount順 | E-01 (line 809-812) | ○ |
| C-82 (UT-TSA-082) | SystemFontKey同一比較 | E-01 (line 624-626) | ○ |
| C-83 (UT-TSA-083) | SystemFontKey異なる比較 | E-01 (line 624-626) | ○ |
| C-84 (UT-TSA-084) | SystemFontKeyHasherが同一ハッシュ | E-01 (line 665-686) | ○ |

### FontPriorityList
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 (UT-TSA-085) | operator[]が優先度順に返す | E-01 (line 744-768) | △ |
| C-86 (UT-TSA-086) | sizeがフォント数を返す | E-01 (line 733-735) | ○ |
| C-87 (UT-TSA-087) | カラーフォントが優先される | E-01 (line 737-742) | ○ |
| C-88 (UT-TSA-088) | スクリプト対応フォントが優先 | E-01 (line 741) | ○ |

### フォントデータ取得
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 (UT-TSA-089) | _get_font_dataがフォントデータを返す | E-01 (line 593-600) | ○ |
| C-90 (UT-TSA-090) | LinkedVariationから基底フォント取得 | E-01 (line 595-598) | ○ |

## 4) 不足情報（Unknown / Missing）
- **find_texture_pos_for_glyph (UT-TSA-049, 050)**：テクスチャパッキングの詳細なアルゴリズム検証には追加のテストデータが必要
  - 候補：実際のフォントデータを使用した統合テスト / モックテクスチャでの単体テスト
- **tvg_svg_in_ot_preset_slot/render (UT-TSA-063, 065)**：SVGレンダリングは外部ライブラリ(ThorVG)依存
  - 候補：モックSVGデータでの検証 / 実際のSVGフォントでの統合テスト
- **FontPriorityList (UT-TSA-085)**：複数フォントの優先度計算ロジックの詳細検証
  - 候補：異なる言語・スクリプト設定での検証

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：フィーチャー判定、タグ変換、スタイル判定 - 単純な条件分岐でコード根拠が明確
- **1（中リスク）**：RID管理、ICUデータロード - メモリ管理・ファイルI/Oが関与
- **2（高リスク）**：
  - テクスチャパッキング - 複雑なアルゴリズムで境界条件が多い
  - SVGレンダリング - 外部ライブラリ依存、実行環境による差異の可能性
  - FontPriorityList - 動的な優先度計算でエッジケースが存在する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] UT-TSA-007, 008, 009：RID解放時のメモリリーク・二重解放がないか確認
- [ ] UT-TSA-013, 014, 015：ICUデータロード時のエラーハンドリングが適切か確認
- [ ] UT-TSA-049, 050：テクスチャサイズの上限・下限が適切に設定されているか確認
- [ ] UT-TSA-051-060：ScriptIteratorの括弧スタック・絵文字スタックのメモリ管理を確認
- [ ] UT-TSA-063, 065：SVGレンダリングのエラー時に適切にリソースが解放されるか確認
- [ ] UT-TSA-085-088：FontPriorityListで優先度計算が期待通りに動作するか確認
