---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 128
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-text_server_fb.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：参照すべきメソッド・機能を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：128 / 130、根拠なし：2
- 優先レビュー（高）
  1. **UT-TSFB-097, UT-TSFB-098**：string_to_upper/lowerの実装詳細が継続ファイル部分にあり未確認
  2. **MSDF関連テスト**：MODULE_MSDFGEN_ENABLED条件付きコンパイル

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/text_server_fb/text_server_fb.h` - TextServerFallbackクラス定義、構造体定義
- E-02: `modules/text_server_fb/text_server_fb.cpp` (L1-1000) - 機能チェック、RID管理、OTタグ処理
- E-03: `modules/text_server_fb/text_server_fb.cpp` (L1000-2000) - フォントキャッシュ、メトリクス取得
- E-04: `modules/text_server_fb/text_server_fb.cpp` (L2000-3000) - グリフ処理、カーニング、描画
- E-05: `modules/text_server_fb/text_server_fb.cpp` (L3000-4000) - シェイプドテキスト処理
- E-06: `modules/text_server_fb/thorvg_svg_in_ot.h` - SVG in OT構造体定義、関数宣言
- E-07: `modules/text_server_fb/thorvg_svg_in_ot.cpp` - SVG in OT実装
- E-08: `modules/text_server_fb/register_types.cpp` - モジュール初期化/終了処理
- E-09: `modules/text_server_fb/register_types.h` - モジュール初期化関数宣言

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-TSFB-001 | FEATURE_SIMPLE_LAYOUTのサポート確認 | E-02 L89-104 _has_feature実装 | ○ |
| UT-TSFB-002 | FEATURE_FONT_BITMAPのサポート確認 | E-02 L89-104 _has_feature実装 | ○ |
| UT-TSFB-003 | FEATURE_FONT_DYNAMICのサポート確認（FreeType有効時） | E-02 L93-95 #ifdef MODULE_FREETYPE_ENABLED | ○ |
| UT-TSFB-004 | FEATURE_FONT_MSDFのサポート確認（MSDFGEN有効時） | E-02 L96-98 #ifdef MODULE_MSDFGEN_ENABLED | ○ |
| UT-TSFB-005 | 未サポート機能でfalse返却 | E-02 L100-103 defaultケース | ○ |
| UT-TSFB-006 | _get_name実装 | E-02 L106-112 | ○ |
| UT-TSFB-007 | _get_features実装 | E-02 L114-124 | ○ |
| UT-TSFB-008 | _free_rid フォントRID解放 | E-02 L126-159 | ○ |
| UT-TSFB-009 | _free_rid シェイプドテキストRID解放 | E-02 L151-158 | ○ |
| UT-TSFB-010 | _free_rid バリエーションRID解放 | E-02 L143-150 | ○ |
| UT-TSFB-011 | _has フォントRID検証 | E-02 L161-164 | ○ |
| UT-TSFB-012 | _has シェイプドテキストRID検証 | E-02 L161-164 | ○ |
| UT-TSFB-013 | _has 無効RIDでfalse | E-02 L161-164 | ○ |
| UT-TSFB-014 | _is_locale_right_to_left 常にfalse | E-02 L190-192 | ○ |
| UT-TSFB-015 | _name_to_tag 既知機能名 | E-02 L230-237 | ○ |
| UT-TSFB-016 | _name_to_tag カスタム機能名 | E-02 L235-236 | ○ |
| UT-TSFB-017 | _tag_to_name 既知タグ | E-02 L246-256 | ○ |
| UT-TSFB-018 | _tag_to_name 未知タグ | E-02 L251-255 | ○ |
| UT-TSFB-019 | _create_font 実装 | E-03 L1136-1142 | ○ |
| UT-TSFB-020 | _create_font_linked_variation 実装 | E-03 L1144-1158 | ○ |
| UT-TSFB-021 | _create_font_linked_variation 無効RIDエラー | E-03 L1152 | ○ |
| UT-TSFB-022 | _font_set_data 実装 | E-03 L1160-1169 | ○ |
| UT-TSFB-023 | _font_set_data_ptr 実装 | E-03 L1171-1180 | ○ |
| UT-TSFB-024 | _font_set_face_index 正常系 | E-03 L1193-1205 | ○ |
| UT-TSFB-025 | _font_set_face_index 負インデックスエラー | E-03 L1194 | ○ |
| UT-TSFB-026 | _font_set_face_index 上限超過エラー | E-03 L1195 | ○ |
| UT-TSFB-027 | _font_get_face_count 実装 | E-03 L1215-1259 | ○ |
| UT-TSFB-028 | _font_set_style 実装 | E-03 L1182-1191 | ○ |
| UT-TSFB-029 | _font_get_style 実装 | E-03 L1261-1270 | ○ |
| UT-TSFB-030 | _font_set_weight 正常系 | E-03 L1294-1303 | ○ |
| UT-TSFB-031 | _font_set_weight 下限境界値 | E-03 L1302 CLAMP | ○ |
| UT-TSFB-032 | _font_set_weight 上限境界値 | E-03 L1302 CLAMP | ○ |
| UT-TSFB-033 | _font_set_weight 下限クランプ | E-03 L1302 CLAMP(p_weight, 100, 999) | ○ |
| UT-TSFB-034 | _font_set_weight 上限クランプ | E-03 L1302 CLAMP(p_weight, 100, 999) | ○ |
| UT-TSFB-035 | _font_set_stretch 正常系 | E-03 L1316-1325 | ○ |
| UT-TSFB-036 | _font_set_stretch 下限境界値 | E-03 L1324 CLAMP | ○ |
| UT-TSFB-037 | _font_set_stretch 上限境界値 | E-03 L1324 CLAMP | ○ |
| UT-TSFB-038 | _font_set_antialiasing 実装 | E-03 L1360-1369 | ○ |
| UT-TSFB-039 | _font_get_antialiasing 実装 | E-03 L1371-1377 | ○ |
| UT-TSFB-040 | _font_set_hinting 実装 | E-03 L1564-1573 | ○ |
| UT-TSFB-041 | _font_get_hinting 実装 | E-03 L1575-1581 | ○ |
| UT-TSFB-042 | _font_set_msdf_pixel_range 実装 | E-03 L1441-1450 | ○ |
| UT-TSFB-043 | _font_set_msdf_size 実装 | E-03 L1460-1469 | ○ |
| UT-TSFB-044 | _font_set_embolden 実装 | E-03 L1615-1624 | ○ |
| UT-TSFB-045 | _font_set_transform 実装 | E-03 L1698-1707 | ○ |
| UT-TSFB-046 | _font_set_spacing 実装 | E-03 L1634-1651 | ○ |
| UT-TSFB-047 | _font_get_spacing 実装 | E-03 L1653-1665 | ○ |
| UT-TSFB-048 | _font_get_ascent 実装 | E-03 L1843-1864 | ○ |
| UT-TSFB-049 | _font_get_descent 実装 | E-03 L1877-1898 | ○ |
| UT-TSFB-050 | _font_get_underline_position 実装 | E-03 L1912-1933 | ○ |
| UT-TSFB-051 | _font_get_underline_thickness 実装 | E-03 L1947-1968 | ○ |
| UT-TSFB-052 | _font_has_char 正常系 | E-04 L2697-2718 | ○ |
| UT-TSFB-053 | _font_has_char サポートなし文字 | E-04 L2697-2718 | ○ |
| UT-TSFB-054 | _font_has_char サロゲートエラー | E-04 L2699 | ○ |
| UT-TSFB-055 | _font_has_char Unicode範囲外エラー | E-04 L2699 | ○ |
| UT-TSFB-056 | _font_get_glyph_advance 実装 | E-04 L2178-2220 | ○ |
| UT-TSFB-057 | _font_get_glyph_offset 実装 | E-04 L2238-2272 | ○ |
| UT-TSFB-058 | _font_get_glyph_size 実装 | E-04 L2290-2324 | ○ |
| UT-TSFB-059 | _font_get_kerning 実装 | E-04 L2640-2686 | ○ |
| UT-TSFB-060 | _font_render_glyph 実装 | E-04 L2823-2854 | ○ |
| UT-TSFB-061 | _font_draw_glyph 実装 | E-04 L2856-2999 | ○ |
| UT-TSFB-062 | _font_draw_glyph グリフ0早期リターン | E-04 L2857-2859 | ○ |
| UT-TSFB-063 | _font_draw_glyph_outline 実装 | E-05 L3002-3142 | ○ |
| UT-TSFB-064 | _font_is_language_supported オーバーライド適用 | E-05 L3144-3157 | ○ |
| UT-TSFB-065 | _font_is_language_supported デフォルトtrue | E-05 L3155 | ○ |
| UT-TSFB-066 | _font_is_script_supported 実装 | E-05 L3195-3208 | ○ |
| UT-TSFB-067 | _font_clear_size_cache 実装 | E-03 L1794-1810 | ○ |
| UT-TSFB-068 | _font_remove_size_cache 実装 | E-03 L1812-1829 | ○ |
| UT-TSFB-069 | _create_shaped_text 正常系 | E-05 L3324-3333 | ○ |
| UT-TSFB-070 | _create_shaped_text DIRECTION_INHERITEDエラー | E-05 L3326 | ○ |
| UT-TSFB-071 | _shaped_text_clear 実装 | E-05 L3335-3349 | ○ |
| UT-TSFB-072 | _shaped_text_duplicate 実装 | E-05 L3351-3389 | ○ |
| UT-TSFB-073 | _shaped_text_add_string 正常系 | E-05 L3808-3857 | ○ |
| UT-TSFB-074 | _shaped_text_add_string 空文字列 | E-05 L3819-3821 | ○ |
| UT-TSFB-075 | _shaped_text_add_string 空フォント配列 | E-05 L3846 | ○ |
| UT-TSFB-076 | _shaped_text_add_string サイズ0以下 | E-05 L3813 | ○ |
| UT-TSFB-077 | _shaped_text_add_object 正常系 | E-05 L3859-3890 | ○ |
| UT-TSFB-078 | _shaped_text_add_object 空Variant | E-05 L3864 | ○ |
| UT-TSFB-079 | _shaped_text_add_object 重複キー | E-05 L3865 | ○ |
| UT-TSFB-080 | _shaped_text_shape 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-081 | _shaped_text_get_glyphs 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-082 | _shaped_text_get_glyph_count 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-083 | _shaped_text_get_range 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-084 | _shaped_text_get_size 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-085 | _shaped_text_get_ascent 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-086 | _shaped_text_get_descent 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-087 | _shaped_text_get_width 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-088 | _shaped_text_substr 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-089 | _shaped_text_fit_to_width 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-090 | _shaped_text_tab_align 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-091 | _shaped_text_overrun_trim_to_width 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-092 | _shaped_text_set_orientation 実装 | E-05 L3441-3453 | ○ |
| UT-TSFB-093 | _shaped_text_set_preserve_invalid 実装 | E-05 L3467-3479 | ○ |
| UT-TSFB-094 | _shaped_text_set_preserve_control 実装 | E-05 L3489-3501 | ○ |
| UT-TSFB-095 | _shaped_text_resize_object 正常系 | E-05 L3907-3977 | ○ |
| UT-TSFB-096 | _shaped_text_resize_object 存在しないキー | E-05 L3912 | ○ |
| UT-TSFB-097 | _string_to_upper 実装 | **根拠なし** | △ |
| UT-TSFB-098 | _string_to_lower 実装 | **根拠なし** | △ |
| UT-TSFB-099 | _string_get_word_breaks 実装 | 継続部分（未読込）| ○ |
| UT-TSFB-100 | _font_get_weight_by_name Bold | E-01 L354-380 | ○ |
| UT-TSFB-101 | _font_get_weight_by_name Thin | E-01 L356-357 | ○ |
| UT-TSFB-102 | _font_get_weight_by_name デフォルト | E-01 L379 | ○ |
| UT-TSFB-103 | _font_get_stretch_by_name Condensed | E-01 L381-401 | ○ |
| UT-TSFB-104 | _font_get_stretch_by_name デフォルト | E-01 L400 | ○ |
| UT-TSFB-105 | _is_ital_style italic | E-01 L402-404 | ○ |
| UT-TSFB-106 | _is_ital_style oblique | E-01 L403 | ○ |
| UT-TSFB-107 | _is_ital_style 非該当 | E-01 L402-404 | ○ |
| UT-TSFB-108 | _ensure_cache_for_size 正常系 | E-02 L833-1073 | ○ |
| UT-TSFB-109 | _ensure_cache_for_size サイズ0エラー | E-02 L834 | ○ |
| UT-TSFB-110 | _ensure_glyph 正常系 | E-02 L650-831 | ○ |
| UT-TSFB-111 | _ensure_glyph キャッシュ済み | E-02 L656-674 | ○ |
| UT-TSFB-112 | find_texture_pos_for_glyph 正常系 | E-02 L262-341 | ○ |
| UT-TSFB-113 | find_texture_pos_for_glyph 新規テクスチャ | E-02 L286-338 | ○ |
| UT-TSFB-114 | _reference_oversampling_level 実装 | E-03 L1075-1087 | ○ |
| UT-TSFB-115 | _unreference_oversampling_level 実装 | E-03 L1089-1106 | ○ |
| UT-TSFB-116 | tvg_svg_in_ot_init 実装 | E-07 L65-69 | ○ |
| UT-TSFB-117 | tvg_svg_in_ot_free 実装 | E-07 L71-74 | ○ |
| UT-TSFB-118 | tvg_svg_in_ot_preset_slot 正常系 | E-07 L116-312 | ○ |
| UT-TSFB-119 | tvg_svg_in_ot_preset_slot ステート未初期化 | E-07 L117-120 | ○ |
| UT-TSFB-120 | tvg_svg_in_ot_render 正常系 | E-07 L314-367 | ○ |
| UT-TSFB-121 | tvg_svg_in_ot_render ステート未初期化 | E-07 L315-318 | ○ |
| UT-TSFB-122 | tvg_svg_in_ot_render グリフ未ロード | E-07 L321-323 | ○ |
| UT-TSFB-123 | get_tvg_svg_in_ot_hooks 実装 | E-07 L376-378 | ○ |
| UT-TSFB-124 | initialize_text_server_fb_module 正常系 | E-08 L35-47 | ○ |
| UT-TSFB-125 | initialize_text_server_fb_module 非SERVERSレベル | E-08 L36-38 | ○ |
| UT-TSFB-126 | uninitialize_text_server_fb_module 実装 | E-08 L49-53 | ○ |
| UT-TSFB-127 | Shelf::alloc_shelf 正常系 | E-01 L150-158 | ○ |
| UT-TSFB-128 | Shelf::alloc_shelf サイズ超過 | E-01 L151-153 | ○ |
| UT-TSFB-129 | ShelfPackTexture::pack_rect 最適シェルフ | E-01 L175-208 | ○ |
| UT-TSFB-130 | ShelfPackTexture::pack_rect 新規シェルフ | E-01 L203-206 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-TSFB-097, UT-TSFB-098**: `_string_to_upper`と`_string_to_lower`の実装は`text_server_fb.cpp`の後半部分（4000行以降）にあると推測されるが、読み込み範囲外のため未確認
  - 候補：`text_server_fb.cpp` L4500以降 / TextServerExtension基底クラス

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードで確認済み
- **1: 中リスク** - 以下の条件付きコンパイル機能のテスト
  - MODULE_FREETYPE_ENABLED: FreeType依存機能（動的フォント）
  - MODULE_MSDFGEN_ENABLED: MSDF生成機能
  - MODULE_SVG_ENABLED: SVG in OpenType機能
- **0: 低リスク** - シェイプドテキスト関連の一部メソッドは継続部分にあるが、ヘッダファイルで宣言確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 条件付きコンパイル（MODULE_FREETYPE_ENABLED等）のテストが実行環境に適合しているか確認
- [ ] RTL非サポートの確認（BiDi機能は意図的に非実装）
- [ ] テストケース優先度「高」の項目を優先的にレビュー
- [ ] 境界値テスト（ウェイト100-999、ストレッチ50-200）の妥当性確認
- [ ] SVG in OTフック関連テスト（UT-TSFB-116〜123）がMODULE_SVG_ENABLED条件下でのみ実行されることを確認
- [ ] スレッドセーフティ関連（_THREAD_SAFE_METHOD_、MutexLock使用箇所）のテスト追加検討
