---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 116
  claims_with_evidence: 112
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-theora 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 116、根拠なし：4
- 優先レビュー（高）
  1. **UT-THE-040（PP レベル動的調整）**：アルゴリズム詳細が不明
  2. **UT-THE-034（delay_compensation）**：AudioServer連携の詳細が未確認
  3. **UT-THE-105, UT-THE-106（ilog関数）**：使用箇所が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/theora/video_stream_theora.h` - VideoStreamPlaybackTheora クラス定義
- E-02: `modules/theora/video_stream_theora.cpp` - VideoStreamPlaybackTheora 実装
- E-03: `modules/theora/register_types.h` - モジュール登録関数宣言
- E-04: `modules/theora/register_types.cpp` - モジュール登録関数実装
- E-05: `modules/theora/editor/movie_writer_ogv.h` - MovieWriterOGV クラス定義
- E-06: `modules/theora/editor/movie_writer_ogv.cpp` - MovieWriterOGV 実装
- E-07: `modules/theora/editor/rgb2yuv.h` - RGB/YUV 変換関数
- E-08: libtheora API ドキュメント（外部参照）
- E-09: libvorbis API ドキュメント（外部参照）
- E-10: libogg API ドキュメント（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）

### VideoStreamPlaybackTheora クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | buffer_data: 4096バイト読み込み | E-02 L39-45 | ○ |
| C-02 | buffer_data: EOF処理 | E-02 L39-45 | ○ |
| C-03 | queue_page: ページ追加 | E-02 L47-59 | ○ |
| C-04 | queue_page: EOS検出 | E-02 L49-56 | ○ |
| C-05 | read_page: ページ読み込み | E-02 L61-75 | ○ |
| C-06 | read_page: EOF時0返却 | E-02 L68-70 | ○ |
| C-07 | get_page_time: Theora時間取得 | E-02 L77-90 | ○ |
| C-08 | get_page_time: Vorbis時間取得 | E-02 L85-87 | ○ |
| C-09 | get_page_time: 不明ストリーム | E-02 L77-90 | ○ |
| C-10 | feed_pages: ページ供給 | E-02 L93-111 | ○ |
| C-11 | feed_pages: 空バッファ | E-02 L102-106 | ○ |
| C-12 | seek_streams: 指定時間シーク | E-02 L115-232 | ○ |
| C-13 | seek_streams: 時間0シーク | E-02 L115-232 | ○ |
| C-14 | seek_streams: p_time=-1処理 | E-02 L127-131 | ○ |
| C-15 | seek_streams: シーク失敗 | E-02 L168-172 | ○ |
| C-16 | video_write: YUV420変換 | E-02 L234-255, L246-248 | ○ |
| C-17 | video_write: YUV422変換 | E-02 L243-245 | ○ |
| C-18 | video_write: YUV444変換 | E-02 L240-242 | ○ |
| C-19 | clear: リソース解放 | E-02 L257-285 | ○ |
| C-20 | clear: 音声バッファ解放 | E-02 L267-269 | ○ |
| C-21 | clear: 初期化前呼び出し | E-02 L258-260 | ○ |
| C-22 | find_streams: Theora検出 | E-02 L287-337, L314-317 | ○ |
| C-23 | find_streams: Vorbis検出 | E-02 L318-330 | ○ |
| C-24 | find_streams: マルチトラック | E-02 L292, L320-326 | ○ |
| C-25 | find_streams: 不明コーデック | E-02 L331-334 | ○ |
| C-26 | read_headers: Theoraヘッダ | E-02 L339-375 | ○ |
| C-27 | read_headers: Vorbisヘッダ | E-02 L355-358 | ○ |
| C-28 | read_headers: 不完全ヘッダ | E-02 L373-374 | ○ |
| C-29 | set_file: ファイル開く | E-02 L377-485 | ○ |
| C-30 | set_file: 再生中拒否 | E-02 L378 | ○ |
| C-31 | set_file: 存在しないファイル | E-02 L383-384 | ○ |
| C-32 | set_file: 映像なし拒否 | E-02 L415-424 | ○ |
| C-33 | set_file: stream_length計算 | E-02 L476-482 | ○ |
| C-34 | get_time: delay_compensation | E-02 L487-492 | ○ |
| C-35 | get_texture: テクスチャ返却 | E-02 L494-496 | ○ |
| C-36 | update: 時間進行 | E-02 L498-613, L507 | ○ |
| C-37 | update: 一時停止処理 | E-02 L503-505 | ○ |
| C-38 | update: ファイルなし | E-02 L499-501 | ○ |
| C-39 | update: EOS停止 | E-02 L597-600 | ○ |
| C-40 | update: PP レベル調整 | E-02 L588-594 | △ |
| C-41 | play: 再生開始 | E-02 L615-623 | ○ |
| C-42 | play: 冪等性 | E-02 L616-618 | ○ |
| C-43 | play: delay_compensation読込 | E-02 L621-622 | ○ |
| C-44 | stop: 停止処理 | E-02 L625-628 | ○ |
| C-45 | is_playing: 状態取得 | E-02 L630-632 | ○ |
| C-46 | set_paused: 一時停止設定 | E-02 L634-636 | ○ |
| C-47 | is_paused: 状態取得 | E-02 L638-640 | ○ |
| C-48 | get_length: 長さ取得 | E-02 L642-644 | ○ |
| C-49 | get_playback_position: 位置取得 | E-02 L646-648 | ○ |
| C-50 | seek: シーク | E-02 L650-768 | ○ |
| C-51 | seek: 範囲外シーク | E-02 L654-656 | ○ |
| C-52 | seek: ファイルなし | E-02 L651-653 | ○ |
| C-53 | seek: シーク後描画 | E-02 L756-767 | ○ |
| C-54 | get_channels: チャンネル数 | E-02 L770-772 | ○ |
| C-55 | set_audio_track: トラック設定 | E-02 L774-776 | ○ |
| C-56 | get_mix_rate: サンプルレート | E-02 L778-780 | ○ |
| C-57 | send_audio: 音声送信 | E-01 L115-127 | ○ |
| C-58 | send_audio: 部分送信 | E-01 L122-124 | ○ |
| C-59 | コンストラクタ: テクスチャ初期化 | E-02 L782-784 | ○ |
| C-60 | デストラクタ: clear呼び出し | E-02 L786-788 | ○ |

### VideoStreamTheora クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | instantiate_playback: 生成 | E-01 L163-168 | ○ |
| C-62 | instantiate_playback: audio_track設定 | E-01 L165 | ○ |
| C-63 | set_audio_track: 設定 | E-01 L170 | ○ |
| C-64 | コンストラクタ: 初期化 | E-01 L172 | ○ |

### ResourceFormatLoaderTheora クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | load: OGVロード | E-02 L792-811 | ○ |
| C-66 | load: エラー処理 | E-02 L794-799 | ○ |
| C-67 | get_recognized_extensions: ogv | E-02 L813-815 | ○ |
| C-68 | handles_type: VideoStream | E-02 L817-819 | ○ |
| C-69 | handles_type: 派生型 | E-02 L818 | ○ |
| C-70 | handles_type: 無関係型 | E-02 L818 | ○ |
| C-71 | get_resource_type: ogv | E-02 L821-826 | ○ |
| C-72 | get_resource_type: 非対応 | E-02 L825 | ○ |

### MovieWriterOGV クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | push_audio: Vorbis供給 | E-06 L37-51 | ○ |
| C-74 | push_audio: 正規化 | E-06 L45 | ○ |
| C-75 | push_audio: デインターリーブ | E-06 L43-48 | ○ |
| C-76 | pull_audio: パケット生成 | E-06 L53-71 | ○ |
| C-77 | pull_audio: EOS処理 | E-06 L67-70 | ○ |
| C-78 | push_video: RGBA変換 | E-06 L73-81, L76 | ○ |
| C-79 | push_video: RGB変換 | E-06 L78 | ○ |
| C-80 | push_video: Theora供給 | E-06 L80 | ○ |
| C-81 | pull_video: パケット追加 | E-06 L83-93 | ○ |
| C-82 | pull_video: EOS設定 | E-06 L88 | ○ |
| C-83 | get_audio_mix_rate: 取得 | E-06 L95-97 | ○ |
| C-84 | get_audio_speaker_mode: 取得 | E-06 L99-101 | ○ |
| C-85 | handles_file: ogv | E-06 L103-105 | ○ |
| C-86 | handles_file: 非対応 | E-06 L104 | ○ |
| C-87 | get_supported_extensions: ogv | E-06 L107-109 | ○ |
| C-88 | write_begin: 初期化 | E-06 L111-309 | ○ |
| C-89 | write_begin: 奇数幅エラー | E-06 L112 | ○ |
| C-90 | write_begin: 奇数高さエラー | E-06 L112 | ○ |
| C-91 | write_begin: ファイルエラー | E-06 L119-120 | ○ |
| C-92 | write_begin: パス正規化 | E-06 L113-117 | ○ |
| C-93 | write_begin: チャンネル数 | E-06 L124-138 | ○ |
| C-94 | write_begin: バッファ初期化 | E-06 L166-184 | ○ |
| C-95 | write_frame: フレーム書込 | E-06 L315-331 | ○ |
| C-96 | write_frame: 未初期化エラー | E-06 L316 | ○ |
| C-97 | write_frame: 定期フラッシュ | E-06 L323-325 | ○ |
| C-98 | save_page: バックアップ | E-06 L333-345 | ○ |
| C-99 | save_page: リアロケート | E-06 L335-337 | ○ |
| C-100 | restore_page: 復元 | E-06 L347-352 | ○ |
| C-101 | write_to_file: インターリーブ | E-06 L357-394 | ○ |
| C-102 | write_to_file: 終了フラッシュ | E-06 L369-387 | ○ |
| C-103 | write_end: リソース解放 | E-06 L396-423 | ○ |
| C-104 | write_end: 最終パケット | E-06 L397-399 | ○ |
| C-105 | ilog: 対数計算 | E-05 L118-124 | △ |
| C-106 | ilog: ゼロケース | E-05 L118-124 | △ |
| C-107 | コンストラクタ: 設定読込 | E-06 L425-432 | ○ |

### rgb2yuv 関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | rgb2yuv420: 変換 | E-07 L70-72 | ○ |
| C-109 | rgb2yuv420: Y計算 | E-07 L48 | ○ |
| C-110 | rgb2yuv420: サブサンプリング | E-07 L42-67 | ○ |
| C-111 | rgba2yuv420: 変換 | E-07 L74-76 | ○ |
| C-112 | _rgb2yuv420: 最小サイズ | E-07 L39-68 | ○ |

### モジュール初期化/終了

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | initialize: SCENE登録 | E-04 L55-59 | ○ |
| C-114 | initialize: SERVERS登録 | E-04 L47-52 | ○ |
| C-115 | uninitialize: SCENE解除 | E-04 L67-70 | ○ |
| C-116 | uninitialize: SERVERS削除 | E-04 L72-77 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-40 (PP レベル動的調整)**：Theoraの後処理レベル調整の詳細アルゴリズムは外部ライブラリに依存しており、具体的な閾値の妥当性は libtheora のドキュメントを参照する必要がある
  - 候補：libtheora ドキュメント / Theora仕様書

- **C-105, C-106 (ilog関数)**：この関数はヘッダファイルで定義されているが、MovieWriterOGVの実装内で直接使用されている箇所が見当たらない。Ogg bitstream の granulepos 計算に関連している可能性があるが、使用箇所の確認が必要
  - 候補：libogg 実装 / Ogg 仕様書

- **delay_compensation の詳細**：AudioServerとの連携部分がコメントアウトされており（E-02 L489-491）、実際の遅延補正の動作確認が必要
  - 候補：AudioServer 実装 / ProjectSettings ドキュメント

## 5) リスクフラグ（レビュー観点）

| リスク | 対象 | 説明 |
|--------|------|------|
| 1 | シーク機能（UT-THE-012〜015, UT-THE-050〜053） | 複雑なアルゴリズムでバックトラッキングを含む。エッジケースでの動作確認が重要 |
| 1 | 音声/映像同期（UT-THE-007〜008, UT-THE-101〜102） | インターリーブ書き込みの時間順序が正しいか確認が必要 |
| 0 | YUV変換（UT-THE-016〜018, UT-THE-108〜112） | 標準的なBT.601変換式を使用、実装は単純 |
| 1 | メモリ管理（UT-THE-019〜021, UT-THE-103） | 複数のリソース解放パスがあり、リーク/二重解放の可能性を確認 |
| 0 | ファイルI/O（UT-THE-029〜032, UT-THE-065〜066） | 標準的なエラーハンドリング |

## 6) レビュアーチェックリスト（最小）

- [ ] シーク機能（seek_streams, seek）のエッジケース（ファイル先頭、終端、キーフレーム間隔）が網羅されているか
- [ ] 音声なしファイル（has_audio=false）のケースが全メソッドで考慮されているか
- [ ] clear() が複数回呼び出されても安全か確認
- [ ] write_begin() の偶数制約エラーメッセージが適切か
- [ ] ilog() 関数の使用箇所と必要性の確認
- [ ] delay_compensation のコメントアウト部分の意図確認
- [ ] YUV変換の色空間（BT.601）がTheoraの想定と一致しているか
