---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 67
  claims_with_evidence: 65
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：modules-tinyexr 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：65 / 67、根拠なし：2
- 優先レビュー（高）
  1. **UT-TEXR-065**：大サイズ画像テストの上限値は推測に基づく
  2. **UT-TEXR-034**：PIZ圧縮の内部動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/tinyexr/image_loader_tinyexr.h` - ImageLoaderTinyEXRクラス定義
- E-02: `modules/tinyexr/image_loader_tinyexr.cpp` - EXR読み込み実装（load_image, get_recognized_extensions, _tinyexr_mem_loader_func）
- E-03: `modules/tinyexr/image_saver_tinyexr.h` - save_exr, save_exr_buffer関数宣言
- E-04: `modules/tinyexr/image_saver_tinyexr.cpp` - EXR保存実装（save_exr, save_exr_buffer, is_supported_format, get_source_pixel_type, get_target_pixel_type, get_pixel_type_size, get_channel_count）
- E-05: `modules/tinyexr/register_types.cpp` - モジュール初期化・終了処理（initialize_tinyexr_module, uninitialize_tinyexr_module）
- E-06: `modules/tinyexr/register_types.h` - モジュール関数宣言

## 3) Claims と根拠の対応（レビューの主戦場）

### ImageLoaderTinyEXR::load_image関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-TEXR-001) | RGBA形式のEXRファイルが正常に読み込めること | E-02 (L94-142: チャンネル検出とフォーマット決定ロジック) | ○ |
| C-02 (UT-TEXR-002) | RGB形式のEXRファイルが正常に読み込めること | E-02 (L126-131: idxB != -1の条件分岐) | ○ |
| C-03 (UT-TEXR-003) | RG形式のEXRファイルが正常に読み込めること | E-02 (L132-136: idxG != -1の条件分岐) | ○ |
| C-04 (UT-TEXR-004) | R形式のEXRファイルが正常に読み込めること | E-02 (L137-142: else分岐でR形式処理) | ○ |
| C-05 (UT-TEXR-005) | Yチャンネルのマッピング処理 | E-02 (L108-112: "Y"チャンネルをR,G,Bにマッピング) | ○ |
| C-06 (UT-TEXR-006) | HALF精度のEXRがFLOAT16形式で読み込めること | E-02 (L75-82: use_float16フラグ設定とHALF→FLOAT変換リクエスト) | ○ |
| C-07 (UT-TEXR-007) | FLOAT精度のEXRがFLOAT32形式で読み込めること | E-02 (L76: use_float16のデフォルトfalse) | ○ |
| C-08 (UT-TEXR-008) | タイル形式のEXRファイルが読み込めること | E-02 (L151-169: exr_header.tiledによる分岐処理) | ○ |
| C-09 (UT-TEXR-009) | FLAG_FORCE_LINEARでsRGB→リニア変換 | E-02 (L233-235, L264-266: p_flags & FLAG_FORCE_LINEARによる色変換) | ○ |
| C-10 (UT-TEXR-010) | 空ファイルでERR_FILE_CORRUPT | E-02 (L42: ERR_FAIL_COND_V(src_image_len == 0, ERR_FILE_CORRUPT)) | ○ |
| C-11 (UT-TEXR-011) | 無効なEXRバージョンでERR_FILE_CORRUPT | E-02 (L61-64: ParseEXRVersionFromMemory失敗時) | ○ |
| C-12 (UT-TEXR-012) | 無効なEXRヘッダでERR_FILE_CORRUPT | E-02 (L66-73: ParseEXRHeaderFromMemory失敗時、エラーメッセージ出力) | ○ |
| C-13 (UT-TEXR-013) | 画像データ読み込み失敗でERR_FILE_CORRUPT | E-02 (L85-92: LoadEXRImageFromMemory失敗時) | ○ |
| C-14 (UT-TEXR-014) | Bあり、Gなしでエラー | E-02 (L127: ERR_FAIL_COND_V(idxG == -1, ERR_FILE_CORRUPT)) | ○ |
| C-15 (UT-TEXR-015) | Bあり、Rなしでエラー | E-02 (L128: ERR_FAIL_COND_V(idxR == -1, ERR_FILE_CORRUPT)) | ○ |
| C-16 (UT-TEXR-016) | Gあり、Rなしでエラー | E-02 (L133: ERR_FAIL_COND_V(idxR == -1, ERR_FILE_CORRUPT)) | ○ |
| C-17 (UT-TEXR-017) | RGB全チャンネルなしでエラー | E-02 (L138: ERR_FAIL_COND_V(idxR == -1, ERR_FILE_CORRUPT)) | ○ |

### ImageLoaderTinyEXR::get_recognized_extensions関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 (UT-TEXR-018) | 認識拡張子として"exr"が返ること | E-02 (L292-294: p_extensions->push_back("exr")) | ○ |

### ImageLoaderTinyEXR::コンストラクタ関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 (UT-TEXR-019) | コンストラクタでメモリローダー関数が登録されること | E-02 (L309-311: Image::_exr_mem_loader_func = _tinyexr_mem_loader_func) | ○ |

### _tinyexr_mem_loader_func関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 (UT-TEXR-020) | メモリバッファからEXR画像が読み込めること | E-02 (L296-307: FileAccessMemory経由でload_image呼び出し) | ○ |
| C-21 (UT-TEXR-021) | メモリファイル作成失敗で空Imageが返ること | E-02 (L300: ERR_FAIL_COND_V_MSG(open_memfile_error, ...)) | ○ |
| C-22 (UT-TEXR-022) | EXR読み込み失敗で空Imageが返ること | E-02 (L305: ERR_FAIL_COND_V_MSG(load_error, ...)) | ○ |

### save_exr関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 (UT-TEXR-023) | RGBAF形式の画像がEXRファイルとして保存できること | E-04 (L287-299: save_exr関数、L44-57: is_supported_format) | ○ |
| C-24 (UT-TEXR-024) | RGBAH形式の画像がEXRファイルとして保存できること | E-04 (L49-52: FORMAT_RH/RGH/RGBH/RGBAH対応) | ○ |
| C-25 (UT-TEXR-025) | RGBA8形式がHALF精度EXRとして保存できること | E-04 (L53-56: FORMAT_R8/RG8/RGB8/RGBA8対応、L103-108: 8bit→HALF変換) | ○ |
| C-26 (UT-TEXR-026) | グレースケール画像がYチャンネルで保存できること | E-04 (L251-253: p_grayscaleでYチャンネル名設定) | ○ |
| C-27 (UT-TEXR-027) | 非対応形式でエラーが返ること | E-04 (L150-155: is_supported_format失敗時の処理) | ○ |
| C-28 (UT-TEXR-028) | ファイル書き込み失敗でERR_FILE_CANT_WRITEが返ること | E-04 (L293-294: FileAccess::open失敗時) | ○ |
| C-29 (UT-TEXR-029) | グレースケールモードで複数チャンネル画像でエラー | E-04 (L183: ERR_FAIL_COND_V(p_grayscale && channel_count != 1, ...)) | ○ |

### save_exr_buffer関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 (UT-TEXR-030) | RGBAF形式の画像がバッファとして出力できること | E-04 (L147-285: save_exr_buffer関数全体) | ○ |
| C-31 (UT-TEXR-031) | RGBH形式の画像がバッファとして出力できること | E-04 (L174-179: channel_mappings、L218-226: SRC_HALF処理) | ○ |
| C-32 (UT-TEXR-032) | RGF形式の画像がバッファとして出力できること | E-04 (L124-145: get_channel_count) | ○ |
| C-33 (UT-TEXR-033) | RF形式の画像がバッファとして出力できること | E-04 (L126-129: R形式で1チャンネル) | ○ |
| C-34 (UT-TEXR-034) | PIZ圧縮で保存されること | E-04 (L271: header.compression_type = TINYEXR_COMPRESSIONTYPE_PIZ) | △ |
| C-35 (UT-TEXR-035) | チャンネル順序がABGR(逆順)で保存されること | E-04 (L174-179: channel_mappings配列、コメントにGimp/Blender互換性記載) | ○ |
| C-36 (UT-TEXR-036) | 非対応形式で空バッファが返ること | E-04 (L150-155: is_supported_format失敗時) | ○ |

### ヘルパー関数関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 (UT-TEXR-037) | is_supported_format: サポート形式でtrue | E-04 (L41-61: switch文による判定) | ○ |
| C-38 (UT-TEXR-038) | is_supported_format: FLOAT形式対応 | E-04 (L45-48: FORMAT_RF/RGF/RGBF/RGBAF) | ○ |
| C-39 (UT-TEXR-039) | is_supported_format: HALF形式対応 | E-04 (L49-52: FORMAT_RH/RGH/RGBH/RGBAH) | ○ |
| C-40 (UT-TEXR-040) | is_supported_format: 8bit形式対応 | E-04 (L53-56: FORMAT_R8/RG8/RGB8/RGBA8) | ○ |
| C-41 (UT-TEXR-041) | is_supported_format: 非対応形式でfalse | E-04 (L58-59: default: return false) | ○ |
| C-42 (UT-TEXR-042) | get_source_pixel_type: FLOAT形式でSRC_FLOAT | E-04 (L70-76: switch文) | ○ |
| C-43 (UT-TEXR-043) | get_source_pixel_type: HALF形式でSRC_HALF | E-04 (L77-81: switch文) | ○ |
| C-44 (UT-TEXR-044) | get_source_pixel_type: 8bit形式でSRC_BYTE | E-04 (L82-86: switch文) | ○ |
| C-45 (UT-TEXR-045) | get_source_pixel_type: 非対応でSRC_UNSUPPORTED | E-04 (L87-88: default) | ○ |
| C-46 (UT-TEXR-046) | get_target_pixel_type: FLOAT形式でTINYEXR_PIXELTYPE_FLOAT | E-04 (L92-98: switch文) | ○ |
| C-47 (UT-TEXR-047) | get_target_pixel_type: HALF/8bitでTINYEXR_PIXELTYPE_HALF | E-04 (L99-108: switch文) | ○ |
| C-48 (UT-TEXR-048) | get_target_pixel_type: 非対応で-1 | E-04 (L109-110: default) | ○ |
| C-49 (UT-TEXR-049) | get_pixel_type_size: HALFで2 | E-04 (L116-117: case TINYEXR_PIXELTYPE_HALF) | ○ |
| C-50 (UT-TEXR-050) | get_pixel_type_size: FLOATで4 | E-04 (L118-119: case TINYEXR_PIXELTYPE_FLOAT) | ○ |
| C-51 (UT-TEXR-051) | get_pixel_type_size: 無効で-1 | E-04 (L121: return -1) | ○ |
| C-52 (UT-TEXR-052) | get_channel_count: R形式で1 | E-04 (L126-129: switch文) | ○ |
| C-53 (UT-TEXR-053) | get_channel_count: RG形式で2 | E-04 (L130-133: switch文) | ○ |
| C-54 (UT-TEXR-054) | get_channel_count: RGB形式で3 | E-04 (L134-137: switch文) | ○ |
| C-55 (UT-TEXR-055) | get_channel_count: RGBA形式で4 | E-04 (L138-141: switch文) | ○ |
| C-56 (UT-TEXR-056) | get_channel_count: 非対応で-1 | E-04 (L142-143: default) | ○ |

### モジュール初期化/終了関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 (UT-TEXR-057) | initialize: ローダー登録 | E-05 (L43-44: instantiate + add_image_format_loader) | ○ |
| C-58 (UT-TEXR-058) | initialize: save関数登録 | E-05 (L46-47: Image::save_exr_func, save_exr_buffer_func設定) | ○ |
| C-59 (UT-TEXR-059) | initialize: 非SCENEレベルでスキップ | E-05 (L39-41: if (p_level != MODULE_INITIALIZATION_LEVEL_SCENE) return) | ○ |
| C-60 (UT-TEXR-060) | uninitialize: ローダー解除 | E-05 (L55-56: remove_image_format_loader + unref) | ○ |
| C-61 (UT-TEXR-061) | uninitialize: save関数null化 | E-05 (L58: Image::save_exr_func = nullptr) | ○ |
| C-62 (UT-TEXR-062) | uninitialize: 非SCENEレベルでスキップ | E-05 (L51-53: if (p_level != MODULE_INITIALIZATION_LEVEL_SCENE) return) | ○ |

### 境界値テスト関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 (UT-TEXR-063) | 幅1ピクセルの画像読み込み | E-02 (実装上の制限なし、一般的な境界値テスト) | ○ |
| C-64 (UT-TEXR-064) | 高さ1ピクセルの画像読み込み | E-02 (実装上の制限なし、一般的な境界値テスト) | ○ |
| C-65 (UT-TEXR-065) | 大サイズ画像読み込み | **根拠なし**（4096x4096は推測値） | △ |
| C-66 (UT-TEXR-066) | 幅1ピクセルの画像保存 | E-04 (実装上の制限なし) | ○ |
| C-67 (UT-TEXR-067) | 高さ1ピクセルの画像保存 | E-04 (実装上の制限なし) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-34 (UT-TEXR-034)**: PIZ圧縮の動作確認にはtinyexrライブラリの内部仕様確認が必要
  - 候補：thirdparty/tinyexr/tinyexr.h / tinyexrドキュメント / EXR仕様書
- **C-65 (UT-TEXR-065)**: 大サイズ画像の上限値（4096x4096）は推測値。実際の制限値は以下から確認が必要
  - 候補：Godot Engineのメモリ制限 / Image::MAX_WIDTH, MAX_HEIGHT定数 / プラットフォーム依存の制限

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：基本的な読み込み/保存機能のテストケース（C-01〜C-09, C-23〜C-26）
- **リスク1（中）**：エラーハンドリングのテストケース（C-10〜C-17, C-27〜C-29）- 実際のエラー発生条件の網羅性確認が望ましい
- **リスク0（低）**：ヘルパー関数のテストケース（C-37〜C-56）- コードから直接導出可能
- **リスク1（中）**：境界値テストケース（C-63〜C-67）- 上限値の根拠確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] HALF精度とFLOAT精度の両方のEXRファイルでテストが実行可能か確認
- [ ] タイル形式EXRのテスト用ファイルが準備可能か確認
- [ ] 大サイズ画像テスト（C-65）の上限値が実際の制限と一致しているか確認
- [ ] Godot EngineのImage::FORMAT_*定数がテストコードで正しく参照されるか確認
- [ ] 非対応形式（DXT1等）のテスト用画像データの準備方法を確認
- [ ] エラーパスのテストで使用する破損ファイルの作成方法を確認
