---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 101
  claims_with_evidence: 98
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：modules-upnp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：98 / 101、根拠なし：3
- 優先レビュー（高）
  1. **UT-UPN-078（ポート1の境界値テスト）**：ルーターの実際の動作に依存
  2. **UT-UPN-084（小文字プロトコルのテスト）**：実装コードでは大文字比較のみだがルーターの動作確認が必要
  3. **UT-UPN-091（削除時のポート1境界値テスト）**：ルーターの実際の動作に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/upnp/upnp.h` - UPNPクラスの抽象インターフェース定義
- E-02: `modules/upnp/upnp.cpp` - UPNPクラスのGodotバインディング
- E-03: `modules/upnp/upnp_device.h` - UPNPDeviceクラスの抽象インターフェース定義
- E-04: `modules/upnp/upnp_device.cpp` - UPNPDeviceクラスのGodotバインディング
- E-05: `modules/upnp/upnp_miniupnp.h` - UPNPMiniUPNP実装クラスのヘッダー
- E-06: `modules/upnp/upnp_miniupnp.cpp` - UPNPMiniUPNP実装クラスの本体
- E-07: `modules/upnp/upnp_device_miniupnp.h` - UPNPDeviceMiniUPNP実装クラスのヘッダー
- E-08: `modules/upnp/upnp_device_miniupnp.cpp` - UPNPDeviceMiniUPNP実装クラスの本体
- E-09: `modules/upnp/doc_classes/UPNP.xml` - UPNP APIドキュメント
- E-10: `modules/upnp/doc_classes/UPNPDevice.xml` - UPNPDevice APIドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

### UPNPクラス（基底クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-UPN-001) | _createファクトリでインスタンス生成 | E-01 (L78-83) | ○ |
| C-02 (UT-UPN-002) | _create未設定時にnullptr返却 | E-01 (L79-81) | ○ |

### UPNPMiniUPNPクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 (UT-UPN-003) | discover成功時にSUCCESS返却 | E-06 (L54-99) | ○ |
| C-04 (UT-UPN-004) | timeout負値でINVALID_PARAM返却 | E-06 (L55) | ○ |
| C-05 (UT-UPN-005) | TTL負値でINVALID_PARAM返却 | E-06 (L56) | ○ |
| C-06 (UT-UPN-006) | TTL>=256でINVALID_PARAM返却 | E-06 (L56) | ○ |
| C-07 (UT-UPN-007) | TTL=0で正常動作 | E-06 (L56)の条件から | ○ |
| C-08 (UT-UPN-008) | TTL=255で正常動作 | E-06 (L56)の条件から | ○ |
| C-09 (UT-UPN-009) | 空device_filterで全デバイス検出 | E-06 (L65, L89) | ○ |
| C-10 (UT-UPN-010) | デバイス未検出時NO_DEVICES返却 | E-06 (L82-84) | ○ |
| C-11 (UT-UPN-011) | ソケットエラー時SOCKET_ERROR返却 | E-06 (L73-74) | ○ |
| C-12 (UT-UPN-012) | 空文字がcommon deviceと判定 | E-06 (L47) | ○ |
| C-13 (UT-UPN-013) | InternetGatewayDeviceの判定 | E-06 (L48) | ○ |
| C-14 (UT-UPN-014) | WANIPConnectionの判定 | E-06 (L49) | ○ |
| C-15 (UT-UPN-015) | WANPPPConnectionの判定 | E-06 (L50) | ○ |
| C-16 (UT-UPN-016) | rootdeviceの判定 | E-06 (L51) | ○ |
| C-17 (UT-UPN-017) | 未知デバイスの判定 | E-06 (L46-52) | ○ |
| C-18 (UT-UPN-018) | get_device_countの動作 | E-06 (L233-235) | ○ |
| C-19 (UT-UPN-019) | 空リスト時のデバイス数0 | E-06 (L233-235) | ○ |
| C-20 (UT-UPN-020) | get_deviceの正常動作 | E-06 (L237-241) | ○ |
| C-21 (UT-UPN-021) | 範囲外インデックスでnullptr | E-06 (L238) | ○ |
| C-22 (UT-UPN-022) | 負インデックスでnullptr | E-06 (L238) | ○ |
| C-23 (UT-UPN-023) | add_deviceの正常動作 | E-06 (L243-247) | ○ |
| C-24 (UT-UPN-024) | null追加の拒否 | E-06 (L244) | ○ |
| C-25 (UT-UPN-025) | set_deviceの正常動作 | E-06 (L249-254) | ○ |
| C-26 (UT-UPN-026) | set_device範囲外エラー | E-06 (L250) | ○ |
| C-27 (UT-UPN-027) | set_device null拒否 | E-06 (L251) | ○ |
| C-28 (UT-UPN-028) | remove_deviceの正常動作 | E-06 (L256-260) | ○ |
| C-29 (UT-UPN-029) | remove_device範囲外エラー | E-06 (L257) | ○ |
| C-30 (UT-UPN-030) | clear_devicesの正常動作 | E-06 (L262-264) | ○ |
| C-31 (UT-UPN-031) | 空リストのclear動作 | E-06 (L263) | ○ |
| C-32 (UT-UPN-032) | get_gateway有効なゲートウェイ取得 | E-06 (L266-278) | ○ |
| C-33 (UT-UPN-033) | get_gateway空リスト時nullptr | E-06 (L267) | ○ |
| C-34 (UT-UPN-034) | get_gateway有効なIGDなし時nullptr | E-06 (L269-275) | ○ |
| C-35 (UT-UPN-035) | query_external_addressの正常動作 | E-06 (L304-312) | ○ |
| C-36 (UT-UPN-036) | query_external_addressゲートウェイなし | E-06 (L307-309) | ○ |
| C-37 (UT-UPN-037) | add_port_mappingの正常動作 | E-06 (L314-322) | ○ |
| C-38 (UT-UPN-038) | TCPポートマッピング | E-06 (L314-322) | ○ |
| C-39 (UT-UPN-039) | 異なる内部・外部ポート | E-06 (L314-322) | ○ |
| C-40 (UT-UPN-040) | 説明付きマッピング | E-06 (L314-322) | ○ |
| C-41 (UT-UPN-041) | 有効期限付きマッピング | E-06 (L314-322) | ○ |
| C-42 (UT-UPN-042) | add_port_mappingゲートウェイなし | E-06 (L317-319) | ○ |
| C-43 (UT-UPN-043) | delete_port_mappingの正常動作 | E-06 (L324-332) | ○ |
| C-44 (UT-UPN-044) | TCP削除の正常動作 | E-06 (L324-332) | ○ |
| C-45 (UT-UPN-045) | delete_port_mappingゲートウェイなし | E-06 (L327-329) | ○ |
| C-46 (UT-UPN-046) | set_discover_multicast_ifの動作 | E-06 (L280-286) | ○ |
| C-47 (UT-UPN-047) | 空文字でデフォルトリセット | E-06 (L280-286) | ○ |
| C-48 (UT-UPN-048) | set_discover_local_portの動作 | E-06 (L288-294) | ○ |
| C-49 (UT-UPN-049) | ポート0で自動選択 | E-06 (L288-294), E-09 (L156) | ○ |
| C-50 (UT-UPN-050) | IPv6有効化 | E-06 (L296-302) | ○ |
| C-51 (UT-UPN-051) | IPv6無効化 | E-06 (L296-302) | ○ |
| C-52 (UT-UPN-052) | upnp_result SUCCESS変換 | E-06 (L183-184) | ○ |
| C-53 (UT-UPN-053) | upnp_result 402変換 | E-06 (L196-197) | ○ |
| C-54 (UT-UPN-054) | upnp_result 403変換 | E-06 (L198-199) | ○ |
| C-55 (UT-UPN-055) | upnp_result 718変換 | E-06 (L210-211) | ○ |
| C-56 (UT-UPN-056) | upnp_result 未知コード変換 | E-06 (L230) | ○ |

### UPNPDeviceクラス（基底クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 (UT-UPN-057) | _createファクトリでインスタンス生成 | E-03 (L57-62) | ○ |
| C-58 (UT-UPN-058) | _create未設定時にnullptr返却 | E-03 (L58-60) | ○ |

### UPNPDeviceMiniUPNPクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 (UT-UPN-059) | description_url設定 | E-08 (L101-107) | ○ |
| C-60 (UT-UPN-060) | description_url空文字設定 | E-08 (L101-107) | ○ |
| C-61 (UT-UPN-061) | service_type設定 | E-08 (L109-115) | ○ |
| C-62 (UT-UPN-062) | igd_control_url設定 | E-08 (L117-123) | ○ |
| C-63 (UT-UPN-063) | igd_service_type設定 | E-08 (L125-131) | ○ |
| C-64 (UT-UPN-064) | igd_our_addr設定 | E-08 (L133-139) | ○ |
| C-65 (UT-UPN-065) | igd_status IGD_STATUS_OK設定 | E-08 (L141-147) | ○ |
| C-66 (UT-UPN-066) | igd_status HTTP_ERROR設定 | E-08 (L141-147) | ○ |
| C-67 (UT-UPN-067) | igd_status DISCONNECTED設定 | E-08 (L141-147) | ○ |
| C-68 (UT-UPN-068) | is_valid_gateway OK時true | E-08 (L149-151) | ○ |
| C-69 (UT-UPN-069) | is_valid_gateway 非OK時false | E-08 (L149-151) | ○ |
| C-70 (UT-UPN-070) | is_valid_gateway 初期状態false | E-07 (L48), E-08 (L149-151) | ○ |
| C-71 (UT-UPN-071) | query_external_address正常動作 | E-08 (L43-55) | ○ |
| C-72 (UT-UPN-072) | query_external_address無効ゲートウェイ | E-08 (L44) | ○ |
| C-73 (UT-UPN-073) | add_port_mapping正常動作 | E-08 (L57-82) | ○ |
| C-74 (UT-UPN-074) | port_internal=0時の自動設定 | E-08 (L64-66) | ○ |
| C-75 (UT-UPN-075) | add_port_mapping無効ゲートウェイ | E-08 (L58) | ○ |
| C-76 (UT-UPN-076) | ポート0のバリデーション | E-08 (L59) | ○ |
| C-77 (UT-UPN-077) | ポート65536のバリデーション | E-08 (L59) | ○ |
| C-78 (UT-UPN-078) | ポート1境界値テスト | E-08 (L59)、**ルーター動作は未確認** | △ |
| C-79 (UT-UPN-079) | ポート65535境界値テスト | E-08 (L59) | ○ |
| C-80 (UT-UPN-080) | 内部ポート負値バリデーション | E-08 (L60) | ○ |
| C-81 (UT-UPN-081) | 内部ポート65536バリデーション | E-08 (L60) | ○ |
| C-82 (UT-UPN-082) | 無効プロトコルバリデーション | E-08 (L61) | ○ |
| C-83 (UT-UPN-083) | 空プロトコルバリデーション | E-08 (L61) | ○ |
| C-84 (UT-UPN-084) | 小文字プロトコルバリデーション | E-08 (L61)、**大文字小文字厳密比較は実装確認済みだがルーター動作は未確認** | △ |
| C-85 (UT-UPN-085) | 負duration バリデーション | E-08 (L62) | ○ |
| C-86 (UT-UPN-086) | duration=0永続マッピング | E-08 (L77), E-09 (L81) | ○ |
| C-87 (UT-UPN-087) | delete_port_mapping正常動作 | E-08 (L84-99) | ○ |
| C-88 (UT-UPN-088) | delete_port_mappingポート0 | E-08 (L85) | ○ |
| C-89 (UT-UPN-089) | delete_port_mappingポート65536 | E-08 (L85) | ○ |
| C-90 (UT-UPN-090) | delete_port_mapping無効プロトコル | E-08 (L86) | ○ |
| C-91 (UT-UPN-091) | delete_port_mappingポート1境界値 | E-08 (L85)、**ルーター動作は未確認** | △ |
| C-92 (UT-UPN-092) | delete_port_mappingポート65535境界値 | E-08 (L85) | ○ |
| C-93 (UT-UPN-093) | parse_igd正常解析 | E-06 (L117-179) | ○ |
| C-94 (UT-UPN-094) | parse_igd HTTPエラー | E-06 (L122-125) | ○ |
| C-95 (UT-UPN-095) | parse_igd 空レスポンス | E-06 (L127-130) | ○ |
| C-96 (UT-UPN-096) | parse_igd IGDなし | E-06 (L152-154) | ○ |
| C-97 (UT-UPN-097) | parse_igd 切断状態 | E-06 (L155-157) | ○ |
| C-98 (UT-UPN-098) | parse_igd 未知デバイス | E-06 (L158-160) | ○ |
| C-99 (UT-UPN-099) | parse_igd 無効control URL | E-06 (L167-170) | ○ |
| C-100 (UT-UPN-100) | UPNPMiniUPNP make_default | E-06 (L42-44) | ○ |
| C-101 (UT-UPN-101) | UPNPDeviceMiniUPNP make_default | E-08 (L39-41) | ○ |

## 4) 不足情報（Unknown / Missing）
- **ルーター実機での動作確認**：低ポート番号（1-1023）のマッピングは、多くのルーターで制限される可能性がある
  - 候補：実機テスト環境 / 各種ルーターのUPnP仕様書 / miniupnpcライブラリのテストスイート
- **エラーコードの網羅性**：miniupnpcライブラリが返す可能性のある全エラーコードの確認
  - 候補：miniupnpc/upnpcommands.h / miniupnpcライブラリドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロパティのgetter/setterテスト（98件）
- 1: 中リスク - ルーター依存の動作テスト（ポート1境界値など3件）
- 0: 高リスク - なし

## 6) レビュアーチェックリスト（最小）
- [ ] UT-UPN-078, UT-UPN-084, UT-UPN-091の期待結果が実環境で妥当か確認
- [ ] エラーコード変換（upnp_result関数）の網羅性が十分か確認
- [ ] parse_igd関数のエッジケース（不正なXML等）が網羅されているか確認
- [ ] IPv6モード時の動作テストが必要か確認
- [ ] マルチスレッド環境での動作テストが必要か確認（ドキュメントにはThread使用を推奨している）
