---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：modules-vhacd 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UT-VHACD-029, UT-VHACD-030**：nullポインタ処理の実装確認が必要（コード上で明示的なチェックなし）
  2. **UT-VHACD-049**：hull_count=0の場合の挙動確認（VHACDライブラリ依存）
  3. **大規模メッシュテスト**：パフォーマンス基準の明確化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/vhacd/register_types.cpp` - convex_decompose関数実装（37-92行目）
- E-02: `modules/vhacd/register_types.cpp` - initialize_vhacd_module関数（94-100行目）
- E-03: `modules/vhacd/register_types.cpp` - uninitialize_vhacd_module関数（102-108行目）
- E-04: `modules/vhacd/register_types.h` - モジュール関数宣言（35-36行目）
- E-05: `modules/vhacd/config.py` - can_build関数（1-2行目）
- E-06: `modules/vhacd/config.py` - configure関数（5-6行目）
- E-07: `scene/resources/mesh.h` - MeshConvexDecompositionSettingsクラス定義（213-294行目）
- E-08: `scene/resources/mesh.h` - ConvexDecompositionFunc型定義（196行目）
- E-09: `thirdparty/vhacd/public/VHACD.h` - IVHACD::Parameters構造体（72-110行目）
- E-10: `thirdparty/vhacd/public/VHACD.h` - IVHACD::ConvexHull構造体（62-70行目）
- E-11: `thirdparty/vhacd/public/VHACD.h` - IVHACD インターフェース（112-149行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | convex_decompose関数が凸包分解を実行する | E-01, E-09, E-11 | ○ |
| C-02 | r_convex_indicesにインデックスが設定される | E-01（80-85行目） | ○ |
| C-03 | r_convex_indicesがnullでも動作する | E-01（62-64行目、80行目の条件分岐） | ○ |
| C-04 | max_concavityがparams.m_concavityにマッピングされる | E-01（39行目）, E-07 | ○ |
| C-05 | symmetry_planes_clipping_biasがparams.m_alphaにマッピングされる | E-01（40行目）, E-07 | ○ |
| C-06 | revolution_axes_clipping_biasがparams.m_betaにマッピングされる | E-01（41行目）, E-07 | ○ |
| C-07 | min_volume_per_convex_hullがparams.m_minVolumePerCHにマッピングされる | E-01（42行目）, E-07 | ○ |
| C-08 | resolutionがparams.m_resolutionにマッピングされる | E-01（43行目）, E-07 | ○ |
| C-09 | max_num_vertices_per_convex_hullがparams.m_maxNumVerticesPerCHにマッピングされる | E-01（44行目）, E-07 | ○ |
| C-10 | plane_downsamplingがparams.m_planeDownsamplingにマッピングされる | E-01（45行目）, E-07 | ○ |
| C-11 | convex_hull_downsamplingがparams.m_convexhullDownsamplingにマッピングされる | E-01（46行目）, E-07 | ○ |
| C-12 | normalize_meshがparams.m_pcaにマッピングされる | E-01（47行目）, E-07 | ○ |
| C-13 | modeがparams.m_modeにマッピングされる（VOXELモード） | E-01（48行目）, E-07（217-220行目） | ○ |
| C-14 | modeがparams.m_modeにマッピングされる（TETRAHEDRONモード） | E-01（48行目）, E-07（217-220行目） | ○ |
| C-15 | convex_hull_approximationがparams.m_convexhullApproximationにマッピングされる | E-01（49行目）, E-07 | ○ |
| C-16 | max_convex_hullsがparams.m_maxConvexHullsにマッピングされる | E-01（51行目）, E-07 | ○ |
| C-17 | project_hull_verticesがparams.m_projectHullVerticesにマッピングされる | E-01（52行目）, E-07 | ○ |
| C-18 | m_oclAccelerationが常にtrueに設定される | E-01（50行目） | ○ |
| C-19 | 複数の凸包が生成可能 | E-01（57-86行目のループ処理）, E-11 | ○ |
| C-20 | 頂点座標がVector3に正しく変換される | E-01（70-78行目） | ○ |
| C-21 | 頂点数0の場合の挙動 | E-11（VHACD依存） | ○ |
| C-22 | 三角形数0の場合の挙動 | E-11（VHACD依存） | ○ |
| C-23 | 最小構成メッシュの処理 | E-01, E-11 | ○ |
| C-24 | max_concavity=0.0の境界値 | E-07（225-226行目）, E-09 | ○ |
| C-25 | max_concavity=1.0の境界値 | E-07（225-226行目）, E-09 | ○ |
| C-26 | resolution最小値の境界値 | E-07（232-233行目）, E-09 | ○ |
| C-27 | max_convex_hulls=1の境界値 | E-07（247行目）, E-09 | ○ |
| C-28 | max_num_vertices_per_convex_hull最小値 | E-07（234行目）, E-09 | ○ |
| C-29 | p_vertices=nullptrの異常系 | **根拠なし** | △ |
| C-30 | p_triangles=nullptrの異常系 | **根拠なし** | △ |
| C-31 | Clean/Releaseによるリソース解放 | E-01（88-89行目） | ○ |
| C-32 | initialize時にconvex_decomposition_functionが設定される | E-02（99行目）, E-08 | ○ |
| C-33 | SCENE以外のレベルでは初期化しない | E-02（95-97行目） | ○ |
| C-34 | SERVERSレベルでは初期化しない | E-02（95-97行目） | ○ |
| C-35 | uninitialize時にconvex_decomposition_functionがnullになる | E-03（107行目） | ○ |
| C-36 | SCENE以外のレベルでは終了処理しない | E-03（103-105行目） | ○ |
| C-37 | can_buildがdisable_physics_3dに基づきtrueを返す | E-05（2行目） | ○ |
| C-38 | can_buildがdisable_physics_3dに基づきfalseを返す | E-05（2行目） | ○ |
| C-39 | configure関数が空実装 | E-06（5-6行目） | ○ |
| C-40 | 大規模メッシュの処理完了 | E-01, E-11 | ○ |
| C-41 | 単純な凸形状の最適化 | E-11（VHACD依存） | ○ |
| C-42 | 三角形インデックスの正しいコピー | E-01（81-84行目） | ○ |
| C-43 | plane_downsampling=1の境界値 | E-07（236-237行目）, E-09 | ○ |
| C-44 | plane_downsampling=16の境界値 | E-07（236-237行目）, E-09 | ○ |
| C-45 | convex_hull_downsampling=1の境界値 | E-07（239-241行目）, E-09 | ○ |
| C-46 | convex_hull_downsampling=16の境界値 | E-07（239-241行目）, E-09 | ○ |
| C-47 | symmetry_planes_clipping_bias=0.0の境界値 | E-07（227-228行目）, E-09 | ○ |
| C-48 | revolution_axes_clipping_bias=0.0の境界値 | E-07（229-230行目）, E-09 | ○ |
| C-49 | hull_count=0の場合の空Vector返却 | **根拠なし**（VHACD内部実装依存） | △ |
| C-50 | m_nPointsとVector3配列サイズの整合性 | E-01（71行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-29, C-30（nullポインタ処理）**：convex_decompose関数内でnullポインタチェックが明示的に行われていない。VHACDライブラリ内部でのエラー処理に依存しており、実際の挙動確認が必要。
  - 候補：VHACDライブラリソースコード確認 / 実行時テストによる検証 / Godotエンジンの他のnullチェック実装パターン参照
- **C-49（hull_count=0の場合）**：VHACDが凸包を0個返すケースの条件が不明。実装上は問題ないが、そのようなケースが発生する入力条件の特定が必要。
  - 候補：VHACDドキュメント / エッジケーステスト

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：C-29, C-30のnullポインタ処理 - クラッシュの可能性があるため、実際のテスト実行で確認必要
- **リスク0（低）**：パラメータマッピング - ソースコードから明確に確認可能
- **リスク0（低）**：モジュール初期化/終了処理 - シンプルな実装で明確

## 6) レビュアーチェックリスト（最小）
- [ ] convex_decompose関数のパラメータマッピングがMeshConvexDecompositionSettingsの全プロパティをカバーしているか確認
- [ ] VHACD::IVHACDインターフェースのCompute, GetNConvexHulls, GetConvexHull, Clean, Releaseの呼び出しシーケンスが正しいか確認
- [ ] hull.m_pointsからVector3への変換ロジック（3要素ずつ読み取り）が正しいか確認
- [ ] r_convex_indicesのnullチェックと条件分岐が適切か確認
- [ ] initialize/uninitialize関数のレベルチェック（MODULE_INITIALIZATION_LEVEL_SCENE）が正しいか確認
- [ ] config.pyのcan_build関数が3D物理無効時にモジュールをスキップするか確認
- [ ] 異常系テスト（UT-VHACD-029, UT-VHACD-030）の期待結果が実際の挙動と一致するか実行確認
