---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 90
  claims_with_evidence: 87
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：modules-vorbis 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：87 / 90、根拠なし：3
- 優先レビュー（高）
  1. **UT-VOR-063（BPMベースループ）**：複雑なロジックのため実際の動作確認が必要
  2. **UT-VOR-064（ループフェード）**：フェード処理の詳細な挙動確認が必要
  3. **UT-VOR-088/089（モジュール初期化）**：TOOLS_ENABLED条件の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/vorbis/audio_stream_ogg_vorbis.h` - AudioStreamOggVorbis、AudioStreamPlaybackOggVorbisクラス定義
- E-02: `modules/vorbis/audio_stream_ogg_vorbis.cpp` - AudioStreamOggVorbis、AudioStreamPlaybackOggVorbis実装
- E-03: `modules/vorbis/resource_importer_ogg_vorbis.h` - ResourceImporterOggVorbisクラス定義
- E-04: `modules/vorbis/resource_importer_ogg_vorbis.cpp` - ResourceImporterOggVorbis実装
- E-05: `modules/vorbis/register_types.h` - モジュール登録ヘッダー
- E-06: `modules/vorbis/register_types.cpp` - モジュール登録実装
- E-07: `modules/vorbis/doc_classes/AudioStreamOggVorbis.xml` - APIドキュメント
- E-08: `modules/vorbis/doc_classes/AudioStreamPlaybackOggVorbis.xml` - APIドキュメント
- E-09: `modules/vorbis/doc_classes/ResourceImporterOggVorbis.xml` - APIドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

### AudioStreamOggVorbis クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-VOR-001) | load_from_file正常系 | E-02 (line 700-704) | ○ |
| C-02 (UT-VOR-002) | load_from_file存在しないファイル | E-02 (line 702) ERR_FAIL_COND_V_MSG | ○ |
| C-03 (UT-VOR-003) | load_from_file空ファイル | E-02 (line 702) 空チェック | ○ |
| C-04 (UT-VOR-004) | load_from_buffer正常系 | E-02 (line 580-698) | ○ |
| C-05 (UT-VOR-005) | load_from_buffer空バッファ | E-02 (line 603-606) cursor >= size チェック | ○ |
| C-06 (UT-VOR-006) | load_from_buffer不正データ | E-02 (line 601, 691-692) エラーチェック | ○ |
| C-07 (UT-VOR-007) | load_from_buffer非Vorbisヘッダー | E-02 (line 655-662) vorbis_synthesis_idheader | ○ |
| C-08 (UT-VOR-008) | set_loop/has_loop true | E-02 (line 501-507) | ○ |
| C-09 (UT-VOR-009) | set_loop/has_loop false | E-02 (line 501-507) | ○ |
| C-10 (UT-VOR-010) | set_loop_offset/get_loop_offset | E-02 (line 509-515) | ○ |
| C-11 (UT-VOR-011) | loop_offset 0秒 | E-02 (line 509-515) 制約なし | ○ |
| C-12 (UT-VOR-012) | 負のloop_offset | E-02 制約なし | ○ |
| C-13 (UT-VOR-013) | set_bpm/get_bpm正常 | E-02 (line 522-530) | ○ |
| C-14 (UT-VOR-014) | 負のBPMエラー | E-02 (line 523) ERR_FAIL_COND | ○ |
| C-15 (UT-VOR-015) | BPM=0境界 | E-02 (line 523) p_bpm < 0 のみチェック | ○ |
| C-16 (UT-VOR-016) | set_beat_count/get_beat_count | E-02 (line 532-540) | ○ |
| C-17 (UT-VOR-017) | 負のbeat_countエラー | E-02 (line 533) ERR_FAIL_COND | ○ |
| C-18 (UT-VOR-018) | set_bar_beats/get_bar_beats | E-02 (line 542-550) | ○ |
| C-19 (UT-VOR-019) | bar_beats < 2 エラー | E-02 (line 543) ERR_FAIL_COND | ○ |
| C-20 (UT-VOR-020) | set_tags/get_tags | E-02 (line 552-558) | ○ |
| C-21 (UT-VOR-021) | set_packet_sequence正常 | E-02 (line 490-498) | ○ |
| C-22 (UT-VOR-022) | null packet_sequence | E-02 (line 492) 条件分岐 | ○ |
| C-23 (UT-VOR-023) | get_length正常 | E-02 (line 517-520) | ○ |
| C-24 (UT-VOR-024) | get_length nullケース | E-02 (line 518) ERR_FAIL_COND_V | ○ |
| C-25 (UT-VOR-025) | instantiate_playback正常 | E-02 (line 412-428) | ○ |
| C-26 (UT-VOR-026) | instantiate_playback null | E-02 (line 415) ERR_FAIL_COND_V | ○ |
| C-27 (UT-VOR-027) | is_monophonic | E-02 (line 560-562) | ○ |
| C-28 (UT-VOR-028) | can_be_sampled | E-01 (line 175-177) | ○ |
| C-29 (UT-VOR-029) | generate_sample | E-02 (line 568-578) | ○ |
| C-30 (UT-VOR-030) | generate_sampleループ設定 | E-02 (line 572-576) | ○ |
| C-31 (UT-VOR-031) | get_stream_name | E-02 (line 430-432) | ○ |
| C-32 (UT-VOR-032) | get_parameter_list | E-02 (line 564-566) | ○ |
| C-33 (UT-VOR-033) | maybe_update_info | E-02 (line 434-488) | ○ |
| C-34 (UT-VOR-034) | タグパース | E-02 (line 466-481) | ○ |

### AudioStreamPlaybackOggVorbis クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 (UT-VOR-035) | start正常系 | E-02 (line 231-238) | ○ |
| C-36 (UT-VOR-036) | start指定位置 | E-02 (line 235) seek呼び出し | ○ |
| C-37 (UT-VOR-037) | start ready=false | E-02 (line 232) ERR_FAIL_COND | ○ |
| C-38 (UT-VOR-038) | stop | E-02 (line 240-242) | ○ |
| C-39 (UT-VOR-039) | is_playing true | E-02 (line 244-246) | ○ |
| C-40 (UT-VOR-040) | is_playing false | E-02 (line 244-246) | ○ |
| C-41 (UT-VOR-041) | get_loop_count | E-02 (line 248-250) | ○ |
| C-42 (UT-VOR-042) | get_playback_position | E-02 (line 252-254) | ○ |
| C-43 (UT-VOR-043) | seek正常系 | E-02 (line 279-376) | ○ |
| C-44 (UT-VOR-044) | seek超過 | E-02 (line 286-288) | ○ |
| C-45 (UT-VOR-045) | seek ready=false | E-02 (line 280) ERR_FAIL_COND | ○ |
| C-46 (UT-VOR-046) | seek active=false | E-02 (line 282-284) | ○ |
| C-47 (UT-VOR-047) | set_parameter looping | E-02 (line 260-269) | ○ |
| C-48 (UT-VOR-048) | set_parameter Variant() | E-02 (line 262-264) | ○ |
| C-49 (UT-VOR-049) | get_parameter override true | E-02 (line 272-277) | ○ |
| C-50 (UT-VOR-050) | get_parameter override false | E-02 (line 272-277) | ○ |
| C-51 (UT-VOR-051) | set_is_sample/get_is_sample | E-02 (line 378-384) | ○ |
| C-52 (UT-VOR-052) | set_sample_playback/get | E-02 (line 386-395) | ○ |
| C-53 (UT-VOR-053) | stream_playback関連付け | E-02 (line 392-394) | ○ |
| C-54 (UT-VOR-054) | get_stream_sampling_rate | E-02 (line 192-194) | ○ |
| C-55 (UT-VOR-055) | _alloc_vorbis正常 | E-02 (line 196-229) | ○ |
| C-56 (UT-VOR-056) | _alloc_vorbis null | E-02 (line 202) ERR_FAIL_COND_V | ○ |
| C-57 (UT-VOR-057) | _alloc_vorbis ヘッダー不足 | E-02 (line 209-211) | ○ |
| C-58 (UT-VOR-058) | _mix_internal正常 | E-02 (line 38-144) | ○ |
| C-59 (UT-VOR-059) | _mix_internal ready=false | E-02 (line 39) ERR_FAIL_COND_V | ○ |
| C-60 (UT-VOR-060) | _mix_internal active=false | E-02 (line 41-43) | ○ |
| C-61 (UT-VOR-061) | ループ再生 | E-02 (line 125-141) | ○ |
| C-62 (UT-VOR-062) | 非ループ停止 | E-02 (line 135-139) | ○ |
| C-63 (UT-VOR-063) | BPMベースループ | E-02 (line 50-52, 102-122) | △ |
| C-64 (UT-VOR-064) | ループフェード | E-02 (line 68-74, 107-116) | △ |
| C-65 (UT-VOR-065) | _mix_frames_vorbis正常 | E-02 (line 146-190) | ○ |
| C-66 (UT-VOR-066) | ステレオ処理 | E-02 (line 177-181) | ○ |
| C-67 (UT-VOR-067) | モノラル処理 | E-02 (line 182-186) | ○ |
| C-68 (UT-VOR-068) | パケット終端 | E-02 (line 152-155) | ○ |
| C-69 (UT-VOR-069) | デストラクタ正常 | E-02 (line 397-410) | ○ |
| C-70 (UT-VOR-070) | デストラクタ部分解放 | E-02 (line 398-409) 各フラグチェック | ○ |
| C-71 (UT-VOR-071) | tag_used_streams | E-02 (line 256-258) | ○ |

### ResourceImporterOggVorbis クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 (UT-VOR-072) | get_importer_name | E-04 (line 43-45) | ○ |
| C-73 (UT-VOR-073) | get_visible_name | E-04 (line 47-49) | ○ |
| C-74 (UT-VOR-074) | get_recognized_extensions | E-04 (line 51-53) | ○ |
| C-75 (UT-VOR-075) | get_save_extension | E-04 (line 55-57) | ○ |
| C-76 (UT-VOR-076) | get_resource_type | E-04 (line 59-61) | ○ |
| C-77 (UT-VOR-077) | get_preset_count | E-04 (line 67-69) | ○ |
| C-78 (UT-VOR-078) | get_preset_name | E-04 (line 71-73) | ○ |
| C-79 (UT-VOR-079) | get_import_options | E-04 (line 75-81) | ○ |
| C-80 (UT-VOR-080) | get_option_visibility | E-04 (line 63-65) | ○ |
| C-81 (UT-VOR-081) | import正常 | E-04 (line 96-115) | ○ |
| C-82 (UT-VOR-082) | import loop反映 | E-04 (line 97, 108) | ○ |
| C-83 (UT-VOR-083) | import BPM反映 | E-04 (line 99, 110) | ○ |
| C-84 (UT-VOR-084) | import無効ファイル | E-04 (line 104-106) ERR_CANT_OPEN | ○ |
| C-85 (UT-VOR-085) | can_import_threaded | E-03 (line 66) | ○ |
| C-86 (UT-VOR-086) | load_from_file非推奨 | E-04 (line 122-124) | ○ |
| C-87 (UT-VOR-087) | load_from_buffer非推奨 | E-04 (line 118-120) | ○ |

### モジュール登録
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 (UT-VOR-088) | initialize SCENEレベル | E-06 (line 47-50) | ○ |
| C-89 (UT-VOR-089) | initialize EDITORレベル | E-06 (line 52-57) | △ |
| C-90 (UT-VOR-090) | uninitialize | E-06 (line 61-62) | ○ |

## 4) 不足情報（Unknown / Missing）

1. **BPMベースループ処理（UT-VOR-063）**
   - beat_length_framesの計算式は確認済み（line 51）
   - 実際の動作タイミングやエッジケースは実行テストが必要
   - 候補：実際のオーディオファイルでの統合テスト / 境界値テスト

2. **ループフェード処理（UT-VOR-064）**
   - FADE_SIZE=256フレームのフェード処理
   - loop_fade配列の使用パターンはコードで確認可能
   - フェードの聴覚的品質は主観評価が必要
   - 候補：オーディオ出力の波形解析 / 聴覚テスト

3. **TOOLS_ENABLED条件（UT-VOR-089）**
   - エディタビルド時のみ有効
   - _editor_init関数の登録処理
   - 候補：エディタビルドでの実行確認 / ランタイムビルドとの差分確認

## 5) リスクフラグ（レビュー観点）

| リスク | 項目 | 説明 |
|-------|------|------|
| 1 | メモリリーク | デストラクタでのVorbis構造体解放（C-69, C-70）|
| 1 | スレッドセーフティ | can_import_threadedがtrue（C-85）|
| 0 | エラーハンドリング | 各ERR_FAIL_COND/ERR_FAIL_COND_Vの網羅確認済み |
| 0 | バリデーション | set_bpm, set_beat_count, set_bar_beatsの境界チェック確認済み |
| 1 | オーディオ品質 | ループフェード、サンプリングレート変換の品質 |

## 6) レビュアーチェックリスト（最小）

- [ ] load_from_buffer/load_from_fileの実ファイルでのテスト
- [ ] 不正なOggファイル（破損、非Vorbis）でのエラーハンドリング確認
- [ ] BPMベースループの実際の動作確認
- [ ] デストラクタでのメモリリーク検証（Valgrind等）
- [ ] スレッドセーフなインポート処理の検証
- [ ] ステレオ/モノラルの正しいチャンネル処理
- [ ] シーク処理の精度（特にページ境界をまたぐケース）
