---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 128
  claims_with_evidence: 125
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：modules-webrtc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：125 / 128、根拠なし：3
- 優先レビュー（高）
  1. **UT-WRT-123**: JS環境エラー時の挙動は実際のブラウザ環境でのテストが必要
  2. **UT-WRT-125**: JS API失敗時のnull返却は実環境依存
  3. **UT-WRT-115**: バッファオーバーフロー時の正確な閾値は設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/webrtc/webrtc_data_channel.h` - WebRTCDataChannel基底クラス定義（列挙型、仮想メソッド宣言）
- E-02: `modules/webrtc/webrtc_data_channel.cpp` - WebRTCDataChannelコンストラクタ、_bind_methods実装
- E-03: `modules/webrtc/webrtc_peer_connection.h` - WebRTCPeerConnection基底クラス定義（状態列挙型、仮想メソッド）
- E-04: `modules/webrtc/webrtc_peer_connection.cpp` - set_default_extension、create、_bind_methods実装
- E-05: `modules/webrtc/webrtc_multiplayer_peer.h` - WebRTCMultiplayerPeer定義（NetworkMode、ConnectedPeer内部クラス）
- E-06: `modules/webrtc/webrtc_multiplayer_peer.cpp` - 全publicメソッド実装（create_server/client/mesh、add/remove_peer、poll等）
- E-07: `modules/webrtc/webrtc_peer_connection_extension.h` - WebRTCPeerConnectionExtension GDExtensionバインディング定義
- E-08: `modules/webrtc/webrtc_peer_connection_extension.cpp` - _bind_methods（GDVIRTUALバインド）
- E-09: `modules/webrtc/webrtc_data_channel_extension.h` - WebRTCDataChannelExtension定義
- E-10: `modules/webrtc/webrtc_data_channel_extension.cpp` - get_packet/put_packet実装（GDVIRTUAL_CALL使用）
- E-11: `modules/webrtc/webrtc_peer_connection_js.h` - WebRTCPeerConnectionJS定義（Web環境専用）
- E-12: `modules/webrtc/webrtc_peer_connection_js.cpp` - JS関数呼び出し実装（godot_js_rtc_pc_*）
- E-13: `modules/webrtc/webrtc_data_channel_js.h` - WebRTCDataChannelJS定義（RingBuffer、コールバック）
- E-14: `modules/webrtc/webrtc_data_channel_js.cpp` - JSデータチャンネル実装（_on_message、get_packet/put_packet）
- E-15: `modules/webrtc/register_types.h` - モジュール登録関数宣言
- E-16: `modules/webrtc/register_types.cpp` - initialize_webrtc_module実装（ClassDB登録、GLOBAL_DEF）

## 3) Claims と根拠の対応（レビューの主戦場）

### WebRTCDataChannel（UT-WRT-001〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WriteMode列挙型（TEXT/BINARY）が定義されている | E-01 (L39-42) | ○ |
| C-02 | ChannelState列挙型（CONNECTING/OPEN/CLOSING/CLOSED）が定義されている | E-01 (L44-49) | ○ |
| C-03 | set_write_mode/get_write_modeは純粋仮想関数 | E-01 (L57-58) | ○ |
| C-04 | was_string_packetは純粋仮想関数 | E-01 (L59) | ○ |
| C-05 | get_ready_stateは純粋仮想関数でChannelStateを返す | E-01 (L61) | ○ |
| C-06 | get_label/is_ordered/get_id等のプロパティメソッドが定義 | E-01 (L62-68) | ○ |
| C-07 | get_buffered_amountは純粋仮想関数 | E-01 (L70) | ○ |
| C-08 | poll/closeメソッドが定義 | E-01 (L72-73) | ○ |
| C-09 | コンストラクタでGLOBAL_GETからバッファサイズ計算 | E-02 (L63-65) | ○ |
| C-10 | _bind_methodsで全メソッドがバインドされている | E-02 (L35-60) | ○ |

### WebRTCPeerConnection（UT-WRT-021〜050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | ConnectionState列挙型（NEW/CONNECTING/CONNECTED/DISCONNECTED/FAILED/CLOSED） | E-03 (L39-46) | ○ |
| C-12 | GatheringState列挙型（NEW/GATHERING/COMPLETE） | E-03 (L48-52) | ○ |
| C-13 | SignalingState列挙型（STABLE/HAVE_LOCAL_OFFER等） | E-03 (L54-61) | ○ |
| C-14 | initializeメソッドはDictionaryを引数に取る | E-03 (L76) | ○ |
| C-15 | create_data_channelはlabelとoptionsを引数に取る | E-03 (L77) | ○ |
| C-16 | create_offerは引数なし | E-03 (L78) | ○ |
| C-17 | set_remote/local_descriptionはtype,sdpを引数に取る | E-03 (L79-80) | ○ |
| C-18 | add_ice_candidateは3引数（mid, mline_index, sdp） | E-03 (L81) | ○ |
| C-19 | set_default_extensionでClassDB::is_parent_classチェック | E-04 (L42-43) | ○ |
| C-20 | createファクトリメソッドでWEB_ENABLEDによる分岐 | E-04 (L46-62) | ○ |
| C-21 | session_description_created/ice_candidate_created/data_channel_receivedシグナル定義 | E-04 (L80-82) | ○ |

### WebRTCMultiplayerPeer（UT-WRT-051〜108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | CH_RELIABLE=0, CH_ORDERED=1, CH_UNRELIABLE=2, CH_RESERVED_MAX=3 | E-05 (L44-49) | ○ |
| C-23 | NetworkMode列挙型（NONE/SERVER/CLIENT/MESH） | E-05 (L51-56) | ○ |
| C-24 | ConnectedPeerクラスにconnection, channels, connectedメンバ | E-05 (L58-70) | ○ |
| C-25 | create_serverでunique_id=1、MODE_SERVER設定 | E-06 (L190-192) | ○ |
| C-26 | create_clientでp_self_id==1チェックしERR_INVALID_PARAMETER | E-06 (L194-196) | ○ |
| C-27 | _initializeでp_self_id範囲チェック（<1または>~(1<<31)） | E-06 (L204) | ○ |
| C-28 | _initializeでchannels_config要素のVariant::INTチェック | E-06 (L211) | ○ |
| C-29 | add_peerでMODE_NONEチェック→ERR_UNCONFIGURED | E-06 (L289) | ○ |
| C-30 | add_peerでMODE_CLIENTかつp_peer_id!=1チェック | E-06 (L290) | ○ |
| C-31 | add_peerでMODE_SERVERかつp_peer_id==1チェック | E-06 (L291) | ○ |
| C-32 | add_peerでp_unreliable_lifetime<0チェック | E-06 (L293) | ○ |
| C-33 | add_peerでis_refusing_new_connections()チェック | E-06 (L294) | ○ |
| C-34 | add_peerでp_peer.is_null()チェック | E-06 (L296) | ○ |
| C-35 | add_peerでget_connection_state()!=STATE_NEWチェック | E-06 (L297) | ○ |
| C-36 | remove_peerでpeer_map.has()チェック | E-06 (L333) | ○ |
| C-37 | remove_peerでMODE_CLIENTかつTARGET_PEER_SERVER時にDISCONNECTED | E-06 (L339-341) | ○ |
| C-38 | get_peerで!peer_map.has()時に空Dictionary返却 | E-06 (L272) | ○ |
| C-39 | put_packetでCONNECTION_DISCONNECTEDチェック | E-06 (L376) | ○ |
| C-40 | put_packetでtarget_peer>0の単一送信とtarget_peer<=0のブロードキャスト分岐 | E-06 (L395-416) | ○ |
| C-41 | get_available_packet_countでnext_packet_peer==0時に0返却 | E-06 (L421-422) | ○ |
| C-42 | get_max_packet_sizeは1200固定 | E-06 (L436-438) | ○ |
| C-43 | pollでpeer_map.is_empty()時に早期リターン | E-06 (L67-69) | ○ |
| C-44 | pollでSTATE_CONNECTED以外（DISCONNECTED/FAILED/CLOSED）をremoveリストに追加 | E-06 (L85-88) | ○ |
| C-45 | pollで全チャンネルOPENかつ!connectedの時にaddリストに追加 | E-06 (L108-110) | ○ |
| C-46 | closeで全状態をリセット（peer_map.clear(), unique_id=0等） | E-06 (L440-449) | ○ |
| C-47 | disconnect_peerでp_force=trueの時peer_map.erase即実行 | E-06 (L347-351) | ○ |
| C-48 | disconnect_peerでp_force=falseの時connection->close()呼び出し | E-06 (L353) | ○ |
| C-49 | get_unique_idでCONNECTION_DISCONNECTED時に1返却 | E-06 (L253) | ○ |
| C-50 | is_server_relay_supportedでMODE_SERVER/CLIENT時にtrue | E-06 (L248-250) | ○ |

### Extension/JS実装（UT-WRT-109〜128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | WebRTCDataChannelExtension::get_packetでGDVIRTUAL_CALL | E-10 (L59-65) | ○ |
| C-52 | WebRTCDataChannelExtension::get_packet未実装時WARN_PRINT_ONCE | E-10 (L64) | ○ |
| C-53 | WebRTCDataChannelExtension::put_packetでGDVIRTUAL_CALL | E-10 (L68-74) | ○ |
| C-54 | WebRTCDataChannelJS::_on_messageでspace_left()チェック | E-14 (L77) | ○ |
| C-55 | WebRTCDataChannelJS::get_packetでSTATE_OPENチェック | E-14 (L106) | ○ |
| C-56 | WebRTCDataChannelJS::get_packetでqueue_count==0時ERR_UNAVAILABLE | E-14 (L108-110) | ○ |
| C-57 | WebRTCDataChannelJS::put_packetでSTATE_OPENチェック | E-14 (L136) | ○ |
| C-58 | WebRTCPeerConnectionJS::create_data_channelでSTATE_NEWチェック | E-12 (L118) | ○ |
| C-59 | WebRTCPeerConnectionJS::create_offerでSTATE_NEWチェック | E-12 (L79) | ○ |
| C-60 | WebRTCPeerConnectionJS::set_remote_descriptionでofferタイプ時STATE_NEWチェック | E-12 (L92-95) | ○ |
| C-61 | initialize_webrtc_moduleでMODULE_INITIALIZATION_LEVEL_SCENEチェック | E-16 (L42-44) | ○ |
| C-62 | initialize_webrtc_moduleでGLOBAL_DEFによるmax_channel_in_buffer_kb登録 | E-16 (L45) | ○ |
| C-63 | WebRTCPeerConnectionJS::initializeでJS API失敗時FAILED返却 | E-12 (L114) | △ |
| C-64 | WebRTCDataChannelJS::_on_messageのバッファオーバーフロー閾値 | E-14 (L77) | △ |
| C-65 | WebRTCPeerConnectionJS環境エラー時の挙動 | E-12 | △ |

## 4) 不足情報（Unknown / Missing）
- **JS環境依存の挙動**: WebRTCPeerConnectionJS、WebRTCDataChannelJSのエラー系テストケースは、実際のブラウザ環境（Emscripten）でのテストが必要
  - 候補：Emscriptenテスト環境 / ブラウザ自動テスト / モック実装
- **バッファサイズ計算の詳細**: `nearest_shift`関数の実装詳細がcore/mathに存在するが本モジュール外
  - 候補：core/math/math_funcs.h / ユニットテストでの境界値確認
- **GDExtensionの実装テスト**: EXBIND系マクロの展開結果は自動生成ファイルに依存
  - 候補：ext_wrappers.gen.inc / gdvirtual.gen.inc

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: WebRTCDataChannel/WebRTCPeerConnection基底クラスのテストケース（純粋仮想関数のインターフェース確認）
- **1（中リスク）**: WebRTCMultiplayerPeerの状態遷移テスト（複数のピア間の相互作用）
- **2（高リスク）**: JS実装（WebRTCPeerConnectionJS/WebRTCDataChannelJS）のテストケース - 実行環境依存性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 状態遷移テスト（UT-WRT-005〜008, 021〜026）が全状態をカバーしているか確認
- [ ] add_peer/remove_peerの入力検証テスト（UT-WRT-058〜068）が全エラー条件を網羅しているか確認
- [ ] put_packet/get_packetのエラーハンドリングテスト（UT-WRT-075〜082）が実用的なシナリオをカバーしているか確認
- [ ] JS実装のテストケース（UT-WRT-113〜125）がWeb環境でのみ実行されることを考慮した設計になっているか確認
- [ ] Extension実装のGDVIRTUAL_CALLテスト（UT-WRT-109〜112）がGDExtension APIの仕様と整合しているか確認
- [ ] pollメソッドのテストケース（UT-WRT-096〜099）が接続状態変化のイベント発火を適切に検証しているか確認
