---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 198
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：modules-websocket 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：198 / 200、根拠なし：2
- 優先レビュー（高）
  1. **UT-WS-091**：RFC6455準拠のキー計算検証 - 仕様書との照合が必要
  2. **UT-WS-183**：ポート再試行ロジック - エディタ設定との整合性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/websocket_peer.h`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/websocket_peer.cpp`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/websocket_multiplayer_peer.h`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/websocket_multiplayer_peer.cpp`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/wsl_peer.h`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/wsl_peer.cpp`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/emws_peer.h`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/emws_peer.cpp`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/packet_buffer.h`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/remote_debugger_peer_websocket.h`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/remote_debugger_peer_websocket.cpp`
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/editor/editor_debugger_server_websocket.h`
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/editor/editor_debugger_server_websocket.cpp`
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/websocket/register_types.cpp`

## 3) Claims と根拠の対応（レビューの主戦場）

### WebSocketPeer クラス (UT-WS-001 - UT-WS-021)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocketPeer::create()でファクトリパターンが実装されている | E-01 (76-81行), E-02 (33行) | ○ |
| C-02 | send_text()でUTF-8エンコーディングが行われる | E-02 (99-102行) | ○ |
| C-03 | set_supported_protocols()で前後空白が除去される | E-02 (104-110行) | ○ |
| C-04 | DEFAULT_BUFFER_SIZE = 65535 | E-01 (52-54行) | ○ |
| C-05 | max_queued_packets = 4096 | E-01 (72行) | ○ |
| C-06 | heartbeat_interval_msec = 0 がデフォルト | E-01 (73行) | ○ |
| C-07 | set_heartbeat_interval()で負の値チェック | E-02 (164-166行) | ○ |
| C-08 | State列挙型にCONNECTING, OPEN, CLOSING, CLOSEDが定義 | E-01 (40-45行) | ○ |
| C-09 | WriteMode列挙型にTEXT, BINARYが定義 | E-01 (47-50行) | ○ |

### WSLPeer クラス (UT-WS-022 - UT-WS-091)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | WSLPeer::initialize()で_createと_static_rngが設定される | E-06 (39-43行) | ○ |
| C-11 | WSLPeer::deinitialize()で_static_rngが解放される | E-06 (45-50行) | ○ |
| C-12 | connect_to_url()で空URLチェック | E-06 (478行) | ○ |
| C-13 | connect_to_url()でプロトコル検証(ws://, wss://) | E-06 (494行) | ○ |
| C-14 | connect_to_url()で状態検証(STATE_CLOSED, STATE_CLOSING) | E-06 (480行) | ○ |
| C-15 | connect_to_url()でサーバー用TLSオプション拒否 | E-06 (479行) | ○ |
| C-16 | デフォルトポート: ws=80, wss=443 | E-06 (500-502行) | ○ |
| C-17 | accept_stream()でnullストリームチェック | E-06 (128行) | ○ |
| C-18 | accept_stream()で状態検証 | E-06 (129行) | ○ |
| C-19 | accept_stream()でStreamPeerTCPとStreamPeerTLSをサポート | E-06 (133-143行) | ○ |
| C-20 | _send()でready_state検証 | E-06 (782行) | ○ |
| C-21 | _send()でキュー数制限チェック | E-06 (783行) | ○ |
| C-22 | _send()でバッファサイズ制限チェック | E-06 (784行) | ○ |
| C-23 | close()で負のコードで強制クローズ | E-06 (844-847行) | ○ |
| C-24 | poll()でSTATE_CLOSED時は早期リターン | E-06 (699-701行) | ○ |
| C-25 | poll()でハートビート処理 | E-06 (715-737行) | ○ |
| C-26 | get_packet()でready_state検証 | E-06 (811行) | ○ |
| C-27 | get_packet()でパケットなし時ERR_UNAVAILABLE | E-06 (813-815行) | ○ |
| C-28 | get_available_packet_count()でSTATE_OPEN以外は0 | E-06 (828-830行) | ○ |
| C-29 | get_current_outbound_buffered_amount()でSTATE_OPEN以外は0 | E-06 (836-838行) | ○ |
| C-30 | get_connected_host()でtcp.is_null()チェック | E-06 (872行) | ○ |
| C-31 | get_connected_port()でtcp.is_null()チェック | E-06 (877行) | ○ |
| C-32 | set_no_delay()でtcp.is_null()チェック | E-06 (890行) | ○ |
| C-33 | Resolver::start()でIPアドレス判定 | E-06 (59-60行) | ○ |
| C-34 | Resolver::start()でホスト名の非同期解決 | E-06 (62-71行) | ○ |
| C-35 | Resolver::stop()でresolver_idクリア | E-06 (75-81行) | ○ |
| C-36 | _parse_client_request()でGETメソッド検証 | E-06 (162行) | ○ |
| C-37 | _parse_client_request()でHTTP/1.1検証 | E-06 (162行) | ○ |
| C-38 | _parse_client_request()でUpgradeヘッダー検証 | E-06 (183行) | ○ |
| C-39 | _parse_client_request()でSec-WebSocket-Key検証 | E-06 (185行) | ○ |
| C-40 | _parse_client_request()でSec-WebSocket-Version=13検証 | E-06 (184行) | ○ |
| C-41 | _verify_server_response()でステータスコード101検証 | E-06 (428行) | ○ |
| C-42 | _verify_server_response()でSec-WebSocket-Accept検証 | E-06 (451行) | ○ |
| C-43 | _generate_key()で16バイトキー生成 | E-06 (685行) | ○ |
| C-44 | _compute_key_response()でRFC6455マジックUUID使用 | E-06 (692行) | △ |
| C-45 | WSL_MAX_HEADER_SIZE = 4096 | E-05 (43行) | ○ |

### EMWSPeer クラス (UT-WS-092 - UT-WS-103)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | EMWSPeer::connect_to_url()で空URLチェック | E-08 (64行) | ○ |
| C-47 | EMWSPeer::connect_to_url()でプロトコル検証 | E-08 (81行) | ○ |
| C-48 | EMWSPeer::accept_stream()でERR_UNAVAILABLE返却 | E-08 (115-117行) | ○ |
| C-49 | EMWSPeer::_send()でバッファ制限チェック | E-08 (121行) | ○ |
| C-50 | EMWSPeer::close()で負コード処理 | E-08 (183-189行) | ○ |
| C-51 | EMWSPeer::poll()は何もしない(ブラウザ委譲) | E-08 (202-204行) | ○ |
| C-52 | EMWSPeer::get_connected_host()でERR_FAIL | E-08 (226-227行) | ○ |
| C-53 | EMWSPeer::get_connected_port()でERR_FAIL | E-08 (230-231行) | ○ |
| C-54 | EMWSPeer::set_no_delay()でERR_FAIL | E-08 (234-235行) | ○ |

### PacketBuffer クラス (UT-WS-104 - UT-WS-117)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | write_packet()でペイロード領域チェック | E-09 (51行) | ○ |
| C-56 | write_packet()でパケット数チェック | E-09 (52行) | ○ |
| C-57 | write_packet()でp_info=null時はペイロードのみ | E-09 (54-66行) | ○ |
| C-58 | write_packet()でp_payload=null時は情報のみ | E-09 (68-71行) | ○ |
| C-59 | read_packet()でキュー空チェック | E-09 (77行) | ○ |
| C-60 | read_packet()でバッファサイズチェック | E-09 (86行) | ○ |
| C-61 | resize()でポインタリセット | E-09 (97-99行) | ○ |
| C-62 | clear()で全リセット | E-09 (114-120行) | ○ |

### WebSocketMultiplayerPeer クラス (UT-WS-118 - UT-WS-158)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | create_server()で状態検証 | E-04 (182行) | ○ |
| C-64 | create_server()でTLSオプション検証 | E-04 (183行) | ○ |
| C-65 | create_client()で状態検証 | E-04 (198行) | ○ |
| C-66 | create_client()でTLSオプション検証 | E-04 (199行) | ○ |
| C-67 | is_server()でtcp_server.is_valid()判定 | E-04 (214-216行) | ○ |
| C-68 | poll()でCONNECTION_DISCONNECTED時早期リターン | E-04 (404-406行) | ○ |
| C-69 | _poll_client()でID受信処理 | E-04 (226-244行) | ○ |
| C-70 | _poll_server()でハンドシェイクタイムアウト | E-04 (297-301行) | ○ |
| C-71 | disconnect_peer()で強制切断時マップ削除 | E-04 (485-490行) | ○ |
| C-72 | get_packet()で状態検証 | E-04 (119行) | ○ |
| C-73 | put_packet()で状態検証 | E-04 (140行) | ○ |
| C-74 | put_packet()でターゲットピア検証 | E-04 (144行) | ○ |
| C-75 | put_packet()でブロードキャスト | E-04 (146-153行) | ○ |
| C-76 | put_packet()で除外送信 | E-04 (148-149行) | ○ |
| C-77 | get_max_packet_size()でPROTO_SIZE減算 | E-04 (177-179行) | ○ |
| C-78 | PROTO_SIZE = 9 | E-03 (52行) | ○ |
| C-79 | handshake_timeout = 3000 | E-03 (68行) | ○ |
| C-80 | set_handshake_timeout()で0以下チェック | E-04 (468行) | ○ |

### RemoteDebuggerPeerWebSocket クラス (UT-WS-159 - UT-WS-179)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | connect_to_host()でプロトコル設定 | E-11 (39-42行) | ○ |
| C-82 | connect_to_host()でバッファサイズ設定((1<<23)-1) | E-11 (44-45行) | ○ |
| C-83 | is_peer_connected()で状態判定 | E-11 (60-62行) | ○ |
| C-84 | poll()でws_peer.is_null()チェック | E-11 (65行) | ○ |
| C-85 | poll()でメッセージ受信キュー制限 | E-11 (68行) | ○ |
| C-86 | put_message()でキュー満杯チェック | E-11 (101-103行) | ○ |
| C-87 | can_block()でWEB_ENABLED分岐 | E-11 (114-120行) | ○ |
| C-88 | create()でプロトコル検証 | E-11 (133行) | ○ |

### EditorDebuggerServerWebSocket クラス (UT-WS-180 - UT-WS-196)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | start()でmax_attempts=5のポート再試行 | E-13 (84-96行) | △ |
| C-90 | poll()で3000msタイムアウト | E-13 (60行) | ○ |
| C-91 | is_active()でis_listening()判定 | E-13 (109-111行) | ○ |
| C-92 | is_connection_available()でSTATE_OPEN判定 | E-13 (113-115行) | ○ |
| C-93 | create()でプロトコル検証(ws://) | E-13 (133行) | ○ |

### モジュール初期化 (UT-WS-197 - UT-WS-200)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | initialize_websocket_module()でクラス登録 | E-14 (69-70行) | ○ |
| C-95 | initialize_websocket_module()でURIハンドラ登録 | E-14 (72-73行) | ○ |
| C-96 | uninitialize_websocket_module()でレベルチェック | E-14 (84-86行) | ○ |
| C-97 | uninitialize_websocket_module()でWSLPeer::deinitialize() | E-14 (88行) | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-44 (UT-WS-091)**: RFC6455仕様書との完全な照合
  - 候補：RFC6455 The WebSocket Protocol / IETF仕様書 / WebSocket公式ドキュメント
  - 現状：コード内にマジックUUID "258EAFA5-E914-47DA-95CA-C5AB0DC85B11" が含まれており、SHA-1ハッシュとBase64エンコードが実装されているが、RFC仕様との完全一致は外部仕様書の確認が必要

- **C-89 (UT-WS-183)**: エディタ設定との整合性
  - 候補：EditorSettings / network/debug/remote_host, remote_port設定
  - 現状：コード内でEDITOR_GET()を使用してデフォルト値を取得しているが、設定の詳細な仕様は別ファイルを参照する必要がある

## 5) リスクフラグ（レビュー観点）

| リスク | 対象 | 説明 |
|--------|------|------|
| 0 (低) | WebSocketPeer基本機能 | getter/setterは単純で、コードと一致 |
| 0 (低) | PacketBuffer | テンプレートクラスで境界チェックが明確 |
| 1 (中) | WSLPeerハンドシェイク | 複雑なHTTPパース処理、エッジケースの網羅性 |
| 1 (中) | EMWSPeer | Web環境固有の制限事項、実環境テストが必要 |
| 1 (中) | WebSocketMultiplayerPeer | マルチピア管理、競合状態の可能性 |
| 2 (高) | セキュリティ関連 | TLS処理、キー生成・検証のRFC準拠性 |

## 6) レビュアーチェックリスト（最小）

- [ ] RFC6455準拠性：_compute_key_response()のマジックUUID "258EAFA5-E914-47DA-95CA-C5AB0DC85B11" が正しいか
- [ ] バッファオーバーフロー：WSL_MAX_HEADER_SIZE (4096) の制限が十分か
- [ ] ハンドシェイクタイムアウト：3000ms (WebSocketMultiplayerPeer) がユースケースに適切か
- [ ] ポート再試行ロジック：max_attempts=5が適切か、ログ出力が十分か
- [ ] Web環境制限：accept_stream()、get_connected_host/port()、set_no_delay()の非対応が文書化されているか
- [ ] メモリ管理：PacketBufferのwrite_packet/read_packetでメモリリークがないか
- [ ] スレッドセーフティ：WebSocketMultiplayerPeerのpoll()が複数スレッドから呼ばれた場合の挙動
- [ ] エラーハンドリング：ERR_FAIL_COND系マクロの使用が適切か
