---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 110
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-webxr 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：110 / 110、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/webxr/webxr_interface.h` - WebXRInterface基底クラス定義（80行）
- E-02: `modules/webxr/webxr_interface.cpp` - WebXRInterfaceのメソッドバインディング実装（83行）
- E-03: `modules/webxr/webxr_interface_js.h` - WebXRInterfaceJS派生クラス定義（265行）
- E-04: `modules/webxr/webxr_interface_js.cpp` - WebXRInterfaceJSの実装（891行）
- E-05: `modules/webxr/register_types.h` - モジュール登録ヘッダー（37行）
- E-06: `modules/webxr/register_types.cpp` - モジュール初期化・終了処理（77行）
- E-07: `modules/webxr/godot_webxr.h` - WebXR JavaScript API定義（100行）
- E-08: `modules/webxr/webxr_interface.compat.inc` - 互換性メソッド（42行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッドバインディング（_bind_methods） | E-02:34-82 | ○ |
| C-02 | TargetRayMode列挙型定義 | E-01:52-57 | ○ |
| C-03 | set_session_mode実装 | E-04:124-126 | ○ |
| C-04 | get_session_mode実装 | E-04:128-130 | ○ |
| C-05 | set_required_features実装 | E-04:132-134 | ○ |
| C-06 | get_required_features実装 | E-04:136-138 | ○ |
| C-07 | set_optional_features実装 | E-04:140-142 | ○ |
| C-08 | get_optional_features実装 | E-04:144-146 | ○ |
| C-09 | set_requested_reference_space_types実装 | E-04:148-150 | ○ |
| C-10 | get_requested_reference_space_types実装 | E-04:152-154 | ○ |
| C-11 | get_reference_space_type実装 | E-04:156-158 | ○ |
| C-12 | get_enabled_features実装 | E-04:160-162 | ○ |
| C-13-16 | is_input_source_active実装・境界値 | E-04:164-167 | ○ |
| C-17-18 | get_input_source_tracker実装・境界値 | E-04:169-172 | ○ |
| C-19-21 | get_input_source_target_ray_mode実装・境界値 | E-04:174-180 | ○ |
| C-22-23 | get_visibility_state実装・null処理 | E-04:182-191 | ○ |
| C-24-25 | get_play_area実装・境界値 | E-04:193-208 | ○ |
| C-26-27 | display_refresh_rate getter/setter | E-04:210-216 | ○ |
| C-28-29 | get_available_display_refresh_rates実装 | E-04:218-232 | ○ |
| C-30-33 | environment_blend_mode関連メソッド | E-04:234-252 | ○ |
| C-34-38 | _set_environment_blend_mode内部実装 | E-04:254-270 | ○ |
| C-39 | get_name実装 | E-04:272-274 | ○ |
| C-40 | get_capabilities実装 | E-04:276-278 | ○ |
| C-41-42 | is_initialized実装 | E-04:284-286 | ○ |
| C-43-48 | initialize実装・エラー処理 | E-04:288-343 | ○ |
| C-49-52 | uninitialize実装 | E-04:345-388 | ○ |
| C-53 | get_system_info実装 | E-04:390-398 | ○ |
| C-54-55 | _js_matrix_to_transform実装 | E-04:400-417 | ○ |
| C-56-57 | get_render_target_size実装 | E-04:419-437 | ○ |
| C-58-59 | get_camera_transform実装 | E-04:439-455 | ○ |
| C-60-62 | get_transform_for_view実装 | E-04:457-474 | ○ |
| C-63-64 | get_projection_for_view実装 | E-04:476-499 | ○ |
| C-65-66 | pre_draw_viewport実装 | E-04:501-524 | ○ |
| C-67 | post_draw_viewport実装 | E-04:526-537 | ○ |
| C-68-72 | テクスチャ取得関連メソッド | E-04:539-583 | ○ |
| C-73 | get_velocity_texture実装 | E-04:593-600 | ○ |
| C-74-75 | process実装 | E-04:602-618 | ○ |
| C-76-88 | _update_input_source実装 | E-04:620-813 | ○ |
| C-89-94 | _on_input_event実装 | E-04:815-861 | ○ |
| C-95-98 | _get_screen_position_from_joy_vector実装 | E-04:863-875 | ○ |
| C-99 | コンストラクタ | E-04:877-881 | ○ |
| C-100 | デストラクタ | E-04:883-888 | ○ |
| C-101 | get_view_count実装 | E-04:280-282 | ○ |
| C-102-104 | モジュール初期化・終了 | E-06:40-76 | ○ |
| C-105-110 | Emscriptenコールバック関数 | E-04:50-118 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのクレームがソースコードで確認可能

特記事項:
- WebXRモジュールはWeb（Emscripten）環境専用であり、`WEB_ENABLED`マクロで条件コンパイルされている
- JavaScript APIとの連携部分（godot_webxr_*関数）は外部定義されており、モック化が必要
- XRServer、TextureStorage等の外部依存があり、テスト時はモック/スタブが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 入力ソースID範囲チェック（0-15）のテストケースが適切か確認
- [ ] initialize/uninitializeの前提条件が正しいか確認
- [ ] EmscriptenコールバックのXRServer/Interface nullチェックが適切か確認
- [ ] ハンドトラッキングのジョイント変換（WebXR→Godot）が正しいか確認
- [ ] タッチイベント処理（スクリーンモード）のテストケースが十分か確認
- [ ] environment_blend_modeのフォールバック処理が適切か確認
