---
generated_at: 2026-01-23 16:50:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-xatlas_unwrap 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全てのテストケースがソースコードに基づいて設計されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/xatlas_unwrap/register_types.cpp` - メインのソースコード
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/xatlas_unwrap/register_types.h` - ヘッダファイル
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/xatlas_unwrap/config.py` - ビルド設定
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/modules/xatlas_unwrap/SCsub` - ビルドスクリプト
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/thirdparty/xatlas/xatlas.h` - xatlasライブラリヘッダ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-XAT-001) | 有効なメッシュデータでUVアンラップが成功すること | E-01 (L39-225) | ○ |
| C-02 (UT-XAT-002) | キャッシュが存在する場合にキャッシュからデータが読み込まれること | E-01 (L57-106) | ○ |
| C-03 (UT-XAT-003) | キャッシュが存在しない場合に新規アンラップが実行されること | E-01 (L107-178) | ○ |
| C-04 (UT-XAT-004) | キャッシュ使用フラグONで新規キャッシュデータが生成されること | E-01 (L181-220) | ○ |
| C-05 (UT-XAT-005) | UV座標が0.0-1.0の範囲に正規化されること | E-01 (L164-165) | ○ |
| C-06 (UT-XAT-006) | サイズヒントが正しく設定されること | E-01 (L140-141) | ○ |
| C-07 (UT-XAT-007) | texel_sizeが0以下の場合にfalseが返却されること | E-01 (L125) | ○ |
| C-08 (UT-XAT-008) | texel_sizeが負の値の場合にfalseが返却されること | E-01 (L125) | ○ |
| C-09 (UT-XAT-009) | アトラス幅または高さが0の場合にfalseが返却されること | E-01 (L146-149) | ○ |
| C-10 (UT-XAT-010) | xatlas::AddMeshがエラーを返す場合にfalseが返却されること | E-01 (L136) | ○ |
| C-11 (UT-XAT-011) | メモリ確保失敗時(r_vertex)にfalseが返却されること | E-01 (L153-154) | ○ |
| C-12 (UT-XAT-012) | メモリ確保失敗時(r_uv)にfalseが返却されること | E-01 (L155-156) | ○ |
| C-13 (UT-XAT-013) | メモリ確保失敗時(r_index)にfalseが返却されること | E-01 (L157-158) | ○ |
| C-14 (UT-XAT-014) | 頂点数1の最小メッシュでの動作 | E-01, E-05 | ○ |
| C-15 (UT-XAT-015) | 頂点数が非常に大きい場合の動作 | E-01, E-05 | ○ |
| C-16 (UT-XAT-016) | texel_sizeが非常に小さい値の場合 | E-01 (L131) | ○ |
| C-17 (UT-XAT-017) | texel_sizeが非常に大きい値の場合 | E-01 (L131) | ○ |
| C-18 (UT-XAT-018) | 複数エントリのキャッシュから正しいエントリが検索されること | E-01 (L62-80) | ○ |
| C-19 (UT-XAT-019) | MD5ハッシュが正しく計算されること | E-01 (L40-49) | ○ |
| C-20 (UT-XAT-020) | 異なる入力データで異なるハッシュが生成されること | E-01 (L40-49) | ○ |
| C-21 (UT-XAT-021) | ChartOptionsのfixWindingがtrueで設定されること | E-01 (L122-123) | ○ |
| C-22 (UT-XAT-022) | PackOptionsが正しく設定されること | E-01 (L127-131) | ○ |
| C-23 (UT-XAT-023) | 頂点参照(xref)が正しく出力されること | E-01 (L163), E-05 (L64) | ○ |
| C-24 (UT-XAT-024) | インデックス配列が正しく出力されること | E-01 (L172-176) | ○ |
| C-25 (UT-XAT-025) | MODULE_INITIALIZATION_LEVEL_SCENEでコールバックが登録されること | E-01 (L227-233), E-02 (L35) | ○ |
| C-26 (UT-XAT-026) | MODULE_INITIALIZATION_LEVEL_SCENE以外では何も実行されないこと(CORE) | E-01 (L228-230) | ○ |
| C-27 (UT-XAT-027) | MODULE_INITIALIZATION_LEVEL_SCENE以外では何も実行されないこと(SERVERS) | E-01 (L228-230) | ○ |
| C-28 (UT-XAT-028) | MODULE_INITIALIZATION_LEVEL_SCENEで正常に終了処理が実行されること | E-01 (L235-239), E-02 (L36) | ○ |
| C-29 (UT-XAT-029) | MODULE_INITIALIZATION_LEVEL_SCENE以外では何も実行されないこと(終了) | E-01 (L236-238) | ○ |
| C-30 (UT-XAT-030) | エディタビルド時にtrueが返却されること | E-03 (L1-2) | ○ |
| C-31 (UT-XAT-031) | 非エディタビルド時にfalseが返却されること | E-03 (L1-2) | ○ |
| C-32 (UT-XAT-032) | configure関数が正常に実行されること | E-03 (L5-6) | ○ |
| C-33 (UT-XAT-033) | インデックス数が3の最小三角形メッシュ | E-01, E-05 (L147) | ○ |
| C-34 (UT-XAT-034) | キャッシュエントリ数が0の場合 | E-01 (L60-61) | ○ |
| C-35 (UT-XAT-035) | r_use_cacheがfalseの場合にキャッシュが生成されないこと | E-01 (L181) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし
  - 全てのテストケースはソースコードに基づいて設計されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードの直接的な根拠に基づいている
- 注意点:
  - メモリ確保失敗テスト(UT-XAT-011〜013)はモック/スタブが必要な可能性がある
  - 大規模入力テスト(UT-XAT-015)は実行時間に注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] xatlas_mesh_lightmap_unwrap_callback関数の全分岐パスがテストでカバーされているか確認
- [ ] エラー処理のテストケース(UT-XAT-007〜013)が実装可能か確認
- [ ] キャッシュ機能のテストケース(UT-XAT-002〜004, 018, 034, 035)のテストデータ準備方法を検討
- [ ] モジュール初期化/終了テスト(UT-XAT-025〜029)の実行環境を確認
- [ ] ビルド設定テスト(UT-XAT-030〜032)のPythonテスト環境を確認

---

## 参考：モジュール構成

### ファイル一覧
| ファイル | 説明 |
|---------|------|
| `register_types.cpp` | メイン実装ファイル（xatlas_mesh_lightmap_unwrap_callback, 初期化/終了関数） |
| `register_types.h` | ヘッダファイル（関数宣言） |
| `config.py` | ビルド設定（can_build, configure） |
| `SCsub` | SCons ビルドスクリプト |

### 主要関数
| 関数名 | 説明 | テストケース数 |
|--------|------|---------------|
| `xatlas_mesh_lightmap_unwrap_callback` | ライトマップ用メッシュUVアンラップ | 24 |
| `initialize_xatlas_unwrap_module` | モジュール初期化 | 3 |
| `uninitialize_xatlas_unwrap_module` | モジュール終了 | 2 |
| `can_build` (Python) | ビルド可否判定 | 2 |
| `configure` (Python) | ビルド設定 | 1 |

### 外部依存
- `xatlas` ライブラリ（`thirdparty/xatlas/`）
- `CryptoCore::MD5Context`（Godot内部）
