---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 56
  claims_with_evidence: 54
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：modules-zip 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：54 / 56、根拠なし：2
- 優先レビュー（高）
  1. **UT-ZIP-038**：2GB以上のファイル処理の実際の動作確認が必要
  2. **UT-ZIP-028**：破損ZIPファイルの挙動は推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/zip/zip_packer.h` - ZIPPackerクラス定義、列挙型定義
- E-02: `modules/zip/zip_packer.cpp` - ZIPPackerメソッド実装
- E-03: `modules/zip/zip_reader.h` - ZIPReaderクラス定義
- E-04: `modules/zip/zip_reader.cpp` - ZIPReaderメソッド実装
- E-05: `modules/zip/register_types.h` - モジュール登録関数宣言
- E-06: `modules/zip/register_types.cpp` - モジュール登録関数実装
- E-07: `modules/zip/tests/test_zip.h` - 既存テストケース定義
- E-08: `modules/zip/tests/test_zip.cpp` - 既存テストヘルパー関数

## 3) Claims と根拠の対応（レビューの主戦場）

### ZIPPackerクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | open()はZIPファイルを作成できる | E-02 (36-44行目) | ○ |
| C-02 | open()は既存ファイルに追記できる | E-01 (49-53行目: ZipAppend列挙型), E-02 | ○ |
| C-03 | open()は既存オープン時に自動close | E-02 (37-39行目) | ○ |
| C-04 | open()は無効パスでFAILED | E-02 (43行目: zf != nullptr条件) | ○ |
| C-05 | close()はオープン済みをクローズ | E-02 (46-56行目) | ○ |
| C-06 | close()は未オープンでFAILED | E-02 (47行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-07 | set_compression_level()は有効値を設定 | E-02 (58-61行目) | ○ |
| C-08 | set_compression_level()は無効値でエラー | E-02 (59行目: ERR_FAIL_COND_MSG) | ○ |
| C-09 | get_compression_level()は値を返却 | E-02 (63-65行目) | ○ |
| C-10 | start_file()は新規ファイルを開始 | E-02 (67-103行目) | ○ |
| C-11 | start_file()はUTF-8対応 | E-02 (101行目: ビット11設定) | ○ |
| C-12 | start_file()は未オープンでFAILED | E-02 (68行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-13 | write_file()はデータを書き込む | E-02 (105-109行目) | ○ |
| C-14 | write_file()は未オープンでFAILED | E-02 (106行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-15 | close_file()はファイルをクローズ | E-02 (111-115行目) | ○ |
| C-16 | close_file()は未オープンでFAILED | E-02 (112行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-17 | デストラクタで自動close | E-02 (140-144行目) | ○ |

### ZIPReaderクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | open()はZIPファイルを開く | E-04 (36-44行目) | ○ |
| C-19 | open()は既存オープン時に自動close | E-04 (37-39行目) | ○ |
| C-20 | open()は存在しないファイルでFAILED | E-04 (43行目: uzf != nullptr条件) | ○ |
| C-21 | open()は破損ファイルでFAILED | E-04 (unzOpen2の戻り値) | △ |
| C-22 | close()はオープン済みをクローズ | E-04 (46-56行目) | ○ |
| C-23 | close()は未オープンでFAILED | E-04 (47行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-24 | get_files()はファイル一覧を返却 | E-04 (58-89行目) | ○ |
| C-25 | get_files()は空ZIPで空配列 | E-04 (64-66行目) | ○ |
| C-26 | get_files()は未オープンで空配列 | E-04 (59行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-27 | read_file()はファイル内容を読み込む | E-04 (91-126行目) | ○ |
| C-28 | read_file()は大文字小文字区別可能 | E-04 (97行目: godot_unzip_locate_file) | ○ |
| C-29 | read_file()は存在しないファイルで空配列 | E-04 (98行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-30 | read_file()は未オープンで空配列 | E-04 (92行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-31 | read_file()は2GB超でエラー | E-04 (106行目: INT_MAX比較) | ○ |
| C-32 | file_exists()は存在確認 | E-04 (128-141行目) | ○ |
| C-33 | file_exists()は大文字小文字区別可能 | E-04 (131行目: cs変数) | ○ |
| C-34 | file_exists()は未オープンでfalse | E-04 (129行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-35 | get_compression_level()は圧縮レベル取得 | E-04 (143-160行目) | ○ |
| C-36 | get_compression_level()は存在しないファイルで-1 | E-04 (147-149行目) | ○ |
| C-37 | get_compression_level()は未オープンで-1 | E-04 (144行目: ERR_FAIL_COND_V_MSG) | ○ |
| C-38 | デストラクタで自動close | E-04 (164-168行目) | ○ |

### モジュール登録
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | initialize_zip_moduleでクラス登録 | E-06 (38-45行目) | ○ |
| C-40 | SCENE以外のレベルでは登録しない | E-06 (39-41行目) | ○ |
| C-41 | uninitialize_zip_moduleは正常終了 | E-06 (47-51行目) | ○ |

### 統合テスト・境界値テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | 完全なZIP作成フロー | E-07 (43-59行目: default compression test) | ○ |
| C-43 | 完全なZIP読み込みフロー | E-07 (80-103行目: read files test) | ○ |
| C-44 | 相互運用性 | E-07 (両テストの組み合わせから推論) | ○ |
| C-45 | 2GB超ファイル処理 | E-04 (106行目のINT_MAX比較のみ) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-21（破損ZIPファイルの挙動）**: unzOpen2関数の内部動作はminizipライブラリに依存。実際の破損ファイル処理は実機テストが必要
  - 候補：minizip ライブラリのドキュメント / 実機テスト / サードパーティテストデータ
- **C-45（2GB超ファイル処理）**: INT_MAX比較のコードは存在するが、実際に2GBを超えるファイルでのテストは未実施
  - 候補：大容量テストデータ / メモリ使用量測定 / 実機テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ZIPPacker/ZIPReaderの基本API（open/close/read/write）
- **1（中リスク）**: 圧縮レベル設定、UTF-8ファイル名サポート
- **2（高リスク）**: 大容量ファイル処理（2GB制限）、破損ファイルハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] ZIPPackerの全メソッドが状態チェック（fa.is_null()）を行っていることを確認
- [ ] ZIPReaderの全メソッドが状態チェック（fa.is_null()）を行っていることを確認
- [ ] 圧縮レベルの境界値（-1, 0, 9, 10, -2）が正しくテストされていることを確認
- [ ] UTF-8ファイル名のエンコーディング処理が正しいことを確認
- [ ] 2GB制限に関するテストケースの妥当性を確認
- [ ] 既存テスト（test_zip.h/cpp）との整合性を確認
- [ ] 大文字小文字区別オプション（p_case_sensitive）の動作を確認
