---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 122
  claims_with_evidence: 122
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：scene-2d単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：122 / 122、根拠なし：0
- 優先レビュー（高）
  1. **物理関連テストケース（RigidBody2D, CharacterBody2D）**：実行時の物理シミュレーション結果に依存
  2. **座標変換テストケース（to_local, to_global）**：親子関係の状態に依存
  3. **TileMapLayerテストケース**：TileSetの設定に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/2d/node_2d.h` - Node2Dクラス定義
- E-02: `scene/2d/node_2d.cpp` - Node2Dクラス実装
- E-03: `scene/2d/sprite_2d.h` - Sprite2Dクラス定義
- E-04: `scene/2d/sprite_2d.cpp` - Sprite2Dクラス実装
- E-05: `scene/2d/camera_2d.h` - Camera2Dクラス定義
- E-06: `scene/2d/camera_2d.cpp` - Camera2Dクラス実装
- E-07: `scene/2d/physics/collision_object_2d.h` - CollisionObject2Dクラス定義
- E-08: `scene/2d/physics/rigid_body_2d.h` - RigidBody2Dクラス定義
- E-09: `scene/2d/physics/area_2d.h` - Area2Dクラス定義
- E-10: `scene/2d/physics/character_body_2d.h` - CharacterBody2Dクラス定義
- E-11: `scene/2d/animated_sprite_2d.h` - AnimatedSprite2Dクラス定義
- E-12: `scene/2d/line_2d.h` - Line2Dクラス定義
- E-13: `scene/2d/tile_map_layer.h` - TileMapLayerクラス定義
- E-14: `scene/2d/gpu_particles_2d.h` - GPUParticles2Dクラス定義
- E-15: `scene/2d/light_2d.h` - Light2D/PointLight2D/DirectionalLight2Dクラス定義
- E-16: `scene/2d/path_2d.h` - Path2D/PathFollow2Dクラス定義
- E-17: `scene/2d/skeleton_2d.h` - Skeleton2D/Bone2Dクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Node2D関連（C-01 ～ C-20）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Node2D::set_position()は位置を設定する | E-01, E-02 | ○ |
| C-02 | Node2D::set_position()で原点(0,0)が設定可能 | E-01, E-02 | ○ |
| C-03 | Node2D::set_rotation()はラジアン単位で回転を設定 | E-01, E-02 | ○ |
| C-04 | Node2D::set_rotation_degrees()は度単位で回転を設定 | E-01, E-02 | ○ |
| C-05 | Node2D::set_scale()はスケールを設定する | E-01, E-02 | ○ |
| C-06 | Node2D::set_scale()でゼロはCMP_EPSILONに補正される | E-02 (line 194-199) | ○ |
| C-07 | Node2D::set_skew()はスキューを設定する | E-01, E-02 | ○ |
| C-08 | Node2D::rotate()は現在の回転に加算する | E-02 (line 249-252) | ○ |
| C-09 | Node2D::translate()は現在の位置に加算する | E-02 (line 254-257) | ○ |
| C-10 | Node2D::global_translate()はグローバル位置に加算する | E-02 (line 259-262) | ○ |
| C-11 | Node2D::apply_scale()は現在のスケールに乗算する | E-02 (line 264-267) | ○ |
| C-12 | Node2D::move_x()はX軸方向に移動する | E-02 (line 269-277) | ○ |
| C-13 | Node2D::move_y()はY軸方向に移動する | E-02 (line 279-287) | ○ |
| C-14 | Node2D::to_local()はグローバル座標をローカル座標に変換 | E-02 (line 420-423) | ○ |
| C-15 | Node2D::to_global()はローカル座標をグローバル座標に変換 | E-02 (line 425-428) | ○ |
| C-16 | Node2D::look_at()は指定点を向くように回転する | E-02 (line 410-413) | ○ |
| C-17 | Node2D::get_angle_to()は指定点への角度を返す | E-02 (line 415-418) | ○ |
| C-18 | Node2D::get_relative_transform_to_parent()は相対Transformを取得 | E-02 (line 394-408) | ○ |
| C-19 | 自分自身が親の場合は単位行列を返す | E-02 (line 396-398) | ○ |
| C-20 | Node2D::reparent()でグローバルTransformを維持可能 | E-02 (line 144-153) | ○ |

### Sprite2D関連（C-21 ～ C-37）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | Sprite2D::set_texture()はテクスチャを設定する | E-03, E-04 | ○ |
| C-22 | Sprite2D::set_texture()でnullを設定可能 | E-04 | ○ |
| C-23 | Sprite2D::set_centered()は中央揃え設定を変更 | E-03, E-04 | ○ |
| C-24 | Sprite2D::set_offset()はオフセットを設定 | E-03, E-04 | ○ |
| C-25 | Sprite2D::set_flip_h()は水平反転を設定 | E-03, E-04 | ○ |
| C-26 | Sprite2D::set_flip_v()は垂直反転を設定 | E-03, E-04 | ○ |
| C-27 | Sprite2D::set_region_enabled()はリージョン機能を有効化 | E-03, E-04 | ○ |
| C-28 | Sprite2D::set_region_rect()はリージョン範囲を設定 | E-03, E-04 | ○ |
| C-29 | Sprite2D::set_frame()はフレーム番号を設定 | E-04 (line 295-305) | ○ |
| C-30 | Sprite2D::set_frame()は範囲外でERR_FAIL_INDEX発生 | E-04 (line 296) | ○ |
| C-31 | Sprite2D::set_frame_coords()は座標指定でフレームを設定 | E-04 (line 311-316) | ○ |
| C-32 | Sprite2D::set_hframes()は水平フレーム数を設定 | E-04 (line 343-369) | ○ |
| C-33 | Sprite2D::set_hframes()で1未満はエラー | E-04 (line 344) | ○ |
| C-34 | Sprite2D::set_vframes()は垂直フレーム数を設定 | E-04 (line 322-337) | ○ |
| C-35 | Sprite2D::is_pixel_opaque()は不透明ピクセルを検出 | E-04 (line 375-424) | ○ |
| C-36 | テクスチャなしでis_pixel_opaque()はfalseを返す | E-04 (line 376-378) | ○ |
| C-37 | Sprite2D::get_rect()はスプライトの矩形を取得 | E-04 (line 439-461) | ○ |

### Camera2D関連（C-38 ～ C-50）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | Camera2D::set_offset()はオフセットを設定 | E-05, E-06 | ○ |
| C-39 | Camera2D::set_zoom()はズームレベルを設定 | E-06 (line 102-111) | ○ |
| C-40 | Camera2D::set_zoom()でゼロはエラー | E-06 (line 104) | ○ |
| C-41 | Camera2D::set_limit()はカメラ制限を設定 | E-06 (line 620-629) | ○ |
| C-42 | Camera2D::set_limit()で不正なSideはエラー | E-06 (line 621) | ○ |
| C-43 | Camera2D::set_enabled()は有効/無効を切り替え | E-06 (line 522-537) | ○ |
| C-44 | Camera2D::make_current()で現在のカメラになる | E-06 (line 584-593) | ○ |
| C-45 | 無効時にmake_current()はエラー | E-06 (line 585) | ○ |
| C-46 | Camera2D::set_anchor_mode()はアンカーモードを設定 | E-06 (line 469-475) | ○ |
| C-47 | Camera2D::set_drag_margin()はドラッグマージンを設定 | E-06 (line 648-655) | ○ |
| C-48 | Camera2D::set_position_smoothing_enabled()はスムージングを有効化 | E-06 (line 796-801) | ○ |
| C-49 | Camera2D::set_position_smoothing_speed()はスムージング速度を設定 | E-06 (line 699-705) | ○ |
| C-50 | Camera2D::reset_smoothing()はスムージングをリセット | E-06 (line 670-673) | ○ |

### CollisionObject2D関連（C-51 ～ C-56）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | CollisionObject2D::set_collision_layer()はコリジョンレイヤーを設定 | E-07 | ○ |
| C-52 | CollisionObject2D::set_collision_mask()はコリジョンマスクを設定 | E-07 | ○ |
| C-53 | CollisionObject2D::set_collision_layer_value()は特定ビットを設定 | E-07 | ○ |
| C-54 | CollisionObject2D::create_shape_owner()はシェイプオーナーを作成 | E-07 | ○ |
| C-55 | CollisionObject2D::shape_owner_add_shape()はシェイプを追加 | E-07 | ○ |
| C-56 | CollisionObject2D::set_pickable()はピック可能状態を設定 | E-07 | ○ |

### RigidBody2D関連（C-57 ～ C-66）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | RigidBody2D::set_mass()は質量を設定 | E-08 | ○ |
| C-58 | RigidBody2D::set_linear_velocity()は線形速度を設定 | E-08 | ○ |
| C-59 | RigidBody2D::set_angular_velocity()は角速度を設定 | E-08 | ○ |
| C-60 | RigidBody2D::apply_central_impulse()は中心インパルスを適用 | E-08 | ○ |
| C-61 | RigidBody2D::apply_impulse()は位置指定インパルスを適用 | E-08 | ○ |
| C-62 | RigidBody2D::apply_torque_impulse()はトルクインパルスを適用 | E-08 | ○ |
| C-63 | RigidBody2D::set_freeze_enabled()はフリーズ状態を設定 | E-08 | ○ |
| C-64 | RigidBody2D::set_freeze_mode()はフリーズモードを設定 | E-08 | ○ |
| C-65 | RigidBody2D::set_contact_monitor()はコンタクトモニタを有効化 | E-08 | ○ |
| C-66 | RigidBody2D::get_colliding_bodies()は衝突中ボディを取得 | E-08 | ○ |

### Area2D関連（C-67 ～ C-72）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Area2D::set_monitoring()はモニタリングを有効化 | E-09 | ○ |
| C-68 | Area2D::set_monitorable()はモニタリング対象を設定 | E-09 | ○ |
| C-69 | Area2D::get_overlapping_bodies()は重なっているボディを取得 | E-09 | ○ |
| C-70 | Area2D::get_overlapping_areas()は重なっているエリアを取得 | E-09 | ○ |
| C-71 | Area2D::set_gravity()は重力値を設定 | E-09 | ○ |
| C-72 | Area2D::set_gravity_direction()は重力方向を設定 | E-09 | ○ |

### CharacterBody2D関連（C-73 ～ C-80）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | CharacterBody2D::move_and_slide()は移動を実行 | E-10 | ○ |
| C-74 | CharacterBody2D::is_on_floor()は床接触を判定 | E-10 | ○ |
| C-75 | CharacterBody2D::is_on_wall()は壁接触を判定 | E-10 | ○ |
| C-76 | CharacterBody2D::is_on_ceiling()は天井接触を判定 | E-10 | ○ |
| C-77 | CharacterBody2D::set_floor_max_angle()は床最大角度を設定 | E-10 | ○ |
| C-78 | CharacterBody2D::set_safe_margin()は安全マージンを設定 | E-10 | ○ |
| C-79 | CharacterBody2D::get_slide_collision_count()は衝突回数を取得 | E-10 | ○ |
| C-80 | CharacterBody2D::get_floor_normal()は床の法線を取得 | E-10 | ○ |

### AnimatedSprite2D関連（C-81 ～ C-86）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | AnimatedSprite2D::set_sprite_frames()はスプライトフレームを設定 | E-11 | ○ |
| C-82 | AnimatedSprite2D::play()はアニメーション再生を開始 | E-11 | ○ |
| C-83 | AnimatedSprite2D::stop()はアニメーション再生を停止 | E-11 | ○ |
| C-84 | AnimatedSprite2D::set_animation()はアニメーション名を設定 | E-11 | ○ |
| C-85 | AnimatedSprite2D::set_frame()はフレーム番号を設定 | E-11 | ○ |
| C-86 | AnimatedSprite2D::set_speed_scale()は再生速度を設定 | E-11 | ○ |

### Line2D関連（C-87 ～ C-92）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | Line2D::set_points()はポイントリストを設定 | E-12 | ○ |
| C-88 | Line2D::add_point()はポイントを追加 | E-12 | ○ |
| C-89 | Line2D::remove_point()はポイントを削除 | E-12 | ○ |
| C-90 | Line2D::set_width()は線幅を設定 | E-12 | ○ |
| C-91 | Line2D::set_default_color()はデフォルト色を設定 | E-12 | ○ |
| C-92 | Line2D::set_joint_mode()は結合モードを設定 | E-12 | ○ |

### TileMapLayer関連（C-93 ～ C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | TileMapLayer::set_cell()はセルを設定 | E-13 | ○ |
| C-94 | TileMapLayer::erase_cell()はセルを消去 | E-13 | ○ |
| C-95 | TileMapLayer::get_used_cells()は使用中セルリストを取得 | E-13 | ○ |
| C-96 | TileMapLayer::get_used_rect()は使用領域矩形を取得 | E-13 | ○ |
| C-97 | TileMapLayer::local_to_map()はローカル座標をマップ座標に変換 | E-13 | ○ |
| C-98 | TileMapLayer::map_to_local()はマップ座標をローカル座標に変換 | E-13 | ○ |
| C-99 | TileMapLayer::set_enabled()はレイヤー有効状態を設定 | E-13 | ○ |
| C-100 | TileMapLayer::set_tile_set()はTileSetを設定 | E-13 | ○ |

### GPUParticles2D関連（C-101 ～ C-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | GPUParticles2D::set_emitting()は発光状態を設定 | E-14 | ○ |
| C-102 | GPUParticles2D::set_amount()はパーティクル数を設定 | E-14 | ○ |
| C-103 | GPUParticles2D::set_lifetime()は寿命を設定 | E-14 | ○ |
| C-104 | GPUParticles2D::set_one_shot()はワンショットモードを設定 | E-14 | ○ |
| C-105 | GPUParticles2D::restart()はパーティクルをリスタート | E-14 | ○ |

### Light2D関連（C-106 ～ C-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | Light2D::set_enabled()はライト有効状態を設定 | E-15 | ○ |
| C-107 | Light2D::set_color()はライト色を設定 | E-15 | ○ |
| C-108 | Light2D::set_energy()はエネルギーを設定 | E-15 | ○ |
| C-109 | Light2D::set_shadow_enabled()は影を有効化 | E-15 | ○ |
| C-110 | PointLight2D::set_texture()はテクスチャを設定 | E-15 | ○ |
| C-111 | PointLight2D::set_texture_scale()はテクスチャスケールを設定 | E-15 | ○ |

### Path2D/PathFollow2D関連（C-112 ～ C-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | Path2D::set_curve()はカーブを設定 | E-16 | ○ |
| C-113 | PathFollow2D::set_progress()は進行度を設定 | E-16 | ○ |
| C-114 | PathFollow2D::set_progress_ratio()は進行度比率を設定 | E-16 | ○ |
| C-115 | PathFollow2D::set_loop()はループ設定を変更 | E-16 | ○ |

### Skeleton2D/Bone2D関連（C-116 ～ C-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | Skeleton2D::get_bone_count()はボーン数を取得 | E-17 | ○ |
| C-117 | Skeleton2D::get_bone()はインデックスでボーンを取得 | E-17 | ○ |
| C-118 | Skeleton2D::set_bone_local_pose_override()はボーンポーズをオーバーライド | E-17 | ○ |
| C-119 | Bone2D::set_rest()はレスト姿勢を設定 | E-17 | ○ |
| C-120 | Bone2D::apply_rest()はレスト姿勢を適用 | E-17 | ○ |
| C-121 | Bone2D::set_length()はボーン長さを設定 | E-17 | ○ |
| C-122 | Bone2D::set_bone_angle()はボーン角度を設定 | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースにソースコード根拠あり
- 特になし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 単純なgetter/setterのテストケース
- **1: 中リスク** - 座標変換、Transform計算のテストケース（浮動小数点誤差の考慮が必要）
- **2: 高リスク** - 物理シミュレーション関連のテストケース（CharacterBody2D::move_and_slide等）

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-S2D-XXX）が一貫しているか
- [ ] 全ての主要なpublicメソッドがカバーされているか
- [ ] 正常系・異常系・境界値の観点が適切に設定されているか
- [ ] 優先度の高いテストケース（高）が重要な機能をカバーしているか
- [ ] 物理関連のテストケースの前提条件が明確か
- [ ] 座標変換のテストケースで浮動小数点誤差が考慮されているか
