---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 145
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：scene-3d モジュール 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：145 / 150、根拠なし：5
- 優先レビュー（高）
  1. **C-071 move_and_slide**：実行時の複合挙動のため詳細な期待結果の検証が必要
  2. **C-128 emit_particle**：GPUパーティクルの手動発生APIの実装詳細確認が必要
  3. **C-150 get_skeleton**：モディファイアとスケルトンの関係性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/3d/node_3d.h` - Node3Dクラス定義（変換操作、可視性制御）
- E-02: `scene/3d/node_3d.cpp` - Node3Dクラス実装（変換計算、階層処理）
- E-03: `scene/3d/camera_3d.h` - Camera3Dクラス定義（投影、レイキャスト）
- E-04: `scene/3d/skeleton_3d.h` - Skeleton3Dクラス定義（ボーン管理、ポーズ）
- E-05: `scene/3d/mesh_instance_3d.h` - MeshInstance3Dクラス定義（メッシュ、スキン、ブレンドシェイプ）
- E-06: `scene/3d/light_3d.h` - Light3D、DirectionalLight3D、OmniLight3D、SpotLight3Dクラス定義
- E-07: `scene/3d/visual_instance_3d.h` - VisualInstance3D、GeometryInstance3Dクラス定義
- E-08: `scene/3d/physics/rigid_body_3d.h` - RigidBody3Dクラス定義（物理特性）
- E-09: `scene/3d/physics/character_body_3d.h` - CharacterBody3Dクラス定義（キャラクター移動）
- E-10: `scene/3d/physics/area_3d.h` - Area3Dクラス定義（エリア検出、重力）
- E-11: `scene/3d/physics/collision_object_3d.h` - CollisionObject3Dクラス定義（衝突オブジェクト基底）
- E-12: `scene/3d/physics/ray_cast_3d.h` - RayCast3Dクラス定義（レイキャスト）
- E-13: `scene/3d/path_3d.h` - Path3D、PathFollow3Dクラス定義（パス追従）
- E-14: `scene/3d/sprite_3d.h` - SpriteBase3D、Sprite3D、AnimatedSprite3Dクラス定義
- E-15: `scene/3d/cpu_particles_3d.h` - CPUParticles3Dクラス定義（CPUパーティクル）
- E-16: `scene/3d/gpu_particles_3d.h` - GPUParticles3Dクラス定義（GPUパーティクル）
- E-17: `scene/3d/decal.h` - Decalクラス定義（デカール投影）
- E-18: `scene/3d/remote_transform_3d.h` - RemoteTransform3Dクラス定義（リモート変換）
- E-19: `scene/3d/physics/collision_shape_3d.h` - CollisionShape3Dクラス定義（衝突形状）
- E-20: `scene/3d/skeleton_modifier_3d.h` - SkeletonModifier3Dクラス定義（スケルトンモディファイア）

## 3) Claims と根拠の対応（レビューの主戦場）

### Node3D (C-01 〜 C-20)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set_position で位置設定が正しく反映される | E-01, E-02 | ○ |
| C-02 | set_rotation で回転設定が正しく反映される | E-01, E-02 | ○ |
| C-03 | set_scale でスケール設定が正しく反映される | E-01, E-02 | ○ |
| C-04 | 負のスケール値が設定可能 | E-01 | ○ |
| C-05 | スケール0の境界値挙動 | E-01, E-02 | ○ |
| C-06 | set_transform でTransform3D設定が正しく反映される | E-01, E-02 | ○ |
| C-07 | set_global_transform でグローバル変換が設定される | E-01, E-02 | ○ |
| C-08 | set_quaternion でクォータニオン回転が設定される | E-01 | ○ |
| C-09 | look_at で指定した点を向く | E-01 | ○ |
| C-10 | look_at の同一点への呼び出し | E-01 | ○ |
| C-11 | to_local でグローバル→ローカル変換 | E-01 | ○ |
| C-12 | to_global でローカル→グローバル変換 | E-01 | ○ |
| C-13 | rotate で軸周りの回転 | E-01 | ○ |
| C-14 | rotate_x でX軸周りの回転 | E-01 | ○ |
| C-15 | translate で平行移動 | E-01 | ○ |
| C-16 | set_visible で可視性設定 | E-01 | ○ |
| C-17 | is_visible_in_tree でツリー内可視性判定 | E-01 | ○ |
| C-18 | set_as_top_level でトップレベル設定 | E-01 | ○ |
| C-19 | get_parent_node_3d で親Node3D取得（正常系） | E-01 | ○ |
| C-20 | get_parent_node_3d で親がNode3Dでない場合 | E-01 | ○ |

### Camera3D (C-21 〜 C-30)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | set_perspective で透視投影設定 | E-03 | ○ |
| C-22 | set_orthogonal で正射投影設定 | E-03 | ○ |
| C-23 | set_fov でFOV最小値 | E-03 | ○ |
| C-24 | set_fov でFOV最大値 | E-03 | ○ |
| C-25 | project_ray_normal でレイ方向計算 | E-03 | ○ |
| C-26 | project_position で座標変換 | E-03 | ○ |
| C-27 | unproject_position で逆座標変換 | E-03 | ○ |
| C-28 | is_position_behind で後方判定 | E-03 | ○ |
| C-29 | make_current でカレントカメラ設定 | E-03 | ○ |
| C-30 | set_cull_mask でカリングマスク設定 | E-03 | ○ |

### Skeleton3D (C-31 〜 C-42)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | add_bone でボーン追加 | E-04 | ○ |
| C-32 | find_bone でボーン検索（正常系） | E-04 | ○ |
| C-33 | find_bone でボーン検索（異常系） | E-04 | ○ |
| C-34 | set_bone_parent で親子関係設定 | E-04 | ○ |
| C-35 | set_bone_rest でレスト変換設定 | E-04 | ○ |
| C-36 | set_bone_pose_position でポーズ位置設定 | E-04 | ○ |
| C-37 | set_bone_pose_rotation でポーズ回転設定 | E-04 | ○ |
| C-38 | set_bone_pose_scale でポーズスケール設定 | E-04 | ○ |
| C-39 | get_bone_global_pose でグローバルポーズ取得 | E-04 | ○ |
| C-40 | reset_bone_poses でポーズリセット | E-04 | ○ |
| C-41 | set_bone_enabled でボーン有効/無効設定 | E-04 | ○ |
| C-42 | get_bone_children で子ボーン一覧取得 | E-04 | ○ |

### MeshInstance3D (C-43 〜 C-51)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | set_mesh でメッシュ設定 | E-05 | ○ |
| C-44 | set_mesh でnull設定 | E-05 | ○ |
| C-45 | set_skin でスキン設定 | E-05 | ○ |
| C-46 | set_skeleton_path でスケルトンパス設定 | E-05 | ○ |
| C-47 | set_blend_shape_value でブレンドシェイプ設定 | E-05 | ○ |
| C-48 | set_blend_shape_value で境界値0.0 | E-05 | ○ |
| C-49 | set_blend_shape_value で境界値1.0 | E-05 | ○ |
| C-50 | set_surface_override_material でマテリアルオーバーライド | E-05 | ○ |
| C-51 | get_aabb でAABB取得 | E-05 | ○ |

### Light3D系 (C-52 〜 C-61)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | set_color でライトカラー設定 | E-06 | ○ |
| C-53 | set_param でライトパラメータ設定 | E-06 | ○ |
| C-54 | set_shadow でシャドウ有効化 | E-06 | ○ |
| C-55 | set_negative でネガティブライト設定 | E-06 | ○ |
| C-56 | set_cull_mask でカリングマスク設定 | E-06 | ○ |
| C-57 | set_bake_mode でベイクモード設定 | E-06 | ○ |
| C-58 | DirectionalLight3D::set_shadow_mode | E-06 | ○ |
| C-59 | DirectionalLight3D::set_blend_splits | E-06 | ○ |
| C-60 | DirectionalLight3D::set_sky_mode | E-06 | ○ |
| C-61 | OmniLight3D::set_shadow_mode | E-06 | ○ |

### RigidBody3D (C-62 〜 C-70)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | set_mass で質量設定 | E-08 | ○ |
| C-63 | set_mass で質量0の境界値 | E-08 | ○ |
| C-64 | set_linear_velocity で線形速度設定 | E-08 | ○ |
| C-65 | set_angular_velocity で角速度設定 | E-08 | ○ |
| C-66 | apply_impulse でインパルス適用 | E-08 | ○ |
| C-67 | apply_force で力の適用 | E-08 | ○ |
| C-68 | set_freeze_enabled でフリーズ設定 | E-08 | ○ |
| C-69 | set_sleeping でスリープ設定 | E-08 | ○ |
| C-70 | set_contact_monitor でコンタクトモニター有効化 | E-08 | ○ |

### CharacterBody3D (C-71 〜 C-78)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | move_and_slide で移動とスライド | E-09 | △ |
| C-72 | is_on_floor で床接地判定 | E-09 | ○ |
| C-73 | is_on_wall で壁接触判定 | E-09 | ○ |
| C-74 | is_on_ceiling で天井接触判定 | E-09 | ○ |
| C-75 | set_velocity で速度設定 | E-09 | ○ |
| C-76 | get_floor_normal で床法線取得 | E-09 | ○ |
| C-77 | set_floor_max_angle で床判定角度設定 | E-09 | ○ |
| C-78 | set_safe_margin でセーフマージン設定 | E-09 | ○ |

### Area3D (C-79 〜 C-85)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | set_monitoring でモニタリング有効化 | E-10 | ○ |
| C-80 | set_monitorable で被モニタリング設定 | E-10 | ○ |
| C-81 | set_gravity で重力設定 | E-10 | ○ |
| C-82 | set_gravity_direction で重力方向設定 | E-10 | ○ |
| C-83 | get_overlapping_bodies で重なりボディ取得 | E-10 | ○ |
| C-84 | get_overlapping_areas で重なりエリア取得 | E-10 | ○ |
| C-85 | overlaps_body で衝突判定 | E-10 | ○ |

### CollisionObject3D (C-86 〜 C-90)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | set_collision_layer でコリジョンレイヤー設定 | E-11 | ○ |
| C-87 | set_collision_mask でコリジョンマスク設定 | E-11 | ○ |
| C-88 | create_shape_owner でシェイプオーナー作成 | E-11 | ○ |
| C-89 | shape_owner_add_shape でシェイプ追加 | E-11 | ○ |
| C-90 | set_ray_pickable でレイピック設定 | E-11 | ○ |

### RayCast3D (C-91 〜 C-99)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | set_enabled で有効状態設定 | E-12 | ○ |
| C-92 | set_target_position でターゲット位置設定 | E-12 | ○ |
| C-93 | force_raycast_update で強制更新 | E-12 | ○ |
| C-94 | is_colliding で衝突判定 | E-12 | ○ |
| C-95 | get_collider で衝突オブジェクト取得 | E-12 | ○ |
| C-96 | get_collision_point で衝突点取得 | E-12 | ○ |
| C-97 | get_collision_normal で衝突法線取得 | E-12 | ○ |
| C-98 | add_exception で例外追加 | E-12 | ○ |
| C-99 | set_collide_with_areas でエリア衝突設定 | E-12 | ○ |

### Path3D / PathFollow3D (C-100 〜 C-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | set_curve でカーブ設定 | E-13 | ○ |
| C-101 | set_progress で進行度設定 | E-13 | ○ |
| C-102 | set_progress_ratio で進行度比率設定 | E-13 | ○ |
| C-103 | set_progress_ratio で境界値0.0 | E-13 | ○ |
| C-104 | set_progress_ratio で境界値1.0 | E-13 | ○ |
| C-105 | set_rotation_mode で回転モード設定 | E-13 | ○ |
| C-106 | set_loop でループ設定 | E-13 | ○ |

### Sprite3D / AnimatedSprite3D (C-107 〜 C-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | set_texture でテクスチャ設定 | E-14 | ○ |
| C-108 | set_frame でフレーム設定 | E-14 | ○ |
| C-109 | set_hframes で水平フレーム数設定 | E-14 | ○ |
| C-110 | set_vframes で垂直フレーム数設定 | E-14 | ○ |
| C-111 | set_centered で中央揃え設定 | E-14 | ○ |
| C-112 | set_pixel_size でピクセルサイズ設定 | E-14 | ○ |
| C-113 | set_axis で表示軸設定 | E-14 | ○ |
| C-114 | set_modulate で変調色設定 | E-14 | ○ |
| C-115 | set_sprite_frames でSpriteFrames設定 | E-14 | ○ |
| C-116 | play でアニメーション再生 | E-14 | ○ |
| C-117 | stop でアニメーション停止 | E-14 | ○ |
| C-118 | set_animation でアニメーション名設定 | E-14 | ○ |

### CPUParticles3D (C-119 〜 C-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | set_emitting で発生開始 | E-15 | ○ |
| C-120 | set_amount でパーティクル数設定 | E-15 | ○ |
| C-121 | set_lifetime で寿命設定 | E-15 | ○ |
| C-122 | set_one_shot でワンショット設定 | E-15 | ○ |
| C-123 | set_emission_shape で発生形状設定 | E-15 | ○ |
| C-124 | set_gravity で重力設定 | E-15 | ○ |

### GPUParticles3D (C-125 〜 C-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | set_emitting で発生開始 | E-16 | ○ |
| C-126 | set_process_material でプロセスマテリアル設定 | E-16 | ○ |
| C-127 | set_draw_pass_mesh で描画パスメッシュ設定 | E-16 | ○ |
| C-128 | emit_particle で手動パーティクル発生 | E-16 | △ |

### VisualInstance3D / GeometryInstance3D (C-129 〜 C-138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | set_layer_mask でレイヤーマスク設定 | E-07 | ○ |
| C-130 | set_layer_mask_value で特定レイヤー設定 | E-07 | ○ |
| C-131 | set_sorting_offset でソートオフセット設定 | E-07 | ○ |
| C-132 | set_material_override でマテリアルオーバーライド | E-07 | ○ |
| C-133 | set_cast_shadows_setting でシャドウキャスト設定 | E-07 | ○ |
| C-134 | set_gi_mode でGIモード設定 | E-07 | ○ |
| C-135 | set_visibility_range_begin で可視距離開始設定 | E-07 | ○ |
| C-136 | set_visibility_range_end で可視距離終了設定 | E-07 | ○ |
| C-137 | set_transparency で透明度設定 | E-07 | ○ |
| C-138 | set_extra_cull_margin で追加カリングマージン設定 | E-07 | ○ |

### Decal (C-139 〜 C-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | set_size でサイズ設定 | E-17 | ○ |
| C-140 | set_texture でテクスチャ設定 | E-17 | ○ |
| C-141 | set_modulate で変調色設定 | E-17 | ○ |
| C-142 | set_emission_energy で発光強度設定 | E-17 | ○ |

### RemoteTransform3D (C-143 〜 C-145)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | set_remote_node でリモートノード設定 | E-18 | ○ |
| C-144 | set_use_global_coordinates でグローバル座標使用設定 | E-18 | ○ |
| C-145 | set_update_position で位置更新設定 | E-18 | ○ |

### CollisionShape3D (C-146 〜 C-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | set_shape でシェイプ設定 | E-19 | ○ |
| C-147 | set_disabled で無効状態設定 | E-19 | ○ |

### SkeletonModifier3D (C-148 〜 C-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-148 | set_active でアクティブ状態設定 | E-20 | ○ |
| C-149 | set_influence で影響度設定 | E-20 | ○ |
| C-150 | get_skeleton で親スケルトン取得 | E-20 | △ |

## 4) 不足情報（Unknown / Missing）

- **C-071 move_and_slide**: 複合的な挙動（衝突検出、スライド処理、接地判定の連動）の詳細な期待結果については、実装コードの詳細解析が必要
  - 候補：`character_body_3d.cpp`の`_move_and_slide_grounded`と`_move_and_slide_floating`の実装解析

- **C-128 emit_particle**: GPUパーティクルの手動発生における具体的な発生確認方法が不明
  - 候補：RenderingServerのパーティクルAPI詳細確認

- **C-150 get_skeleton**: モディファイアがスケルトンの子ノードでない場合の挙動確認が必要
  - 候補：`skeleton_modifier_3d.cpp`の`_update_skeleton`実装確認

## 5) リスクフラグ（レビュー観点）

| フラグ | 対象 | リスクレベル | 説明 |
|--------|------|-------------|------|
| RF-01 | C-05 | 1 (中) | スケール0での変換行列縮退は数学的に特異点となりうる |
| RF-02 | C-63 | 1 (中) | 質量0は物理シミュレーションで問題を起こす可能性 |
| RF-03 | C-71 | 2 (高) | move_and_slideは複合挙動のため、テスト条件の組み合わせが複雑 |
| RF-04 | C-10 | 0 (低) | look_atの同一点呼び出しはエッジケースだが頻度は低い |

## 6) レビュアーチェックリスト（最小）

- [ ] Node3D変換操作（C-01〜C-15）が3D数学の観点から正しいか確認
- [ ] Camera3D投影計算（C-21〜C-28）が正しく設計されているか確認
- [ ] Skeleton3Dのボーン階層管理（C-31〜C-42）がアニメーションシステムと整合しているか確認
- [ ] CharacterBody3D::move_and_slide（C-71）の複合挙動テストケースが十分か確認
- [ ] 物理系クラス（RigidBody3D、Area3D）の境界値テストが適切か確認
- [ ] GPUParticles3D::emit_particle（C-128）の期待結果の検証方法を確認
- [ ] 全テストケースの優先度設定が適切か確認（高=データ整合性/コア機能、中=一般機能、低=補助機能）
