---
generated_at: 2026-01-23 14:30:00
metrics:
  claims_total: 182
  claims_with_evidence: 178
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：scene-animation単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：178 / 182、根拠なし：4
- 優先レビュー（高）
  1. **AnimationNodeExtension内部変換メソッドのテスト（UT-SCA-162〜164）**：GDVIRTUALマクロによる実装のため、詳細な動作が不明
  2. **イージング関数の数値検証（UT-SCA-170〜179）**：数式ベースの実装のため、期待値の厳密な検証が必要
  3. **RootMotionViewの描画関連テスト（UT-SCA-165〜169）**：3D描画関連のため、視覚的検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/animation/tween.h` - Tween, Tweener, PropertyTweener, IntervalTweener, CallbackTweener, MethodTweener, SubtweenTweenerクラス定義
- E-02: `scene/animation/tween.cpp` - 上記クラスの実装
- E-03: `scene/animation/animation_player.h` - AnimationPlayerクラス定義
- E-04: `scene/animation/animation_player.cpp` - AnimationPlayerクラス実装
- E-05: `scene/animation/animation_mixer.h` - AnimationMixer, AnimatedValuesBackupクラス定義
- E-06: `scene/animation/animation_tree.h` - AnimationTree, AnimationNode, AnimationRootNodeクラス定義
- E-07: `scene/animation/animation_blend_tree.h` - AnimationNodeAnimation, AnimationNodeOneShot, AnimationNodeBlend2/3, AnimationNodeAdd2/3, AnimationNodeTimeScale, AnimationNodeTimeSeek, AnimationNodeTransition, AnimationNodeBlendTreeクラス定義
- E-08: `scene/animation/animation_blend_space_1d.h` - AnimationNodeBlendSpace1Dクラス定義
- E-09: `scene/animation/animation_blend_space_2d.h` - AnimationNodeBlendSpace2Dクラス定義
- E-10: `scene/animation/animation_node_state_machine.h` - AnimationNodeStateMachine, AnimationNodeStateMachineTransition, AnimationNodeStateMachinePlaybackクラス定義
- E-11: `scene/animation/animation_node_extension.h` - AnimationNodeExtensionクラス定義
- E-12: `scene/animation/easing_equations.h` - Linear, Sine, Quint, Quart, Quad, Expo, Elastic, Cubic, Circ, Bounce, Back, Spring各種イージング関数
- E-13: `scene/animation/root_motion_view.h` - RootMotionViewクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Tweenクラス関連 (UT-SCA-001〜031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tween::tween_propertyがPropertyTweenerを返却する | E-01, E-02 | ○ |
| C-02 | nullターゲットでnull返却 | E-02 (CHECK_VALIDマクロ) | ○ |
| C-03 | 存在しないプロパティでエラー | E-02 (prop_validチェック) | ○ |
| C-04 | tween_intervalがIntervalTweenerを返却 | E-01, E-02 | ○ |
| C-05 | tween_callbackがCallbackTweenerを返却 | E-01, E-02 | ○ |
| C-06 | tween_methodがMethodTweenerを返却 | E-01, E-02 | ○ |
| C-07 | 型不一致でnull返却 | E-02 (validate_type_match) | ○ |
| C-08 | stepが正しく実行される | E-02 (step実装) | ○ |
| C-09 | deadなTweenでfalse返却 | E-02 (step実装先頭のdeadチェック) | ○ |
| C-10 | stopで停止・リセット | E-02 (_stop_internal実装) | ○ |
| C-11 | pauseで一時停止 | E-02 (_stop_internal(false)呼び出し) | ○ |
| C-12 | playで再生開始 | E-02 (play実装) | ○ |
| C-13 | 無効Tweenでplay失敗 | E-02 (ERR_FAIL_COND_MSG) | ○ |
| C-14 | killで完全無効化 | E-02 (kill実装) | ○ |
| C-15 | is_runningが状態を返却 | E-02 (is_running実装) | ○ |
| C-16 | is_validが状態を返却 | E-02 (is_valid実装) | ○ |
| C-17 | bind_nodeでバインド | E-02 (bind_node実装) | ○ |
| C-18 | set_loopsでループ設定 | E-02 (set_loops実装) | ○ |
| C-19 | loops=0で無限ループ | E-02 (get_loops_left実装) | ○ |
| C-20 | get_loops_leftの計算 | E-02 (loops - loops_done) | ○ |
| C-21 | 無限ループで-1返却 | E-02 (get_loops_left実装) | ○ |
| C-22 | set_speed_scaleで速度設定 | E-02 | ○ |
| C-23 | set_transでトランジション設定 | E-02 | ○ |
| C-24 | set_easeでイージング設定 | E-02 | ○ |
| C-25 | parallelで並列モード | E-02 | ○ |
| C-26 | chainでチェーンモード | E-02 | ○ |
| C-27 | run_equationの計算 | E-02 (run_equation実装) | ○ |
| C-28 | duration=0でp_initial+p_delta | E-02 (特殊ケース処理) | ○ |
| C-29 | interpolate_variantの補間 | E-02 | ○ |
| C-30 | can_processの判定 | E-02 (can_process実装) | ○ |
| C-31 | 一時停止時にfalse | E-02 (pause_mode判定) | ○ |

### PropertyTweener関連 (UT-SCA-032〜039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | fromで開始値設定 | E-02 (from実装) | ○ |
| C-33 | 型不一致でnull | E-02 (validate_type_match) | ○ |
| C-34 | from_currentで現在値開始 | E-02 | ○ |
| C-35 | as_relativeで相対値 | E-02 | ○ |
| C-36 | set_delayで遅延設定 | E-02 | ○ |
| C-37 | stepで補間処理 | E-02 (step実装) | ○ |
| C-38 | 遅延中は変化なし | E-02 (elapsed_time < delay判定) | ○ |
| C-39 | 完了時にfinal_val | E-02 (step実装末尾) | ○ |

### IntervalTweener関連 (UT-SCA-040〜041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | 待機完了でfalse | E-02 (step実装) | ○ |
| C-41 | 時間内でtrue | E-02 | ○ |

### CallbackTweener関連 (UT-SCA-042〜044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | コールバック呼び出し | E-02 (callback.callp) | ○ |
| C-43 | 無効Callableでfalse | E-02 (is_valid判定) | ○ |
| C-44 | set_delayで遅延 | E-02 | ○ |

### MethodTweener関連 (UT-SCA-045〜046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | 補間値でメソッド呼び出し | E-02 (step実装) | ○ |
| C-46 | 完了時にfinal_val | E-02 | ○ |

### SubtweenTweener関連 (UT-SCA-047〜048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | サブTweenリセット・開始 | E-02 (start実装) | ○ |
| C-48 | サブTweenステップ | E-02 (step実装) | ○ |

### AnimationPlayer関連 (UT-SCA-049〜088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | playでアニメーション開始 | E-04 (play実装) | ○ |
| C-50 | 存在しないアニメーションでエラー | E-04 (ERR_FAIL_COND_MSG) | ○ |
| C-51 | auto_captureでキャプチャ付き | E-04 (play実装内分岐) | ○ |
| C-52 | play_backwardsで逆再生 | E-04 (speed=-1) | ○ |
| C-53 | play_sectionでセクション再生 | E-04 | ○ |
| C-54 | start>endでエラー | E-04 (ERR_FAIL_COND_MSG) | ○ |
| C-55 | play_section_with_markersでマーカー間再生 | E-04 | ○ |
| C-56 | 存在しないマーカーでエラー | E-04 | ○ |
| C-57 | stopで停止 | E-04 (_stop_internal) | ○ |
| C-58 | keep_stateで位置維持 | E-04 | ○ |
| C-59 | pauseで一時停止 | E-04 | ○ |
| C-60 | is_playingで再生状態 | E-04 | ○ |
| C-61 | queueでキュー追加 | E-04 | ○ |
| C-62 | 停止中で即再生 | E-04 | ○ |
| C-63 | get_queueでキュー取得 | E-04 | ○ |
| C-64 | clear_queueでクリア | E-04 | ○ |
| C-65 | seekでシーク | E-04 (seek_internal) | ○ |
| C-66 | 範囲外クランプ | E-04 (CLAMP処理) | ○ |
| C-67 | advanceで時間進行 | E-04 | ○ |
| C-68 | get_current_animation_positionで位置取得 | E-04 | ○ |
| C-69 | nullでエラー | E-04 (ERR_FAIL_NULL_V_MSG) | ○ |
| C-70 | get_current_animation_lengthで長さ取得 | E-04 | ○ |
| C-71 | set_speed_scaleで速度設定 | E-04 | ○ |
| C-72 | get_playing_speedで実効速度 | E-04 | ○ |
| C-73 | 停止中は0 | E-04 | ○ |
| C-74 | set_blend_timeでブレンド時間設定 | E-04 | ○ |
| C-75 | 存在しないアニメーションでエラー | E-04 | ○ |
| C-76 | 負の時間でエラー | E-04 | ○ |
| C-77 | get_blend_timeで取得 | E-04 | ○ |
| C-78 | 未設定で0 | E-04 | ○ |
| C-79 | animation_set_nextで次設定 | E-04 | ○ |
| C-80 | animation_get_nextで取得 | E-04 | ○ |
| C-81 | set_sectionでセクション設定 | E-04 | ○ |
| C-82 | reset_sectionでリセット | E-04 | ○ |
| C-83 | has_sectionで判定 | E-04 | ○ |
| C-84 | LOOP_NONEでクランプ | E-04 (_process_playback_data) | ○ |
| C-85 | LOOP_LINEARでラップ | E-04 (fposmod) | ○ |
| C-86 | LOOP_PINGPONGで方向反転 | E-04 (pingpong) | ○ |
| C-87 | get_current_blend_amountの計算 | E-04 | ○ |
| C-88 | 最小値0 | E-04 (MAX(0, blend)) | ○ |

### AnimationMixer関連 (UT-SCA-089〜100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | add_animation_libraryで追加 | E-05 | ○ |
| C-90 | remove_animation_libraryで削除 | E-05 | ○ |
| C-91 | has_animation_libraryで確認 | E-05 | ○ |
| C-92 | get_animationで取得 | E-05 | ○ |
| C-93 | has_animationで確認 | E-05 | ○ |
| C-94 | set_activeで設定 | E-05 | ○ |
| C-95 | set_root_nodeで設定 | E-05 | ○ |
| C-96 | set_callback_mode_processで設定 | E-05 | ○ |
| C-97 | set_audio_max_polyphonyで設定 | E-05 | ○ |
| C-98 | get_root_motion_positionで取得 | E-05 | ○ |
| C-99 | get_root_motion_rotationで取得 | E-05 | ○ |
| C-100 | captureで実行 | E-05 | ○ |

### AnimationTree関連 (UT-SCA-101〜104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | set_root_animation_nodeで設定 | E-06 | ○ |
| C-102 | set_animation_playerで設定 | E-06 | ○ |
| C-103 | is_state_invalidで判定 | E-06 | ○ |
| C-104 | get_connection_activityで取得 | E-06 | ○ |

### AnimationNode関連 (UT-SCA-105〜112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | set_parameterで設定 | E-06 | ○ |
| C-106 | get_parameterで取得 | E-06 | ○ |
| C-107 | add_inputで追加 | E-06 | ○ |
| C-108 | remove_inputで削除 | E-06 | ○ |
| C-109 | get_input_countで数取得 | E-06 | ○ |
| C-110 | find_inputで検索 | E-06 | ○ |
| C-111 | get_remainで残時間計算 | E-06 (NodeTimeInfo) | ○ |
| C-112 | ループ時にHUGE_LENGTH | E-06 | ○ |

### AnimationNodeAnimation関連 (UT-SCA-113〜116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | set_animationで設定 | E-07 | ○ |
| C-114 | set_play_modeで設定 | E-07 | ○ |
| C-115 | set_advance_on_startで設定 | E-07 | ○ |
| C-116 | set_use_custom_timelineで設定 | E-07 | ○ |

### AnimationNodeOneShot関連 (UT-SCA-117〜120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | set_fade_in_timeで設定 | E-07 | ○ |
| C-118 | set_fade_out_timeで設定 | E-07 | ○ |
| C-119 | set_auto_restart_enabledで設定 | E-07 | ○ |
| C-120 | set_mix_modeで設定 | E-07 | ○ |

### AnimationNodeBlend関連 (UT-SCA-121〜125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | Blend2でブレンド | E-07 | ○ |
| C-122 | Blend3でブレンド | E-07 | ○ |
| C-123 | Add2で加算 | E-07 | ○ |
| C-124 | TimeScaleで時間スケール | E-07 | ○ |
| C-125 | TimeSeekでシーク | E-07 | ○ |

### AnimationNodeTransition関連 (UT-SCA-126〜127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | set_xfade_timeで設定 | E-07 | ○ |
| C-127 | set_input_as_auto_advanceで設定 | E-07 | ○ |

### AnimationNodeBlendTree関連 (UT-SCA-128〜134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | add_nodeで追加 | E-07 | ○ |
| C-129 | remove_nodeで削除 | E-07 | ○ |
| C-130 | rename_nodeでリネーム | E-07 | ○ |
| C-131 | has_nodeで確認 | E-07 | ○ |
| C-132 | connect_nodeで接続 | E-07 | ○ |
| C-133 | disconnect_nodeで解除 | E-07 | ○ |
| C-134 | can_connect_nodeで判定 | E-07 | ○ |

### AnimationNodeBlendSpace1D関連 (UT-SCA-135〜140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | add_blend_pointで追加 | E-08 | ○ |
| C-136 | remove_blend_pointで削除 | E-08 | ○ |
| C-137 | get_blend_point_countで数取得 | E-08 | ○ |
| C-138 | set_min_spaceで設定 | E-08 | ○ |
| C-139 | set_max_spaceで設定 | E-08 | ○ |
| C-140 | set_blend_modeで設定 | E-08 | ○ |

### AnimationNodeBlendSpace2D関連 (UT-SCA-141〜146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | 2Dポイント追加 | E-09 | ○ |
| C-142 | 三角形追加 | E-09 | ○ |
| C-143 | 三角形削除 | E-09 | ○ |
| C-144 | 三角形数取得 | E-09 | ○ |
| C-145 | 自動三角形化設定 | E-09 | ○ |
| C-146 | 最近傍点取得 | E-09 | ○ |

### AnimationNodeStateMachine関連 (UT-SCA-147〜161)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | ステート追加 | E-10 | ○ |
| C-148 | ステート削除 | E-10 | ○ |
| C-149 | トランジション追加 | E-10 | ○ |
| C-150 | トランジション削除 | E-10 | ○ |
| C-151 | トランジション存在確認 | E-10 | ○ |
| C-152 | トランジション数取得 | E-10 | ○ |
| C-153 | スイッチモード設定 | E-10 | ○ |
| C-154 | 進行モード設定 | E-10 | ○ |
| C-155 | クロスフェード設定 | E-10 | ○ |
| C-156 | travel開始 | E-10 | ○ |
| C-157 | start開始 | E-10 | ○ |
| C-158 | stop停止 | E-10 | ○ |
| C-159 | is_playing状態取得 | E-10 | ○ |
| C-160 | get_current_node取得 | E-10 | ○ |
| C-161 | get_travel_path取得 | E-10 | ○ |

### AnimationNodeExtension関連 (UT-SCA-162〜164)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | _processでカスタム処理 | E-11 | △ |
| C-163 | is_loopingでループ判定 | E-11 | △ |
| C-164 | get_remaining_timeで残時間 | E-11 | △ |

### RootMotionView関連 (UT-SCA-165〜169)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165 | set_animation_mixerで設定 | E-13 | ○ |
| C-166 | set_colorで色設定 | E-13 | ○ |
| C-167 | set_cell_sizeでサイズ設定 | E-13 | ○ |
| C-168 | set_radiusで半径設定 | E-13 | ○ |
| C-169 | get_aabbでAABB取得 | E-13 | △ |

### イージング関数関連 (UT-SCA-170〜179)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-170 | Linear::in計算 | E-12 | ○ |
| C-171 | Sine::in計算 | E-12 | ○ |
| C-172 | Sine::out計算 | E-12 | ○ |
| C-173 | Sine::in_out計算 | E-12 | ○ |
| C-174 | Elastic::in計算 | E-12 | ○ |
| C-175 | Elastic::out計算 | E-12 | ○ |
| C-176 | Bounce::in計算 | E-12 | ○ |
| C-177 | Bounce::out計算 | E-12 | ○ |
| C-178 | Back::in計算 | E-12 | ○ |
| C-179 | Spring::out計算 | E-12 | ○ |

### AnimatedValuesBackup関連 (UT-SCA-180〜182)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-180 | set_dataでデータ設定 | E-05 | ○ |
| C-181 | get_dataでデータ取得 | E-05 | ○ |
| C-182 | clear_dataでクリア | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- **AnimationNodeExtension（C-162〜164）**: GDVIRTUALマクロによる仮想関数の実装詳細が不明。実際の動作はGDScriptまたはC#での拡張実装に依存する。
  - 候補：GDScriptでの拡張実装例 / C#バインディング仕様 / 単体テスト実装サンプル
- **RootMotionView::get_aabb（C-169）**: 3D描画関連の実装詳細がヘッダーのみでは確認困難。
  - 候補：root_motion_view.cppの実装確認 / VisualInstance3Dの基底クラス仕様

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接確認可能
- **1: 中リスク** - イージング関数のテストは数値検証が必要。期待値の計算根拠を確認する必要あり
- **1: 中リスク** - AnimationNodeExtensionのテストはGDVIRTUALの動作理解が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Tweenクラスの状態管理（valid, dead, running, started）の遷移が正しくテストされているか
- [ ] AnimationPlayerのループモード（NONE, LINEAR, PINGPONG）の境界値テストが十分か
- [ ] イージング関数の期待値が数学的に正しいか（Robert Pennerの公式と照合）
- [ ] AnimationNodeStateMachineのトラベル機能のA*探索ロジックがテストされているか
- [ ] AnimationNodeExtensionのGDVIRTUAL呼び出しがモック可能か確認
- [ ] RootMotionViewの3D描画テストの実行環境要件を確認
