---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 84
  claims_with_evidence: 82
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：scene-audio 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：82 / 84、根拠なし：2
- 優先レビュー（高）
  1. **C-54: アクセシビリティ通知処理**：DisplayServerのアクセシビリティAPI仕様の詳細確認が必要
  2. **C-75-76: validate_property**：エディタモード判定の詳細動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/audio/audio_stream_player.h` - AudioStreamPlayerクラス定義
- E-02: `scene/audio/audio_stream_player.cpp` - AudioStreamPlayerクラス実装
- E-03: `scene/audio/audio_stream_player_internal.h` - AudioStreamPlayerInternalクラス定義
- E-04: `scene/audio/audio_stream_player_internal.cpp` - AudioStreamPlayerInternalクラス実装
- E-05: `servers/audio/audio_server.h` - AudioServer::PlaybackType enum定義（参照）
- E-06: `servers/audio/audio_stream.h` - AudioStream/AudioStreamPlaybackクラス（参照）

## 3) Claims と根拠の対応（レビューの主戦場）

### AudioStreamPlayer クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set_stream：有効なAudioStreamを設定できる | E-02 L49-51 | ○ |
| C-02 | set_stream：nullストリームを設定できる | E-04 L254-265 | ○ |
| C-03 | get_stream：設定されたストリームが取得できる | E-02 L65-67 | ○ |
| C-04 | set_volume_db：音量をdBで設定できる | E-02 L69-77 | ○ |
| C-05 | set_volume_db：負のdB値を設定できる | E-02 L69-77, L282（-80,24範囲） | ○ |
| C-06 | set_volume_db：正のdB値（最大24dB）を設定できる | E-02 L282（PROPERTY_HINT_RANGE） | ○ |
| C-07 | set_volume_db：NaN値でエラー発生 | E-02 L70（ERR_FAIL_COND_MSG） | ○ |
| C-08 | get_volume_db：設定された音量（dB）が取得できる | E-02 L79-81 | ○ |
| C-09 | set_volume_linear：線形音量を設定できる | E-02 L83-85 | ○ |
| C-10 | get_volume_linear：線形音量が取得できる | E-02 L87-89 | ○ |
| C-11 | set_pitch_scale：ピッチスケールを設定できる | E-02 L91-93 | ○ |
| C-12 | set_pitch_scale：0以下でエラー発生 | E-04 L313-315（ERR_FAIL_COND） | ○ |
| C-13 | set_pitch_scale：最小有効値（0.01）を設定できる | E-02 L284（PROPERTY_HINT_RANGE） | ○ |
| C-14 | get_pitch_scale：設定されたピッチスケールが取得できる | E-02 L95-97 | ○ |
| C-15 | set_max_polyphony：最大ポリフォニー数を設定できる | E-02 L99-101 | ○ |
| C-16 | set_max_polyphony：0以下の値は無視される | E-04 L322-326 | ○ |
| C-17 | get_max_polyphony：設定されたポリフォニー数が取得できる | E-02 L103-105 | ○ |
| C-18 | play：オーディオ再生が開始される | E-02 L107-124 | ○ |
| C-19 | play：指定位置から再生が開始される | E-02 L107, L112（p_from_pos引数） | ○ |
| C-20 | play：ストリーム未設定時は早期リターン | E-02 L108-111 | ○ |
| C-21 | play：ノードがツリー外の場合エラー | E-04 L142（ERR_FAIL_COND_V_MSG） | ○ |
| C-22 | stop：再生が停止される | E-02 L130-132, E-04 L274-282 | ○ |
| C-23 | stop：停止中に呼び出しても問題ない | E-04 L274-282（クリア処理のみ） | ○ |
| C-24 | seek：再生位置を変更できる | E-02 L126-128, E-04 L267-272 | ○ |
| C-25 | seek：停止中にseekしても何も起きない | E-04 L268（is_playing()チェック） | ○ |
| C-26 | is_playing：再生中にtrueが返る | E-02 L134-136, E-04 L284-291 | ○ |
| C-27 | is_playing：停止中にfalseが返る | E-04 L284-291 | ○ |
| C-28 | get_playback_position：再生位置が取得できる | E-02 L138-140, E-04 L293-299 | ○ |
| C-29 | get_playback_position：停止中は0が返る | E-04 L295-298 | ○ |
| C-30 | set_bus：オーディオバスを設定できる | E-02 L142-147 | ○ |
| C-31 | get_bus：設定されたバスが取得できる | E-02 L149-151, E-04 L345-353 | ○ |
| C-32 | get_bus：存在しないバス名の場合Masterが返る | E-04 L345-353 | ○ |
| C-33 | set_autoplay：自動再生を有効にできる | E-02 L153-155 | ○ |
| C-34 | set_autoplay：自動再生を無効にできる | E-02 L153-155 | ○ |
| C-35 | is_autoplay_enabled：自動再生状態が取得できる | E-02 L157-159 | ○ |
| C-36 | set_mix_target：MIX_TARGET_STEREOを設定できる | E-02 L161-163 | ○ |
| C-37 | set_mix_target：MIX_TARGET_SURROUNDを設定できる | E-02 L161-163 | ○ |
| C-38 | set_mix_target：MIX_TARGET_CENTERを設定できる | E-02 L161-163 | ○ |
| C-39 | get_mix_target：設定されたミックスターゲットが取得できる | E-02 L165-167 | ○ |
| C-40 | set_stream_paused：再生を一時停止できる | E-02 L173-175, E-04 L178-186 | ○ |
| C-41 | set_stream_paused：一時停止を解除できる | E-02 L173-175, E-04 L178-186 | ○ |
| C-42 | get_stream_paused：一時停止中にtrueが返る | E-02 L177-179, E-04 L188-194 | ○ |
| C-43 | get_stream_paused：playbacksが空の場合falseが返る | E-04 L190-193 | ○ |
| C-44 | has_stream_playback：再生中にtrueが返る | E-02 L222-224, E-04 L328-330 | ○ |
| C-45 | has_stream_playback：停止中にfalseが返る | E-04 L328-330 | ○ |
| C-46 | get_stream_playback：再生中のplaybackが取得できる | E-02 L226-228, E-04 L332-335 | ○ |
| C-47 | get_stream_playback：停止中に呼び出した場合エラー | E-04 L333（ERR_FAIL_COND_V_MSG） | ○ |
| C-48 | set_playback_type：再生タイプを設定できる | E-02 L234-236, E-04 L337-339 | ○ |
| C-49 | get_playback_type：設定された再生タイプが取得できる | E-02 L230-232, E-04 L341-343 | ○ |
| C-50 | _get_volume_vector：ステレオモードで正しい音量ベクトル生成 | E-02 L181-216（switch文） | ○ |
| C-51 | _get_volume_vector：サラウンド/STEREOターゲットで正しい音量ベクトル生成 | E-02 L199-201 | ○ |
| C-52 | _get_volume_vector：サラウンド/SURROUNDターゲットで全チャンネル設定 | E-02 L202-208 | ○ |
| C-53 | _get_volume_vector：サラウンド/CENTERターゲットでセンターチャンネルのみ設定 | E-02 L209-212 | ○ |
| C-54 | _notification：NOTIFICATION_ACCESSIBILITY_UPDATEでアクセシビリティ更新 | E-02 L39-44 | △ |

### AudioStreamPlayerInternal クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | process：終了したplaybackが削除される | E-04 L63-82 | ○ |
| C-56 | process：全playback終了時にactiveフラグがクリアされる | E-04 L74-78 | ○ |
| C-57 | process：playback終了時にfinishedシグナルが発火する | E-04 L79-81 | ○ |
| C-58 | ensure_playback_limit：max_polyphony超過時に古いplaybackが削除される | E-04 L84-89 | ○ |
| C-59 | ensure_playback_limit：max_polyphony以下の場合は何も削除されない | E-04 L85（while条件） | ○ |
| C-60 | notification：ENTER_TREEでautoplayが有効なら再生開始 | E-04 L93-97 | ○ |
| C-61 | notification：ENTER_TREEでエディタ内ならautoplayでも再生しない | E-04 L94（is_editor_hint()チェック） | ○ |
| C-62 | notification：EXIT_TREEで一時停止される | E-04 L100-102 | ○ |
| C-63 | notification：PREDELETEで全playbackが停止・クリアされる | E-04 L108-113 | ○ |
| C-64 | notification：PAUSEDで処理不可なら一時停止される | E-04 L115-122 | ○ |
| C-65 | notification：UNPAUSEDで一時停止が解除される | E-04 L131-133 | ○ |
| C-66 | play_basic：monophonicストリームで既存再生が停止される | E-04 L143-145 | ○ |
| C-67 | play_basic：パラメータが新しいplaybackに適用される | E-04 L149-151 | ○ |
| C-68 | play_basic：サンプルモードでストリームが登録される | E-04 L153-170 | ○ |
| C-69 | set_stream：既存ストリームのシグナル接続が解除される | E-04 L255-257 | ○ |
| C-70 | set_stream：新しいストリームにシグナルが接続される | E-04 L261-263 | ○ |
| C-71 | set：パラメータが設定・全playbackに適用される | E-04 L214-224 | ○ |
| C-72 | set：存在しないパラメータの場合falseが返る | E-04 L215-218 | ○ |
| C-73 | get：パラメータ値が取得できる | E-04 L226-233 | ○ |
| C-74 | get：存在しないパラメータの場合falseが返る | E-04 L227-230 | ○ |
| C-75 | validate_property：busプロパティにバス一覧がヒントとして設定される | E-04 L196-212 | △ |
| C-76 | validate_property：エディタ外では何もしない | E-04 L197-199 | ○ |
| C-77 | _update_stream_parameters：ストリームパラメータが登録される | E-04 L44-61 | ○ |
| C-78 | _update_stream_parameters：既存パラメータは上書きされない | E-04 L54（has()チェック） | ○ |
| C-79 | _update_stream_parameters：streamがnullの場合は何もしない | E-04 L45-47 | ○ |
| C-80 | _is_sample：デフォルト再生タイプがSAMPLEでplayback_typeがDEFAULTならtrue | E-03 L64-66 | ○ |
| C-81 | _is_sample：playback_typeがSAMPLEならtrue | E-03 L64-66 | ○ |
| C-82 | _is_sample：それ以外の場合false | E-03 L64-66 | ○ |
| C-83 | コンストラクタ：初期値が正しく設定される | E-04 L355-360 | ○ |
| C-84 | コンストラクタ：AudioServerのシグナルに接続される | E-04 L362-363 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-54**: DisplayServer::accessibility_update_set_roleの詳細な動作仕様がモジュール外のため完全な検証不可
  - 候補：servers/display/display_server.h / display_server.cpp
- **C-75**: AudioServer::get_bus_count/get_bus_nameの動作がモジュール外のため完全な検証不可
  - 候補：servers/audio/audio_server.h / audio_server.cpp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的にソースコードとの整合性が高く、テストケースの根拠が明確
- **1: 中リスク** - アクセシビリティ関連（C-54）は外部依存があるため、統合テストでの確認推奨
- **0: 低リスク** - 音量・ピッチ・ポリフォニー関連のテストケースは境界値含め網羅的

## 6) レビュアーチェックリスト（最小）
- [ ] ERR_FAIL_CONDマクロを使用したエラーハンドリングの境界値テストケースが妥当か
- [ ] モノフォニック/ポリフォニック動作の状態遷移テストケースが網羅的か
- [ ] サンプルモード（PLAYBACK_TYPE_SAMPLE）の条件分岐テストケースが適切か
- [ ] AudioServerとの連携部分（外部依存）のモックテスト方針が明確か
- [ ] finishedシグナル発火タイミングのテストケースが適切か
