---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 125
  claims_with_evidence: 125
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：scene-debugger 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：125 / 125、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/debugger/scene_debugger.h` - ヘッダーファイル（クラス定義、メソッド宣言）
- E-02: `scene/debugger/scene_debugger.cpp` - 実装ファイル（メソッド実装、ロジック詳細）
- E-03: SceneDebuggerクラス定義（L53-135）- シングルトン、メッセージハンドリング
- E-04: SceneDebuggerObjectクラス定義（L138-155）- オブジェクト情報管理
- E-05: SceneDebuggerTreeクラス定義（L157-192）- ツリー情報管理
- E-06: LiveEditorクラス定義（L194-236）- ライブエディティング
- E-07: RuntimeNodeSelectクラス定義（L238-443）- 実行時ノード選択

## 3) Claims と根拠の対応（レビューの主戦場）

### SceneDebugger クラス（テストID: UT-SDB-001〜036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initialize()でシングルトン生成 | E-02 L98-105 | ○ |
| C-02 | initialize()で非アクティブ時は生成しない | E-02 L99 `if (EngineDebugger::is_active())` | ○ |
| C-03 | deinitialize()でシングルトン解放 | E-02 L107-111 | ○ |
| C-04 | parse_message()でハンドラ呼出 | E-02 L520-529 | ○ |
| C-05 | parse_message()で未登録メッセージ処理 | E-02 L531-538 | ○ |
| C-06 | parse_message()でSceneTree null時エラー | E-02 L521 `ERR_FAIL_NULL_V` | ○ |
| C-07 | parse_message()でlive_プレフィックス処理 | E-02 L531-535 | ○ |
| C-08 | _msg_setup_scene()実装 | E-02 L145-148 | ○ |
| C-09 | _msg_request_scene_tree()実装 | E-02 L150-153 | ○ |
| C-10 | _msg_save_node()実装 | E-02 L155-162 | ○ |
| C-11 | _msg_save_node()引数バリデーション | E-02 L156 `ERR_FAIL_COND_V(p_args.size() < 2` | ○ |
| C-12 | _msg_inspect_objects()実装 | E-02 L164-172 | ○ |
| C-13 | _msg_inspect_objects()引数バリデーション | E-02 L165 | ○ |
| C-14 | _msg_clear_selection()実装 | E-02 L194-197 | ○ |
| C-15 | _msg_suspend_changed()実装 | E-02 L199-205 | ○ |
| C-16 | _msg_suspend_changed()引数バリデーション | E-02 L200 | ○ |
| C-17 | _msg_next_frame()実装 | E-02 L207-210 | ○ |
| C-18 | _msg_speed_changed()実装 | E-02 L212-217 | ○ |
| C-19 | _msg_debug_mute_audio()実装 | E-02 L219-224 | ○ |
| C-20 | _msg_override_cameras()実装 | E-02 L226-236 | ○ |
| C-21 | _msg_set_object_property()実装 | E-02 L238-243 | ○ |
| C-22 | _msg_set_object_property()引数バリデーション | E-02 L239 | ○ |
| C-23 | _msg_reload_cached_files()実装 | E-02 L252-257 | ○ |
| C-24 | _msg_rq_screenshot()実装 | E-02 L480-514 | ○ |
| C-25 | _msg_rq_screenshot()引数バリデーション | E-02 L481 | ○ |
| C-26 | add_to_cache()実装 | E-02 L713-722 | ○ |
| C-27 | add_to_cache()空ファイル名チェック | E-02 L719 `!p_filename.is_empty()` | ○ |
| C-28 | remove_from_cache()実装 | E-02 L724-747 | ○ |
| C-29 | reload_cached_files()実装 | E-02 L749-756 | ○ |
| C-30 | _save_node()実装 | E-02 L594-617 | ○ |
| C-31 | _save_node()ノードnullチェック | E-02 L596 `ERR_FAIL_NULL` | ○ |
| C-32 | _set_node_owner_recursive()実装 | E-02 L619-627 | ○ |
| C-33 | _set_object_property() Members/プレフィックス処理 | E-02 L684-688 | ○ |
| C-34 | _set_object_property()リソースロード | E-02 L691-693 | ○ |
| C-35 | _next_frame()実装 | E-02 L703-711 | ○ |
| C-36 | _next_frame()非サスペンド時チェック | E-02 L705-707 | ○ |

### SceneDebuggerObject クラス（テストID: UT-SDB-037〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | コンストラクタ(ObjectID)実装 | E-02 L758-760 | ○ |
| C-38 | コンストラクタ(ObjectID)無効ID処理 | E-04 L148-150 | ○ |
| C-39 | コンストラクタ(Object*)実装 | E-02 L763-807 | ○ |
| C-40 | コンストラクタ(Object*) null処理 | E-02 L764-766 | ○ |
| C-41 | _parse_script_properties()実装 | E-02 L809-880 | ○ |
| C-42 | serialize()実装 | E-02 L882-913 | ○ |
| C-43 | serialize()最大サイズ処理 | E-02 L897-901 | ○ |
| C-44 | deserialize(Array)実装 | E-02 L915-923 | ○ |
| C-45 | deserialize(Array)サイズバリデーション | E-02 L917 | ○ |
| C-46 | deserialize(3引数)実装 | E-02 L925-962 | ○ |

### SceneDebuggerTree クラス（テストID: UT-SDB-047〜051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | コンストラクタ実装 | E-02 L965-1014 | ○ |
| C-48 | 可視性フラグ設定 | E-02 L981-997 | ○ |
| C-49 | serialize()実装 | E-02 L1016-1025 | ○ |
| C-50 | deserialize()実装 | E-02 L1027-1040 | ○ |
| C-51 | deserialize()サイズバリデーション | E-02 L1030-1037 | ○ |

### LiveEditor クラス（テストID: UT-SDB-052〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | get_singleton()実装 | E-02 L1043-1045 | ○ |
| C-53 | _send_tree()実装 | E-02 L1047-1058 | ○ |
| C-54 | _send_tree() SceneTree nullチェック | E-02 L1049-1051 | ○ |
| C-55 | _node_path_func()実装 | E-02 L1060-1062 | ○ |
| C-56 | _res_path_func()実装 | E-02 L1064-1066 | ○ |
| C-57 | _node_set_func()実装 | E-02 L1068-1130 | ○ |
| C-58 | _node_set_func()キャッシュチェック | E-02 L1074-1076 | ○ |
| C-59 | _node_set_res_func()実装 | E-02 L1132-1138 | ○ |
| C-60 | _node_call_func()実装 | E-02 L1140-1201 | ○ |
| C-61 | _res_set_func()実装 | E-02 L1204-1221 | ○ |
| C-62 | _res_set_func() ResourceCacheチェック | E-02 L1211-1213 | ○ |
| C-63 | _root_func()実装 | E-02 L1251-1254 | ○ |
| C-64 | _create_node_func()実装 | E-02 L1256-1292 | ○ |
| C-65 | _create_node_func()キャッシュチェック | E-02 L1267-1270 | ○ |
| C-66 | _instance_node_func()実装 | E-02 L1294-1336 | ○ |
| C-67 | _instance_node_func()パス無効チェック | E-02 L1302-1304 | ○ |
| C-68 | _remove_node_func()実装 | E-02 L1338-1372 | ○ |
| C-69 | _remove_and_keep_node_func()実装 | E-02 L1374-1408 | ○ |
| C-70 | _restore_node_func()実装 | E-02 L1410-1462 | ○ |
| C-71 | _duplicate_node_func()実装 | E-02 L1464-1501 | ○ |
| C-72 | _reparent_node_func()実装 | E-02 L1503-1544 | ○ |

### RuntimeNodeSelect クラス（テストID: UT-SDB-073〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | get_singleton()実装 | E-02 L1547-1549 | ○ |
| C-74 | デストラクタ実装 | E-02 L1551-1561 | ○ |
| C-75 | _setup()実装 | E-02 L1563-1665 | ○ |
| C-76 | _setup()重複接続チェック | E-02 L1565 | ○ |
| C-77 | _node_set_type()実装 | E-02 L1667-1670 | ○ |
| C-78 | _select_set_mode()実装 | E-02 L1672-1674 | ○ |
| C-79 | _set_camera_override_enabled()実装 | E-02 L1676-1697 | ○ |
| C-80 | _set_camera_override_enabled()初回リセット | E-02 L1679-1685 | ○ |
| C-81 | _root_window_input()実装 | E-02 L1699-1765 | ○ |
| C-82 | _root_window_input() NODE_TYPE_NONEチェック | E-02 L1701-1710 | ○ |
| C-83 | _update_input_state()実装 | E-02 L1776-1788 | ○ |
| C-84 | _process_frame()フリールック処理 | E-02 L1790-1850 | ○ |
| C-85 | _process_frame()選択更新 | E-02 L1852-1857 | ○ |
| C-86 | _physics_frame() 2Dアイテム検索 | E-02 L1860-1878 | ○ |
| C-87 | _physics_frame()ドラッグ選択 | E-02 L1866-1873 | ○ |
| C-88 | _send_ids()実装 | E-02 L2023-2112 | ○ |
| C-89 | _send_ids()選択制限 | E-02 L2030-2033, L2081-2085 | ○ |
| C-90 | _set_selected_nodes()実装 | E-02 L2114-2204 | ○ |
| C-91 | _set_selected_nodes()空ベクター処理 | E-02 L2115-2118 | ○ |
| C-92 | _queue_selection_update()実装 | E-02 L2206-2214 | ○ |
| C-93 | _update_selection() 2D描画 | E-02 L2216-2263 | ○ |
| C-94 | _update_selection() 3D描画 | E-02 L2265-2336 | ○ |
| C-95 | _clear_selection()実装 | E-02 L2339-2350 | ○ |
| C-96 | _update_selection_drag()実装 | E-02 L2352-2381 | ○ |
| C-97 | _find_canvas_items_at_pos()実装 | E-02 L2456-2516 | ○ |
| C-98 | _find_canvas_items_at_pos() Viewportチェック | E-02 L2457-2459 | ○ |
| C-99 | _find_canvas_items_at_rect()実装 | E-02 L2519-2576 | ○ |
| C-100 | _pan_callback()実装 | E-02 L2578-2584 | ○ |
| C-101 | _zoom_callback()実装 | E-02 L2587-2607 | ○ |
| C-102 | _zoom_callback()ズームクランプ | E-02 L2589 | ○ |
| C-103 | _reset_camera_2d()実装 | E-02 L2609-2625 | ○ |
| C-104 | _update_view_2d()実装 | E-02 L2627-2637 | ○ |
| C-105 | _find_3d_items_at_pos()実装 | E-02 L2640-2718 | ○ |
| C-106 | _find_3d_items_at_pos()カメラチェック | E-02 L2644-2647 | ○ |
| C-107 | _find_3d_items_at_rect()実装 | E-02 L2720-2856 | ○ |
| C-108 | _handle_3d_input()マウスホイール処理 | E-02 L2870-2900 | ○ |
| C-109 | _handle_3d_input()右クリック処理 | E-02 L2893-2896 | ○ |
| C-110 | _set_camera_freelook_enabled()実装 | E-02 L2956-2978 | ○ |
| C-111 | _cursor_scale_distance()実装 | E-02 L2980-2987 | ○ |
| C-112 | _cursor_scale_distance()距離クランプ | E-02 L2982-2984 | ○ |
| C-113 | _cursor_look()実装 | E-02 L2999-3024 | ○ |
| C-114 | _cursor_look()回転クランプ | E-02 L3012 | ○ |
| C-115 | _cursor_pan()実装 | E-02 L3026-3045 | ○ |
| C-116 | _cursor_orbit()実装 | E-02 L3047-3069 | ○ |
| C-117 | _get_cursor_transform()実装 | E-02 L3081-3089 | ○ |
| C-118 | _reset_camera_3d()実装 | E-02 L3091-3115 | ○ |
| C-119 | _set_selection_visible()実装 | E-02 L2439-2445 | ○ |
| C-120 | _set_avoid_locked()実装 | E-02 L2447-2449 | ○ |
| C-121 | _set_prefer_group()実装 | E-02 L2451-2453 | ○ |
| C-122 | _open_selection_list()実装 | E-02 L2383-2432 | ○ |
| C-123 | _close_selection_list()実装 | E-02 L2434-2437 | ○ |
| C-124 | RemoteNodeコンストラクタ | E-01 L173-181 | ○ |
| C-125 | SelectResult::operator<実装 | E-01 L264 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコード内のメソッド・クラス定義に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコードの根拠があります

**補足事項:**
- このモジュールはGodot Engineのデバッグ機能を提供するため、DEBUG_ENABLEDマクロによる条件付きコンパイルが多く使用されています
- 3D関連機能は`_3D_DISABLED`マクロで条件付きコンパイルされています
- 物理エンジン関連は`PHYSICS_2D_DISABLED`/`PHYSICS_3D_DISABLED`マクロで条件付きコンパイルされています

## 6) レビュアーチェックリスト（最小）
- [ ] SceneDebuggerのシングルトン初期化・終了処理が正しくテストされているか
- [ ] メッセージハンドリングの正常系・異常系が網羅されているか
- [ ] LiveEditorのノード操作（作成・削除・復元・複製・再親付け）が網羅されているか
- [ ] RuntimeNodeSelectの2D/3D選択機能が網羅されているか
- [ ] カメラオーバーライド機能（2D/3D）のテストが十分か
- [ ] 条件付きコンパイル（DEBUG_ENABLED, _3D_DISABLED等）を考慮したテストケースになっているか
