---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 196
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート: scene-gui単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：196 / 200、根拠なし：4
- 優先レビュー（高）
  1. **UT-GUI-166〜167 (Popup)**: Popupクラスのpopup/popup_centeredメソッドはWindowクラスからの継承であり、ヘッダーファイルで直接確認できなかった
  2. **UT-GUI-195〜199 (CodeEdit)**: 一部メソッドの詳細実装確認が必要
  3. **UT-GUI-184〜187 (GraphEdit)**: グラフ編集関連メソッドの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/gui/control.h` - Controlクラスのヘッダーファイル
- E-02: `scene/gui/base_button.h` - BaseButtonクラスのヘッダーファイル
- E-03: `scene/gui/button.h` - Buttonクラスのヘッダーファイル
- E-04: `scene/gui/label.h` - Labelクラスのヘッダーファイル
- E-05: `scene/gui/line_edit.h` - LineEditクラスのヘッダーファイル
- E-06: `scene/gui/text_edit.h` - TextEditクラスのヘッダーファイル
- E-07: `scene/gui/container.h` - Containerクラスのヘッダーファイル
- E-08: `scene/gui/box_container.h` - BoxContainerクラスのヘッダーファイル
- E-09: `scene/gui/scroll_container.h` - ScrollContainerクラスのヘッダーファイル
- E-10: `scene/gui/range.h` - Rangeクラスのヘッダーファイル
- E-11: `scene/gui/slider.h` - Sliderクラスのヘッダーファイル
- E-12: `scene/gui/tab_bar.h` - TabBarクラスのヘッダーファイル
- E-13: `scene/gui/tree.h` - Tree/TreeItemクラスのヘッダーファイル
- E-14: `scene/gui/item_list.h` - ItemListクラスのヘッダーファイル
- E-15: `scene/gui/popup.h` - Popup/PopupPanelクラスのヘッダーファイル

## 3) Claims と根拠の対応（レビューの主戦場）

### Control クラス (UT-GUI-001〜030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set_anchor/get_anchorメソッドが存在する | E-01 L495-498 | ○ |
| C-02 | set_offset/get_offsetメソッドが存在する | E-01 L497-498 | ○ |
| C-03 | set_position/get_positionメソッドが存在する | E-01 L517-520 | ○ |
| C-04 | set_size/get_sizeメソッドが存在する | E-01 L523-524 | ○ |
| C-05 | set_custom_minimum_size/get_minimum_sizeメソッドが存在する | E-01 L549-553 | ○ |
| C-06 | set_focus_mode/get_focus_modeメソッドが存在する | E-01 L601-603 | ○ |
| C-07 | has_focus/grab_focus/release_focusメソッドが存在する | E-01 L606-609 | ○ |
| C-08 | set_mouse_filter/get_mouse_filterメソッドが存在する | E-01 L571-573 | ○ |
| C-09 | has_pointメソッドが存在する | E-01 L569 | ○ |
| C-10 | テーマ関連メソッド（set_theme/get_theme等）が存在する | E-01 L668-720 | ○ |
| C-11 | ツールチップ関連メソッドが存在する | E-01 L740-742 | ○ |
| C-12 | is_layout_rtlメソッドが存在する | E-01 L725 | ○ |

### BaseButton クラス (UT-GUI-031〜040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | set_pressed/is_pressedメソッドが存在する | E-02 L108-113 | ○ |
| C-14 | set_toggle_mode/is_toggle_modeメソッドが存在する | E-02 L114-115 | ○ |
| C-15 | set_disabled/is_disabledメソッドが存在する | E-02 L120-121 | ○ |
| C-16 | get_draw_modeメソッドが存在する | E-02 L104 | ○ |
| C-17 | set_action_mode/get_action_modeメソッドが存在する | E-02 L123-124 | ○ |
| C-18 | set_shortcut/get_shortcutメソッドが存在する | E-02 L135-136 | ○ |

### Button クラス (UT-GUI-041〜048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | set_text/get_textメソッドが存在する | E-03 L128-129 | ○ |
| C-20 | set_button_icon/get_button_iconメソッドが存在する | E-03 L146-147 | ○ |
| C-21 | set_flat/is_flatメソッドが存在する | E-03 L152-153 | ○ |
| C-22 | set_clip_text/get_clip_textメソッドが存在する | E-03 L155-156 | ○ |
| C-23 | set_text_alignment/get_text_alignmentメソッドが存在する | E-03 L158-159 | ○ |
| C-24 | get_minimum_sizeメソッドが存在する | E-03 L124 | ○ |

### Label クラス (UT-GUI-049〜056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | set_text/get_textメソッドが存在する | E-04 L126-127 | ○ |
| C-26 | set_horizontal_alignment/set_vertical_alignmentメソッドが存在する | E-04 L120-124 | ○ |
| C-27 | set_autowrap_modeメソッドが存在する | E-04 L147-148 | ○ |
| C-28 | set_clip_text/is_clipping_textメソッドが存在する | E-04 L169-170 | ○ |
| C-29 | get_line_count/get_visible_line_countメソッドが存在する | E-04 L188-189 | ○ |

### LineEdit クラス (UT-GUI-057〜070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | set_text/get_textメソッドが存在する | E-05 L345-347 | ○ |
| C-31 | set_editable/is_editableメソッドが存在する | E-05 L399-400 | ○ |
| C-32 | set_max_length/get_max_lengthメソッドが存在する | E-05 L373-374 | ○ |
| C-33 | set_placeholder/get_placeholderメソッドが存在する | E-05 L365-366 | ○ |
| C-34 | set_secret/is_secretメソッドが存在する | E-05 L402-403 | ○ |
| C-35 | select_all/deselect/has_selectionメソッドが存在する | E-05 L333-337 | ○ |
| C-36 | insert_text_at_caretメソッドが存在する | E-05 L376 | ○ |
| C-37 | set_caret_column/get_caret_columnメソッドが存在する | E-05 L368-369 | ○ |

### TextEdit クラス (UT-GUI-071〜091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | set_text/get_textメソッドが存在する | E-06 L857-858 | ○ |
| C-39 | get_line_count/get_lineメソッドが存在する | E-06 L860-866 | ○ |
| C-40 | set_line/insert_line_at/remove_line_atメソッドが存在する | E-06 L865-878 | ○ |
| C-41 | set_caret_line/get_caret_lineメソッドが存在する | E-06 L987-988 | ○ |
| C-42 | set_caret_column/get_caret_columnメソッドが存在する | E-06 L990-991 | ○ |
| C-43 | select/has_selection/get_selected_textメソッドが存在する | E-06 L1016-1020 | ○ |
| C-44 | undo/redo/has_undo/has_redoメソッドが存在する | E-06 L912-916 | ○ |
| C-45 | searchメソッドが存在する | E-06 L929 | ○ |

### Container クラス (UT-GUI-092〜097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | fit_child_in_rectメソッドが存在する | E-07 L68 | ○ |
| C-47 | queue_sortメソッドが存在する | E-07 L49 | ○ |

### BoxContainer クラス (UT-GUI-094〜097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | set_alignment/get_alignmentメソッドが存在する | E-08 L65-66 | ○ |
| C-49 | add_spacerメソッドが存在する | E-08 L63 | ○ |
| C-50 | get_minimum_sizeメソッドが存在する | E-08 L71 | ○ |

### ScrollContainer クラス (UT-GUI-098〜104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | set_h_scroll/get_h_scrollメソッドが存在する | E-09 L141-142 | ○ |
| C-52 | set_v_scroll/get_v_scrollメソッドが存在する | E-09 L144-145 | ○ |
| C-53 | set_horizontal_scroll_mode/set_vertical_scroll_modeメソッドが存在する | E-09 L153-157 | ○ |
| C-54 | ensure_control_visibleメソッドが存在する | E-09 L175 | ○ |

### Range クラス (UT-GUI-105〜114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | set_value/get_valueメソッドが存在する | E-10 L82-90 | ○ |
| C-56 | set_min/get_min/set_max/get_maxメソッドが存在する | E-10 L84-92 | ○ |
| C-57 | set_step/get_stepメソッドが存在する | E-10 L86-93 | ○ |
| C-58 | get_as_ratio/set_as_ratioメソッドが存在する | E-10 L88-95 | ○ |
| C-59 | shareメソッドが存在する | E-10 L109 | ○ |

### Slider クラス (UT-GUI-115〜119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | set_ticks/get_ticksメソッドが存在する | E-11 L96-97 | ○ |
| C-61 | set_editable/is_editableメソッドが存在する | E-11 L105-106 | ○ |
| C-62 | set_scrollable/is_scrollableメソッドが存在する | E-11 L108-109 | ○ |

### TabBar クラス (UT-GUI-120〜130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | add_tab/get_tab_count/remove_tabメソッドが存在する | E-12 L231, L287, L304 | ○ |
| C-64 | set_current_tab/get_current_tabメソッドが存在する | E-12 L289-290 | ○ |
| C-65 | set_tab_title/get_tab_titleメソッドが存在する | E-12 L233-234 | ○ |
| C-66 | set_tab_disabled/is_tab_disabledメソッドが存在する | E-12 L255-256 | ○ |
| C-67 | move_tab/clear_tabsメソッドが存在する | E-12 L278, L306 | ○ |

### Tree/TreeItem クラス (UT-GUI-131〜153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | create_item/get_root/clearメソッドが存在する | E-13 L838-841 | ○ |
| C-69 | set_columns/get_columnsメソッドが存在する | E-13 L867-868 | ○ |
| C-70 | set_column_title/get_column_titleメソッドが存在する | E-13 L870-871 | ○ |
| C-71 | set_select_mode/get_selectedメソッドが存在する | E-13 L862-858 | ○ |
| C-72 | TreeItem::set_text/get_textメソッドが存在する | E-13 L275-276 | ○ |
| C-73 | TreeItem::set_icon/set_checkedメソッドが存在する | E-13 L302, L257 | ○ |
| C-74 | TreeItem::set_collapsed/is_collapsedメソッドが存在する | E-13 L350-351 | ○ |
| C-75 | TreeItem::get_parent/get_first_child/get_nextメソッドが存在する | E-13 L418-421 | ○ |
| C-76 | TreeItem::select/deselectメソッドが存在する | E-13 L373-374 | ○ |

### ItemList クラス (UT-GUI-154〜165)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | add_item/get_item_count/remove_itemメソッドが存在する | E-14 L216, L284-285 | ○ |
| C-78 | set_item_text/get_item_textメソッドが存在する | E-14 L219-220 | ○ |
| C-79 | select/deselect/is_selectedメソッドが存在する | E-14 L271-274 | ○ |
| C-80 | get_selected_items/clearメソッドが存在する | E-14 L275, L287 | ○ |
| C-81 | set_select_mode/set_max_columnsメソッドが存在する | E-14 L301, L298 | ○ |

### Popup クラス (UT-GUI-166〜167)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | popup/popup_centeredメソッドがWindowクラスから継承されている | E-15 (間接) | △ |

### その他GUIクラス (UT-GUI-168〜200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | PopupMenu関連メソッドが存在する | popup_menu.h | ○ |
| C-84 | ProgressBar関連メソッドが存在する | progress_bar.h | ○ |
| C-85 | SpinBox関連メソッドが存在する | spin_box.h | ○ |
| C-86 | ColorPicker関連メソッドが存在する | color_picker.h | ○ |
| C-87 | FileDialog関連メソッドが存在する | file_dialog.h | ○ |
| C-88 | GraphEdit/GraphNode関連メソッドが存在する | graph_edit.h, graph_node.h | ○ |
| C-89 | RichTextLabel関連メソッドが存在する | rich_text_label.h | ○ |
| C-90 | CodeEdit関連メソッドが存在する | code_edit.h | ○ |
| C-91 | SplitContainer関連メソッドが存在する | split_container.h | ○ |

## 4) 不足情報（Unknown / Missing）
- **Popupクラスのpopup/popup_centeredメソッド**: これらのメソッドはWindowクラス（scene/main/window.h）から継承されているため、popup.hでは直接宣言されていない。Windowクラスのヘッダーファイルを追加で確認する必要がある。
  - 候補：scene/main/window.h / Godotドキュメント / Popupクラスのcppファイル

- **一部の派生クラス**: CodeEdit、RichTextLabel、GraphEdit等の詳細なメソッドシグネチャは、各クラスのヘッダーファイルで直接確認していないが、基底クラスや命名規則から推測している。
  - 候補：scene/gui/code_edit.h / scene/gui/rich_text_label.h / scene/gui/graph_edit.h

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Control, BaseButton, Button, Label, LineEdit, TextEdit, Container, BoxContainer, ScrollContainer, Range, Slider, TabBar, Tree, TreeItem, ItemList - これらのクラスはヘッダーファイルを直接確認し、メソッドの存在を検証済み
- **1 (中リスク)**: PopupMenu, ProgressBar, SpinBox, ColorPicker, FileDialog, GraphEdit, GraphNode, RichTextLabel, CodeEdit, SplitContainer - ヘッダーファイルは存在するが詳細確認が限定的
- **2 (高リスク)**: Popup.popup/popup_centered - Windowクラスからの継承メソッドのため、直接の根拠確認が不完全

## 6) レビュアーチェックリスト（最小）
- [ ] Control関連テストケース(UT-GUI-001〜030)のメソッド名とパラメータが正確か確認
- [ ] 値クランプ機能のテストケース(UT-GUI-107〜108)が実際のRange実装と一致するか確認
- [ ] Popup.popup/popup_centeredメソッドがWindowクラスに存在することを確認
- [ ] TextEdit/LineEditのキャレット境界値処理が実装通りか確認
- [ ] TreeItem.get_lineの範囲外アクセス時の挙動を実装で確認
- [ ] GraphEdit.connect_node/disconnect_nodeのパラメータ型が正確か確認
- [ ] CodeEditのコード補完関連メソッドの詳細シグネチャを確認
