---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：scene-resources 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード（ヘッダーファイル）に対応するメソッド定義が存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がメソッドシグネチャと矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-SCR-124 (FontFile::load_dynamic_font)**: 実際のファイルI/O動作は実行環境依存
  2. **UT-SCR-135 (PackedScene::pack)**: 実際のシーンツリー状態に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `scene/resources/texture.h` - Texture, Texture2D, TextureLayered, Texture3D クラス定義
- E-02: `scene/resources/image_texture.h` - ImageTexture, ImageTextureLayered, ImageTexture3D クラス定義
- E-03: `scene/resources/material.h` - Material, ShaderMaterial, BaseMaterial3D クラス定義
- E-04: `scene/resources/mesh.h` - Mesh, MeshConvexDecompositionSettings, ArrayMesh, PlaceholderMesh クラス定義
- E-05: `scene/resources/animation.h` - Animation クラス定義（トラック管理、キー操作、補間処理）
- E-06: `scene/resources/curve.h` - Curve, Curve2D, Curve3D クラス定義
- E-07: `scene/resources/gradient.h` - Gradient クラス定義
- E-08: `scene/resources/style_box.h` - StyleBox, StyleBoxEmpty クラス定義
- E-09: `scene/resources/font.h` - Font, FontFile, FontVariation, SystemFont クラス定義
- E-10: `scene/resources/shader.h` - Shader クラス定義
- E-11: `scene/resources/packed_scene.h` - SceneState, PackedScene クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Texture系クラス (UT-SCR-001 - UT-SCR-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Texture2D::get_width メソッドが存在し int を返す | E-01 line 59 | ○ |
| C-02 | Texture2D::get_height メソッドが存在し int を返す | E-01 line 60 | ○ |
| C-03 | Texture2D::get_size メソッドが存在し Size2 を返す | E-01 line 61 | ○ |
| C-04 | Texture2D::is_pixel_opaque メソッドが存在する | E-01 line 63 | ○ |
| C-05 | Texture2D::has_alpha メソッドが存在する | E-01 line 65 | ○ |
| C-06 | Texture2D::draw メソッドが存在する | E-01 line 68 | ○ |
| C-07 | Texture2D::draw_rect メソッドが存在する | E-01 line 69 | ○ |
| C-08 | Texture2D::get_image メソッドが存在する | E-01 line 73 | ○ |
| C-09 | ImageTexture::set_image メソッドが存在する | E-02 line 55 | ○ |
| C-10 | ImageTexture::create_from_image 静的メソッドが存在する | E-02 line 56 | ○ |
| C-11 | ImageTexture::update メソッドが存在する | E-02 line 60 | ○ |
| C-12 | ImageTexture::get_format メソッドが存在する | E-02 line 58 | ○ |
| C-13 | TextureLayered クラスに get_format, get_layers, get_layer_data が存在する | E-01 line 100-106 | ○ |
| C-14 | Texture3D クラスに get_depth, get_data が存在する | E-01 line 126-131 | ○ |

### Material系クラス (UT-SCR-025 - UT-SCR-048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | Material::set_next_pass, get_next_pass が存在する | E-03 line 80-81 | ○ |
| C-16 | Material::set_render_priority, get_render_priority が存在する | E-03 line 83-84 | ○ |
| C-17 | Material::get_shader_rid が存在する | E-03 line 87 | ○ |
| C-18 | ShaderMaterial::set_shader, get_shader が存在する | E-03 line 124-125 | ○ |
| C-19 | ShaderMaterial::set_shader_parameter, get_shader_parameter が存在する | E-03 line 127-128 | ○ |
| C-20 | BaseMaterial3D に albedo, metallic, roughness 関連メソッドが存在する | E-03 line 646-656 | ○ |
| C-21 | BaseMaterial3D::set_transparency が存在する | E-03 line 727-728 | ○ |
| C-22 | BaseMaterial3D::set_cull_mode が存在する | E-03 line 754-755 | ○ |
| C-23 | BaseMaterial3D::set_texture, get_texture が存在する | E-03 line 766-767 | ○ |
| C-24 | BaseMaterial3D::set_flag, get_flag が存在する | E-03 line 763-764 | ○ |

### Mesh系クラス (UT-SCR-049 - UT-SCR-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Mesh::get_surface_count が存在する | E-04 line 167 | ○ |
| C-26 | Mesh::surface_get_arrays が存在する | E-04 line 170 | ○ |
| C-27 | Mesh::surface_get_material, surface_set_material が存在する | E-04 line 175-176 | ○ |
| C-28 | Mesh::get_aabb が存在する | E-04 line 180 | ○ |
| C-29 | Mesh::get_faces が存在する | E-04 line 182 | ○ |
| C-30 | Mesh::generate_triangle_mesh が存在する | E-04 line 184 | ○ |
| C-31 | ArrayMesh::add_surface_from_arrays が存在する | E-04 line 342 | ○ |
| C-32 | ArrayMesh::add_blend_shape, clear_blend_shapes が存在する | E-04 line 350, 354 | ○ |
| C-33 | ArrayMesh::surface_remove, clear_surfaces が存在する | E-04 line 365-366 | ○ |

### Animation系クラス (UT-SCR-064 - UT-SCR-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | Animation::add_track, remove_track が存在する | E-05 line 407-408 | ○ |
| C-35 | Animation::get_track_count が存在する | E-05 line 416 | ○ |
| C-36 | Animation::track_get_type が存在する | E-05 line 417 | ○ |
| C-37 | Animation::track_set_path, track_get_path が存在する | E-05 line 419-420 | ○ |
| C-38 | Animation::track_insert_key, track_remove_key が存在する | E-05 line 436, 441 | ○ |
| C-39 | Animation::track_get_key_count, track_get_key_value, track_get_key_time が存在する | E-05 line 443-445 | ○ |
| C-40 | Animation::position_track_interpolate が存在する | E-05 line 452 | ○ |
| C-41 | Animation::rotation_track_interpolate が存在する | E-05 line 457 | ○ |
| C-42 | Animation::scale_track_interpolate が存在する | E-05 line 462 | ○ |
| C-43 | Animation::set_length, get_length が存在する | E-05 line 528-529 | ○ |
| C-44 | Animation::set_loop_mode, get_loop_mode が存在する | E-05 line 531-532 | ○ |
| C-45 | Animation::add_marker, has_marker, remove_marker が存在する | E-05 line 517-519 | ○ |
| C-46 | Animation::optimize が存在する | E-05 line 539 | ○ |

### Curve系クラス (UT-SCR-089 - UT-SCR-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | Curve::add_point, remove_point が存在する | E-06 line 79, 89 | ○ |
| C-48 | Curve::get_point_count が存在する | E-06 line 75 | ○ |
| C-49 | Curve::sample, sample_baked が存在する | E-06 line 115, 139 | ○ |
| C-50 | Curve::set_min_value, set_max_value が存在する | E-06 line 101, 103 | ○ |
| C-51 | Curve2D::add_point, get_baked_length, sample_baked が存在する | E-06 line 229, 245-246 | ○ |
| C-52 | Curve2D::get_closest_point が存在する | E-06 line 250 | ○ |
| C-53 | Curve3D::add_point, get_baked_length, sample_baked_with_rotation が存在する | E-06 line 326, 348, 350 | ○ |

### Gradient/StyleBox/Font系クラス (UT-SCR-105 - UT-SCR-126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Gradient::add_point, remove_point が存在する | E-07 line 129-130 | ○ |
| C-55 | Gradient::get_color_at_offset が存在する | E-07 line 151 | ○ |
| C-56 | Gradient::set_interpolation_mode, set_interpolation_color_space が存在する | E-07 line 145, 148 | ○ |
| C-57 | StyleBox::get_minimum_size が存在する | E-08 line 55 | ○ |
| C-58 | StyleBox::set_content_margin, get_content_margin が存在する | E-08 line 57, 60 | ○ |
| C-59 | StyleBox::draw が存在する | E-08 line 65 | ○ |
| C-60 | Font::get_height, get_ascent, get_descent が存在する | E-09 line 131-133 | ○ |
| C-61 | Font::get_string_size が存在する | E-09 line 150 | ○ |
| C-62 | Font::draw_string が存在する | E-09 line 153 | ○ |
| C-63 | Font::has_char が存在する | E-09 line 165 | ○ |
| C-64 | FontFile::load_dynamic_font が存在する | E-09 line 243 | ○ |
| C-65 | FontFile::set_data が存在する | E-09 line 247 | ○ |

### Shader/PackedScene系クラス (UT-SCR-126 - UT-SCR-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | Shader::set_code, get_code が存在する | E-10 line 88-89 | ○ |
| C-67 | Shader::get_mode が存在する | E-10 line 83 | ○ |
| C-68 | Shader::set_default_texture_parameter が存在する | E-10 line 95 | ○ |
| C-69 | SceneState::get_node_count, get_node_type, get_node_name, get_node_path が存在する | E-11 line 174-177 | ○ |
| C-70 | SceneState::can_instantiate が存在する | E-11 line 160 | ○ |
| C-71 | PackedScene::pack が存在する | E-11 line 266 | ○ |
| C-72 | PackedScene::instantiate が存在する | E-11 line 271 | ○ |
| C-73 | PackedScene::can_instantiate が存在する | E-11 line 270 | ○ |

### その他クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | AnimationLibrary 関連メソッド（add_animation等）の仕様 | animation_library.h参照 | ○ |
| C-75 | SpriteFrames 関連メソッド（add_animation等）の仕様 | sprite_frames.h参照 | ○ |
| C-76 | MultiMesh 関連メソッド（set_mesh等）の仕様 | multimesh.h参照 | ○ |

## 4) 不足情報（Unknown / Missing）
- **FontFile::load_dynamic_font の戻り値詳細**: ファイルI/Oエラーコードの詳細仕様は実装ファイル(.cpp)を確認する必要がある
  - 候補：scene/resources/font.cpp / core/io/resource_loader.cpp
- **PackedScene::pack の内部動作詳細**: シーンツリーの再帰的解析ロジックは実装ファイルを確認する必要がある
  - 候補：scene/resources/packed_scene.cpp

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Texture, Material, Mesh, Animation, Curve, Gradient, StyleBox, Font 関連テストケース - ヘッダーファイルから直接メソッドシグネチャを確認
- **1（中リスク）**: SceneState, PackedScene 関連テストケース - 複雑な内部状態管理があり、実装詳細の確認推奨
- **0（低リスク）**: Shader 関連テストケース - 明確なAPI定義あり

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（UT-SCR-XXX）が重複していないことを確認
- [ ] 各テストケースの「対象メソッド」がヘッダーファイルに存在することを確認
- [ ] 境界値テストが適切な範囲（0, -1, MAX, MIN）をカバーしていることを確認
- [ ] 異常系テストがnull入力と範囲外入力を適切にカバーしていることを確認
- [ ] 優先度「高」のテストケースが重要なメソッド（データ取得、設定、描画）をカバーしていることを確認
- [ ] C++特有のメモリ管理（Ref<>テンプレート）を考慮したテストケースになっていることを確認
