---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：scene-theme 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-THM-046**: update_class_instance_itemsのnullチェック動作（マクロ展開後の動作確認が必要）
  2. **UT-THM-119**: フォントバリエーション作成の詳細条件（BROTLI_ENABLEDマクロ依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scene/theme/theme_db.h` - ThemeDBクラス定義、ThemeContextクラス定義、マクロ定義
- E-02: `scene/theme/theme_db.cpp` - ThemeDB実装、ThemeContext実装
- E-03: `scene/theme/theme_owner.h` - ThemeOwnerクラス定義
- E-04: `scene/theme/theme_owner.cpp` - ThemeOwner実装
- E-05: `scene/theme/default_theme.h` - fill_default_theme、make_default_theme関数宣言
- E-06: `scene/theme/default_theme.cpp` - デフォルトテーマ生成実装、ヘルパー関数

## 3) Claims と根拠の対応（レビューの主戦場）

### ThemeDBクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-THM-001) | シングルトンインスタンス取得 | E-01 L179, E-02 L443-445 | ○ |
| C-02 (UT-THM-002) | テーマ初期化処理 | E-02 L46-90 | ○ |
| C-03 (UT-THM-003) | プロジェクトテーマ読み込み | E-02 L64-71 | ○ |
| C-04 (UT-THM-004) | 無効テーマパスエラー | E-02 L69 | ○ |
| C-05 (UT-THM-005) | 無効フォントパスエラー | E-02 L79 | ○ |
| C-06 (UT-THM-006) | プロジェクトなし初期化 | E-02 L92-98 | ○ |
| C-07 (UT-THM-007) | テーマリソース解放 | E-02 L100-111 | ○ |
| C-08 (UT-THM-008) | RenderingServer不在警告 | E-02 L101-103 | ○ |
| C-09 (UT-THM-009) | デフォルトテーマ設定 | E-02 L115-117 | ○ |
| C-10 (UT-THM-010) | デフォルトテーマ取得 | E-02 L119-121 | ○ |
| C-11 (UT-THM-011) | プロジェクトテーマ設定 | E-02 L123-125 | ○ |
| C-12 (UT-THM-012) | プロジェクトテーマ取得 | E-02 L127-129 | ○ |
| C-13 (UT-THM-013) | フォールバックスケール設定 | E-02 L133-140 | ○ |
| C-14 (UT-THM-014) | 同値設定時シグナル抑制 | E-02 L134-136 | ○ |
| C-15 (UT-THM-015) | 値変更時シグナル発行 | E-02 L139 | ○ |
| C-16 (UT-THM-016) | フォールバックスケール取得 | E-02 L142-144 | ○ |
| C-17 (UT-THM-017) | フォールバックフォント設定 | E-02 L146-153 | ○ |
| C-18 (UT-THM-018) | 同値設定時シグナル抑制（フォント） | E-02 L147-149 | ○ |
| C-19 (UT-THM-019) | フォールバックフォント取得 | E-02 L155-157 | ○ |
| C-20 (UT-THM-020) | フォールバックフォントサイズ設定 | E-02 L159-166 | ○ |
| C-21 (UT-THM-021) | フォールバックフォントサイズ取得 | E-02 L168-170 | ○ |
| C-22 (UT-THM-022) | フォールバックアイコン設定 | E-02 L172-179 | ○ |
| C-23 (UT-THM-023) | フォールバックアイコン取得 | E-02 L181-183 | ○ |
| C-24 (UT-THM-024) | フォールバックスタイルボックス設定 | E-02 L185-192 | ○ |
| C-25 (UT-THM-025) | フォールバックスタイルボックス取得 | E-02 L194-196 | ○ |
| C-26 (UT-THM-026) | 型依存関係取得 | E-02 L198-208 | ○ |
| C-27 (UT-THM-027) | 空型名の境界値処理 | E-02 L199-201 | ○ |
| C-28 (UT-THM-028) | ClassDB未登録型の処理 | E-02 L205-207 | ○ |
| C-29 (UT-THM-029) | テーマコンテキスト作成 | E-02 L212-228 | ○ |
| C-30 (UT-THM-030) | ツリー外ノードエラー | E-02 L213 | ○ |
| C-31 (UT-THM-031) | 既存コンテキストエラー | E-02 L214 | ○ |
| C-32 (UT-THM-032) | 空テーマ配列エラー | E-02 L215 | ○ |
| C-33 (UT-THM-033) | テーマコンテキスト破棄 | E-02 L230-241 | ○ |
| C-34 (UT-THM-034) | 存在しないノードエラー | E-02 L231 | ○ |
| C-35 (UT-THM-035) | テーマコンテキスト取得 | E-02 L298-304 | ○ |
| C-36 (UT-THM-036) | コンテキストなしnullptr | E-02 L299-301 | ○ |
| C-37 (UT-THM-037) | デフォルトコンテキスト取得 | E-02 L306-308 | ○ |
| C-38 (UT-THM-038) | 最近接コンテキスト検索 | E-02 L310-323 | ○ |
| C-39 (UT-THM-039) | コンテキストなしnullptr | E-02 L322 | ○ |
| C-40 (UT-THM-040) | ツリー外ノードエラー | E-02 L311 | ○ |
| C-41 (UT-THM-041) | テーマアイテムバインド | E-02 L327-338 | ○ |
| C-42 (UT-THM-042) | 重複バインドエラー | E-02 L328 | ○ |
| C-43 (UT-THM-043) | 外部アイテムバインド | E-02 L340-353 | ○ |
| C-44 (UT-THM-044) | 重複バインドエラー（外部） | E-02 L341 | ○ |
| C-45 (UT-THM-045) | インスタンスキャッシュ更新 | E-02 L355-371 | ○ |
| C-46 (UT-THM-046) | nullインスタンスエラー | E-02 L356 | △ |
| C-47 (UT-THM-047) | 継承階層バインド適用 | E-02 L361-370 | ○ |
| C-48 (UT-THM-048) | クラスアイテム一覧取得 | E-02 L373-404 | ○ |
| C-49 (UT-THM-049) | 継承アイテム含有 | E-02 L395-397 | ○ |
| C-50 (UT-THM-050) | データタイプフィルタ | E-02 L386-388 | ○ |
| C-51 (UT-THM-051) | テーマアイテムソート | E-02 L406-410 | ○ |
| C-52 (UT-THM-052) | コンテキスト子ノード伝播 | E-02 L243-265 | ○ |
| C-53 (UT-THM-053) | 別コンテキスト伝播停止 | E-02 L258-261 | ○ |

### ThemeContextクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 (UT-THM-054) | テーマリスト設定 | E-02 L475-492 | ○ |
| C-55 (UT-THM-055) | nullテーマスキップ | E-02 L483-485 | ○ |
| C-56 (UT-THM-056) | 変更シグナル接続 | E-02 L488 | ○ |
| C-57 (UT-THM-057) | 既存テーマシグナル切断 | E-02 L476-478 | ○ |
| C-58 (UT-THM-058) | 設定後シグナル発行 | E-02 L491 | ○ |
| C-59 (UT-THM-059) | テーマリスト取得 | E-02 L494-496 | ○ |
| C-60 (UT-THM-060) | フォールバックテーマ取得 | E-02 L498-505 | ○ |
| C-61 (UT-THM-061) | 空配列デフォルト返却 | E-02 L500-501 | ○ |
| C-62 (UT-THM-062) | changedシグナル発行 | E-02 L471-473 | ○ |

### ThemeOwnerクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 (UT-THM-063) | コンストラクタholder設定 | E-03 L81 | ○ |
| C-64 (UT-THM-064) | オーナーノード設定（Control） | E-04 L39-42 | ○ |
| C-65 (UT-THM-065) | オーナーノード設定（Window） | E-04 L40 | ○ |
| C-66 (UT-THM-066) | 非Control/Windowエラー | E-04 L40 | ○ |
| C-67 (UT-THM-067) | オーナーノード取得 | E-03 L59 | ○ |
| C-68 (UT-THM-068) | オーナーノード存在確認（true） | E-03 L60 | ○ |
| C-69 (UT-THM-069) | オーナーノード存在確認（false） | E-03 L60 | ○ |
| C-70 (UT-THM-070) | オーナーコンテキスト設定 | E-04 L44-64 | ○ |
| C-71 (UT-THM-071) | nullコンテキストデフォルト接続 | E-04 L57-59 | ○ |
| C-72 (UT-THM-072) | 既存コンテキストシグナル切断 | E-04 L47-51 | ○ |
| C-73 (UT-THM-073) | p_propagate=trueで変更通知 | E-04 L61-63 | ○ |
| C-74 (UT-THM-074) | p_propagate=falseで変更通知なし | E-04 L61-63 | ○ |
| C-75 (UT-THM-075) | Control NOTIFICATION送信 | E-04 L75-76 | ○ |
| C-76 (UT-THM-076) | Window NOTIFICATION送信 | E-04 L77-79 | ○ |
| C-77 (UT-THM-077) | ツリー外holder無処理 | E-04 L67-70 | ○ |
| C-78 (UT-THM-078) | 親Control伝播 | E-04 L92-109 | ○ |
| C-79 (UT-THM-079) | 親Window伝播 | E-04 L104-107 | ○ |
| C-80 (UT-THM-080) | unparentedクリア | E-04 L111-127 | ○ |
| C-81 (UT-THM-081) | 非GUI無処理 | E-04 L133-136 | ○ |
| C-82 (UT-THM-082) | 独自テーマ保持時オーナースキップ | E-04 L140-146 | ○ |
| C-83 (UT-THM-083) | p_notify=true通知送信 | E-04 L152-154, L165-167 | ○ |
| C-84 (UT-THM-084) | 再帰的子伝播 | E-04 L170-172 | ○ |
| C-85 (UT-THM-085) | テーマタイプ依存関係取得 | E-04 L177-225 | ○ |
| C-86 (UT-THM-086) | 非GUI型エラー | E-04 L180 | ○ |
| C-87 (UT-THM-087) | バリエーション依存解決 | E-04 L191-216 | ○ |
| C-88 (UT-THM-088) | テーマアイテム取得 | E-04 L227-261 | ○ |
| C-89 (UT-THM-089) | 空テーマタイプエラー | E-04 L228 | ○ |
| C-90 (UT-THM-090) | ノード階層検索 | E-04 L232-245 | ○ |
| C-91 (UT-THM-091) | グローバルコンテキストフォールバック | E-04 L247-260 | ○ |
| C-92 (UT-THM-092) | テーマアイテム存在確認（true） | E-04 L263-297 | ○ |
| C-93 (UT-THM-093) | テーマアイテム存在確認（false） | E-04 L296 | ○ |
| C-94 (UT-THM-094) | 空テーマタイプエラー（has） | E-04 L264 | ○ |
| C-95 (UT-THM-095) | デフォルトベーススケール取得 | E-04 L299-327 | ○ |
| C-96 (UT-THM-096) | フォールバックスケール返却 | E-04 L326 | ○ |
| C-97 (UT-THM-097) | デフォルトフォント取得 | E-04 L329-357 | ○ |
| C-98 (UT-THM-098) | フォールバックフォント返却 | E-04 L356 | ○ |
| C-99 (UT-THM-099) | デフォルトフォントサイズ取得 | E-04 L359-387 | ○ |
| C-100 (UT-THM-100) | フォールバックフォントサイズ返却 | E-04 L386 | ○ |
| C-101 (UT-THM-101) | Controlテーマ取得 | E-04 L389-393 | ○ |
| C-102 (UT-THM-102) | Windowテーマ取得 | E-04 L395-398 | ○ |
| C-103 (UT-THM-103) | 非GUI空参照返却 | E-04 L400 | ○ |
| C-104 (UT-THM-104) | 親Controlオーナー検索 | E-04 L403-408 | ○ |
| C-105 (UT-THM-105) | 親Windowオーナー検索 | E-04 L409-413 | ○ |
| C-106 (UT-THM-106) | 非GUI親nullptr返却 | E-04 L416 | ○ |

### default_theme モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 (UT-THM-107) | StyleBoxFlat作成 | E-06 L57-71 | ○ |
| C-108 (UT-THM-108) | スケール適用 | E-06 L60-68 | ○ |
| C-109 (UT-THM-109) | 拡張マージン設定 | E-06 L73-79 | ○ |
| C-110 (UT-THM-110) | アイコンテクスチャ生成 | E-06 L82-84 | ○ |
| C-111 (UT-THM-111) | 空スタイルボックス作成 | E-06 L86-90 | ○ |
| C-112 (UT-THM-112) | デフォルトテーマ設定 | E-06 L92-1357 | ○ |
| C-113 (UT-THM-113) | 全GUIコンポーネントスタイル | E-06 L133-1357 | ○ |
| C-114 (UT-THM-114) | デフォルトテーマ作成 | E-06 L1359-1415 | ○ |
| C-115 (UT-THM-115) | フォールバック値設定 | E-06 L1410-1414 | ○ |
| C-116 (UT-THM-116) | スケールクランプ（下限） | E-06 L1369 | ○ |
| C-117 (UT-THM-117) | スケールクランプ（上限） | E-06 L1369 | ○ |
| C-118 (UT-THM-118) | カスタムフォント使用 | E-06 L1371-1374 | ○ |
| C-119 (UT-THM-119) | フォントバリエーション作成 | E-06 L1391-1404 | △ |
| C-120 (UT-THM-120) | SortByType比較演算子 | E-01 L112-116 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-THM-046（C-46）**: `ERR_FAIL_NULL`マクロの正確な動作はマクロ定義ファイル（core/error/error_macros.h）を参照する必要がある
  - 候補：core/error/error_macros.h / 単体テスト実行時の実際の動作確認
- **UT-THM-119（C-119）**: フォントバリエーション作成は`BROTLI_ENABLED`マクロが有効な場合のみデフォルトフォントが設定される。無効な場合の動作は未確認
  - 候補：ビルド設定確認 / 条件付きコンパイルテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- **1（中リスク）**:
  - シングルトンパターン関連（UT-THM-001）：マルチスレッド環境でのテストが必要な可能性
  - シグナル接続/切断（UT-THM-056, UT-THM-057）：メモリリークの可能性を確認する必要
- **2（高リスク）**:
  - テーマコンテキストの伝播（UT-THM-052, UT-THM-053）：複雑なノード階層での動作確認が必要
  - BROTLI_ENABLED依存の処理（UT-THM-119）：ビルド構成によって動作が異なる

## 6) レビュアーチェックリスト（最小）
- [ ] ThemeDBのシングルトン初期化順序が他のシングルトンと競合しないか確認
- [ ] テーマコンテキストのメモリ管理（memnew/memdelete）が適切か確認
- [ ] ERR_FAIL_*マクロの動作がテストケースの期待結果と一致するか確認
- [ ] シグナル接続/切断のペアが正しく管理されているか確認
- [ ] BROTLI_ENABLED無効時のデフォルトフォント動作を確認
- [ ] フォールバック値変更時のシグナル発行が意図通りか確認
- [ ] Control/Window以外のノードタイプでの動作が適切にハンドリングされているか確認
