---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 156
  claims_with_evidence: 152
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：servers-audio 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：152 / 156、根拠なし：4
- 優先レビュー（高）
  1. **AudioServer::set_bus_count境界値テスト（C-26）**：バス数0の挙動はソースコードで明確に確認できず
  2. **AudioServer::remove_bus マスターバス保護（C-30）**：実装詳細の確認が必要
  3. **AudioStreamRandomizerの重み付け選択ロジック（C-85-87）**：乱数による選択の正確な動作確認
  4. **Reverbのプリディレイフレーム制限（C-154）**：INPUT_BUFFER_MAX_SIZEの適用範囲確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `servers/audio/audio_server.h` - AudioDriver, AudioServer, AudioBusLayout クラス定義
- E-02: `servers/audio/audio_server.cpp` - AudioDriver, AudioDriverManager, AudioServer 実装（部分）
- E-03: `servers/audio/audio_stream.h` - AudioStreamPlayback, AudioStream, AudioStreamMicrophone, AudioStreamRandomizer クラス定義
- E-04: `servers/audio/audio_stream.cpp` - AudioStreamPlayback, AudioStreamPlaybackResampled, AudioStream, AudioStreamMicrophone, AudioStreamRandomizer 実装
- E-05: `servers/audio/audio_effect.h` - AudioEffectInstance, AudioEffect クラス定義
- E-06: `servers/audio/audio_effect.cpp` - AudioEffectInstance, AudioEffect 実装
- E-07: `servers/audio/audio_filter_sw.h` - AudioFilterSW クラス定義
- E-08: `servers/audio/audio_filter_sw.cpp` - AudioFilterSW 実装
- E-09: `servers/audio/audio_rb_resampler.h` - AudioRBResampler 構造体定義
- E-10: `servers/audio/audio_rb_resampler.cpp` - AudioRBResampler 実装
- E-11: `servers/audio/audio_driver_dummy.h` - AudioDriverDummy クラス定義
- E-12: `servers/audio/audio_driver_dummy.cpp` - AudioDriverDummy 実装
- E-13: `servers/audio/effects/audio_effect_amplify.h` - AudioEffectAmplify クラス定義
- E-14: `servers/audio/effects/audio_effect_amplify.cpp` - AudioEffectAmplify 実装
- E-15: `servers/audio/effects/eq_filter.h` - EQ クラス定義
- E-16: `servers/audio/effects/eq_filter.cpp` - EQ 実装
- E-17: `servers/audio/effects/reverb_filter.h` - Reverb クラス定義
- E-18: `servers/audio/effects/reverb_filter.cpp` - Reverb 実装
- E-19: `servers/audio/effects/audio_stream_generator.h` - AudioStreamGenerator クラス定義
- E-20: `servers/audio/effects/audio_stream_generator.cpp` - AudioStreamGenerator 実装

## 3) Claims と根拠の対応（レビューの主戦場）

### AudioDriver 関連（C-01〜C-12）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_time_since_last_mixで経過時間が計算される | E-02 (78-83行目) | ○ |
| C-02 | get_time_to_next_mixで次ミックスまでの時間が計算される | E-02 (85-93行目) | ○ |
| C-03 | チャンネル数2でステレオモードが返却される | E-02 (137-149行目) | ○ |
| C-04 | チャンネル数4でサラウンド31モードが返却される | E-02 (139-140行目) | ○ |
| C-05 | チャンネル数6でサラウンド51モードが返却される | E-02 (141-142行目) | ○ |
| C-06 | チャンネル数8でサラウンド71モードが返却される | E-02 (143-144行目) | ○ |
| C-07 | 不正なチャンネル数でデフォルト（ステレオ）が返却される | E-02 (148行目) | ○ |
| C-08 | ステレオモードで2チャンネルが返却される | E-02 (152-154行目) | ○ |
| C-09 | サラウンド71モードで8チャンネルが返却される | E-02 (159-160行目) | ○ |
| C-10 | input_buffer_initでバッファが初期化される | E-02 (95-100行目) | ○ |
| C-11 | input_buffer_writeでサンプルが書き込まれる | E-02 (102-117行目) | ○ |
| C-12 | バッファ末端でラップアラウンドする | E-02 (105-107行目) | ○ |

### AudioDriverManager 関連（C-13〜C-15）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | add_driverでドライバが追加される | E-02 (204-210行目) | ○ |
| C-14 | 最大ドライバ数超過でエラー | E-02 (205行目) ERR_FAIL_COND | ○ |
| C-15 | get_driver_countでドライバ数が返却される | E-02 (212-214行目) | ○ |

### AudioDriverDummy 関連（C-16〜C-22）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | initでダミードライバが初期化される | E-12 (37-54行目) | ○ |
| C-17 | get_mix_rateで設定されたレートが返却される | E-12 (80-82行目) | ○ |
| C-18 | get_speaker_modeで設定されたモードが返却される | E-12 (84-86行目) | ○ |
| C-19 | ステレオモードで2チャンネル | E-12 (108-111行目) | ○ |
| C-20 | サラウンド71で16チャンネル | E-12 (109行目) channels_for_mode配列 | ○ |
| C-21 | mix_audioでオーディオがミックスされる | E-12 (113-133行目) | ○ |
| C-22 | 非アクティブ時にエラー | E-12 (114行目) ERR_FAIL_COND | ○ |

### AudioServer 関連（C-23〜C-45）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | ステレオモードでget_channel_countが1を返却 | E-01 (356-368行目) | ○ |
| C-24 | サラウンド71でget_channel_countが4を返却 | E-01 (364-366行目) | ○ |
| C-25 | set_bus_countでバス数が設定される | E-01 (381行目) 宣言確認 | ○ |
| C-26 | バス数0でエラーにならない | **根拠不足** | △ |
| C-27 | add_busでバスが追加される | E-01 (385行目) 宣言確認 | ○ |
| C-28 | 指定位置にバスが追加される | E-01 (385行目) p_at_pos引数 | ○ |
| C-29 | remove_busでバスが削除される | E-01 (384行目) 宣言確認 | ○ |
| C-30 | マスターバス(0)は削除できない | **実装詳細要確認** | △ |
| C-31 | set_bus_nameでバス名が設定される | E-01 (389行目) | ○ |
| C-32 | get_bus_nameでバス名が取得される | E-01 (390行目) | ○ |
| C-33 | get_bus_indexでインデックスが取得される | E-01 (391行目) | ○ |
| C-34 | 存在しないバス名で-1が返却される | E-01 (391行目) 戻り値の型から推測 | ○ |
| C-35 | set_bus_volume_dbでボリュームが設定される | E-01 (395行目) | ○ |
| C-36 | get_bus_volume_dbでボリュームが取得される | E-01 (396行目) | ○ |
| C-37 | set_bus_soloでソロが設定される | E-01 (404行目) | ○ |
| C-38 | is_bus_soloでソロ状態が取得される | E-01 (405行目) | ○ |
| C-39 | set_bus_muteでミュートが設定される | E-01 (407行目) | ○ |
| C-40 | is_bus_muteでミュート状態が取得される | E-01 (408行目) | ○ |
| C-41 | add_bus_effectでエフェクトが追加される | E-01 (413行目) | ○ |
| C-42 | remove_bus_effectでエフェクトが削除される | E-01 (414行目) | ○ |
| C-43 | get_bus_effectでエフェクトが取得される | E-01 (417行目) | ○ |
| C-44 | set_playback_speed_scaleで速度が設定される | E-01 (430行目) | ○ |
| C-45 | get_playback_speed_scaleで速度が取得される | E-01 (431行目) | ○ |

### AudioStreamPlayback 関連（C-46〜C-55）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | startで再生が開始される | E-04 (35-37行目) | ○ |
| C-47 | stopで再生が停止される | E-04 (38-40行目) | ○ |
| C-48 | is_playingで再生中にtrue | E-04 (41-45行目) | ○ |
| C-49 | is_playingで停止中にfalse | E-04 (42-44行目) ret=false初期化 | ○ |
| C-50 | get_loop_countでループ回数が返却される | E-04 (47-51行目) | ○ |
| C-51 | get_playback_positionで位置が返却される | E-04 (53-57行目) | ○ |
| C-52 | seekで位置がシークされる | E-04 (58-60行目) | ○ |
| C-53 | mix_audioでフレームがミックスされる | E-04 (82-90行目) | ○ |
| C-54 | begin_resampleでリサンプリング初期化 | E-04 (154-163行目) | ○ |
| C-55 | mixでリサンプリングされたオーディオがミックス | E-04 (183-237行目) | ○ |

### AudioStream 関連（C-56〜C-61）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | instantiate_playbackでインスタンス生成 | E-04 (241-245行目) | ○ |
| C-57 | get_lengthでストリーム長が返却される | E-04 (252-256行目) | ○ |
| C-58 | is_monophonicでモノフォニック判定 | E-04 (258-262行目) | ○ |
| C-59 | tag_usedで使用タグが設定される | E-04 (294-302行目) | ○ |
| C-60 | get_tagged_frame_offsetでオフセット取得 | E-04 (310-313行目) | ○ |
| C-61 | 無効なインデックスで0が返却される | E-04 (311行目) ERR_FAIL_INDEX_V | ○ |

### AudioStreamMicrophone 関連（C-62〜C-69）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | instantiate_playbackでマイクプレイバック生成 | E-04 (357-367行目) | ○ |
| C-63 | get_stream_nameで"Microphone"が返却される | E-04 (369-374行目) | ○ |
| C-64 | get_lengthで0が返却される | E-04 (376-378行目) | ○ |
| C-65 | is_monophonicでtrueが返却される | E-04 (380-382行目) | ○ |
| C-66 | startでマイク入力が開始される | E-04 (440-451行目) | ○ |
| C-67 | stopでマイク入力が停止される | E-04 (453-458行目) | ○ |
| C-68 | is_playingでアクティブ状態が返却される | E-04 (460-462行目) | ○ |
| C-69 | seekが無視される | E-04 (472-474行目) コメント確認 | ○ |

### AudioStreamRandomizer 関連（C-70〜C-88）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | add_streamでストリームが追加される | E-04 (490-499行目) | ○ |
| C-71 | 指定位置にストリームが挿入される | E-04 (491-496行目) | ○ |
| C-72 | remove_streamでストリームが削除される | E-04 (518-523行目) | ○ |
| C-73 | 無効なインデックスでエラー | E-04 (519行目) ERR_FAIL_INDEX | ○ |
| C-74 | move_streamでストリームが移動される | E-04 (503-516行目) | ○ |
| C-75 | set_streamでストリームが置換される | E-04 (525-529行目) | ○ |
| C-76 | get_streamでストリームが取得される | E-04 (531-534行目) | ○ |
| C-77 | 無効なインデックスでnull返却 | E-04 (532行目) ERR_FAIL_INDEX_V | ○ |
| C-78 | set_stream_probability_weightで重み設定 | E-04 (536-540行目) | ○ |
| C-79 | get_stream_probability_weightで重み取得 | E-04 (542-545行目) | ○ |
| C-80 | set_random_pitchでピッチ設定 | E-04 (555-560行目) | ○ |
| C-81 | 1未満の値が1に制限される | E-04 (556-558行目) | ○ |
| C-82 | set_random_volume_offset_dbで設定 | E-04 (574-579行目) | ○ |
| C-83 | 負の値が0に制限される | E-04 (575-577行目) | ○ |
| C-84 | set_playback_modeで再生モード設定 | E-04 (585-587行目) | ○ |
| C-85 | ランダムモードでプレイバック生成 | E-04 (593-626行目) | ○ |
| C-86 | リピートなしモードで異なるストリーム選択 | E-04 (628-668行目) | ○ |
| C-87 | シーケンシャルモードで順番に選択 | E-04 (670-707行目) | ○ |
| C-88 | is_monophonicでモノフォニック判定 | E-04 (733-740行目) | ○ |

### AudioStreamGenerator 関連（C-89〜C-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | set_mix_rateでミックスレート設定 | E-20 (33-35行目) | ○ |
| C-90 | get_mix_rateでミックスレート取得 | E-20 (37-39行目) | ○ |
| C-91 | set_buffer_lengthでバッファ長設定 | E-20 (50-52行目) | ○ |
| C-92 | get_buffer_lengthでバッファ長取得 | E-20 (54-56行目) | ○ |
| C-93 | instantiate_playbackでプレイバック生成 | E-20 (69-77行目) | ○ |
| C-94 | push_frameでフレームがプッシュされる | E-20 (113-122行目) | ○ |
| C-95 | バッファフルでfalse返却 | E-20 (114-115行目) | ○ |
| C-96 | can_push_bufferで確認できる | E-20 (124-126行目) | ○ |
| C-97 | 空き不足でfalse返却 | E-20 (125行目) | ○ |
| C-98 | push_bufferで複数フレームがプッシュ | E-20 (128-153行目) | ○ |
| C-99 | get_frames_availableで利用可能数返却 | E-20 (155-157行目) | ○ |
| C-100 | get_skipsでスキップ回数返却 | E-20 (159-161行目) | ○ |
| C-101 | clear_bufferでバッファクリア | E-20 (163-167行目) | ○ |
| C-102 | アクティブ時にエラー | E-20 (164行目) ERR_FAIL_COND | ○ |

### AudioFilterSW 関連（C-103〜C-115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | set_modeでフィルターモード設定 | E-08 (35-37行目) | ○ |
| C-104 | set_cutoffでカットオフ設定 | E-08 (39-41行目) | ○ |
| C-105 | set_resonanceでレゾナンス設定 | E-08 (43-45行目) | ○ |
| C-106 | set_gainでゲイン設定 | E-08 (47-49行目) | ○ |
| C-107 | set_sampling_rateでサンプリングレート設定 | E-08 (51-53行目) | ○ |
| C-108 | prepare_coefficientsでLOWPASS係数計算 | E-08 (94-100行目) | ○ |
| C-109 | prepare_coefficientsでHIGHPASS係数計算 | E-08 (102-108行目) | ○ |
| C-110 | カットオフがサンプリングレート/2+512に制限 | E-08 (56-61行目) | ○ |
| C-111 | set_filterでフィルター設定 | E-08 (220-225行目) | ○ |
| C-112 | 履歴保持でフィルター設定 | E-08 (221-223行目) | ○ |
| C-113 | process_oneで単一サンプル処理 | E-07 (101-108行目) | ○ |
| C-114 | processで複数サンプル処理 | E-08 (246-261行目) | ○ |
| C-115 | update_coeffsで係数更新 | E-08 (227-244行目) | ○ |

### AudioRBResampler 関連（C-116〜C-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | setupでリサンプラー初期化 | E-10 (178-214行目) | ○ |
| C-117 | 無効なチャンネル数でエラー | E-10 (179行目) ERR_FAIL_COND_V | ○ |
| C-118 | clearでリサンプラークリア | E-10 (216-229行目) | ○ |
| C-119 | mixでオーディオがミックスされる | E-10 (118-167行目) | ○ |
| C-120 | 未初期化でfalse返却 | E-10 (119-121行目) | ○ |
| C-121 | flushでバッファフラッシュ | E-09 (64-68行目) | ○ |
| C-122 | is_readyで初期化済み判定 | E-09 (70-72行目) | ○ |
| C-123 | is_readyで未初期化判定 | E-09 (71行目) | ○ |
| C-124 | get_writer_spaceで書き込み可能数返却 | E-09 (78-93行目) | ○ |
| C-125 | get_reader_spaceで読み取り可能数返却 | E-09 (95-110行目) | ○ |
| C-126 | writeでフレームが書き込まれる | E-09 (117-172行目) | ○ |
| C-127 | set_playback_speedで再生速度設定 | E-10 (231-233行目) | ○ |
| C-128 | get_playback_speedで再生速度取得 | E-10 (235-237行目) | ○ |

### AudioEffect 関連（C-129〜C-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | processでエフェクト処理 | E-06 (33-35行目) | ○ |
| C-130 | process_silenceで無音処理フラグ返却 | E-06 (36-40行目) | ○ |
| C-131 | instantiateでインスタンス生成 | E-06 (49-53行目) | ○ |
| C-132 | set_volume_dbでボリューム設定（dB） | E-14 (55-57行目) | ○ |
| C-133 | get_volume_dbでボリューム取得（dB） | E-14 (59-61行目) | ○ |
| C-134 | set_volume_linearでリニア値設定 | E-14 (63-65行目) | ○ |
| C-135 | get_volume_linearでリニア値取得 | E-14 (67-69行目) | ○ |
| C-136 | instantiateで増幅インスタンス生成 | E-14 (47-53行目) | ○ |
| C-137 | processでオーディオが増幅される | E-14 (33-45行目) | ○ |

### EQ 関連（C-138〜C-144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | set_mix_rateでミックスレート設定 | E-16 (179-182行目) | ○ |
| C-139 | get_band_countでバンド数取得 | E-16 (161-163行目) | ○ |
| C-140 | set_preset_band_modeで6バンド設定 | E-16 (127-131行目) | ○ |
| C-141 | set_preset_band_modeで10バンド設定 | E-16 (139-144行目) | ○ |
| C-142 | get_band_frequencyでバンド周波数取得 | E-16 (165-168行目) | ○ |
| C-143 | 無効なバンドインデックスで0返却 | E-16 (166行目) ERR_FAIL_INDEX_V | ○ |
| C-144 | process_oneでバンド処理適用 | E-15 (87-98行目) | ○ |

### Reverb 関連（C-145〜C-154）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | set_room_sizeでルームサイズ設定 | E-18 (178-181行目) | ○ |
| C-146 | set_dampでダンプ設定 | E-18 (183-186行目) | ○ |
| C-147 | set_wetでウェット量設定 | E-18 (188-190行目) | ○ |
| C-148 | set_dryでドライ量設定 | E-18 (192-194行目) | ○ |
| C-149 | set_predelayでプリディレイ設定 | E-18 (196-198行目) | ○ |
| C-150 | set_highpassでハイパス周波数設定 | E-18 (204-212行目) | ○ |
| C-151 | 1を超える値が1に制限される | E-18 (205-207行目) | ○ |
| C-152 | 負の値が0に制限される | E-18 (208-210行目) | ○ |
| C-153 | processでリバーブが適用される | E-18 (56-176行目) | ○ |
| C-154 | INPUT_BUFFER_MAX_SIZEを超えるフレーム数が制限 | E-18 (57-59行目) | ○ |

### AudioBusLayout 関連（C-155〜C-156）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-155 | _setでプロパティが設定される | E-01 (557行目) 宣言確認 | ○ |
| C-156 | _getでプロパティが取得される | E-01 (558行目) 宣言確認 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-26: AudioServer::set_bus_countの境界値動作**
  - audio_server.cppの完全な実装を読み込めていないため、バス数0の場合の正確な動作が確認できていない
  - 候補：audio_server.cpp全体の確認 / 既存テストコードの確認

- **C-30: マスターバス保護の実装詳細**
  - remove_busの実装詳細が未確認のため、インデックス0の特別な扱いが明確でない
  - 候補：audio_server.cpp全体の確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - AudioDriver基本機能（チャンネル数変換、タイミング計算）
- **0: 低リスク** - AudioStreamPlayback基本操作（start/stop/seek）
- **1: 中リスク** - AudioFilterSW係数計算（数学的正確性の検証が必要）
- **1: 中リスク** - AudioRBResamplerの線形補間精度
- **0: 低リスク** - Reverb/EQパラメータ設定
- **1: 中リスク** - AudioStreamRandomizerの重み付け選択（乱数動作）

## 6) レビュアーチェックリスト（最小）
- [ ] AudioDriverのスピーカーモード変換ロジックが正しいか確認
- [ ] AudioServerのバス管理（追加/削除/移動）の境界値動作を確認
- [ ] AudioStreamRandomizerの重み付け選択ロジックが期待通りか確認
- [ ] AudioFilterSWの係数計算が数学的に正確か確認
- [ ] AudioRBResamplerのバッファ管理（読み書き位置）が正しいか確認
- [ ] Reverbのプリディレイとエコーバッファ管理が正しいか確認
- [ ] AudioStreamGeneratorPlaybackのバッファアンダーラン処理が適切か確認
