---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：servers-camera 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/servers/camera/camera_server.h`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/servers/camera/camera_server.cpp`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/servers/camera/camera_feed.h`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/godot-master/servers/camera/camera_feed.cpp`

## 3) Claims と根拠の対応（レビューの主戦場）

### CameraServer クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_singleton はシングルトンインスタンスを返す | E-01 L67-69, E-02 L65-69 | ○ |
| C-02 | set_monitoring_feeds でモニタリングフラグを設定できる | E-02 L71-73 | ○ |
| C-03 | is_monitoring_feeds でモニタリング状態を取得できる | E-01 L94 | ○ |
| C-04 | get_free_id は未使用IDを生成する | E-02 L75-91 | ○ |
| C-05 | get_free_id は既存IDと重複しないIDを返す | E-02 L80-88 | ○ |
| C-06 | get_feed_index はIDからインデックスを検索する | E-02 L93-103 | ○ |
| C-07 | get_feed_index はモニタリング無効時にエラーを返す | E-02 L94 | ○ |
| C-08 | get_feed_by_id はIDからフィードを取得する | E-02 L105-115 | ○ |
| C-09 | get_feed_by_id はモニタリング無効時にnullを返す | E-02 L106 | ○ |
| C-10 | add_feed はフィードを追加しシグナルを発火する | E-02 L117-127 | ○ |
| C-11 | add_feed はnullチェックを行う | E-02 L118 | ○ |
| C-12 | remove_feed はフィードを削除しシグナルを発火する | E-02 L129-144 | ○ |
| C-13 | get_feed はインデックスでフィードを取得する | E-02 L146-151 | ○ |
| C-14 | get_feed は範囲外インデックスでnullを返す | E-02 L148 | ○ |
| C-15 | get_feed_count はフィード数を返す | E-02 L153-156 | ○ |
| C-16 | get_feeds は全フィードの配列を返す | E-02 L158-169 | ○ |
| C-17 | feed_texture はフィードのテクスチャRIDを返す | E-02 L171-179 | ○ |

### CameraFeed クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | デフォルトコンストラクタで初期化される | E-04 L151-163 | ○ |
| C-19 | 引数付きコンストラクタで初期化される | E-04 L165-177 | ○ |
| C-20 | get_id は一意のIDを返す | E-04 L84-86 | ○ |
| C-21 | is_active はアクティブ状態を返す | E-04 L88-90 | ○ |
| C-22 | set_active は状態を変更し activate/deactivate を呼ぶ | E-04 L92-105 | ○ |
| C-23 | set_active は同じ状態では何もしない | E-04 L93-94 | ○ |
| C-24 | get_name は名前を返す | E-04 L107-109 | ○ |
| C-25 | set_name は名前を設定する | E-04 L111-113 | ○ |
| C-26 | get_base_width はベース幅を返す | E-04 L115-117 | ○ |
| C-27 | get_base_height はベース高さを返す | E-04 L119-121 | ○ |
| C-28 | get_datatype はデータタイプを返す | E-04 L123-125 | ○ |
| C-29 | get_position はカメラ位置を返す | E-04 L127-129 | ○ |
| C-30 | set_position はカメラ位置を設定する | E-04 L131-133 | ○ |
| C-31 | get_transform は変換行列を返す | E-04 L135-137 | ○ |
| C-32 | set_transform は変換行列を設定する | E-04 L139-141 | ○ |
| C-33 | get_texture はテクスチャRIDを返す | E-04 L143-145 | ○ |
| C-34 | get_texture_tex_id はネイティブテクスチャIDを返す | E-04 L147-149 | ○ |
| C-35 | set_rgb_image はRGB画像を設定する | E-04 L186-216 | ○ |
| C-36 | set_rgb_image はnullチェックを行う | E-04 L187 | ○ |
| C-37 | set_rgb_image はサイズ変更時にシグナルを発火する | E-04 L196-198 | ○ |
| C-38 | set_ycbcr_image はYCbCr画像を設定する | E-04 L218-248 | ○ |
| C-39 | set_ycbcr_image はnullチェックを行う | E-04 L219 | ○ |
| C-40 | set_ycbcr_images は分離YCbCr画像を設定する | E-04 L250-291 | ○ |
| C-41 | set_ycbcr_images は両画像のnullチェックを行う | E-04 L251-252 | ○ |
| C-42 | set_external は外部テクスチャを設定する | E-04 L293-315 | ○ |
| C-43 | activate_feed は仮想メソッドを呼び出す | E-04 L317-321 | ○ |
| C-44 | deactivate_feed は仮想メソッドを呼び出す | E-04 L323-325 | ○ |
| C-45 | set_format はデフォルトでfalseを返す | E-04 L327-329 | ○ |
| C-46 | get_formats はデフォルトで空配列を返す | E-04 L331-333 | ○ |
| C-47 | get_format はデフォルトで空のFeedFormatを返す | E-04 L335-338 | ○ |
| C-48 | デストラクタでテクスチャを解放する | E-04 L179-184 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - すべてのテストケースはソースコードの実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコード根拠あり
- 注意点:
  - プラットフォーム固有の実装（Android等）は解析対象外のため、FEED_EXTERNAL関連のテストは基本クラスの動作のみ検証
  - GDVIRTUAL_CALLを使用するメソッド（activate_feed, deactivate_feed）はサブクラスでのオーバーライドテストが別途必要

## 6) レビュアーチェックリスト（最小）
- [ ] CameraServer のモニタリングフラグ前提条件チェック（UT-CAM-010, 013, 020, 023, 025, 028）が網羅されているか確認
- [ ] CameraFeed の画像設定メソッド（set_rgb_image, set_ycbcr_image, set_ycbcr_images）のnullチェックテストが適切か確認
- [ ] シグナル発火テスト（camera_feed_added, camera_feed_removed, format_changed, frame_changed）の観点が妥当か確認
- [ ] デストラクタのリソース解放テスト（UT-CAM-068, 069, 070）が実行可能か確認
- [ ] GDVIRTUAL_CALL を使用するメソッドのテスト方針が適切か確認

## 7) 補足：テストケース分類

### 優先度別分布
| 優先度 | 件数 | 割合 |
|--------|------|------|
| 高 | 40 | 57.1% |
| 中 | 26 | 37.1% |
| 低 | 4 | 5.7% |

### テスト観点別分布
| 観点 | 件数 | 割合 |
|------|------|------|
| 正常系 | 49 | 70.0% |
| 異常系 | 14 | 20.0% |
| 境界値 | 7 | 10.0% |

### クラス別分布
| クラス | 件数 |
|--------|------|
| CameraServer | 28 |
| CameraFeed | 42 |
