---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 89
  claims_with_evidence: 89
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：servers-debugger.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（servers-debugger.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：89 / 89、根拠なし：0
- 優先レビュー（高）
  1. **シリアライズ/デシリアライズ処理**：通信プロトコルの要となるため重点確認推奨
  2. **プロファイラのtoggle/tick処理**：状態管理とメッセージ送信タイミングの検証
  3. **_captureコマンド処理**：デバッガコマンドのハンドリング検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/debugger/servers_debugger.h` - クラス定義・構造体定義
- E-02: `servers/debugger/servers_debugger.cpp` - 実装コード

## 3) Claims と根拠の対応（レビューの主戦場）

### ResourceInfo構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VRAM値が異なる場合は降順でソート | E-01 L44: `vram > p_img.vram` | ○ |
| C-02 | VRAM同一時はRID比較 | E-01 L44: `id < p_img.id` | ○ |
| C-03 | VRAM=0のソート動作 | E-01 L44 | ○ |

### ResourceUsage構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | serialize()でソート後シリアライズ | E-02 L43-54 | ○ |
| C-05 | VRAM降順ソート | E-02 L44: `infos.sort()` + E-01 L44 | ○ |
| C-06 | 空リストのシリアライズ | E-02 L46-53 | ○ |
| C-07 | deserialize()の正常復元 | E-02 L56-73 | ○ |
| C-08 | 配列サイズ不足時false | E-02 L57: `CHECK_SIZE` | ○ |
| C-09 | サイズ%4!=0時false | E-02 L59: `ERR_FAIL_COND_V(size % 4, false)` | ○ |
| C-10 | データ不足時false | E-02 L60: `CHECK_SIZE` | ○ |
| C-11 | 余分データ時false | E-02 L71: `CHECK_END` | ○ |

### ScriptFunctionSignature構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | serialize()で[name, id]を返す | E-02 L75-77 | ○ |
| C-13 | deserialize()の正常復元 | E-02 L79-85 | ○ |
| C-14 | 配列サイズ<2時false | E-02 L80: `CHECK_SIZE(p_arr, 2, ...)` | ○ |
| C-15 | 配列サイズ>2時false | E-02 L83: `CHECK_END` | ○ |

### ServersProfilerFrame構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | serialize()でフレーム情報格納 | E-02 L87-109 | ○ |
| C-17 | サーバー関数情報のシリアライズ | E-02 L90-98 | ○ |
| C-18 | スクリプト関数情報のシリアライズ | E-02 L100-107 | ○ |
| C-19 | 空serversリストのシリアライズ | E-02 L90 | ○ |
| C-20 | 空script_functionsのシリアライズ | E-02 L100 | ○ |
| C-21 | deserialize()の正常復元 | E-02 L111-154 | ○ |
| C-22 | 配列サイズ<7時false | E-02 L112: `CHECK_SIZE(p_arr, 7, ...)` | ○ |
| C-23 | サーバーデータ不完全時false | E-02 L122, L128 | ○ |
| C-24 | スクリプト関数データ不完全時false | E-02 L138, L141 | ○ |
| C-25 | 余分データ時false | E-02 L152: `CHECK_END` | ○ |

### VisualProfilerFrame構造体
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | serialize()でフレーム情報格納 | E-02 L156-164 | ○ |
| C-27 | 空areasのシリアライズ | E-02 L157 | ○ |
| C-28 | deserialize()の正常復元 | E-02 L166-182 | ○ |
| C-29 | 配列サイズ<2時false | E-02 L167: `CHECK_SIZE(p_arr, 2, ...)` | ○ |
| C-30 | areasデータ不完全時false | E-02 L170: `CHECK_SIZE` | ○ |
| C-31 | 余分データ時false | E-02 L180: `CHECK_END` | ○ |

### ScriptsProfilerクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | toggle(true)で全言語プロファイリング開始 | E-02 L197-208 | ○ |
| C-33 | ネイティブコール保存オプション設定 | E-02 L202-204 | ○ |
| C-34 | max_frame_functions設定 | E-02 L206-208 | ○ |
| C-35 | 負値でmax_frame_functions=0 | E-02 L207: `MAX(0, int(p_opts[0]))` | ○ |
| C-36 | toggle(false)で全言語プロファイリング停止 | E-02 L209-213 | ○ |
| C-37 | write_frame_dataでtotal_time降順ソート | E-02 L230-231 | ○ |
| C-38 | 新規シグネチャのsig_map登録 | E-02 L238-245 | ○ |
| C-39 | 時間単位変換（マイクロ秒→秒） | E-02 L258-260: `/ 1000000.0` | ○ |
| C-40 | max_frame_functions制限 | E-02 L233: `MIN(ofs, max_frame_functions)` | ○ |
| C-41 | コンストラクタでinfo配列リサイズ | E-02 L265-267 | ○ |

### ServersProfilerクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | toggle(true)でserver_dataクリア | E-02 L315-316 | ○ |
| C-43 | toggle(false)で最終フレーム送信 | E-02 L317-318 | ○ |
| C-44 | add()で新規サーバー追加 | E-02 L323-329 | ○ |
| C-45 | add()で既存サーバーに関数追加 | E-02 L330-337 | ○ |
| C-46 | tick()でフレームデータ送信 | E-02 L340-346, L308 | ○ |
| C-47 | tick()後に関数リストクリア | E-02 L295 | ○ |
| C-48 | skip_frame()でスキップ | E-02 L348-350, L301-304 | ○ |
| C-49 | スキップフラグは1フレームのみ | E-02 L301-302 | ○ |

### VisualProfilerクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | toggle(true)でRS有効化 | E-02 L361 | ○ |
| C-51 | toggle()でハードウェア情報送信 | E-02 L363-368 | ○ |
| C-52 | toggle(false)でRS無効化 | E-02 L361 | ○ |
| C-53 | tick()でフレーム情報送信 | E-02 L373-383 | ○ |
| C-54 | 空profile_areasで早期リターン | E-02 L376-378 | ○ |

### ServersDebuggerクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | initialize()でデバッガアクティブ時インスタンス作成 | E-02 L388-392 | ○ |
| C-56 | initialize()でデバッガ非アクティブ時インスタンス作成しない | E-02 L389 | ○ |
| C-57 | deinitialize()でsingleton削除 | E-02 L394-398 | ○ |
| C-58 | deinitialize()でsingleton=null時何もしない | E-02 L395 | ○ |
| C-59 | _capture()でmemoryコマンド処理 | E-02 L403-404 | ○ |
| C-60 | _capture()でdrawコマンド描画実行 | E-02 L405-416 | ○ |
| C-61 | _capture()でdelta時間計算 | E-02 L407-411 | ○ |
| C-62 | _capture()でdrawnメッセージ送信 | E-02 L416 | ○ |
| C-63 | _capture()でforegroundコマンド処理 | E-02 L417-420 | ○ |
| C-64 | _capture()でlast_draw_timeリセット | E-02 L418 | ○ |
| C-65 | _capture()でskip_frame呼び出し | E-02 L420 | ○ |
| C-66 | _capture()で不明コマンド時r_captured=false | E-02 L421-423 | ○ |
| C-67 | _capture()でsingleton=null時ERR_BUG | E-02 L401 | ○ |
| C-68 | _send_resource_usage()でテクスチャ情報収集 | E-02 L430-462 | ○ |
| C-69 | _send_resource_usage()でメッシュ情報収集 | E-02 L464-490 | ○ |
| C-70 | 2Dテクスチャタイプ設定 | E-02 L440-441 | ○ |
| C-71 | 3Dテクスチャタイプ設定 | E-02 L442-443 | ○ |
| C-72 | レイヤードテクスチャタイプ設定 | E-02 L444-445 | ○ |
| C-73 | パスからリソースタイプ取得・上書き | E-02 L451-454, L483-486 | ○ |
| C-74 | 2Dテクスチャフォーマット文字列生成 | E-02 L456-457 | ○ |
| C-75 | 3Dテクスチャフォーマット文字列生成 | E-02 L458-459 | ○ |
| C-76 | メッシュVRAM計算 | E-02 L471 | ○ |
| C-77 | 空メッシュスキップ | E-02 L477-479 | ○ |
| C-78 | memory_usageメッセージ送信 | E-02 L492 | ○ |
| C-79 | _get_resource_type_from_path()で空パス処理 | E-02 L497-499 | ○ |
| C-80 | _get_resource_type_from_path()で存在チェック | E-02 L501-503 | ○ |
| C-81 | キャッシュからクラス名取得 | E-02 L505-507 | ○ |
| C-82 | ResourceLoaderからタイプ取得 | E-02 L509-513 | ○ |
| C-83 | タイプ取得失敗時空文字 | E-02 L516 | ○ |
| C-84 | コンストラクタでsingleton設定 | E-02 L520 | ○ |
| C-85 | コンストラクタでservers_profilerバインド | E-02 L523-524 | ○ |
| C-86 | コンストラクタでvisual_profilerバインド | E-02 L527-528 | ○ |
| C-87 | コンストラクタでserversキャプチャ登録 | E-02 L530-531 | ○ |
| C-88 | デストラクタでキャプチャ解除 | E-02 L535 | ○ |
| C-89 | デストラクタでsingletonクリア | E-02 L536 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
  - 全てのテストケースはソースコード（servers_debugger.h, servers_debugger.cpp）から直接導出

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに直接紐付いている
- 注意点：
  - シリアライズ/デシリアライズはネットワーク通信の基盤となるため、境界値テストの網羅性を確認推奨
  - プロファイラの状態管理（skip_profile_frame等）は並行処理時の挙動に注意

## 6) レビュアーチェックリスト（最小）
- [ ] シリアライズ/デシリアライズのテストケースがCHECK_SIZE/CHECK_ENDマクロの全パスをカバーしているか
- [ ] プロファイラのtoggle処理で有効化/無効化の両方向が網羅されているか
- [ ] _captureのコマンドハンドリングで全コマンド（memory, draw, foreground）がカバーされているか
- [ ] リソース情報収集（テクスチャ/メッシュ）の各タイプ分岐がカバーされているか
- [ ] 時間計算（マイクロ秒→秒変換、delta計算）の精度に関する考慮があるか
