---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 181
  claims_with_evidence: 181
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：servers-display 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたservers-displayモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：181 / 181、根拠なし：0
- 優先レビュー（高）
  1. **プラットフォーム固有テスト**：プラットフォーム依存の機能は実機での検証が必要
  2. **アクセシビリティ機能**：AccessibilityDriverの実装はプラットフォームごとに異なる
  3. **TTSテスト**：Text-to-Speech機能は環境依存が大きい

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/display/display_server.h` - DisplayServerクラス定義、列挙型、仮想メソッド宣言
- E-02: `servers/display/display_server.cpp` - DisplayServerクラスの実装、デフォルト動作
- E-03: `servers/display/native_menu.h` - NativeMenuクラス定義、メニュー関連メソッド宣言
- E-04: `servers/display/native_menu.cpp` - NativeMenuクラスの実装、デフォルト実装
- E-05: `servers/display/display_server_headless.h` - DisplayServerHeadlessクラス、スタブ実装

## 3) Claims と根拠の対応（レビューの主戦場）

### DisplayServer クラス（UT-DSP-001 ～ UT-DSP-132）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_singletonがシングルトンを返す | E-01 L59-61 static singleton変数定義 | ○ |
| C-02 | has_featureがFeature値に応じた結果を返す | E-01 L174 純粋仮想関数宣言 | ○ |
| C-03 | get_nameがサーバー名を返す | E-01 L175 純粋仮想関数宣言 | ○ |
| C-04 | TTS関連メソッドが存在する | E-01 L259-270, E-02 L414-480 実装 | ○ |
| C-05 | tts_get_voices_for_languageが言語フィルタを行う | E-02 L437-447 実装ロジック確認 | ○ |
| C-06 | MouseMode関連メソッドが存在する | E-01 L289-307 宣言、E-02 L499-521 実装 | ○ |
| C-07 | クリップボード関連メソッドが存在する | E-01 L309-315 宣言、E-02 L534-559 実装 | ○ |
| C-08 | スクリーン関連メソッドが存在する | E-01 L351-371 宣言、E-02 L562-601 実装 | ○ |
| C-09 | _get_screen_indexがスクリーンID解決を行う | E-01 L330-349 switch文による解決ロジック | ○ |
| C-10 | ウィンドウ管理メソッドが存在する | E-01 L437-530 多数のウィンドウ関連メソッド宣言 | ○ |
| C-11 | V-Sync関連メソッドが存在する | E-01 L504-505 宣言、E-02 L1261-1268 実装 | ○ |
| C-12 | IME関連メソッドが存在する | E-01 L525-526, L767-768 宣言、E-02 L627-633, L1085-1091 実装 | ○ |
| C-13 | 仮想キーボード関連メソッドが存在する | E-01 L781-785 宣言、E-02 L1093-1105 実装 | ○ |
| C-14 | カーソル関連メソッドが存在する | E-01 L809-811 宣言、E-02 L1111-1121 実装 | ○ |
| C-15 | ダイアログ関連メソッドが存在する | E-01 L822-834 宣言、E-02 L1150-1168 実装 | ○ |
| C-16 | キーボードレイアウト関連メソッドが存在する | E-01 L843-849 宣言、E-02 L1173-1198 実装 | ○ |
| C-17 | ステータスインジケーター関連メソッドが存在する | E-01 L868-874 宣言、E-02 L1226-1254 実装 | ○ |
| C-18 | アクセシビリティ関連メソッドが存在する | E-01 L685-763 多数の宣言、E-02 L635-1083 実装 | ○ |
| C-19 | register/unregister_additional_outputが存在する | E-01 L880-882 宣言、E-02 L1277-1286 実装 | ○ |
| C-20 | create関数が存在する | E-01 L888 宣言 | ○ |

### NativeMenu クラス（UT-DSP-133 ～ UT-DSP-170）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | get_singletonがシングルトンを返す | E-03 L47-49 static singleton定義 | ○ |
| C-22 | has_featureがFeature値を検証する | E-03 L68, E-04 L133-135 実装 | ○ |
| C-23 | システムメニュー関連メソッドが存在する | E-03 L70-75, E-04 L137-170 実装 | ○ |
| C-24 | get_system_menu_nameがメニュー名を返す | E-04 L146-161 switch文による実装確認 | ○ |
| C-25 | メニュー作成/解放メソッドが存在する | E-03 L77-79, E-04 L172-184 実装 | ○ |
| C-26 | ポップアップ表示メソッドが存在する | E-03 L81-82, E-04 L186-193 実装 | ○ |
| C-27 | コールバック設定メソッドが存在する | E-03 L86-91, E-04 L199-228 実装 | ○ |
| C-28 | アイテム追加メソッドが存在する | E-03 L95-103, E-04 L231-274 実装 | ○ |
| C-29 | アイテム検索メソッドが存在する | E-03 L105-107, E-04 L276-297 実装 | ○ |
| C-30 | find_item_index_with_submenuが実装されている | E-04 L286-297 ループによる検索実装 | ○ |
| C-31 | アイテム状態取得メソッドが存在する | E-03 L109-124, E-04 L299-377 実装 | ○ |
| C-32 | アイテム状態設定メソッドが存在する | E-03 L126-142, E-04 L379-445 実装 | ○ |
| C-33 | get_item_countが存在する | E-03 L144, E-04 L447-450 実装 | ○ |
| C-34 | remove_item/clearが存在する | E-03 L147-148, E-04 L457-463 実装 | ○ |
| C-35 | is_system_menuが存在する | E-03 L145, E-04 L452-455 実装 | ○ |

### DisplayServerHeadless クラス（UT-DSP-171 ～ UT-DSP-178）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | has_featureが常にfalseを返す | E-05 L69 実装確認 | ○ |
| C-37 | get_nameが"headless"を返す | E-05 L70 実装確認 | ○ |
| C-38 | get_screen_countが0を返す | E-05 L75 実装確認 | ○ |
| C-39 | screen_get_dpiが96を返す | E-05 L80 実装確認（0はissuesを起こす可能性があるためコメント付き） | ○ |
| C-40 | window_is_focusedが常にtrueを返す | E-05 L145 実装確認 | ○ |
| C-41 | process_eventsがInput::flush_buffered_eventsを呼ぶ | E-05 L156-158 実装確認 | ○ |
| C-42 | window_set_input_event_callbackがコールバックを保存する | E-05 L102-104 実装確認 | ○ |
| C-43 | _dispatch_input_eventがコールバックを呼び出す | E-05 L59-63 実装確認 | ○ |

### AccessibilityDriver クラス（UT-DSP-179 ～ UT-DSP-181）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | 純粋仮想関数として定義されている | E-01 L912 init純粋仮想関数宣言 | ○ |
| C-45 | window_create/destroyが存在する | E-01 L914-915 純粋仮想関数宣言 | ○ |
| C-46 | アクセシビリティ要素操作メソッドが存在する | E-01 L917-994 多数の純粋仮想関数宣言 | ○ |

## 4) 不足情報（Unknown / Missing）
- **プラットフォーム固有実装**: Windows/macOS/Linux/モバイル向けの具体的なDisplayServer実装は本モジュール外にある
  - 候補：`platform/windows/display_server_windows.cpp` / `platform/macos/display_server_macos.mm` / `platform/linuxbsd/display_server_x11.cpp`
- **レンダリングコンテキスト**: Vulkan/D3D12/Metal等のレンダリングドライバーとの連携詳細
  - 候補：`drivers/vulkan/` / `drivers/d3d12/` / `drivers/metal/`
- **Inputクラスとの連携**: マウス・キーボード入力の詳細な連携
  - 候補：`core/input/input.h`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: シングルトンパターン、基本的なゲッター/セッター
- **1 (中リスク)**: TTS、IME、仮想キーボードなど環境依存機能
- **2 (高リスク)**: プラットフォーム固有機能のテスト（実機テスト必須）

## 6) レビュアーチェックリスト（最小）
- [ ] DisplayServerの純粋仮想関数がプラットフォーム実装で適切にオーバーライドされているか確認
- [ ] NativeMenuのデフォルト実装が「サポートされていない」警告を適切に出すか確認
- [ ] DisplayServerHeadlessがCI/CDパイプラインで正しく動作するか確認
- [ ] アクセシビリティ機能がスクリーンリーダーと正しく連携するか確認（実機テスト）
- [ ] TTSテストが各プラットフォームの音声エンジンで動作するか確認
- [ ] ウィンドウ管理テストがマルチモニタ環境で正しく動作するか確認
- [ ] V-Sync設定テストが各グラフィックスAPIで動作するか確認
