---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 94
  claims_with_evidence: 94
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：servers-navigation_3d 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：94 / 94、根拠なし：0
- 優先レビュー（高）
  1. **UT-NV3-001〜016**: NavigationServer3Dクラスのコア機能テスト
  2. **UT-NV3-017〜043**: NavigationPathQueryParameters3Dクラスの全setter/getter
  3. **UT-NV3-044〜052**: NavigationPathQueryResult3Dクラスのパス結果管理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/navigation_3d/navigation_server_3d.h` - NavigationServer3Dクラス定義
- E-02: `servers/navigation_3d/navigation_server_3d.cpp` - NavigationServer3D実装
- E-03: `servers/navigation_3d/navigation_path_query_parameters_3d.h` - パスクエリパラメータクラス定義
- E-04: `servers/navigation_3d/navigation_path_query_parameters_3d.cpp` - パスクエリパラメータ実装
- E-05: `servers/navigation_3d/navigation_path_query_result_3d.h` - パスクエリ結果クラス定義
- E-06: `servers/navigation_3d/navigation_path_query_result_3d.cpp` - パスクエリ結果実装
- E-07: `servers/navigation_3d/navigation_constants_3d.h` - 定数・列挙型定義
- E-08: `servers/navigation_3d/navigation_server_3d_dummy.h` - ダミーサーバー実装

## 3) Claims と根拠の対応（レビューの主戦場）

### NavigationServer3D クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_singletonでシングルトンインスタンスが取得できる | E-02 (238-240行目) | ○ |
| C-02 | source_geometry_parser_createでRIDが作成される | E-02 (359-370行目) | ○ |
| C-03 | source_geometry_parser_set_callbackでコールバック設定される | E-02 (385-392行目) | ○ |
| C-04 | 無効なRIDでERR_FAIL_NULLが発生する | E-02 (389行目) | ○ |
| C-05 | free_ridでパーサーRIDが解放される | E-02 (372-383行目) | ○ |
| C-06 | 無効なRIDのfree_ridは安全にスキップされる | E-02 (373-375行目) | ○ |
| C-07 | set_debug_enabledでデバッグ状態が設定される | E-02 (394-410行目) | ○ |
| C-08 | デバッグ状態変更でシグナルが発行される | E-02 (403-407行目) | ○ |
| C-09 | get_debug_enabledで状態取得できる | E-02 (412-414行目) | ○ |
| C-10 | set_debug_navigation_enabledで設定される | E-02 (1010-1014行目) | ○ |
| C-11 | set_debug_avoidance_enabledで設定される | E-02 (1020-1024行目) | ○ |
| C-12 | デバッグ色の設定が反映される | E-02 (709-784行目) | ○ |
| C-13 | マテリアル取得で正しい型が返される | E-02 (433-454行目) | ○ |
| C-14 | マテリアルがキャッシュされる | E-02 (434-436行目) | ○ |
| C-15 | ポイントサイズが設定される | E-02 (786-791行目) | ○ |
| C-16 | ポイントサイズが0.1以上にクランプされる | E-02 (787行目) MAX(0.1, p_point_size) | ○ |

### NavigationPathQueryParameters3D クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | set_pathfinding_algorithmで設定される | E-04 (35-37行目) | ○ |
| C-18 | get_pathfinding_algorithmで取得される | E-04 (39-41行目) | ○ |
| C-19 | set_path_postprocessingで設定される | E-04 (43-45行目) | ○ |
| C-20 | PathPostProcessing列挙値CORRIDORFUNNEL | E-03 (48行目), E-07 (40行目) | ○ |
| C-21 | PathPostProcessing列挙値EDGECENTERED | E-03 (49行目), E-07 (41行目) | ○ |
| C-22 | PathPostProcessing列挙値NONE | E-03 (50行目), E-07 (42行目) | ○ |
| C-23 | set_mapでRID設定される | E-04 (51-53行目) | ○ |
| C-24 | get_mapでRID取得される | E-04 (55-57行目) | ○ |
| C-25 | set_start_positionで開始位置設定される | E-04 (59-61行目) | ○ |
| C-26 | set_target_positionで目標位置設定される | E-04 (67-69行目) | ○ |
| C-27 | set_navigation_layersでレイヤー設定される | E-04 (75-77行目) | ○ |
| C-28 | navigation_layersのデフォルト値は1 | E-03 (67行目) | ○ |
| C-29 | navigation_layersは32ビット全てが有効 | E-03 (67行目) uint32_t型 | ○ |
| C-30 | set_metadata_flagsでフラグ設定される | E-04 (83-85行目) | ○ |
| C-31 | PATH_METADATA_INCLUDE_NONE=0 | E-07 (51行目) | ○ |
| C-32 | set_simplify_pathで有効化される | E-04 (91-93行目) | ○ |
| C-33 | set_simplify_epsilonで設定される | E-04 (99-101行目) | ○ |
| C-34 | simplify_epsilonは0以上にクランプされる | E-04 (100行目) MAX(0.0, p_epsilon) | ○ |
| C-35 | set_included_regionsで配列設定される | E-04 (107-112行目) | ○ |
| C-36 | 空配列も正常に処理される | E-04 (108行目) resize(p_regions.size()) | ○ |
| C-37 | set_excluded_regionsで配列設定される | E-04 (123-128行目) | ○ |
| C-38 | set_path_return_max_lengthで設定される | E-04 (139-141行目) | ○ |
| C-39 | path_return_max_lengthは0以上にクランプされる | E-04 (140行目) MAX(0.0, p_length) | ○ |
| C-40 | set_path_return_max_radiusで設定される | E-04 (147-149行目) | ○ |
| C-41 | path_return_max_radiusは0以上にクランプされる | E-04 (148行目) MAX(0.0, p_radius) | ○ |
| C-42 | set_path_search_max_polygonsで設定される | E-04 (155-157行目) | ○ |
| C-43 | set_path_search_max_distanceで設定される | E-04 (163-165行目) | ○ |
| C-44 | path_search_max_distanceは0以上にクランプされる | E-04 (164行目) MAX(0.0, p_distance) | ○ |

### NavigationPathQueryResult3D クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | set_pathでパス設定される | E-06 (33-35行目) | ○ |
| C-46 | get_pathでパス取得される | E-06 (37-39行目) | ○ |
| C-47 | set_path_typesでタイプ設定される | E-06 (41-43行目) | ○ |
| C-48 | set_path_ridsでRIDs設定される | E-06 (49-51行目) | ○ |
| C-49 | set_path_owner_idsでオーナーIDs設定される | E-06 (57-59行目) | ○ |
| C-50 | set_path_lengthで長さ設定される | E-06 (113-115行目) | ○ |
| C-51 | resetで全配列がクリアされる | E-06 (65-70行目) | ○ |
| C-52 | set_dataで一括設定される | E-06 (72-111行目) | ○ |
| C-53 | set_dataで空データも正常処理される | E-06 (73-76行目) clear()呼び出し | ○ |

### NavigationServer3DManager クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | get_singletonでインスタンス取得される | E-02 (1082-1084行目) | ○ |
| C-55 | register_serverでサーバー登録される | E-02 (1086-1090行目) | ○ |
| C-56 | 重複登録でERR_FAIL_COND発生 | E-02 (1087行目) | ○ |
| C-57 | set_default_serverでデフォルト設定される | E-02 (1092-1099行目) | ○ |
| C-58 | 優先度が高い場合のみ上書きされる | E-02 (1095-1098行目) | ○ |
| C-59 | 優先度が低い場合は上書きされない | E-02 (1095行目) if条件 | ○ |
| C-60 | find_server_idで登録済みサーバーID取得 | E-02 (1101-1108行目) | ○ |
| C-61 | 未登録サーバーで-1が返される | E-02 (1107行目) | ○ |
| C-62 | get_servers_countでサーバー数取得 | E-02 (1110-1112行目) | ○ |
| C-63 | get_server_nameでサーバー名取得 | E-02 (1114-1117行目) | ○ |
| C-64 | 無効なIDで空文字が返される | E-02 (1115行目) ERR_FAIL_INDEX_V | ○ |
| C-65 | new_default_serverでサーバー作成 | E-02 (1119-1128行目) | ○ |
| C-66 | デフォルト未設定でnullptr返却 | E-02 (1120-1122行目) | ○ |
| C-67 | new_serverで名前指定作成 | E-02 (1130-1141行目) | ○ |
| C-68 | 未登録名でnullptr返却 | E-02 (1132-1133行目) | ○ |
| C-69 | create_dummy_server_callbackでダミー作成 | E-02 (1143-1145行目) | ○ |
| C-70 | initialize_serverで初期化される | E-02 (1036-1056行目) | ○ |
| C-71 | 二重初期化でERR_FAIL_COND発生 | E-02 (1037行目) | ○ |
| C-72 | finalize_serverで終了処理される | E-02 (1058-1063行目) | ○ |
| C-73 | 未初期化でERR_FAIL_NULL発生 | E-02 (1059行目) | ○ |

### NavigationServer3DDummy クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | map_createで空RID返却 | E-08 (40行目) | ○ |
| C-75 | map_is_activeで常にfalse返却 | E-08 (42行目) | ○ |
| C-76 | map_get_pathで空Vector返却 | E-08 (57行目) | ○ |
| C-77 | query_pathで何も処理されない | E-08 (187行目) | ○ |
| C-78 | simplify_pathで空Vector返却 | E-08 (200行目) | ○ |
| C-79 | get_process_infoで常に0返却 | E-08 (210行目) | ○ |

### NavigationDefaults3D 定数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | NAV_MESH_CELL_SIZE = 0.25f | E-07 (67行目) | ○ |
| C-81 | NAV_MESH_CELL_HEIGHT = 0.25f | E-07 (66行目) | ○ |
| C-82 | EDGE_CONNECTION_MARGIN = 0.25f | E-07 (73行目) | ○ |
| C-83 | LINK_CONNECTION_RADIUS = 1.0f | E-07 (74行目) | ○ |
| C-84 | path_search_max_polygons = 4096 | E-07 (75行目) | ○ |

### NavigationEnums3D 列挙型

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | PATHFINDING_ALGORITHM_ASTAR = 0 | E-07 (36行目) | ○ |
| C-86 | PATH_POSTPROCESSING_CORRIDORFUNNEL = 0 | E-07 (40行目) | ○ |
| C-87 | PATH_POSTPROCESSING_EDGECENTERED = 1 | E-07 (41行目) | ○ |
| C-88 | PATH_POSTPROCESSING_NONE = 2 | E-07 (42行目) | ○ |
| C-89 | PATH_SEGMENT_TYPE_REGION = 0 | E-07 (46行目) | ○ |
| C-90 | PATH_SEGMENT_TYPE_LINK = 1 | E-07 (47行目) | ○ |
| C-91 | PATH_INCLUDE_NONE = 0 | E-07 (51行目) | ○ |
| C-92 | PATH_INCLUDE_TYPES = 1 | E-07 (52行目) | ○ |
| C-93 | PATH_INCLUDE_RIDS = 2 | E-07 (53行目) | ○ |
| C-94 | PATH_INCLUDE_OWNERS = 4 | E-07 (54行目) | ○ |
| C-95 | PATH_INCLUDE_ALL = 7 | E-07 (55行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードの実装に基づいており、根拠が確認されています。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全てのテストケースはソースコードの実装詳細に基づいており、根拠が明確です。
- **注意点**:
  - NavigationServer3Dは抽象クラスであり、仮想メソッドの実装はサブクラス（modules/navigation_3d等）で行われます
  - DEBUG_ENABLED条件付きのコードはデバッグビルドでのみテスト可能です
  - NavigationServer3DDummyはフォールバック用途であり、実際の機能テストには適していません

## 6) レビュアーチェックリスト（最小）
- [ ] NavigationPathQueryParameters3Dの各setter/getterが正しく対応しているか確認
- [ ] NavigationPathQueryResult3Dのset_dataメソッドが全てのデータを正しくコピーしているか確認
- [ ] NavigationServer3DManagerの優先度制御ロジックが期待通りか確認
- [ ] DEBUG_ENABLED条件付きメソッドのテスト前提条件が明確か確認
- [ ] 境界値テスト（MAX()によるクランプ処理）のテストケースが網羅されているか確認
- [ ] ダミーサーバーのテストケースは主に動作確認用であり、機能テストではないことを認識
