---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 105
  claims_with_evidence: 102
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：servers-physics_2d 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：102 / 105、根拠なし：3
- 優先レビュー（高）
  1. **C-101〜C-103: MotionResult::get_angle**：実装の詳細が限定的
  2. **C-104〜C-105: MotionParameters::constructor**：構造体のコンストラクタ動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/physics_2d/physics_server_2d.h` - 全クラス定義とメソッド宣言
- E-02: `servers/physics_2d/physics_server_2d.cpp` - 実装コード（integrate_forces, クエリメソッド等）
- E-03: `servers/physics_2d/physics_server_2d_extension.h` - 拡張クラス定義
- E-04: `servers/physics_2d/physics_server_2d_extension.cpp` - 拡張クラス実装（is_body_excluded_from_query等）
- E-05: `servers/physics_2d/physics_server_2d_wrap_mt.h` - マルチスレッドラッパー定義
- E-06: `servers/physics_2d/physics_server_2d_wrap_mt.cpp` - マルチスレッドラッパー実装
- E-07: `servers/physics_2d/physics_server_2d_dummy.h` - ダミー実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | integrate_forcesで重力と減衰を適用した速度統合が行われる | E-02: L38-63 | ○ |
| C-02 | step=0の場合に速度が変化しない | E-02: L39-62 | ○ |
| C-03 | 線形減衰が負になる場合に0でクランプされる | E-02: L47-49 | ○ |
| C-04 | 角速度減衰が負になる場合に0でクランプされる | E-02: L55-57 | ○ |
| C-05 | get_contact_collider_objectで有効なObjectIDからオブジェクトが取得できる | E-02: L65-69 | ○ |
| C-06 | 無効なObjectIDの場合にnullが返却される | E-02: L65-69, ObjectDB::get_instanceの仕様 | ○ |
| C-07 | get_singletonでシングルトンインスタンスが取得できる | E-02: L71-73 | ○ |
| C-08 | PhysicsRayQueryParameters2D::createでパラメータを指定してインスタンスが作成される | E-02: L160-168 | ○ |
| C-09 | 除外リストが正しく設定される（create） | E-02: L166 | ○ |
| C-10 | set_excludeで除外リストがクリアされて再設定される | E-02: L170-175 | ○ |
| C-11 | get_excludeでTypedArrayが取得できる | E-02: L177-185 | ○ |
| C-12 | PhysicsPointQueryParameters2D::set_excludeで除外リストが設定される | E-02: L222-227 | ○ |
| C-13 | PhysicsPointQueryParameters2D::get_excludeでTypedArrayが取得できる | E-02: L229-237 | ○ |
| C-14 | set_shapeでResourceからshape_ridが設定される | E-02: L268-272 | ○ |
| C-15 | nullのResourceが渡された場合にエラーになる | E-02: L269 ERR_FAIL_COND | ○ |
| C-16 | set_shape_ridで異なるRIDが設定された場合にshape_refがクリアされる | E-02: L274-279 | ○ |
| C-17 | 同じRIDが設定された場合に変更されない | E-02: L275 if条件 | ○ |
| C-18 | _intersect_rayでヒットした場合に結果が返却される | E-02: L339-358 | ○ |
| C-19 | _intersect_rayでヒットしなかった場合に空のDictionaryが返却される | E-02: L345-347 | ○ |
| C-20 | _intersect_pointで複数の結果が返却される | E-02: L360-383 | ○ |
| C-21 | _intersect_pointで結果が0件の場合に空配列が返却される | E-02: L368-370 | ○ |
| C-22 | _intersect_shapeで結果が返却される | E-02: L385-403 | ○ |
| C-23 | _cast_motionで安全/非安全距離が返却される | E-02: L405-418 | ○ |
| C-24 | _cast_motionで衝突がない場合に空配列が返却される | E-02: L410-412 | ○ |
| C-25 | _collide_shapeで接触点が返却される | E-02: L420-436 | ○ |
| C-26 | _collide_shapeで衝突がない場合に空配列が返却される | E-02: L427-429 | ○ |
| C-27 | _get_rest_infoで静止情報が取得できる | E-02: L438-457 | ○ |
| C-28 | _get_rest_infoで衝突がない場合に空のDictionaryが返却される | E-02: L445-447 | ○ |
| C-29 | get_exclude_bodiesでTypedArrayが取得できる | E-02: L473-483 | ○ |
| C-30 | set_exclude_bodiesで除外ボディリストが設定される | E-02: L485-490 | ○ |
| C-31 | get_exclude_objectsでTypedArrayが取得できる | E-02: L492-502 | ○ |
| C-32 | set_exclude_objectsで除外オブジェクトリストが設定される | E-02: L504-511 | ○ |
| C-33 | nullのObjectIDが含まれる場合にスキップされる | E-02: L508 ERR_CONTINUE | ○ |
| C-34 | get_travelで移動ベクトルが取得できる | E-02: L546-548 | ○ |
| C-35 | get_remainderで残余ベクトルが取得できる | E-02: L550-552 | ○ |
| C-36 | get_collision_pointで衝突点が取得できる | E-02: L554-556 | ○ |
| C-37 | get_collision_normalで衝突法線が取得できる | E-02: L558-560 | ○ |
| C-38 | get_colliderで衝突したオブジェクトが取得できる | E-02: L574-576 | ○ |
| C-39 | 無効なcollider_idの場合にnullが返却される | E-02: L574-576, ObjectDB仕様 | ○ |
| C-40 | get_collision_safe_fractionで安全衝突割合が取得できる | E-02: L590-592 | ○ |
| C-41 | get_collision_unsafe_fractionで非安全衝突割合が取得できる | E-02: L594-596 | ○ |
| C-42 | _body_test_motionで衝突が検出される | E-02: L616-625 | ○ |
| C-43 | _body_test_motionで衝突がない場合にfalseが返却される | E-02: L616-625 | ○ |
| C-44 | 結果パラメータがnullの場合でも正常動作する | E-02: L619-622 | ○ |
| C-45 | PhysicsServer2DManager::get_singletonでシングルトンが取得できる | E-02: L944-946 | ○ |
| C-46 | register_serverで新しいサーバーが登録できる | E-02: L948-953 | ○ |
| C-47 | 同名のサーバーが既に存在する場合にエラーになる | E-02: L950 ERR_FAIL_COND | ○ |
| C-48 | set_default_serverでデフォルトサーバーが設定される | E-02: L955-962 | ○ |
| C-49 | 優先度が高い場合のみデフォルトが更新される | E-02: L958-961 | ○ |
| C-50 | 優先度が低い場合はデフォルトが更新されない | E-02: L958条件 | ○ |
| C-51 | 存在しないサーバー名の場合にエラーになる | E-02: L957 ERR_FAIL_COND | ○ |
| C-52 | find_server_idで登録済みサーバーのIDが取得できる | E-02: L964-971 | ○ |
| C-53 | 未登録のサーバー名の場合に-1が返却される | E-02: L970 | ○ |
| C-54 | get_servers_countで登録サーバー数が取得できる | E-02: L973-975 | ○ |
| C-55 | get_server_nameでIDからサーバー名が取得できる | E-02: L977-980 | ○ |
| C-56 | 無効なIDの場合に空文字が返却される | E-02: L978 ERR_FAIL_INDEX_V | ○ |
| C-57 | new_default_serverでデフォルトサーバーのインスタンスが作成される | E-02: L982-991 | ○ |
| C-58 | デフォルトサーバーが未設定の場合にnullが返却される | E-02: L983-985 | ○ |
| C-59 | new_serverで指定名のサーバーインスタンスが作成される | E-02: L993-1004 | ○ |
| C-60 | 存在しないサーバー名の場合にnullが返却される | E-02: L995-996 | ○ |
| C-61 | on_servers_changedでProjectSettingsが更新される | E-02: L929-937 | ○ |
| C-62 | is_body_excluded_from_queryで除外リストに含まれるボディがtrueを返す | E-04: L33-35 | ○ |
| C-63 | is_body_excluded_from_queryで除外リストに含まれないボディがfalseを返す | E-04: L33-35 | ○ |
| C-64 | excludeがnullの場合にfalseを返す | E-04: L34 exclude && 条件 | ○ |
| C-65 | intersect_rayでGDVIRTUALコールバックが呼び出される | E-03: L142-148 | ○ |
| C-66 | intersect_pointでGDVIRTUALコールバックが呼び出される | E-03: L149-155 | ○ |
| C-67 | intersect_shapeでGDVIRTUALコールバックが呼び出される | E-03: L156-162 | ○ |
| C-68 | cast_motionでGDVIRTUALコールバックが呼び出される | E-03: L163-169 | ○ |
| C-69 | collide_shapeでGDVIRTUALコールバックが呼び出される | E-03: L170-176 | ○ |
| C-70 | rest_infoでGDVIRTUALコールバックが呼び出される | E-03: L177-183 | ○ |
| C-71 | body_test_motion_is_excluding_bodyで除外ボディリストに含まれる場合にtrueを返す | E-04: L127-129 | ○ |
| C-72 | body_test_motion_is_excluding_bodyで除外ボディリストに含まれない場合にfalseを返す | E-04: L127-129 | ○ |
| C-73 | exclude_bodiesがnullの場合にfalseを返す | E-04: L128 exclude_bodies && 条件 | ○ |
| C-74 | body_test_motion_is_excluding_objectで除外オブジェクトリストに含まれる場合にtrueを返す | E-04: L131-133 | ○ |
| C-75 | body_test_motion_is_excluding_objectで除外オブジェクトリストに含まれない場合にfalseを返す | E-04: L131-133 | ○ |
| C-76 | exclude_objectsがnullの場合にfalseを返す | E-04: L132 exclude_objects && 条件 | ○ |
| C-77 | shape_collideでGDVIRTUALコールバックが呼び出される | E-03: L223-227 | ○ |
| C-78 | body_collide_shapeでGDVIRTUALコールバックが呼び出される | E-03: L383-387 | ○ |
| C-79 | body_get_collision_exceptionsでTypedArrayがListに変換される | E-03: L363-369 | ○ |
| C-80 | body_test_motionでGDVIRTUALコールバックが呼び出される | E-03: L401-409 | ○ |
| C-81 | free_ridでGDVIRTUALコールバックが呼び出される | E-03: L440-442 | ○ |
| C-82 | shape_collideでメインスレッドから呼び出された場合に正常動作する | E-05: L100-103 | ○ |
| C-83 | shape_collideでメインスレッド以外から呼び出された場合にエラーになる | E-05: L101 ERR_FAIL_COND_V | ○ |
| C-84 | space_get_direct_stateでメインスレッドから呼び出された場合に状態が取得できる | E-05: L115-118 | ○ |
| C-85 | space_get_direct_stateでメインスレッド以外から呼び出された場合にnullが返却される | E-05: L116 ERR_FAIL_COND_V | ○ |
| C-86 | body_test_motionでメインスレッドから呼び出された場合に正常動作する | E-05: L267-270 | ○ |
| C-87 | body_test_motionでメインスレッド以外から呼び出された場合にfalseが返却される | E-05: L268 ERR_FAIL_COND_V | ○ |
| C-88 | body_get_direct_stateでメインスレッドから呼び出された場合にボディ状態が取得できる | E-05: L273-276 | ○ |
| C-89 | body_get_direct_stateでメインスレッド以外から呼び出された場合にnullが返却される | E-05: L274 ERR_FAIL_COND_V | ○ |
| C-90 | initでスレッド作成モードで正しく初期化される | E-06: L87-98 | ○ |
| C-91 | initで非スレッドモードで正しく初期化される | E-06: L94-97 | ○ |
| C-92 | stepでスレッドモードでコマンドがキューに追加される | E-06: L58-64 | ○ |
| C-93 | stepで非スレッドモードで直接stepが呼び出される | E-06: L61-63 | ○ |
| C-94 | syncでスレッド同期が正しく行われる | E-06: L66-73 | ○ |
| C-95 | syncで非スレッドモードでコマンドがフラッシュされる | E-06: L69-70 | ○ |
| C-96 | end_syncで同期終了時にdoing_syncがクリアされる | E-06: L79-85 | ○ |
| C-97 | finishでスレッドモードでスレッドが終了される | E-06: L100-112 | ○ |
| C-98 | finishで非スレッドモードでfinishが直接呼び出される | E-06: L109-111 | ○ |
| C-99 | PhysicsServer2DDummy::initでダミー状態が作成される | E-07: L337-340 | ○ |
| C-100 | PhysicsServer2DDummy::finishでダミー状態が解放される | E-07: L345-348 | ○ |
| C-101 | MotionResult::get_angleで上方向ベクトルとの衝突角度が計算される | E-01: L526-528 | ○ |
| C-102 | 衝突法線が上方向と一致する場合に0が返却される | E-01: L526-528 数学的推論 | △ |
| C-103 | 衝突法線が上方向と反対の場合にPIが返却される | E-01: L526-528 数学的推論 | △ |
| C-104 | MotionParametersのデフォルトコンストラクタでデフォルト値が設定される | E-01: L494-509 構造体定義 | △ |
| C-105 | MotionParametersのパラメータ付きコンストラクタで値が正しく設定される | E-01: L505-508 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-102, C-103**: get_angleメソッドの境界値テストは数学的推論に基づく。実際の動作確認が必要
  - 候補：実際のテスト実行 / デバッグ出力 / 単体テストの既存コード
- **C-104**: MotionParametersのデフォルトコンストラクタは暗黙的で、明示的なコードが限定的
  - 候補：メンバ初期化リストの確認 / クラス使用箇所の調査

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: シンプルなgetter/setterテスト (C-11, C-13, C-29, C-31, C-34-41, C-52-56)
- **1: 中リスク**: 条件分岐を含むロジック (C-03, C-04, C-16, C-17, C-33, C-49-50, C-62-64, C-71-76)
- **2: 高リスク**: 物理シミュレーションの核心ロジック、スレッドセーフティ (C-01, C-82-98)

## 6) レビュアーチェックリスト（最小）
- [ ] integrate_forcesの減衰計算ロジックが正しいか確認（C-01〜C-04）
- [ ] スレッドセーフティのテストがメインスレッド/非メインスレッド両方をカバーしているか（C-82〜C-89）
- [ ] GDVIRTUALコールバックのテストがモック/スタブを適切に使用しているか（C-65〜C-81）
- [ ] MotionResult::get_angleの数学的正確性を確認（C-101〜C-103）
- [ ] PhysicsServer2DManagerの優先度ロジックが正しくテストされているか（C-48〜C-51）
- [ ] ダミー実装のメモリ管理（init/finish）が正しいか（C-99〜C-100）
