---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 90
  claims_with_evidence: 85
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート: servers-physics_3d.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコードの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.94**
  - 根拠あり: 85 / 90、根拠なし: 5
- 優先レビュー（高）
  1. **UT-P3D-074, 075**: PhysicsServer3DWrapMTの初期化処理（マクロベース実装のため詳細確認要）
  2. **UT-P3D-087, 088**: _thread_loopの内部動作（スレッド同期タイミング）
  3. **UT-P3D-058-063**: PhysicsServer3DManagerのサーバ登録処理（コールバック動作）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `servers/physics_3d/physics_server_3d.h` - PhysicsDirectBodyState3D、PhysicsDirectSpaceState3D、PhysicsServer3Dクラス定義
- E-02: `servers/physics_3d/physics_server_3d.cpp` - メソッド実装、integrate_forces、クエリメソッド
- E-03: `servers/physics_3d/physics_server_3d_extension.h` - Extension系クラス定義
- E-04: `servers/physics_3d/physics_server_3d_extension.cpp` - Extensionメソッドバインディング、除外チェック実装
- E-05: `servers/physics_3d/physics_server_3d_dummy.h` - Dummy実装クラス
- E-06: `servers/physics_3d/physics_server_3d_wrap_mt.h` - マルチスレッドラッパークラス定義
- E-07: `servers/physics_3d/physics_server_3d_wrap_mt.cpp` - マルチスレッド処理実装

## 3) Claims と根拠の対応（レビューの主戦場）

### PhysicsDirectBodyState3D関連（UT-P3D-001〜006）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | integrate_forcesで重力が線形速度に適用される | E-02 (58-82行目) | ○ |
| C-02 | integrate_forcesで線形ダンピングが適用される | E-02 (65-77行目) | ○ |
| C-03 | integrate_forcesで角速度ダンピングが適用される | E-02 (71-78行目) | ○ |
| C-04 | ダンピングが0未満にならないようクランプされる | E-02 (67-74行目) | ○ |
| C-05 | get_contact_collider_objectがObjectDB経由でオブジェクト取得 | E-02 (84-88行目) | ○ |
| C-06 | 無効なコンタクトインデックスでnullptr返却 | E-01 (109行目: virtualメソッド定義) | ○ |

### PhysicsDirectSpaceState3D関連（UT-P3D-007〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | _intersect_rayがDictionaryを返却 | E-02 (363-383行目) | ○ |
| C-08 | レイキャストミス時に空Dictionary | E-02 (369-371行目) | ○ |
| C-09 | _intersect_pointがTypedArrayを返却 | E-02 (385-408行目) | ○ |
| C-10 | 結果0件で空TypedArray | E-02 (393-395行目) | ○ |
| C-11 | _intersect_shapeがTypedArrayを返却 | E-02 (410-428行目) | ○ |
| C-12 | _cast_motionがVector<real_t>を返却 | E-02 (430-443行目) | ○ |
| C-13 | モーションキャスト失敗時に空Vector | E-02 (435-436行目) | ○ |
| C-14 | _collide_shapeがTypedArrayを返却 | E-02 (445-461行目) | ○ |
| C-15 | _get_rest_infoがDictionaryを返却 | E-02 (463-482行目) | ○ |

### PhysicsRayQueryParameters3D関連（UT-P3D-016〜023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | createファクトリメソッドでパラメータ生成 | E-02 (240-248行目) | ○ |
| C-17 | set_excludeでHashSetにRID挿入 | E-02 (184-189行目) | ○ |
| C-18 | get_excludeでTypedArray返却 | E-02 (191-199行目) | ○ |
| C-19 | set_collision_maskでマスク設定 | E-01 (853行目) | ○ |
| C-20〜23 | 各種フラグ設定 | E-01 (856-866行目) | ○ |

### PhysicsPointQueryParameters3D/PhysicsShapeQueryParameters3D関連（UT-P3D-024〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | set_excludeでHashSetにRID挿入 | E-02 (250-255行目) | ○ |
| C-25 | get_excludeでTypedArray返却 | E-02 (257-265行目) | ○ |
| C-26 | set_shapeでshape_refとshape_rid設定 | E-02 (292-296行目) | ○ |
| C-27 | nullシェイプでERR_FAIL_COND | E-02 (293行目) | ○ |
| C-28 | set_shape_ridでRID直接設定 | E-02 (298-303行目) | ○ |
| C-29 | 同じRID設定時の動作 | E-02 (299行目) | ○ |
| C-30 | set_marginでマージン設定 | E-01 (924行目) | ○ |

### PhysicsTestMotionParameters3D関連（UT-P3D-031〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | set_exclude_bodiesでHashSetに挿入 | E-02 (510-515行目) | ○ |
| C-32 | get_exclude_bodiesでTypedArray返却 | E-02 (498-508行目) | ○ |
| C-33 | set_exclude_objectsでHashSetに挿入 | E-02 (529-536行目) | ○ |
| C-34 | null ObjectIDがスキップ | E-02 (533行目: ERR_CONTINUE) | ○ |

### PhysicsTestMotionResult3D関連（UT-P3D-035〜045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | get_travelでresult.travel返却 | E-02 (575-577行目) | ○ |
| C-36 | get_remainderでresult.remainder返却 | E-02 (579-581行目) | ○ |
| C-37 | get_collision_countでresult.collision_count返却 | E-02 (591-593行目) | ○ |
| C-38 | get_collision_pointで衝突位置返却 | E-02 (595-598行目) | ○ |
| C-39 | 無効インデックスでERR_FAIL_INDEX_V | E-02 (596行目) | ○ |
| C-40〜45 | 各種衝突情報取得メソッド | E-02 (600-638行目) | ○ |

### PhysicsServer3D関連（UT-P3D-046〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | get_singletonでsingletonを返却 | E-02 (90-92行目) | ○ |
| C-47〜51 | shape_createでShapeTypeに応じたシェイプ作成 | E-02 (670-695行目) | ○ |
| C-52 | _body_test_motionの実行 | E-02 (659-668行目) | ○ |
| C-53 | 結果オブジェクトへの格納 | E-02 (662-665行目) | ○ |

### PhysicsServer3DRenderingServerHandler関連（UT-P3D-054〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | set_vertexでGDVIRTUAL_CALL | E-02 (36-38行目) | ○ |
| C-55 | set_normalでGDVIRTUAL_CALL | E-02 (39-41行目) | ○ |
| C-56 | set_aabbでGDVIRTUAL_CALL | E-02 (42-44行目) | ○ |

### PhysicsServer3DManager関連（UT-P3D-057〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | get_singletonでsingletonを返却 | E-01 (1042行目) | ○ |
| C-58 | register_serverでサーバ登録 | E-01 (1044行目) | △ |
| C-59 | set_default_serverでデフォルト設定 | E-01 (1045行目) | △ |
| C-60 | find_server_idでID検索 | E-01 (1046行目) | ○ |
| C-61 | 存在しないサーバで-1返却 | E-01 (1046行目: 実装推測) | △ |
| C-62 | new_default_serverでインスタンス生成 | E-01 (1049行目) | ○ |
| C-63 | new_serverで名前指定生成 | E-01 (1050行目) | ○ |

### Extension系クラス関連（UT-P3D-064〜068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | is_body_excluded_from_queryでtrue返却 | E-04 (33-35行目) | ○ |
| C-65 | 含まれない場合にfalse返却 | E-04 (33-35行目) | ○ |
| C-66 | excludeがnullでfalse返却 | E-04 (34行目: exclude && ...) | ○ |
| C-67 | body_test_motion_is_excluding_body | E-04 (129-131行目) | ○ |
| C-68 | body_test_motion_is_excluding_object | E-04 (133-135行目) | ○ |

### Dummy実装関連（UT-P3D-069〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | get_total_gravityでVector3()返却 | E-05 (41行目) | ○ |
| C-70 | get_space_stateでspace_state_dummy返却 | E-05 (108行目) | ○ |
| C-71 | intersect_rayでfalse返却 | E-05 (119行目) | ○ |
| C-72 | initでダミーオブジェクト生成 | E-05 (431-434行目) | ○ |
| C-73 | finishでメモリ解放 | E-05 (439-442行目) | ○ |

### WrapMT関連（UT-P3D-074〜090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | initでワーカースレッド起動 | E-07 (87-98行目) | ○ |
| C-75 | 非スレッドモードでMAIN_ID設定 | E-07 (95-96行目) | ○ |
| C-76 | stepでコマンドキュープッシュ | E-07 (58-64行目) | ○ |
| C-77 | 非スレッドモードで直接step呼び出し | E-07 (62行目) | ○ |
| C-78 | syncで同期実行 | E-07 (66-73行目) | ○ |
| C-79 | flush_queriesの呼び出し | E-07 (75-77行目) | ○ |
| C-80 | end_syncでdoing_syncクリア | E-07 (79-85行目) | ○ |
| C-81 | finishでスレッド終了 | E-07 (100-112行目) | ○ |
| C-82 | space_get_direct_stateのメインスレッドチェック | E-06 (122-125行目) | ○ |
| C-83 | 非メインスレッドでnullptr返却 | E-06 (123行目: ERR_FAIL_COND_V) | ○ |
| C-84 | body_test_motionのメインスレッドチェック | E-06 (274-277行目) | ○ |
| C-85 | 非メインスレッドでfalse返却 | E-06 (275行目: ERR_FAIL_COND_V) | ○ |
| C-86 | body_get_direct_stateのメインスレッドチェック | E-06 (280-283行目) | ○ |
| C-87 | _thread_loopのexit判定 | E-07 (42-50行目) | ○ |
| C-88 | 同期中のフラッシュ抑制 | E-07 (46-48行目) | ○ |
| C-89 | MotionCollision::get_angleの角度計算 | E-01 (556-558行目) | ○ |
| C-90 | 斜め法線での角度計算 | E-01 (556-558行目: Math::acos使用) | △ |

## 4) 不足情報（Unknown / Missing）
- **PhysicsServer3DManagerの実装詳細**: ヘッダファイルにメソッド宣言はあるが、実装の詳細（cpp）が未確認
  - 候補: modules/godot_physics_3d または modules/jolt_physics での実装確認
- **マクロ展開後の実装**: `FUNC*`マクロの展開結果（server_wrap_mt_common.h）
  - 候補: servers/server_wrap_mt_common.h の確認
- **実際の物理エンジン実装**: このモジュールは抽象インターフェースのため、具体的な物理計算はモジュール実装に依存
  - 候補: modules/godot_physics_3d, modules/jolt_physics

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: Dummy実装関連テストケース（UT-P3D-069〜073）
- **1: 中リスク**: パラメータクラスのgetter/setter（UT-P3D-016〜034）- 実装がシンプルで問題発生可能性低
- **1: 中リスク**: Extension系のis_body_excluded_from_query（スレッドローカル変数使用）
- **2: 高リスク**: マルチスレッド関連（UT-P3D-074〜088）- スレッド同期の正確性要確認
- **2: 高リスク**: integrate_forces（UT-P3D-001〜004）- 物理シミュレーションの正確性に直結

## 6) レビュアーチェックリスト（最小）
- [ ] integrate_forcesの重力・ダンピング計算ロジックが物理的に正しいか
- [ ] PhysicsServer3DWrapMTのスレッド同期処理（doing_sync）が競合状態を起こさないか
- [ ] ERR_FAIL_INDEX_Vマクロによる境界チェックが全ての配列アクセスで適用されているか
- [ ] マルチスレッドラッパーのメインスレッドチェック（ERR_FAIL_COND_V）が適切に機能するか
- [ ] PhysicsServer3DManagerのコールバック呼び出しが正しく動作するか
- [ ] thread_local変数（exclude, exclude_bodies, exclude_objects）のライフタイムが適切か
