---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：servers-rendering 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードにおける対象クラス・メソッドの存在確認
2. **根拠との整合性**：テストケースの入力値・期待結果がメソッドシグネチャと一致するか
3. **網羅性**：主要なクラスとメソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-RND-088**: RenderingLightCuller::prepare_camera の戻り値型確認が必要
  2. **UT-RND-093**: _is_colinear_tri の詳細な閾値確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/rendering/rendering_device.h` - RenderingDevice クラス定義
- E-02: `servers/rendering/rendering_server.h` - RenderingServer クラス定義
- E-03: `servers/rendering/renderer_viewport.h` - RendererViewport クラス定義
- E-04: `servers/rendering/renderer_scene_cull.h` - RendererSceneCull クラス定義
- E-05: `servers/rendering/renderer_canvas_cull.h` - RendererCanvasCull クラス定義
- E-06: `servers/rendering/shader_language.h` - ShaderLanguage クラス定義
- E-07: `servers/rendering/shader_compiler.h` - ShaderCompiler クラス定義
- E-08: `servers/rendering/rendering_light_culler.h` - RenderingLightCuller クラス定義
- E-09: `servers/rendering/storage/texture_storage.h` - RendererTextureStorage クラス定義
- E-10: `servers/rendering/storage/mesh_storage.h` - RendererMeshStorage クラス定義
- E-11: `servers/rendering/storage/light_storage.h` - RendererLightStorage クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）

### RenderingDevice 関連 (UT-RND-001 - UT-RND-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | texture_create メソッドが存在する | E-01 (L446) | ○ |
| C-02 | texture_create_shared メソッドが存在する | E-01 (L447) | ○ |
| C-03 | texture_update メソッドが存在する | E-01 (L450) | ○ |
| C-04 | texture_get_data メソッドが存在する | E-01 (L451) | ○ |
| C-05 | texture_copy メソッドが存在する | E-01 (L463) | ○ |
| C-06 | texture_clear メソッドが存在する | E-01 (L464) | ○ |
| C-07 | texture_is_valid メソッドが存在する | E-01 (L456) | ○ |
| C-08 | buffer_copy メソッドが存在する | E-01 (L210) | ○ |
| C-09 | buffer_update メソッドが存在する | E-01 (L253) | ○ |
| C-10 | buffer_clear メソッドが存在する | E-01 (L254) | ○ |
| C-11 | buffer_get_data メソッドが存在する | E-01 (L255) | ○ |

### RenderingServer 関連 (UT-RND-016 - UT-RND-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | texture_2d_create が純粋仮想関数として定義 | E-02 (L136) | ○ |
| C-13 | texture_3d_create が純粋仮想関数として定義 | E-02 (L138) | ○ |
| C-14 | texture_2d_layered_create が定義 | E-02 (L137) | ○ |
| C-15 | shader_create が純粋仮想関数として定義 | E-02 (L230) | ○ |
| C-16 | shader_set_code が純粋仮想関数として定義 | E-02 (L233) | ○ |
| C-17 | shader_get_code が純粋仮想関数として定義 | E-02 (L235) | ○ |
| C-18 | material_create が純粋仮想関数として定義 | E-02 (L262) | ○ |
| C-19 | material_set_shader が純粋仮想関数として定義 | E-02 (L265) | ○ |
| C-20 | mesh_create が純粋仮想関数として定義 | E-02 (L399) | ○ |
| C-21 | mesh_add_surface が純粋仮想関数として定義 | E-02 (L419) | ○ |
| C-22 | multimesh_create が純粋仮想関数として定義 | E-02 (L470) | ○ |
| C-23 | multimesh_allocate_data が定義 | E-02 (L487) | ○ |
| C-24 | multimesh_instance_set_transform が定義 | E-02 (L491) | ○ |

### RendererViewport 関連 (UT-RND-037 - UT-RND-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | viewport_allocate メソッドが存在する | E-03 (L216) | ○ |
| C-26 | viewport_initialize メソッドが存在する | E-03 (L217) | ○ |
| C-27 | viewport_set_size メソッドが存在する | E-03 (L223) | ○ |
| C-28 | viewport_set_active メソッドが存在する | E-03 (L228) | ○ |
| C-29 | viewport_attach_camera メソッドが存在する | E-03 (L256) | ○ |
| C-30 | viewport_set_scenario メソッドが存在する | E-03 (L257) | ○ |
| C-31 | viewport_attach_canvas メソッドが存在する | E-03 (L258) | ○ |
| C-32 | viewport_set_msaa_2d メソッドが存在する | E-03 (L274) | ○ |
| C-33 | viewport_set_msaa_3d メソッドが存在する | E-03 (L275) | ○ |
| C-34 | viewport_set_use_taa メソッドが存在する | E-03 (L277) | ○ |
| C-35 | viewport_get_texture メソッドが存在する | E-03 (L244) | ○ |
| C-36 | draw_viewports メソッドが存在する | E-03 (L308) | ○ |
| C-37 | free メソッドが存在する | E-03 (L310) | ○ |

### RendererSceneCull 関連 (UT-RND-051 - UT-RND-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | camera_allocate メソッドが存在する | E-04 (L106) | ○ |
| C-39 | camera_set_perspective メソッドが存在する | E-04 (L109) | ○ |
| C-40 | camera_set_orthogonal メソッドが存在する | E-04 (L110) | ○ |
| C-41 | camera_set_transform メソッドが存在する | E-04 (L112) | ○ |
| C-42 | camera_set_cull_mask メソッドが存在する | E-04 (L113) | ○ |
| C-43 | scenario_allocate メソッドが存在する | E-04 (L371) | ○ |
| C-44 | scenario_set_environment メソッドが存在する | E-04 (L374) | ○ |
| C-45 | InstanceBounds::in_frustum メソッドが存在する | E-04 (L210) | ○ |
| C-46 | InstanceBounds::in_aabb メソッドが存在する | E-04 (L227) | ○ |

### RendererCanvasCull 関連 (UT-RND-063 - UT-RND-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | canvas_allocate メソッドが存在する | E-05 (L226) | ○ |
| C-48 | canvas_item_allocate メソッドが存在する | E-05 (L235) | ○ |
| C-49 | canvas_item_set_parent メソッドが存在する | E-05 (L238) | ○ |
| C-50 | canvas_item_set_visible メソッドが存在する | E-05 (L240) | ○ |
| C-51 | canvas_item_set_transform メソッドが存在する | E-05 (L246) | ○ |
| C-52 | canvas_item_set_modulate メソッドが存在する | E-05 (L250) | ○ |
| C-53 | canvas_item_add_line メソッドが存在する | E-05 (L258) | ○ |
| C-54 | canvas_item_add_rect メソッドが存在する | E-05 (L261) | ○ |
| C-55 | canvas_item_add_texture_rect メソッドが存在する | E-05 (L264) | ○ |
| C-56 | canvas_item_set_z_index メソッドが存在する | E-05 (L280) | ○ |
| C-57 | canvas_item_clear メソッドが存在する | E-05 (L285) | ○ |
| C-58 | canvas_light_allocate メソッドが存在する | E-05 (L308) | ○ |
| C-59 | canvas_light_set_enabled メソッドが存在する | E-05 (L315) | ○ |
| C-60 | canvas_light_set_color メソッドが存在する | E-05 (L320) | ○ |
| C-61 | canvas_light_set_energy メソッドが存在する | E-05 (L322) | ○ |
| C-62 | ItemYSort 比較演算子が存在する | E-05 (L115-124) | ○ |

### ShaderLanguage / ShaderCompiler 関連 (UT-RND-081 - UT-RND-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | TokenType 列挙型が定義されている | E-06 (L54-200) | ○ |
| C-64 | DataType 列挙型が定義されている | E-06 (L209-244) | ○ |
| C-65 | Node::get_datatype メソッドが存在する | E-06 (L389) | ○ |
| C-66 | OperatorNode::get_array_size メソッドが存在する | E-06 (L421) | ○ |
| C-67 | ShaderCompiler::compile メソッドが存在する | E-07 (L132) | ○ |
| C-68 | ShaderCompiler::initialize メソッドが存在する | E-07 (L134) | ○ |

### RenderingLightCuller 関連 (UT-RND-088 - UT-RND-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | prepare_camera メソッドが存在する | E-08 (L132) | ○ |
| C-70 | prepare_regular_light メソッドが存在する | E-08 (L137) | ○ |
| C-71 | cull_regular_light メソッドが存在する | E-08 (L140) | ○ |
| C-72 | cull_directional_light メソッドが存在する | E-08 (L147) | ○ |
| C-73 | _is_colinear_tri メソッドが存在する | E-08 (L168) | ○ |
| C-74 | prepare_camera の戻り値が bool である | E-08 (L132) | △ |

### Storage 関連 (UT-RND-094 - UT-RND-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | RendererTextureStorage::texture_allocate が定義 | E-09 (L64) | ○ |
| C-76 | RendererTextureStorage::texture_2d_initialize が定義 | E-09 (L67) | ○ |
| C-77 | RendererTextureStorage::render_target_create が定義 | E-09 (L141) | ○ |
| C-78 | RendererTextureStorage::render_target_set_size が定義 | E-09 (L146) | ○ |
| C-79 | RendererTextureStorage::render_target_get_texture が定義 | E-09 (L192) | ○ |
| C-80 | RendererTextureStorage::decal_allocate が定義 | E-09 (L112) | ○ |
| C-81 | RendererTextureStorage::decal_set_size が定義 | E-09 (L116) | ○ |
| C-82 | RendererMeshStorage::mesh_allocate が定義 | E-10 (L42) | ○ |
| C-83 | RendererMeshStorage::mesh_add_surface が定義 | E-10 (L49) | ○ |
| C-84 | RendererMeshStorage::mesh_get_aabb が定義 | E-10 (L70) | ○ |
| C-85 | RendererMeshStorage::skeleton_allocate が定義 | E-10 (L206) | ○ |
| C-86 | RendererMeshStorage::skeleton_allocate_data が定義 | E-10 (L210) | ○ |
| C-87 | RendererMeshStorage::skeleton_bone_set_transform が定義 | E-10 (L212) | ○ |
| C-88 | RendererMeshStorage::skeleton_bone_get_transform が定義 | E-10 (L213) | ○ |
| C-89 | RendererLightStorage::directional_light_allocate が定義 | E-11 (L42) | ○ |
| C-90 | RendererLightStorage::omni_light_allocate が定義 | E-11 (L45) | ○ |
| C-91 | RendererLightStorage::spot_light_allocate が定義 | E-11 (L48) | ○ |
| C-92 | RendererLightStorage::light_set_color が定義 | E-11 (L53) | ○ |
| C-93 | RendererLightStorage::light_set_param が定義 | E-11 (L54) | ○ |
| C-94 | RendererLightStorage::light_set_shadow が定義 | E-11 (L55) | ○ |
| C-95 | RendererLightStorage::light_has_shadow が定義 | E-11 (L77) | ○ |
| C-96 | RendererLightStorage::reflection_probe_allocate が定義 | E-11 (L106) | ○ |
| C-97 | RendererLightStorage::reflection_probe_set_size が定義 | E-11 (L118) | ○ |
| C-98 | RendererLightStorage::shadow_atlas_create が定義 | E-11 (L191) | ○ |
| C-99 | RendererLightStorage::shadow_atlas_set_size が定義 | E-11 (L194) | ○ |
| C-100 | RendererLightStorage::lightmap_allocate が定義 | E-11 (L160) | ○ |
| C-101 | RendererLightStorage::lightmap_set_textures が定義 | E-11 (L164) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-RND-088 (C-74)**: `prepare_camera` メソッドの戻り値の条件（どのような場合にfalseを返すか）の詳細な仕様が不明
  - 候補：ソースコード実装確認 / ドキュメント参照
- **UT-RND-093**: `_is_colinear_tri` の閾値 0.001f の妥当性確認が必要
  - 候補：数学的根拠の確認 / テストによる検証

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース - ヘッダーファイルにメソッドシグネチャが明確に定義されている
- **1 (中リスク)**:
  - RenderingDevice 関連のテストケース - 複雑なGPU操作が含まれ、実行環境依存の可能性
  - ShaderCompiler 関連のテストケース - シェーダー構文エラーの定義が実装依存
- **2 (高リスク)**:
  - 境界値テストケース（UT-RND-003, UT-RND-040, UT-RND-053, UT-RND-073, UT-RND-074） - 実際の動作は実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] RenderingDevice のテクスチャ・バッファ操作テストケースが実際のAPIシグネチャと一致するか確認
- [ ] RenderingServer の純粋仮想関数に対するテストケースが適切な実装クラスでテスト可能か確認
- [ ] RendererViewport のビューポート管理テストケースが実際のレンダリングパイプラインと整合するか確認
- [ ] ShaderLanguage のトークン化テストケースが実際のトークン列挙型と一致するか確認
- [ ] Storage 系の抽象クラスに対するテストケースが具体的な実装クラス（例：RD実装）で実行可能か確認
- [ ] 境界値テストケースの期待結果が実装の実際の動作と一致するか確認
- [ ] フラスタムカリング関連のテストケースが数学的に正しいテスト条件を設定しているか確認
