---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：servers-text 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-TXT-095 _init_diacritics_map**：実装の詳細が非公開メソッドのため検証困難
  2. **UT-TXT-096 strip_diacritics**：diacritics_mapの初期化状態依存
  3. **UT-TXT-100 parse_structured_text**：戻り値の詳細が抽象的
  4. **UT-TXT-085, 086 TextServerExtension**：GDExtension連携部分の実装依存
  5. **UT-TXT-097, 098 is_valid_identifier**：Unicode識別子の詳細仕様要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/text/text_server.h` - TextServer基底クラス定義
- E-02: `servers/text/text_server.cpp` - TextServer実装（行1-1800+）
- E-03: `servers/text/text_server_extension.h` - TextServerExtension拡張クラス定義
- E-04: `servers/text/text_server_extension.cpp` - TextServerExtension実装
- E-05: `servers/text/text_server_dummy.h` - TextServerDummyダミー実装
- E-06: `text_server.h` 行47-48: `GDCLASS(TextServer, RefCounted)` - 継承構造
- E-07: `text_server.h` 行625-648: Glyph構造体定義
- E-08: `text_server.h` 行650-655: CaretInfo構造体定義
- E-09: `text_server.h` 行659-690: TextServerManager クラス定義
- E-10: `text_server.cpp` 行60-91: add_interface/remove_interface実装
- E-11: `text_server.cpp` 行93-128: get_interface_count/get_interface/find_interface/get_interfaces実装
- E-12: `text_server.cpp` 行130-156: set_primary_interface/コンストラクタ/デストラクタ実装
- E-13: `text_server.cpp` 行160-194: Glyph演算子オーバーロード実装
- E-14: `text_server.cpp` 行694-734: name_to_tag/tag_to_name実装（ot_tag_from_string/ot_tag_to_string含む）
- E-15: `text_server.cpp` 行736-812: get_hex_code_box_size/draw_hex_code_box実装
- E-16: `text_server.cpp` 行814-827: shaped_text_has_visible_chars実装
- E-17: `text_server.cpp` 行829-1021: shaped_text_get_line_breaks_adv実装
- E-18: `text_server.cpp` 行1023-1208: shaped_text_get_line_breaks実装
- E-19: `text_server.cpp` 行1210-1241: shaped_text_get_word_breaks実装
- E-20: `text_server.cpp` 行1243-1399: shaped_text_get_carets実装
- E-21: `text_server.cpp` 行1414-1446: shaped_text_get_dominant_direction_in_range実装
- E-22: `text_server.cpp` 行1456-1528: shaped_text_get_selection実装
- E-23: `text_server.cpp` 行1530-1546: shaped_text_hit_test_grapheme実装
- E-24: `text_server.cpp` 行1548-1640: shaped_text_hit_test_position実装
- E-25: `text_server.cpp` 行1642-1661: shaped_text_get_grapheme_bounds実装
- E-26: `text_server.cpp` 行1663-1726: shaped_text_next/prev_grapheme_pos, next/prev/closest_character_pos実装
- E-27: `text_server.cpp` 行1728-1737: string_get_character_breaks実装
- E-28: `text_server.cpp` 行1739以降: shaped_text_draw/shaped_text_draw_outline実装
- E-29: `text_server_extension.cpp` 行394-478: has_feature/get_name/get_features/name_to_tag/tag_to_name実装
- E-30: `text_server_dummy.h` 行42-128: 全メソッドのダミー実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextServerManager::add_interfaceがインターフェースを追加できる | E-10 | ○ |
| C-02 | add_interfaceがnull参照を拒否する | E-10 (ERR_FAIL_COND) | ○ |
| C-03 | add_interfaceが重複を検出する | E-10 (for loop check) | ○ |
| C-04 | remove_interfaceがインターフェースを削除できる | E-10 | ○ |
| C-05 | remove_interfaceがnull参照を拒否する | E-10 (ERR_FAIL_COND) | ○ |
| C-06 | remove_interfaceがプライマリの削除を拒否する | E-10 (ERR_FAIL_COND_MSG) | ○ |
| C-07 | remove_interfaceが存在しないインターフェースでエラーを出す | E-10 | ○ |
| C-08 | get_interface_countがインターフェース数を返す | E-11 | ○ |
| C-09 | get_interface_countが0件で0を返す | E-11 | ○ |
| C-10 | get_interfaceが指定インデックスを返す | E-11 | ○ |
| C-11 | get_interfaceが範囲外でnullを返す | E-11 (ERR_FAIL_INDEX_V) | ○ |
| C-12 | find_interfaceが名前検索できる | E-11 | ○ |
| C-13 | find_interfaceが存在しない名前でnullを返す | E-11 (ERR_FAIL_COND_V_MSG) | ○ |
| C-14 | get_interfacesがDictionary配列を返す | E-11 | ○ |
| C-15 | set_primary_interfaceがプライマリを設定できる | E-12 | ○ |
| C-16 | set_primary_interfaceがnullでクリアできる | E-12 | ○ |
| C-17 | Glyph::operator==が同一グリフでtrueを返す | E-13 | ○ |
| C-18 | Glyph::operator==が異なるグリフでfalseを返す | E-13 | ○ |
| C-19 | Glyph::operator!=が異なるグリフでtrueを返す | E-13 | ○ |
| C-20 | Glyph::operator<がstart比較を行う | E-13 | ○ |
| C-21 | Glyph::operator<がcount比較を行う | E-13 | ○ |
| C-22 | Glyph::operator<が仮想グラフェムを判定する | E-13 (GRAPHEME_IS_VIRTUAL) | ○ |
| C-23 | Glyph::operator>がstart比較を行う | E-13 | ○ |
| C-24 | name_to_tagが名前をタグに変換する | E-14 | ○ |
| C-25 | name_to_tagが空文字列でゼロタグを返す | E-14 | ○ |
| C-26 | tag_to_nameがタグを名前に変換する | E-14 | ○ |
| C-27 | get_hex_code_box_sizeが1バイトインデックスを処理する | E-15 | ○ |
| C-28 | get_hex_code_box_sizeが2バイトインデックスを処理する | E-15 | ○ |
| C-29 | get_hex_code_box_sizeが3バイトインデックスを処理する | E-15 | ○ |
| C-30 | draw_hex_code_boxがボックスを描画する | E-15 | ○ |
| C-31 | draw_hex_code_boxがインデックス0で早期リターンする | E-15 (if p_index == 0) | ○ |
| C-32 | shaped_text_has_visible_charsが可視文字を検出する | E-16 | ○ |
| C-33 | shaped_text_has_visible_charsが不可視でfalseを返す | E-16 | ○ |
| C-34 | shaped_text_has_visible_charsが空でfalseを返す | E-16 | ○ |
| C-35 | shaped_text_get_line_breaks_advが可変幅行分割を行う | E-17 | ○ |
| C-36 | shaped_text_get_line_breaks_advが空幅配列でエラーを返す | E-17 (ERR_FAIL_COND_V) | ○ |
| C-37 | shaped_text_get_line_breaks_advがBREAK_MANDATORYを処理する | E-17 | ○ |
| C-38 | shaped_text_get_line_breaks_advがBREAK_WORD_BOUNDを処理する | E-17 | ○ |
| C-39 | shaped_text_get_line_breaks_advがBREAK_TRIM_INDENTを処理する | E-17 | ○ |
| C-40 | shaped_text_get_line_breaks_advがソフトハイフンを処理する | E-17 (GRAPHEME_IS_SOFT_HYPHEN) | ○ |
| C-41 | shaped_text_get_line_breaksが固定幅行分割を行う | E-18 | ○ |
| C-42 | shaped_text_get_line_breaksがBREAK_ADAPTIVEを処理する | E-18 | ○ |
| C-43 | shaped_text_get_line_breaksが空テキストで空配列を返す | E-18 | ○ |
| C-44 | shaped_text_get_word_breaksが単語区切りを取得する | E-19 | ○ |
| C-45 | shaped_text_get_word_breaksが仮想グラフェムをスキップする | E-19 (p_skip_grapheme_flags) | ○ |
| C-46 | shaped_text_get_caretsがキャレット情報を返す | E-20 | ○ |
| C-47 | shaped_text_get_caretsがグラフェム開始でt_caretを設定する | E-20 | ○ |
| C-48 | shaped_text_get_caretsがグラフェム終了でl_caretを設定する | E-20 | ○ |
| C-49 | shaped_text_get_caretsがグラフェム内部で両方設定する | E-20 | ○ |
| C-50 | shaped_text_get_caretsがRTLテキストで正しい方向を返す | E-20 (GRAPHEME_IS_RTL) | ○ |
| C-51 | shaped_text_get_dominant_direction_in_rangeがLTRを返す | E-21 | ○ |
| C-52 | shaped_text_get_dominant_direction_in_rangeがRTLを返す | E-21 | ○ |
| C-53 | shaped_text_get_dominant_direction_in_rangeが同数でAUTOを返す | E-21 | ○ |
| C-54 | shaped_text_get_dominant_direction_in_rangeがstart==endでAUTOを返す | E-21 | ○ |
| C-55 | shaped_text_get_selectionが選択範囲を返す | E-22 | ○ |
| C-56 | shaped_text_get_selectionがグラフェム全体選択を処理する | E-22 | ○ |
| C-57 | shaped_text_get_selectionがグラフェム部分選択を処理する | E-22 | ○ |
| C-58 | shaped_text_get_selectionがstart==endで空配列を返す | E-22 | ○ |
| C-59 | shaped_text_hit_test_graphemeがグラフェムインデックスを返す | E-23 | ○ |
| C-60 | shaped_text_hit_test_graphemeが範囲外で-1を返す | E-23 | ○ |
| C-61 | shaped_text_hit_test_positionがカーソル位置を返す | E-24 | ○ |
| C-62 | shaped_text_hit_test_positionが座標<=0でテキスト開始を返す | E-24 | ○ |
| C-63 | shaped_text_hit_test_positionが座標>=幅でテキスト終了を返す | E-24 | ○ |
| C-64 | shaped_text_hit_test_positionがリガチャ内部を処理する | E-24 | ○ |
| C-65 | shaped_text_get_grapheme_boundsが境界座標を返す | E-25 | ○ |
| C-66 | shaped_text_get_grapheme_boundsが存在しない位置で空を返す | E-25 | ○ |
| C-67 | shaped_text_next_grapheme_posが次の位置を返す | E-26 | ○ |
| C-68 | shaped_text_next_grapheme_posが末尾で同じ位置を返す | E-26 | ○ |
| C-69 | shaped_text_prev_grapheme_posが前の位置を返す | E-26 | ○ |
| C-70 | shaped_text_prev_grapheme_posが先頭で同じ位置を返す | E-26 | ○ |
| C-71 | shaped_text_next_character_posが次の文字位置を返す | E-26 | ○ |
| C-72 | shaped_text_prev_character_posが前の文字位置を返す | E-26 | ○ |
| C-73 | shaped_text_closest_character_posが最も近い位置を返す | E-26 | ○ |
| C-74 | shaped_text_closest_character_posが完全一致でその位置を返す | E-26 | ○ |
| C-75 | string_get_character_breaksが文字区切りを返す | E-27 | ○ |
| C-76 | string_get_character_breaksが空文字列で空配列を返す | E-27 | ○ |
| C-77 | shaped_text_drawがグリフを描画する | E-28 | ○ |
| C-78 | shaped_text_drawがクリップ領域を適用する | E-28 | ○ |
| C-79 | shaped_text_drawがRTL楕円を描画する | E-28 | ○ |
| C-80 | shaped_text_drawがtrim_posを適用する | E-28 | ○ |
| C-81 | shaped_text_draw_outlineがアウトラインを描画する | E-28 | ○ |
| C-82 | get_overrun_flags_from_behaviorがNO_TRIMMINGを変換する | E-02 | ○ |
| C-83 | get_overrun_flags_from_behaviorがTRIM_ELLIPSISを変換する | E-02 | ○ |
| C-84 | get_overrun_flags_from_behaviorがTRIM_ELLIPSIS_FORCEを変換する | E-02 | ○ |
| C-85 | TextServerExtension::has_featureが仮想メソッドを呼び出す | E-29 | ○ |
| C-86 | TextServerExtension::get_nameが未実装時にUnknownを返す | E-29 | ○ |
| C-87 | TextServerExtension::name_to_tagが未実装時に基底クラスを呼び出す | E-29 | ○ |
| C-88 | TextServerDummy::has_featureがfalseを返す | E-30 | ○ |
| C-89 | TextServerDummy::get_nameがDummyを返す | E-30 | ○ |
| C-90 | TextServerDummy::get_featuresが0を返す | E-30 | ○ |
| C-91 | TextServerDummy::create_fontが空RIDを返す | E-30 | ○ |
| C-92 | TextServerDummy::create_shaped_textが空RIDを返す | E-30 | ○ |
| C-93 | TextServerDummy::shaped_text_get_glyphsがnullptrを返す | E-30 | ○ |
| C-94 | TextServerDummy::shaped_text_is_readyがfalseを返す | E-30 | ○ |
| C-95 | _init_diacritics_mapがマップを初期化する | **根拠なし** | △ |
| C-96 | strip_diacriticsが発音区別符号を除去する | **根拠不足** | △ |
| C-97 | is_valid_identifierが有効な識別子でtrueを返す | **根拠不足** | △ |
| C-98 | is_valid_identifierが無効な識別子でfalseを返す | **根拠不足** | △ |
| C-99 | is_valid_letterが有効な文字でtrueを返す | E-01 (宣言のみ) | △ |
| C-100 | parse_structured_textが構造化テキストをパースする | E-01 (宣言のみ) | ○ |

## 4) 不足情報（Unknown / Missing）

- **_init_diacritics_map / strip_diacritics**:
  - 実装が `text_server.cpp` の読み込み範囲外にあるため、詳細な処理内容が未確認
  - 候補：追加のソースコード読み込み / ドキュメント参照 / 実行テスト

- **is_valid_identifier / is_valid_letter**:
  - Unicode識別子の詳細な判定ロジックが未確認
  - 候補：ICU / Unicode仕様書参照 / 実装の詳細確認

- **GDExtension連携部分**:
  - GDVIRTUAL_CALLの動作詳細は拡張実装に依存
  - 候補：GDExtension仕様書 / 実際の拡張実装の確認

## 5) リスクフラグ（レビュー観点）

| リスク | 該当項目 | 説明 |
|--------|----------|------|
| 0（低） | TextServerDummy関連 (UT-TXT-088〜094) | ダミー実装のため実質的な機能なし |
| 1（中） | 文字列処理関連 (UT-TXT-095〜099) | Unicode処理の複雑性、ロケール依存 |
| 1（中） | GDExtension連携 (UT-TXT-085〜087) | 拡張実装への依存 |
| 0（低） | 比較演算子 (UT-TXT-017〜023) | シンプルなロジック、明確な実装 |
| 1（中） | 行分割処理 (UT-TXT-035〜043) | 複雑なフラグ組み合わせ、境界条件が多い |
| 1（中） | キャレット/選択処理 (UT-TXT-046〜058) | 座標計算、RTL処理の複雑性 |
| 1（中） | ヒットテスト (UT-TXT-059〜064) | リガチャ処理、座標計算の複雑性 |

## 6) レビュアーチェックリスト（最小）

- [ ] TextServerManagerのインターフェース管理ロジックが正しいか確認（シグナル発火含む）
- [ ] Glyph比較演算子の仮想グラフェム判定ロジックが意図通りか確認
- [ ] 行分割処理（shaped_text_get_line_breaks_adv/shaped_text_get_line_breaks）のフラグ組み合わせテストが網羅的か確認
- [ ] RTLテキスト処理（キャレット、選択、ヒットテスト）のテストケースが十分か確認
- [ ] リガチャ処理のテストケースが実際のユースケースをカバーしているか確認
- [ ] TextServerExtensionのGDVIRTUAL連携テストが必要かプロジェクト方針を確認
- [ ] Unicode処理関連（strip_diacritics, is_valid_identifier）の詳細確認が必要か判断
