---
generated_at: 2026-01-23 15:30:00
metrics:
  claims_total: 176
  claims_with_evidence: 176
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：servers-xr モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：176 / 176、根拠なし：0
- 優先レビュー（高）
  1. **XRServer::set_world_scale 境界値テスト**：コード内の制限値(0.01, 1000.0)を確認済み
  2. **XRPositionalTracker::set_tracker_hand 境界値テスト**：ERR_FAIL_INDEX マクロによる検証
  3. **XRVRS パラメータ制限テスト**：WARN_PRINT_ONCE による警告処理を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/xr/xr_server.h` - XRServerクラス定義、列挙型、メソッド宣言
- E-02: `servers/xr/xr_server.cpp` - XRServerクラス実装、境界値チェック、シグナル発行
- E-03: `servers/xr/xr_interface.h` - XRInterfaceクラス定義、仮想メソッド宣言
- E-04: `servers/xr/xr_pose.h` - XRPoseクラス定義、TrackingConfidence列挙型
- E-05: `servers/xr/xr_pose.cpp` - XRPoseクラス実装、get_adjusted_transform処理
- E-06: `servers/xr/xr_tracker.h` - XRTrackerベースクラス定義
- E-07: `servers/xr/xr_positional_tracker.h` - XRPositionalTrackerクラス定義、TrackerHand列挙型
- E-08: `servers/xr/xr_positional_tracker.cpp` - XRPositionalTrackerクラス実装、入力シグナル処理
- E-09: `servers/xr/xr_hand_tracker.h` - XRHandTrackerクラス定義、HandJoint列挙型（26関節）
- E-10: `servers/xr/xr_body_tracker.h` - XRBodyTrackerクラス定義、Joint列挙型（70+関節）
- E-11: `servers/xr/xr_face_tracker.h` - XRFaceTrackerクラス定義、BlendShapeEntry列挙型（194種）
- E-12: `servers/xr/xr_controller_tracker.h` - XRControllerTrackerクラス定義
- E-13: `servers/xr/xr_vrs.h` - XRVRSクラス定義、VRSパラメータ
- E-14: `servers/xr/xr_vrs.cpp` - XRVRSクラス実装、make_vrs_texture処理、境界値チェック
- E-15: `servers/xr/xr_interface_extension.h` - XRInterfaceExtensionクラス定義、GDVIRTUALマクロ

## 3) Claims と根拠の対応（レビューの主戦場）

### XRServer クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XRServer::get_singleton がシングルトンを返す | E-01, E-02 (L48-52) | ○ |
| C-02 | set_xr_mode で XRMode が設定可能 | E-01 (L59-63), E-02 (L40-46) | ○ |
| C-03 | set_world_scale が 0.01-1000.0 の範囲に制限 | E-02 (L125-134) | ○ |
| C-04 | get_world_scale がレンダースレッドで異なる値を返す | E-02 (L112-123) | ○ |
| C-05 | center_on_hmd が rotation_mode に応じて処理を分岐 | E-02 (L186-220) | ○ |
| C-06 | add_interface が重複チェックを行う | E-02 (L249-261) | ○ |
| C-07 | remove_interface が存在チェックを行う | E-02 (L263-278) | ○ |
| C-08 | add_tracker が同名トラッカーを更新する | E-02 (L329-343) | ○ |
| C-09 | get_suggested_tracker_names がデフォルト値を返す | E-02 (L380-401) | ○ |
| C-10 | _process が初期化済みインターフェースのみ処理 | E-02 (L430-442) | ○ |

### XRInterface クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | XRInterface::Capabilities 列挙型が定義済み | E-03 (L55-63) | ○ |
| C-12 | XRInterface::TrackingStatus 列挙型が定義済み | E-03 (L65-71) | ○ |
| C-13 | XRInterface::PlayAreaMode 列挙型が定義済み | E-03 (L73-80) | ○ |
| C-14 | get_name/get_capabilities が純粋仮想関数 | E-03 (L101-102) | ○ |
| C-15 | パススルー関連メソッドがデフォルト実装を持つ | E-03 (L156-159) | ○ |

### XRPose クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | XRPose::TrackingConfidence 列挙型が3値 | E-04 (L40-44) | ○ |
| C-17 | get_adjusted_transform が world_scale を適用 | E-05 (L89-102) | ○ |
| C-18 | get_adjusted_transform が reference_frame を適用 | E-05 (L99) | ○ |

### XRTracker クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | XRTracker がデフォルトで TRACKER_UNKNOWN | E-06 (L45) | ○ |
| C-20 | XRTracker がデフォルト名 "Unknown" | E-06 (L46) | ○ |

### XRPositionalTracker クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | TrackerHand 列挙型が4値（UNKNOWN, LEFT, RIGHT, MAX） | E-07 (L49-54) | ○ |
| C-22 | set_tracker_hand が範囲チェックを行う | E-08 (L81-84) | ○ |
| C-23 | set_pose が既存ポーズを更新する | E-08 (L111-131) | ○ |
| C-24 | invalidate_pose が has_tracking_data を false にする | E-08 (L100-109) | ○ |
| C-25 | set_input が Variant 型に応じてシグナルを発行 | E-08 (L146-191) | ○ |

### XRHandTracker クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | HAND_JOINT_MAX が26関節を定義 | E-09 (L48-76) | ○ |
| C-27 | HandJointFlags ビットフィールドが6フラグ | E-09 (L78-85) | ○ |
| C-28 | 関節ごとにtransform, radius, velocityを保持 | E-09 (L120-124) | ○ |

### XRBodyTracker クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | BodyFlags が3フラグ（上半身、下半身、手） | E-10 (L40-44) | ○ |
| C-30 | JOINT_MAX が70以上の関節を定義 | E-10 (L46-146) | ○ |
| C-31 | JointFlags が4フラグ | E-10 (L148-153) | ○ |

### XRFaceTracker クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | BlendShapeEntry が194種のブレンドシェイプを定義 | E-11 (L48-195) | ○ |
| C-33 | Unified Expressions 標準に基づく | E-11 (L36-40) | ○ |
| C-34 | blend_shape_values 配列で値を保持 | E-11 (L211) | ○ |

### XRControllerTracker クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタで TRACKER_CONTROLLER を設定 | E-12 (L45-47) | ○ |

### XRVRS クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | vrs_min_radius のデフォルト値は 20.0 | E-13 (L44) | ○ |
| C-37 | vrs_strength のデフォルト値は 1.0 | E-13 (L45) | ○ |
| C-38 | set_vrs_min_radius が 1.0-100.0 に制限 | E-14 (L65-76) | ○ |
| C-39 | set_vrs_strength が 0.1-10.0 に制限 | E-14 (L82-93) | ○ |
| C-40 | make_vrs_texture が空配列でエラー | E-14 (L105) | ○ |
| C-41 | make_vrs_texture が dirty フラグで再生成 | E-14 (L126) | ○ |

### XRInterfaceExtension クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | GDVIRTUAL マクロで仮想メソッドを公開 | E-15 (L53-54, L61-64) | ○ |
| C-43 | add_blit でブリット情報を追加可能 | E-15 (L122) | ○ |
| C-44 | post_draw_viewport がブリット配列を返す | E-15 (L127) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースがソースコードに基づいて設計されている）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード解析に基づいており、API境界が明確
- 注意点：
  - レンダースレッドとメインスレッドの状態分離（XRServer の RenderState）のテストは実行環境依存
  - GDVIRTUALメソッドのテストはGDExtension環境が必要

## 6) レビュアーチェックリスト（最小）
- [ ] XRServer の世界座標系関連メソッド（world_scale, world_origin, reference_frame）のテストケースが網羅されているか
- [ ] 各 TrackerType のトラッカークラス（Hand, Body, Face, Controller）が正しくテストされているか
- [ ] 境界値テスト（set_world_scale の 0.01/1000.0、XRVRS の 1.0/100.0, 0.1/10.0）が含まれているか
- [ ] シグナル発行（interface_added, tracker_added, pose_changed 等）のテストケースが含まれているか
- [ ] null 入力に対するエラーハンドリングのテストケースが含まれているか
- [ ] XRInterface の純粋仮想メソッド（get_name, get_capabilities, initialize 等）のテストケースが含まれているか
