---
generated_at: 2026-01-23 17:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 52
  claims_without_evidence: 8
confidence_derived: 0.87
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：52 / 60、根拠なし：8
- 優先レビュー（高）
  1. **UAT-048〜049（アセットライブラリ）**：外部サービス連携のため実装詳細確認が必要
  2. **UAT-050（バージョン管理）**：VCSプラグインの実装状況要確認
  3. **UAT-057〜058（シェーダー）**：シェーダーエディタの詳細機能確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/project_manager/project_manager.h` - プロジェクトマネージャークラス定義
- E-02: `editor/project_manager/project_list.h` - プロジェクトリスト管理
- E-03: `editor/project_manager/project_dialog.h` - プロジェクトダイアログ
- E-04: `editor/editor_node.h` - メインエディタノード（メニューオプション定義）
- E-05: `editor/scene/editor_scene_tabs.h` - シーンタブ管理
- E-06: `editor/script/script_editor_plugin.h` - スクリプトエディタプラグイン
- E-07: `editor/animation/animation_track_editor.h` - アニメーショントラックエディタ
- E-08: `editor/animation/animation_player_editor_plugin.h` - アニメーションプレイヤープラグイン
- E-09: `editor/debugger/editor_debugger_node.h` - デバッガーノード
- E-10: `editor/debugger/script_editor_debugger.h` - スクリプトデバッガー
- E-11: `editor/export/editor_export.h` - エクスポート機能
- E-12: `editor/settings/project_settings_editor.h` - プロジェクト設定エディタ
- E-13: `editor/settings/editor_settings.h` - エディタ設定
- E-14: `editor/settings/action_map_editor.h` - 入力マップエディタ
- E-15: `editor/file_system/editor_file_system.h` - ファイルシステム管理
- E-16: `editor/docks/file_system_dock.h` - ファイルシステムドック
- E-17: `editor/inspector/editor_inspector.h` - インスペクター
- E-18: `editor/gui/editor_file_dialog.h` - ファイルダイアログ
- E-19: `editor/version_control/version_control_editor_plugin.h` - バージョン管理プラグイン
- E-20: `editor/asset_library/asset_library_editor_plugin.h` - アセットライブラリプラグイン
- E-21: `editor/audio/editor_audio_buses.h` - オーディオバスエディタ
- E-22: `editor/shader/shader_editor_plugin.h` - シェーダーエディタプラグイン
- E-23: `editor/gui/editor_layouts_dialog.h` - レイアウトダイアログ
- E-24: `editor/run/editor_run_bar.h` - 実行バー
- E-25: `scene/gui/*.h` - GUIコンポーネント群
- E-26: `README.md` - プロジェクト概要

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規プロジェクト作成機能 | E-01, E-03 | ○ |
| C-02 | プロジェクトインポート機能 | E-01, E-03 | ○ |
| C-03 | プロジェクト複製機能 | E-01 (_duplicate_project) | ○ |
| C-04 | プロジェクト削除機能 | E-01 (_erase_project) | ○ |
| C-05 | プロジェクト検索機能 | E-01 (search_box) | ○ |
| C-06 | プロジェクトタグ管理 | E-01 (tag_manage_dialog) | ○ |
| C-07 | 新規シーン作成 | E-04 (SCENE_NEW_SCENE) | ○ |
| C-08 | シーン保存機能 | E-04 (SCENE_SAVE_SCENE) | ○ |
| C-09 | 複数シーンタブ管理 | E-05 (scene_tabs) | ○ |
| C-10 | 継承シーン作成 | E-04 (SCENE_NEW_INHERITED_SCENE) | ○ |
| C-11 | ノード追加機能 | E-04, E-17 | ○ |
| C-12 | ノード削除機能 | E-04 | ○ |
| C-13 | ノード複製機能 | E-04 | ○ |
| C-14 | ノードドラッグ&ドロップ | E-25 (Tree) | ○ |
| C-15 | プロパティ編集 | E-17 | ○ |
| C-16 | スクリプト作成機能 | E-06 | ○ |
| C-17 | スクリプト編集・保存 | E-06 | ○ |
| C-18 | 検索・置換機能 | E-06 (FindReplaceBar) | ○ |
| C-19 | 構文ハイライト | E-06 (EditorSyntaxHighlighter) | ○ |
| C-20 | 2Dノード配置 | E-04 | ○ |
| C-21 | 2Dノード変形 | E-04 | ○ |
| C-22 | グリッドスナップ | E-04 | ○ |
| C-23 | 3Dノード配置 | E-04 | ○ |
| C-24 | 3Dカメラナビゲーション | E-04 | ○ |
| C-25 | 3Dノード変形 | E-04 | ○ |
| C-26 | アニメーション作成 | E-07, E-08 | ○ |
| C-27 | キーフレーム追加 | E-07 | ○ |
| C-28 | アニメーション再生 | E-08 | ○ |
| C-29 | アニメーションブレンド | E-07 | ○ |
| C-30 | リソースインポート | E-15, E-16 | ○ |
| C-31 | リソース検索 | E-16 | ○ |
| C-32 | リソースプロパティ編集 | E-17 | ○ |
| C-33 | ブレークポイント設定 | E-09, E-10 | ○ |
| C-34 | ステップ実行 | E-09 (DEBUG_NEXT, DEBUG_STEP) | ○ |
| C-35 | 変数監視 | E-10 | ○ |
| C-36 | パフォーマンス計測 | E-09 (editor_profiler) | ○ |
| C-37 | プロジェクト実行 | E-04 (SAVE_AND_RUN) | ○ |
| C-38 | 現在シーン実行 | E-04 (SAVE_AND_RUN_MAIN_SCENE) | ○ |
| C-39 | カスタムシーン実行 | E-04 | ○ |
| C-40 | プロジェクト設定変更 | E-12 | ○ |
| C-41 | 入力マップ設定 | E-14 | ○ |
| C-42 | エクスポートプリセット作成 | E-11 | ○ |
| C-43 | プロジェクトエクスポート | E-11 | ○ |
| C-44 | PCKエクスポート | E-04 (PROJECT_PACK_AS_ZIP) | ○ |
| C-45 | エディタ設定変更 | E-13 | ○ |
| C-46 | テーマ変更 | E-13 | ○ |
| C-47 | ショートカットカスタマイズ | E-13 | ○ |
| C-48 | アセット検索 | E-20 | △ |
| C-49 | アセットダウンロード | E-20 | △ |
| C-50 | バージョン管理初期化 | E-19 | △ |
| C-51 | Undo機能 | E-04 (SCENE_UNDO) | ○ |
| C-52 | Redo機能 | E-04 (SCENE_REDO) | ○ |
| C-53 | クラスリファレンス参照 | E-04 (HELP_SEARCH) | ○ |
| C-54 | レイアウト保存 | E-23 | ○ |
| C-55 | レイアウト復元 | E-23 | ○ |
| C-56 | オーディオバス設定 | E-21 | ○ |
| C-57 | シェーダー作成 | E-22 | △ |
| C-58 | ビジュアルシェーダー作成 | E-22 | △ |
| C-59 | シグナル接続 | E-04 | ○ |
| C-60 | ノードグループ管理 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- **アセットライブラリ機能（C-48, C-49）**: 外部サービス（Godot Asset Library）との連携部分の実装詳細が確認できず
  - 候補：`editor/asset_library/asset_library_editor_plugin.cpp` の詳細確認 / ネットワーク通信部分
- **バージョン管理（C-50）**: VCSプラグインの実装はあるが、具体的な操作フローの詳細確認が不足
  - 候補：`editor/version_control/` 以下のcppファイル詳細確認
- **シェーダーエディタ（C-57, C-58）**: シェーダー作成の具体的なUIフローの詳細確認が必要
  - 候補：`editor/shader/` 以下の詳細確認 / ビジュアルシェーダーノードタイプ一覧

## 5) リスクフラグ（レビュー観点）
- **0 - 低リスク**: 基本的なエディタ機能（シーン、ノード、スクリプト編集）- コードベースで十分確認済み
- **1 - 中リスク**: アニメーション、デバッグ、エクスポート機能 - 主要クラスは確認済みだが詳細フローは要確認
- **2 - 高リスク**: アセットライブラリ、バージョン管理 - 外部サービス連携・プラグイン依存部分

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度（高/中/低）が業務要件と整合しているか確認
- [ ] 各テストケースの前提条件が実際のユーザー環境で満たせるか確認
- [ ] テスト手順が具体的で再現可能か確認
- [ ] 期待結果が測定可能・検証可能か確認
- [ ] アセットライブラリ関連テスト（UAT-048, UAT-049）のネットワーク要件を明確化
- [ ] プラットフォーム別のエクスポートテスト（UAT-043）で対象プラットフォームを特定
- [ ] シェーダー関連テスト（UAT-057, UAT-058）の詳細手順を技術者と確認
