---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての帳票にソースコードの根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/debugger/script_editor_debugger.h` - FileDialogPurpose enum (SAVE_MONITORS_CSV, SAVE_VRAM_CSV)
- E-02: `editor/debugger/script_editor_debugger.cpp` - _file_selected(), _export_csv() メソッド
- E-03: `editor/debugger/editor_profiler.h` - get_data_as_csv() メソッド宣言
- E-04: `editor/debugger/editor_profiler.cpp` - get_data_as_csv() 実装
- E-05: `editor/debugger/editor_visual_profiler.h` - get_data_as_csv() メソッド宣言
- E-06: `editor/debugger/editor_visual_profiler.cpp` - get_data_as_csv() 実装
- E-07: `editor/translations/template_generator.h` - _write_to_pot(), _write_to_csv() メソッド宣言
- E-08: `editor/translations/localization_editor.cpp` - POT/CSV出力ダイアログ設定
- E-09: `core/extension/extension_api_dump.h` - generate_extension_json_file() 宣言
- E-10: `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` - GLTFエクスポート実装
- E-11: `core/io/image.h` / `core/io/image.cpp` - save_png(), save_jpg(), save_webp(), save_exr() メソッド
- E-12: `modules/tinyexr/image_saver_tinyexr.cpp` - EXR保存実装
- E-13: `modules/webp/resource_saver_webp.cpp` - WebP保存実装
- E-14: `servers/movie_writer/movie_writer_pngwav.cpp` - PNG連番+WAV動画出力
- E-15: `modules/jpg/movie_writer_mjpeg.cpp` - MJPEG AVI出力
- E-16: `core/io/logger.h` - RotatedFileLogger クラス定義
- E-17: `editor/export/project_zip_packer.cpp` - プロジェクトZIPパッケージ化

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パフォーマンスモニターCSV出力機能 | E-01, E-02 | ○ |
| C-02 | VRAMメモリ使用量CSV出力機能 | E-01, E-02 | ○ |
| C-03 | スクリプトプロファイラーCSV出力機能 | E-03, E-04 | ○ |
| C-04 | ビジュアルプロファイラーCSV出力機能 | E-05, E-06 | ○ |
| C-05 | 翻訳テンプレートPOT出力機能 | E-07, E-08 | ○ |
| C-06 | 翻訳テンプレートCSV出力機能 | E-07, E-08 | ○ |
| C-07 | GDExtension API JSON出力機能 | E-09 | ○ |
| C-08 | 3Dシーン GLTF/GLB エクスポート機能 | E-10 | ○ |
| C-09 | 画像 PNG 保存機能 | E-11 | ○ |
| C-10 | 画像 EXR 保存機能 | E-11, E-12 | ○ |
| C-11 | 画像 JPG/JPEG 保存機能 | E-11 | ○ |
| C-12 | 画像 WebP 保存機能 | E-11, E-13 | ○ |
| C-13 | 動画 PNG連番+WAV 出力機能 | E-14 | ○ |
| C-14 | 動画 MJPEG AVI 出力機能 | E-15 | ○ |
| C-15 | ログファイル出力機能（ローテーション） | E-16 | ○ |
| C-16 | プロジェクトZIP出力機能 | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての帳票機能についてソースコードの根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての帳票機能はソースコードで確認済み
- 注意点：Godotエンジンはゲームエンジンであり、ビジネスアプリケーションで一般的に使われる帳票（請求書、レポート等）とは異なり、開発者向けのデバッグ・エクスポート機能が主な出力形式となっている

## 6) レビュアーチェックリスト（最小）
- [ ] 帳票の説明がソースコードの実装と一致しているか確認
- [ ] 備考欄のファイルパスが正確か確認
- [ ] カテゴリ分類が適切か確認
- [ ] Godotのバージョンアップにより追加された新機能がないか確認
