# 帳票設計書 2-VRAMメモリ使用量CSV

## 概要

本ドキュメントは、Godotエディタのデバッガーで取得したビデオメモリ（VRAM）使用状況をCSV形式でエクスポートする帳票の設計書である。

### 本帳票の処理概要

本帳票は、Godotエンジン実行中のVRAM（ビデオメモリ）使用状況をCSVファイルとして出力する機能を提供する。テクスチャ、メッシュ、シェーダーなどのGPUリソースがどの程度のメモリを消費しているかを一覧化し、リソースごとのメモリ使用量を詳細に確認できる。

**業務上の目的・背景**：モバイルデバイスや組み込み系プラットフォームでは、VRAMは非常に限られたリソースである。ゲームやアプリケーションがVRAM不足でクラッシュしたり、パフォーマンスが低下することを防ぐため、どのリソースがどれだけのメモリを消費しているかを把握することは重要である。本帳票により、VRAM使用状況を可視化し、最適化対象を特定できる。

**帳票の利用シーン**：主に以下のシーンで利用される。1) メモリ最適化のためのリソース分析時、2) 特定プラットフォーム向けのVRAM上限内に収めるための調整時、3) メモリリーク調査時、4) テクスチャ圧縮やLOD設定の効果確認時。

**主要な出力内容**：
1. リソースのパス/名前
2. リソースの種類（テクスチャ、メッシュ等）
3. リソースのフォーマット
4. メモリ使用量（バイト単位）
5. その他のリソース固有情報

**帳票の出力タイミング**：エディタのデバッガパネルにあるVideo RAMタブで「Export」ボタンをクリックした際に出力される。

**帳票の利用者**：ゲーム開発者、テクニカルアーティスト、グラフィックスプログラマー、最適化担当者

## 帳票種別

データエクスポート / リソース一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 15 | デバッガ | エディタ内蔵（Debugger Panel） | Video RAMタブの「Export」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | CSV |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | ユーザー指定（.csvフィルター） |
| 出力方法 | ファイルダイアログでのファイル保存 |
| 文字コード | UTF-8 |

### CSV固有設定

| 項目 | 内容 |
|-----|------|
| 区切り文字 | カンマ（,） |
| 囲み文字 | ダブルクォート（必要時） |
| ヘッダー行 | あり（1行目にカラム名） |

## 帳票レイアウト

### レイアウト概要

CSVファイルはVRAMツリーの内容をそのままテーブル形式で出力したものである。

```
┌─────────────────────────────────────────────────────────────┐
│              ヘッダー行（カラムタイトル）                       │
├─────────────────────────────────────────────────────────────┤
│              データ行（リソースごとの情報）                    │
│              ...（リソース数分の行）                          │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Path | リソースのファイルパス | vmem_tree->get_column_title(0) | 文字列 |
| 2 | Type | リソースの種類 | vmem_tree->get_column_title(1) | 文字列 |
| 3 | Format | リソースのフォーマット | vmem_tree->get_column_title(2) | 文字列 |
| 4 | VRAM | VRAM使用量 | vmem_tree->get_column_title(3) | 文字列（数値） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Path | リソースのパス | ti->get_text(0) | 文字列 | 可変 |
| 2 | Type | リソース種別 | ti->get_text(1) | 文字列 | 可変 |
| 3 | Format | データフォーマット | ti->get_text(2) | 文字列 | 可変 |
| 4 | VRAM | メモリ使用量 | ti->get_text(3) | 文字列（数値） | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| デバッガ接続 | リモートデバッガがゲームに接続している必要がある | Yes |
| VRAMデータ取得 | Video RAMタブでリソース一覧が取得されている必要がある | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ツリー表示順 | 表示順維持 |

### 改ページ条件

N/A（CSVファイルのため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照せず、UIコンポーネント（vmem_tree）からデータを取得する。

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| vmem_tree (Tree) | VRAMリソース一覧表示 | get_root()、get_first_child()、get_next() |

### テーブル別参照項目詳細

#### vmem_tree (Tree Widget)

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| get_columns() | カラム数 | 常時 | ヘッダー行とデータ行で使用 |
| get_column_title(i) | ヘッダー行の各カラム名 | 0 <= i < columns | カラムタイトル取得 |
| TreeItem::get_text(i) | データ行の各セル値 | 0 <= i < columns | 各リソースの情報 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | - | - | 本帳票は計算処理なし、ツリー表示内容をそのまま出力 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Exportボタンクリック] --> B[_video_mem_export呼び出し]
    B --> C[ファイルダイアログ設定]
    C --> D[file_dialog_purpose = SAVE_VRAM_CSV]
    D --> E[ファイルダイアログ表示]
    E --> F{ファイル選択}
    F -->|選択| G[_file_selected呼び出し]
    F -->|キャンセル| Z[終了]
    G --> H[ファイルオープン]
    H --> I{オープン成功?}
    I -->|失敗| J[エラー出力]
    I -->|成功| K[ヘッダー行構築・書き込み]
    K --> L{vmem_tree->get_root()存在?}
    L -->|Yes| M[最初の子アイテム取得]
    L -->|No| P[ファイルクローズ]
    M --> N[データ行書き込み]
    N --> O{次のアイテム存在?}
    O -->|Yes| N
    O -->|No| P
    P --> Z
    J --> Z
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイルオープン失敗 | 書き込み権限なし、パス不正など | "Failed to open [path]" | ERR_PRINT出力、処理中断 |
| データなし | vmem_treeにルートがない | なし（空ファイル出力） | ヘッダーのみのファイル出力 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百リソース |
| 目標出力時間 | 1秒未満 |
| 同時出力数上限 | 1（シングル処理） |

## セキュリティ考慮事項

- 出力先はユーザーが選択したローカルファイルシステムのみ
- リソースパスからプロジェクト構造が推測可能
- ファイルアクセス権限はEditorFileDialog::ACCESS_FILESYSTEMで制御

## 備考

- VRAMデータは「servers:memory」メッセージでリモートプロセスから取得される
- ツリー表示されている内容がそのままCSVに出力されるため、表示とファイル内容は一致する

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、VRAMデータがどのようにUI上に格納されているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script_editor_debugger.h | `editor/debugger/script_editor_debugger.h` | vmem_treeメンバー変数（Tree*型）の定義を確認 |
| 1-2 | script_editor_debugger.h | `editor/debugger/script_editor_debugger.h` | FileDialogPurpose列挙型のSAVE_VRAM_CSV（108行目）を確認 |

**読解のコツ**: TreeウィジェットはGodotのUI基盤クラスで、階層的なデータを表示する。get_root()でルートTreeItemを取得し、get_first_child()とget_next()でトラバースする。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script_editor_debugger.cpp | `editor/debugger/script_editor_debugger.cpp` | _video_mem_export()（324-330行目）がエクスポートのエントリーポイント |

**主要処理フロー**:
1. **325行目**: file_dialog->set_file_mode(FILE_MODE_SAVE_FILE)でファイル保存モード設定
2. **326行目**: ACCESS_FILESYSTEMでファイルシステムアクセス設定
3. **328行目**: file_dialog_purposeをSAVE_VRAM_CSVに設定
4. **329行目**: ファイルダイアログをポップアップ表示

#### Step 3: ファイル選択後の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | script_editor_debugger.cpp | `editor/debugger/script_editor_debugger.cpp` | _file_selected()（228-257行目）でSAVE_VRAM_CSVケースの処理 |

**主要処理フロー**:
- **228行目**: case SAVE_VRAM_CSV でVRAM CSVの処理分岐
- **229-235行目**: FileAccess::openでファイルを開き、失敗時はエラー出力
- **237-242行目**: vmem_tree->get_columns()でカラム数取得、ヘッダー行を構築
- **244-256行目**: vmem_tree->get_root()から全TreeItemをトラバースしてデータ行出力

#### Step 4: VRAMデータの取得元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | script_editor_debugger.cpp | `editor/debugger/script_editor_debugger.cpp` | _video_mem_request()（320-322行目）でVRAMデータ要求 |

**主要処理フロー**:
- **321行目**: _put_msg("servers:memory", Array())でリモートプロセスにメモリ情報を要求

### プログラム呼び出し階層図

```
ScriptEditorDebugger::_video_mem_export()
    │
    └─ EditorFileDialog::popup_file_dialog()
           │
           └─ ScriptEditorDebugger::_file_selected(path)
                  │
                  ├─ FileAccess::open(path, WRITE)
                  │
                  ├─ vmem_tree->get_columns()
                  │      └─ [カラム数取得]
                  │
                  ├─ vmem_tree->get_column_title(i)
                  │      └─ [ヘッダー行構築]
                  │
                  ├─ file->store_csv_line(headers)
                  │
                  ├─ vmem_tree->get_root()
                  │      └─ get_first_child()
                  │             └─ [ツリーアイテムトラバース]
                  │
                  └─ ti->get_text(i)
                         └─ [各セルのテキスト取得]
```

### データフロー図

```
[入力]                        [処理]                         [出力]

リモートプロセス ─────────▶ "servers:memory" ──────────────▶ vmem_tree
                              メッセージ                    (Tree Widget)
                                                                │
                                                                │
vmem_tree ───────────────▶ get_column_title() ─────────────▶ CSVヘッダー行
      │                                                           │
      │                                                           │
TreeItem ────────────────▶ get_text() ─────────────────────▶ CSVデータ行
      │                        │                                  │
      │                        │                                  │
      │                        ▼                                  │
      │                  FileAccess::store_csv_line() ◀───────────┘
      │                        │
      │                        ▼
      └──────────────────▶ [CSVファイル]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script_editor_debugger.h | `editor/debugger/script_editor_debugger.h` | ヘッダー | ScriptEditorDebuggerクラス定義、vmem_tree、FileDialogPurpose |
| script_editor_debugger.cpp | `editor/debugger/script_editor_debugger.cpp` | ソース | _video_mem_export()、_file_selected()の実装 |
| tree.h | `scene/gui/tree.h` | ヘッダー | Treeウィジェットクラス定義 |
| tree_item.h | `scene/gui/tree_item.h` | ヘッダー | TreeItemクラス定義 |
| file_access.h | `core/io/file_access.h` | ヘッダー | ファイルI/O基盤クラス |
| editor_file_dialog.h | `editor/gui/editor_file_dialog.h` | ヘッダー | ファイル選択ダイアログ |
