# 帳票設計書 7-GDExtension API JSON

## 概要

本ドキュメントは、Godotエンジンの拡張機能API定義をJSON形式でダンプする帳票の設計書である。

### 本帳票の処理概要

本帳票は、GodotエンジンのネイティブAPIをJSON形式でエクスポートする機能を提供する。GDExtension開発者がC++やRust等の言語でGodotエンジンを拡張する際に必要となるAPI仕様書として機能する。クラス、メソッド、プロパティ、シグナル、列挙型などのエンジン内部情報を網羅的に出力する。

**業務上の目的・背景**：GDExtensionはGodot 4.0から導入された新しい拡張機構であり、ネイティブコードでエンジンを拡張できる。拡張開発にはエンジンのAPI構造を正確に把握する必要があり、本帳票はその公式仕様書として機能する。バインディングジェネレーター（godot-cpp等）がこのJSONを読み込んでラッパーコードを自動生成する。

**帳票の利用シーン**：主に以下のシーンで利用される。1) GDExtension開発開始時のAPI確認、2) バインディングジェネレーターへの入力、3) 新バージョンのGodotへの移行時のAPI差分確認、4) カスタムエディター拡張の開発。

**主要な出力内容**：
1. ヘッダー情報（バージョン、精度設定等）
2. 組み込み型サイズ情報
3. グローバル列挙型と定数
4. ユーティリティ関数
5. 組み込み型のメソッド・演算子
6. クラス情報（メソッド、プロパティ、シグナル）
7. シングルトン一覧
8. ネイティブ構造体情報

**帳票の出力タイミング**：コマンドライン引数`--dump-extension-api`を指定してGodotを起動した際に出力される。

**帳票の利用者**：GDExtension開発者、バインディングメンテナー、エンジンコントリビューター

## 帳票種別

API仕様書 / 技術文書出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | N/A | `godot --dump-extension-api` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（データファイル） |
| 向き | N/A |
| ファイル名 | extension_api.json（固定） |
| 出力方法 | コマンドライン実行 |
| 文字コード | UTF-8 |

### JSON固有設定

| 項目 | 内容 |
|-----|------|
| インデント | タブ（\t） |
| 配列形式 | 適切にネスト |
| 文字列エスケープ | 標準JSONエスケープ |

## 帳票レイアウト

### レイアウト概要

JSONファイルは大きく複数のセクションで構成される。

```json
{
    "header": { ... },
    "builtin_class_sizes": [ ... ],
    "builtin_class_member_offsets": [ ... ],
    "global_constants": [ ... ],
    "global_enums": [ ... ],
    "utility_functions": [ ... ],
    "builtin_classes": [ ... ],
    "classes": [ ... ],
    "singletons": [ ... ],
    "native_structures": [ ... ]
}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version_major | メジャーバージョン | GODOT_VERSION_MAJOR | 整数 |
| 2 | version_minor | マイナーバージョン | GODOT_VERSION_MINOR | 整数 |
| 3 | version_patch | パッチバージョン | GODOT_VERSION_PATCH | 整数 |
| 4 | version_status | ステータス | GODOT_VERSION_STATUS | 文字列 |
| 5 | version_build | ビルド情報 | GODOT_VERSION_BUILD | 文字列 |
| 6 | version_full_name | フルネーム | GODOT_VERSION_FULL_NAME | 文字列 |
| 7 | precision | 浮動小数点精度 | REAL_T_IS_DOUBLE | "single"/"double" |

### 明細部（クラス情報例）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | name | クラス名 | ClassDB | 文字列 |
| 2 | is_refcounted | RefCounted派生か | ClassDB::is_parent_class | bool |
| 3 | is_instantiable | インスタンス化可能か | ClassDB::can_instantiate | bool |
| 4 | inherits | 親クラス名 | ClassDB::get_parent_class | 文字列 |
| 5 | methods | メソッド一覧 | ClassDB::get_method_list | 配列 |
| 6 | properties | プロパティ一覧 | ClassDB::get_property_list | 配列 |
| 7 | signals | シグナル一覧 | ClassDB::get_signal_list | 配列 |
| 8 | enums | 列挙型一覧 | ClassDB::get_enum_list | 配列 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| コマンドライン引数 | --dump-extension-apiが指定されている | Yes |
| エディタヒント | Engine::set_editor_hint(true)が設定される | Yes（内部で自動設定） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 型定義順 | Variant::Type順 |
| 2 | クラス名 | アルファベット順（一部） |

### 改ページ条件

N/A（JSONファイルのため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照せず、エンジン内部のメタデータを使用する。

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| ClassDB | クラス情報 | ClassDB::get_class_list()等 |
| Variant | 組み込み型情報 | Variant::get_type_name()等 |
| CoreConstants | グローバル定数 | CoreConstants::get_global_constant_*() |
| Engine | シングルトン情報 | Engine::get_singleton_list() |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 型サイズ | sizeof(Type) | N/A | ビルド構成依存 |
| メンバオフセット | offsetof相当 | N/A | ビルド構成依存 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[main.cpp: dump_extension_api判定] --> B[set_editor_hint true]
    B --> C[generate_extension_json_file呼び出し]
    C --> D[generate_extension_api呼び出し]
    D --> E[ヘッダー情報生成]
    E --> F[組み込み型サイズ情報生成]
    F --> G[メンバオフセット情報生成]
    G --> H[グローバル定数・列挙型生成]
    H --> I[ユーティリティ関数生成]
    I --> J[組み込み型情報生成]
    J --> K[クラス情報生成]
    K --> L[シングルトン情報生成]
    L --> M[ネイティブ構造体情報生成]
    M --> N[JSON::stringify実行]
    N --> O[FileAccess::open]
    O --> P[store_string]
    P --> Q[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイルオープン失敗 | 書き込み権限なし等 | "Cannot open file '[path]' for writing." | ERR_FAIL_COND_MSG |
| ドキュメント未生成 | include_docs時にドキュメントがない | "Could not find '@GlobalScope' in DocData." | CRASH_COND_MSG |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数千のクラス・メソッド定義 |
| 目標出力時間 | 数秒〜十数秒 |
| 同時出力数上限 | 1（起動時一回のみ） |

## セキュリティ考慮事項

- エンジン内部APIが公開されるため、バージョンによるAPI差異に注意
- 本番環境では不要なため、--dump-extension-apiは開発時のみ使用

## 備考

- `--dump-extension-api-with-docs`オプションでドキュメントを含めることも可能
- 出力ファイルサイズは数MB〜数十MBになる場合がある
- ビルド構成（float_32/float_64/double_32/double_64）により型サイズが異なる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.cpp | `main/main.cpp` | dump_extension_api変数とコマンドライン引数処理 |
| 1-2 | main.cpp | `main/main.cpp` | 4161-4163行目でgenerate_extension_json_file呼び出し |

**主要処理フロー**:
1. **4161行目**: dump_extension_apiフラグチェック
2. **4162行目**: Engine::set_editor_hint(true)でエディタモード設定
3. **4163行目**: GDExtensionAPIDump::generate_extension_json_file()呼び出し

#### Step 2: JSON生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extension_api_dump.cpp | `core/extension/extension_api_dump.cpp` | generate_extension_json_file()（1331-1340行目） |
| 2-2 | extension_api_dump.cpp | `core/extension/extension_api_dump.cpp` | generate_extension_api()（103-1328行目） |

**主要処理フロー**:
- **1331行目**: generate_extension_api()でDictionary生成
- **1333-1334行目**: JSON::instantiate()とstringify()
- **1337-1339行目**: FileAccess::openとstore_string()

#### Step 3: API情報収集処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | extension_api_dump.cpp | `core/extension/extension_api_dump.cpp` | 106-127行目：ヘッダー情報生成 |
| 3-2 | extension_api_dump.cpp | `core/extension/extension_api_dump.cpp` | 135-277行目：組み込み型サイズ情報 |
| 3-3 | extension_api_dump.cpp | `core/extension/extension_api_dump.cpp` | 487-以降：グローバル定数・クラス情報 |

### プログラム呼び出し階層図

```
main() [main/main.cpp]
    │
    └─ dump_extension_api フラグチェック
           │
           ├─ Engine::set_editor_hint(true)
           │
           └─ GDExtensionAPIDump::generate_extension_json_file(path, include_docs)
                  │
                  ├─ generate_extension_api(p_include_docs)
                  │      │
                  │      ├─ ヘッダー情報生成
                  │      │      └─ GODOT_VERSION_*マクロ使用
                  │      │
                  │      ├─ builtin_class_sizes生成
                  │      │      └─ type_size_array[]参照
                  │      │
                  │      ├─ builtin_class_member_offsets生成
                  │      │      └─ member_offset_array[]参照
                  │      │
                  │      ├─ global_constants/enums生成
                  │      │      └─ CoreConstants::get_global_constant_*()
                  │      │
                  │      ├─ utility_functions生成
                  │      │      └─ Variant::get_utility_function_*()
                  │      │
                  │      ├─ builtin_classes生成
                  │      │      └─ Variant::get_type_name()等
                  │      │
                  │      ├─ classes生成
                  │      │      └─ ClassDB::get_class_list()等
                  │      │
                  │      ├─ singletons生成
                  │      │      └─ Engine::get_singleton_list()
                  │      │
                  │      └─ native_structures生成
                  │
                  ├─ JSON::stringify(api, "\t", false)
                  │
                  └─ FileAccess::open() → store_string()
```

### データフロー図

```
[入力]                        [処理]                         [出力]

コマンドライン ──────────▶ --dump-extension-api ─────────▶ フラグ設定
                              解析                              │
                                                                │
GODOT_VERSION_* ─────────▶ ヘッダー生成 ──────────────────▶ header{}
                                                                │
                                                                │
type_size_array[] ───────▶ 型サイズ生成 ─────────────────▶ builtin_class_sizes[]
                                                                │
                                                                │
CoreConstants ───────────▶ 定数・列挙型生成 ─────────────▶ global_constants[]
                                                           global_enums[]
                                                                │
ClassDB ─────────────────▶ クラス情報生成 ───────────────▶ classes[]
                                                                │
Engine ──────────────────▶ シングルトン生成 ─────────────▶ singletons[]
                                                                │
                                                                │
                          JSON::stringify()
                                │
                                ▼
                        [extension_api.json]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extension_api_dump.h | `core/extension/extension_api_dump.h` | ヘッダー | GDExtensionAPIDumpクラス宣言 |
| extension_api_dump.cpp | `core/extension/extension_api_dump.cpp` | ソース | generate_extension_api()、generate_extension_json_file()実装 |
| main.cpp | `main/main.cpp` | ソース | コマンドライン引数処理、エントリーポイント |
| class_db.h | `core/object/class_db.h` | ヘッダー | ClassDBクラス定義 |
| variant.h | `core/variant/variant.h` | ヘッダー | Variantクラス定義 |
| core_constants.h | `core/core_constants.h` | ヘッダー | CoreConstantsクラス定義 |
| json.h | `core/io/json.h` | ヘッダー | JSONクラス定義 |
| version.h | `core/version.h` | ヘッダー | GODOT_VERSION_*マクロ定義 |
