# 帳票設計書 8-3DシーンGLTF/GLB

## 概要

本ドキュメントは、3DシーンをglTF 2.0形式（.gltf/.glb）でエクスポートする帳票の設計書である。

### 本帳票の処理概要

本帳票は、Godotエディタで作成した3DシーンをglTF 2.0形式でエクスポートする機能を提供する。メッシュ、マテリアル、テクスチャ、アニメーション、スケルトン（ボーン）などの3Dアセット情報を業界標準フォーマットで出力し、他の3Dソフトウェアとの相互運用を可能にする。

**業務上の目的・背景**：glTF（GL Transmission Format）は「3DのJPEG」とも呼ばれる業界標準フォーマットであり、Blender、Maya、3ds Max等の主要3Dソフトウェアでサポートされている。Godotで制作したシーンを他のツールで編集したり、Webブラウザで表示したりする際に必要となる。

**帳票の利用シーン**：主に以下のシーンで利用される。1) 他の3Dソフトウェアへのシーン共有、2) Web3Dコンテンツへの変換、3) アセットのバックアップ・アーカイブ、4) 他のゲームエンジンへの移行。

**主要な出力内容**：
1. メッシュジオメトリ（頂点、法線、UV等）
2. マテリアル情報（PBR設定、テクスチャ参照）
3. ノード階層（シーンツリー）
4. アニメーション（キーフレーム、ブレンドシェイプ）
5. スケルトン（ボーン階層、スキンウェイト）
6. テクスチャ画像（埋め込みまたは外部参照）

**帳票の出力タイミング**：エディタメニューの「Scene > Export As...」から「glTF 2.0 Scene...」を選択した際に出力される。

**帳票の利用者**：3Dアーティスト、テクニカルアーティスト、ゲーム開発者

## 帳票種別

3Dデータエクスポート / シーン出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | エディタメインメニュー | Scene > Export As... | glTF 2.0 Scene... |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | glTF 2.0 (.gltf) または GLB (.glb) |
| 用紙サイズ | N/A（バイナリ/テキストファイル） |
| 向き | N/A |
| ファイル名 | ユーザー指定（.gltf/.glb） |
| 出力方法 | ファイルダイアログでのファイル保存 |
| 文字コード | UTF-8（.gltfはJSON形式） |

### glTF/GLB固有設定

| 項目 | 内容 |
|-----|------|
| .gltf | JSONテキスト形式、バイナリは別ファイル（.bin） |
| .glb | バイナリ形式、すべて単一ファイルに格納 |
| テクスチャ | 埋め込みまたは外部ファイル参照 |

## 帳票レイアウト

### レイアウト概要

glTFファイルは標準glTF 2.0仕様に従う。

```json
{
    "asset": { ... },
    "scene": 0,
    "scenes": [ ... ],
    "nodes": [ ... ],
    "meshes": [ ... ],
    "accessors": [ ... ],
    "bufferViews": [ ... ],
    "buffers": [ ... ],
    "materials": [ ... ],
    "textures": [ ... ],
    "images": [ ... ],
    "samplers": [ ... ],
    "animations": [ ... ],
    "skins": [ ... ]
}
```

### ヘッダー部（asset）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | version | glTFバージョン | 固定値 | "2.0" |
| 2 | generator | 生成ツール | 固定値 | "Godot Engine vX.X.X" |
| 3 | copyright | 著作権情報 | エクスポート設定 | 文字列 |

### 明細部（主要セクション）

| No | セクション | 説明 | データ取得元 |
|----|-----------|------|-------------|
| 1 | scenes | シーン定義 | Scene tree |
| 2 | nodes | ノード階層 | Node3D等 |
| 3 | meshes | メッシュデータ | MeshInstance3D等 |
| 4 | materials | マテリアル | StandardMaterial3D等 |
| 5 | animations | アニメーション | AnimationPlayer等 |
| 6 | skins | スケルトン | Skeleton3D |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| シーンが開かれている | エディタでシーンが開かれている必要がある | Yes |
| 3Dコンテンツ | 出力対象の3Dノードが存在する必要がある | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | シーンツリー順 | 深さ優先 |

### 改ページ条件

N/A（バイナリ/JSONファイルのため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照せず、シーンツリーからデータを取得する。

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| EditorNode::get_tree()->get_edited_scene_root() | ルートノード取得 | シーンツリーAPI |
| GLTFDocument | glTF変換処理 | append_from_scene() |
| GLTFState | glTF状態管理 | 各種設定とデータ格納 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 座標変換 | Godot座標系 → glTF座標系 | N/A | Y-up、右手系への変換 |
| アニメーションベイク | bake_fps設定に従う | N/A | キーフレーム補間 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Export As... glTF 2.0選択] --> B[_popup_gltf_export_dialog呼び出し]
    B --> C{シーン存在?}
    C -->|No| D[警告表示]
    C -->|Yes| E[ファイルダイアログ表示]
    E --> F{ファイル選択}
    F -->|キャンセル| G[終了]
    F -->|選択| H[_popup_gltf_settings_dialog]
    H --> I[エクスポート設定ダイアログ表示]
    I --> J{確認ボタン}
    J -->|キャンセル| G
    J -->|OK| K[_export_scene_as_gltf呼び出し]
    K --> L[GLTFState初期化]
    L --> M[設定適用 copyright/bake_fps]
    M --> N[GLTFDocument::append_from_scene]
    N --> O{エラー?}
    O -->|Yes| P[エラー出力]
    O -->|No| Q[GLTFDocument::write_to_filesystem]
    Q --> R{エラー?}
    R -->|Yes| P
    R -->|No| S[EditorFileSystem::scan_changes]
    S --> G
    P --> G
    D --> G
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| シーンなし | シーンが開かれていない | "This operation can't be done without a scene." | show_warning()表示 |
| append失敗 | シーン解析エラー | "glTF2 save scene error [code]." | ERR_PRINT出力 |
| write失敗 | ファイル書き込みエラー | "glTF2 save scene error [code]." | ERR_PRINT出力 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数千〜数万ポリゴン |
| 目標出力時間 | シーン複雑度に依存 |
| 同時出力数上限 | 1（シングル処理） |

## セキュリティ考慮事項

- 出力ファイルにはシーン構造とアセットが含まれる
- テクスチャ等の著作物が埋め込まれる可能性がある
- ファイルアクセス権限はEditorFileDialog::ACCESS_FILESYSTEMで制御

## 備考

- glTF 2.0仕様はKhronos Groupが策定
- GLBはglTFのバイナリ版で単一ファイルにすべてを格納
- エクスポート設定でcopyright、bake_fpsを指定可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_scene_exporter_gltf_plugin.cpp | `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` | コンストラクタでメニュー登録（51-80行目） |

**主要処理フロー**:
1. **52行目**: _gltf_document.instantiate()でGLTFDocumentを生成
2. **54-63行目**: ファイルダイアログの設定（.glb/.gltfフィルター）
3. **65-68行目**: 設定ダイアログの設定
4. **76-79行目**: メニューに「glTF 2.0 Scene...」を追加

#### Step 2: ダイアログ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_scene_exporter_gltf_plugin.cpp | `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` | _popup_gltf_export_dialog()（95-109行目） |
| 2-2 | editor_scene_exporter_gltf_plugin.cpp | `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` | _popup_gltf_settings_dialog()（82-93行目） |

**主要処理フロー**:
- **96-100行目**: シーン存在チェック、なければ警告
- **101-106行目**: ファイル名をシーン名から設定
- **108行目**: ファイルダイアログをポップアップ

#### Step 3: エクスポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editor_scene_exporter_gltf_plugin.cpp | `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` | _export_scene_as_gltf()（111-130行目） |

**主要処理フロー**:
- **112-113行目**: ルートノード取得
- **114-120行目**: GLTFState初期化、設定適用
- **121-124行目**: append_from_scene()でシーン解析
- **125-128行目**: write_to_filesystem()でファイル出力
- **129行目**: EditorFileSystem::scan_changes()でファイルシステム更新

### プログラム呼び出し階層図

```
SceneExporterGLTFPlugin コンストラクタ
    │
    ├─ _gltf_document.instantiate()
    │
    ├─ EditorFileDialog設定
    │      └─ add_filter(".glb", ".gltf")
    │
    └─ PopupMenu::add_item("glTF 2.0 Scene...")
           │
           └─ _popup_gltf_export_dialog()
                  │
                  ├─ シーン存在チェック
                  │
                  ├─ ファイル名設定
                  │
                  └─ _file_dialog->popup_file_dialog()
                         │
                         └─ _popup_gltf_settings_dialog(path)
                                │
                                ├─ エクスポート設定生成
                                │
                                └─ _config_dialog->popup_centered()
                                       │
                                       └─ _export_scene_as_gltf()
                                              │
                                              ├─ GLTFState::instantiate()
                                              │
                                              ├─ state->set_copyright()
                                              │
                                              ├─ state->set_bake_fps()
                                              │
                                              ├─ GLTFDocument::append_from_scene()
                                              │
                                              ├─ GLTFDocument::write_to_filesystem()
                                              │
                                              └─ EditorFileSystem::scan_changes()
```

### データフロー図

```
[入力]                        [処理]                         [出力]

Scene Tree ──────────────▶ append_from_scene() ───────────▶ GLTFState
(Node3D, MeshInstance3D等)                                 (内部データ構造)
                                                                │
                                                                │
エクスポート設定 ─────────▶ state->set_*() ─────────────────────┤
(copyright, bake_fps)                                           │
                                                                │
                          write_to_filesystem()
                                │
                                ▼
                        [.gltf/.glb ファイル]
                                │
                                ├─ .gltf (JSON)
                                │     ├─ asset {}
                                │     ├─ scenes []
                                │     ├─ nodes []
                                │     ├─ meshes []
                                │     └─ ...
                                │
                                └─ .glb (Binary)
                                      └─ [GLB Header + JSON + BIN]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_scene_exporter_gltf_plugin.h | `modules/gltf/editor/editor_scene_exporter_gltf_plugin.h` | ヘッダー | SceneExporterGLTFPluginクラス定義 |
| editor_scene_exporter_gltf_plugin.cpp | `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` | ソース | エクスポートプラグイン実装 |
| editor_scene_exporter_gltf_settings.h | `modules/gltf/editor/editor_scene_exporter_gltf_settings.h` | ヘッダー | エクスポート設定クラス |
| gltf_document.h | `modules/gltf/gltf_document.h` | ヘッダー | GLTFDocumentクラス定義 |
| gltf_state.h | `modules/gltf/gltf_state.h` | ヘッダー | GLTFStateクラス定義 |
| editor_file_dialog.h | `editor/gui/editor_file_dialog.h` | ヘッダー | ファイルダイアログ |
