---
generated_at: 2026-01-23 15:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-パフォーマンスモニターCSV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/debugger/script_editor_debugger.h` 107-110行目 - FileDialogPurpose列挙型定義
- E-02: `editor/debugger/script_editor_debugger.cpp` 181-259行目 - _file_selected()メソッド実装
- E-03: `editor/debugger/script_editor_debugger.cpp` 1390-1395行目 - _export_csv()メソッド実装
- E-04: `editor/debugger/editor_profiler.h` 182行目 - get_data_as_csv()宣言
- E-05: `editor/debugger/editor_profiler.cpp` 600-667行目 - get_data_as_csv()実装
- E-06: `editor/debugger/script_editor_debugger.cpp` 191-198行目 - Performance::MONITOR_MAXの使用
- E-07: `editor/debugger/script_editor_debugger.cpp` 223-226行目 - profiler->get_data_as_csv()呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SAVE_MONITORS_CSV列挙値でCSV出力目的を識別 | E-01 | ○ |
| C-02 | _export_csv()がエクスポートのエントリーポイント | E-03 | ○ |
| C-03 | file_dialog_purposeをSAVE_MONITORS_CSVに設定 | E-03 | ○ |
| C-04 | _file_selected()でファイル選択後のCSV出力を実行 | E-02 | ○ |
| C-05 | FileAccess::openで書き込みモードでファイルを開く | E-02 | ○ |
| C-06 | Performance::MONITOR_MAXを使用してカラム数を決定 | E-06 | ○ |
| C-07 | Performance::get_singleton()->get_monitor_name()でヘッダー取得 | E-02 | ○ |
| C-08 | store_csv_line()でCSV形式で行を出力 | E-02 | ○ |
| C-09 | profiler->get_data_as_csv()でプロファイラーデータ取得 | E-07 | ○ |
| C-10 | EditorProfiler::get_data_as_csv()がVector<Vector<String>>を返却 | E-04, E-05 | ○ |
| C-11 | frame_metricsが空の場合は空のベクターを返す | E-05 | ○ |
| C-12 | possible_signaturesに全シグネチャを収集 | E-05 | ○ |
| C-13 | ファイルオープン失敗時はERR_PRINTでエラー出力 | E-02 | ○ |
| C-14 | ファイルダイアログはACCESS_FILESYSTEMで設定 | E-03 | ○ |
| C-15 | FILE_MODE_SAVE_FILEでファイル保存モード | E-03 | ○ |
| C-16 | プロファイラーデータはモニターデータの後に追記 | E-02 | ○ |
| C-17 | 空行でモニターデータとプロファイラーデータを区切る | E-02 | ○ |
| C-18 | イテレータで時系列データを逆順にトラバース | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して実装コードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SAVE_MONITORS_CSV列挙値が正しく定義されているか確認（script_editor_debugger.h 107行目）
- [ ] _export_csv()のファイルダイアログ設定が正しいか確認（script_editor_debugger.cpp 1390-1395行目）
- [ ] _file_selected()でのCSV出力ロジックが正しいか確認（script_editor_debugger.cpp 181-227行目）
- [ ] get_data_as_csv()の戻り値形式が正しいか確認（editor_profiler.cpp 600-667行目）
