---
generated_at: 2026-01-23 16:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-画像JPG/JPEG

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間（100ms以内）**：ベンチマーク根拠なし
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/jpg/image_loader_libjpeg_turbo.cpp` 行108-189
- E-02: `modules/jpg/image_loader_libjpeg_turbo.h` 行35-40
- E-03: `modules/jpg/register_types.cpp` 行39-56
- E-04: `core/io/image.h` (Image::save_jpg_func 宣言)
- E-05: `core/io/image.cpp` (save_jpg 実装)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | libjpeg-turboを使用してJPEGエンコーディングを行う | E-01 行33 (`#include <turbojpeg.h>`) | ○ |
| C-02 | save_jpg() と save_jpg_to_buffer() メソッドで出力 | E-01 行187-188, E-04 | ○ |
| C-03 | 品質パラメータは0.0〜1.0の範囲 | E-01 行128 (`int(p_quality * 100)`) | ○ |
| C-04 | 4:2:0クロマサブサンプリングを使用 | E-01 行138 (`TJSAMP_420`) | ○ |
| C-05 | ビット深度は8ビット固定 | E-01 行133-136 (`TJPARAM_PRECISION, 8`) | ○ |
| C-06 | RGB8フォーマットに変換して出力 | E-01 行119-123 (`convert(Image::FORMAT_RGB8)`) | ○ |
| C-07 | 圧縮済み画像は解凍処理を行う | E-01 行114-117 (`image->decompress()`) | ○ |
| C-08 | tj3Init(TJINIT_COMPRESS)で初期化 | E-01 行125 | ○ |
| C-09 | tj3Compress8で圧縮実行 | E-01 行148-156 | ○ |
| C-10 | ファイル保存は FileAccess::open を使用 | E-01 行175 | ○ |
| C-11 | モジュール初期化時に関数ポインタを設定 | E-03 行48-50, E-01 行185-189 | ○ |
| C-12 | 拡張子は .jpg と .jpeg をサポート | E-01 行96-97 | ○ |
| C-13 | グレースケール画像のサポート | E-01 行58-65 (読み込み時のみ確認) | ○ |
| C-14 | 品質設定失敗時のエラーメッセージ | E-01 行129-131 | ○ |
| C-15 | 圧縮失敗時のエラーメッセージ | E-01 行161 | ○ |
| C-16 | TurboJPEGのクリーンアップ処理 | E-01 行167-168 | ○ |
| C-17 | 画像の有効性チェック | E-01 行111 | ○ |
| C-18 | 目標出力時間は100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（100ms以内）についてはベンチマーク結果やドキュメントからの根拠が見つからなかった
  - 候補：Godot公式ドキュメント / パフォーマンステスト結果 / libjpeg-turboベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく実装詳細は十分に根拠がある
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] libjpeg-turbo の API 使用方法が正しいか確認
- [ ] エラーハンドリングが網羅的か確認
- [ ] 目標出力時間の根拠を追加調査
- [ ] グレースケール出力時の挙動を実機テストで確認
