---
generated_at: 2026-01-23 16:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-動画PNG連番+WAV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. N/A - すべての主張に根拠あり
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/movie_writer/movie_writer_pngwav.cpp` 行36-172
- E-02: `servers/movie_writer/movie_writer_pngwav.h` 行35-68
- E-03: `servers/movie_writer/movie_writer.h` 行37-95

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PNG連番とWAVファイルで出力 | E-01 行44-45, 85, 148-150 | ○ |
| C-02 | .png拡張子でハンドル | E-01 行47-48 | ○ |
| C-03 | 連番は8桁（MAX_TRAILING_ZEROS = 8） | E-02 行38-39 | ○ |
| C-04 | mix_rateはproject設定から取得 | E-01 行169 | ○ |
| C-05 | speaker_modeはproject設定から取得 | E-01 行170 | ○ |
| C-06 | スピーカーモードでチャンネル数が変わる（2/4/6/8） | E-01 行99-113 | ○ |
| C-07 | ビット深度は32ビット固定 | E-01 行123 | ○ |
| C-08 | PCMフォーマット（圧縮コード=1） | E-01 行116 | ○ |
| C-09 | 既存PNG連番ファイルは自動削除 | E-01 行70-83 | ○ |
| C-10 | base_pathが相対パスの場合res://を付加 | E-01 行66-68 | ○ |
| C-11 | WAVはRIFFヘッダーで開始 | E-01 行90-93 | ○ |
| C-12 | fmtチャンクに16バイト格納 | E-01 行97, 115 | ○ |
| C-13 | dataチャンクにオーディオ格納 | E-01 行135-137 | ○ |
| C-14 | zeros_str関数で8桁連番生成 | E-01 行51-60 | ○ |
| C-15 | write_frameでPNGバッファ生成 | E-01 行146 | ○ |
| C-16 | オーディオブロックサイズは(mix_rate/fps)*blockalign | E-01 行127 | ○ |
| C-17 | write_endでWAVサイズ更新 | E-01 行157-165 | ○ |
| C-18 | f_wavがnullの場合ERR_UNCONFIGURED | E-01 行144 | ○ |
| C-19 | DirAccessでディレクトリ操作 | E-01 行73-82 | ○ |
| C-20 | FileAccessでファイル書き込み | E-01 行85, 148 | ○ |
| C-21 | フレームカウントをインクリメント | E-01 行152 | ○ |
| C-22 | wav_data_size_posでシーク位置を保存 | E-01 行138 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく実装詳細は十分に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] WAVファイル形式がRIFF/WAVE標準に準拠しているか確認
- [ ] 連番ファイル名の生成ロジックが正しいか確認
- [ ] 長時間録画時のディスク容量問題を考慮しているか確認
- [ ] 既存ファイル削除の安全性を確認
