---
generated_at: 2026-01-23 16:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-動画MJPEG AVI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. N/A - すべての主張に根拠あり
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/jpg/movie_writer_mjpeg.cpp` 行35-277
- E-02: `modules/jpg/movie_writer_mjpeg.h` 行35-71
- E-03: `modules/jpg/register_types.cpp` 行39-46
- E-04: `servers/movie_writer/movie_writer.h` 行37-95

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AVI形式で出力 | E-01 行42-44, 58, 66-68 | ○ |
| C-02 | .avi拡張子でハンドル | E-01 行42-44, 47 | ○ |
| C-03 | MJPGコーデックを使用 | E-01 行95, 117 | ○ |
| C-04 | mix_rateはproject設定から取得 | E-01 行272 | ○ |
| C-05 | speaker_modeはproject設定から取得 | E-01 行273 | ○ |
| C-06 | video_qualityはproject設定から取得 | E-01 行274 | ○ |
| C-07 | audio_bit_depthはproject設定から取得 | E-01 行275 | ○ |
| C-08 | スピーカーモードでチャンネル数が変わる（2/4/6/8） | E-01 行139-152 | ○ |
| C-09 | 16ビットまたは32ビットオーディオ | E-01 行137, 211-222 | ○ |
| C-10 | PCMフォーマット（圧縮コード=1） | E-01 行179 | ○ |
| C-11 | RIFFヘッダーで開始 | E-01 行66-68 | ○ |
| C-12 | LIST hdrl にヘッダー情報 | E-01 行69-71 | ○ |
| C-13 | avihチャンクにメインヘッダー | E-01 行72-88 | ○ |
| C-14 | マイクロ秒/フレーム = 1000000/fps | E-01 行75 | ○ |
| C-15 | 映像ストリームはstrl/strh/strf構成 | E-01 行89-123 | ○ |
| C-16 | 音声ストリームはstrl/strh/strf構成 | E-01 行155-184 | ○ |
| C-17 | odml拡張ヘッダー対応 | E-01 行125-134 | ○ |
| C-18 | LIST moviにデータ格納 | E-01 行186-189 | ○ |
| C-19 | 映像は00dbチャンク | E-01 行200 | ○ |
| C-20 | 音声は01wbチャンク | E-01 行209 | ○ |
| C-21 | save_jpg_to_bufferでJPEG圧縮 | E-01 行197 | ○ |
| C-22 | 16ビット時に32→16ビット変換 | E-01 行211-219 | ○ |
| C-23 | idx1インデックスチャンク | E-01 行232-251 | ○ |
| C-24 | write_endでサイズフィールド更新 | E-01 行253-265 | ○ |
| C-25 | フレームサイズをjpg_frame_sizesに記録 | E-01 行207, E-02 行48 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく実装詳細は十分に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] AVIファイル形式がRIFF/AVI標準に準拠しているか確認
- [ ] MJPEG圧縮品質の設定が正しく反映されるか確認
- [ ] 16ビット/32ビットオーディオ切り替えが正しく動作するか確認
- [ ] idx1インデックスの正確性を確認（シーク動作テスト）
- [ ] 4GB超ファイルの取り扱いを確認
