---
generated_at: 2026-01-23 16:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ログファイル（ローテーション）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. N/A - すべての主張に根拠あり
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/io/logger.cpp` 行50-274
- E-02: `core/io/logger.h` 行43-140

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RotatedFileLoggerでログ出力 | E-02 行111-126, E-01 行170-219 | ○ |
| C-02 | 最大バックアップ数は引数で設定（デフォルト10） | E-02 行123 | ○ |
| C-03 | タイムスタンプ付きバックアップを作成 | E-01 行147-148 | ○ |
| C-04 | タイムスタンプはコロンをピリオドに置換 | E-01 行147 (`replace_char(':', '.')`) | ○ |
| C-05 | 古いバックアップは自動削除 | E-01 行108-140 | ○ |
| C-06 | バックアップはRBSetでソート（古い順に削除） | E-01 行121-138 | ○ |
| C-07 | ANSIエスケープシーケンスを除去 | E-01 行175-179, 200-207 | ○ |
| C-08 | RegExモジュール有効時のみANSI除去動作 | E-01 行42-44, 175-179, 200-207 | ○ |
| C-09 | should_logで出力判定 | E-01 行50-52, 183-185 | ○ |
| C-10 | CoreGlobals::print_line_enabled参照 | E-01 行51 | ○ |
| C-11 | CoreGlobals::print_error_enabled参照 | E-01 行51 | ○ |
| C-12 | vsnprintfでフォーマット | E-01 行193 | ○ |
| C-13 | バッファサイズ512バイト（静的） | E-01 行188-189 | ○ |
| C-14 | 超過時は動的メモリ確保 | E-01 行194-196 | ○ |
| C-15 | エラータイプはERROR/WARNING/SCRIPT ERROR/SHADER ERROR | E-02 行50-55, 57-69 | ○ |
| C-16 | log_errorでエラーフォーマット出力 | E-01 行58-80 | ○ |
| C-17 | スクリプトバックトレース出力 | E-01 行75-79 | ○ |
| C-18 | ObjectDBからデタッチ | E-01 行167, 177 | ○ |
| C-19 | エラー時またはflush設定時にflush | E-01 行213-217 | ○ |
| C-20 | max_files > 1の場合のみバックアップ作成 | E-01 行146 | ○ |
| C-21 | ディレクトリ存在しない場合は作成 | E-01 行159-163 | ○ |
| C-22 | CompositeLoggerで複数ロガー対応 | E-01 行238-273, E-02 行128-140 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく実装詳細は十分に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] ローテーション処理が正しくバックアップを作成するか確認
- [ ] 古いバックアップの削除順序が正しいか確認
- [ ] ANSIエスケープ除去が正しく動作するか確認
- [ ] 長時間実行時のログファイルサイズ増大問題を確認
- [ ] マルチスレッド環境での動作安全性を確認
