---
generated_at: 2026-01-23 16:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-プロジェクトZIP

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. N/A - すべての主張に根拠あり
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/export/project_zip_packer.cpp` 行39-138
- E-02: `editor/export/project_zip_packer.h` 行36-43

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ZIP形式でプロジェクトをパッケージ化 | E-01 行59-61 | ○ |
| C-02 | pack_project_zipがエントリーポイント | E-01 行52-62, E-02 行42 | ○ |
| C-03 | プロジェクトデータディレクトリを除外 | E-01 行106, 109 | ○ |
| C-04 | "."と".."を除外 | E-01 行109 | ○ |
| C-05 | DEFLATE圧縮を使用 | E-01 行84, 121 | ○ |
| C-06 | Z_DEFAULT_COMPRESSION圧縮レベル | E-01 行85, 122 | ○ |
| C-07 | UTF-8ファイル名エンコーディング（ビット11） | E-01 行93, 130 | ○ |
| C-08 | Unix互換バージョン（0x0314） | E-01 行92, 129 | ○ |
| C-09 | プロジェクト名を安全な形式に変換 | E-01 行44-45 (`to_lower().replace_char(' ', '_')`) | ○ |
| C-10 | 日時を安全な形式に変換 | E-01 行46-47 (`replace_char(' ', '_')`) | ○ |
| C-11 | get_safe_dir_nameでファイル名サニタイズ | E-01 行48 | ○ |
| C-12 | _zip_recursiveで再帰的に走査 | E-01 行60, 98-138 | ○ |
| C-13 | _zip_fileでファイル追加 | E-01 行64-96, 134 | ○ |
| C-14 | DirAccessでディレクトリ操作 | E-01 行73, 99, 153 | ○ |
| C-15 | FileAccessでファイル読み込み | E-01 行65 | ○ |
| C-16 | zipOpenNewFileInZip4でエントリ作成 | E-01 行76-93, 113-130 | ○ |
| C-17 | zipWriteInFileInZipでデータ書き込み | E-01 行94 | ○ |
| C-18 | zipCloseFileInZipでエントリ完了 | E-01 行95, 131 | ○ |
| C-19 | ディレクトリエントリは末尾にスラッシュ付加 | E-01 行112 (`+ "/"`) | ○ |
| C-20 | ベースパスからトリムして相対パス取得 | E-01 行75, 112 (`trim_prefix`) | ○ |

## 4) 不足情報（Unknown / Missing）
- すべての主張に根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく実装詳細は十分に根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] ZIP形式が標準に準拠しているか確認
- [ ] プロジェクトデータディレクトリの除外が正しく動作するか確認
- [ ] 大規模プロジェクトでのメモリ使用量を確認
- [ ] 日本語ファイル名の取り扱いを確認（UTF-8エンコーディング）
- [ ] Windows/macOS/Linuxでの展開互換性を確認
