---
generated_at: 2026-01-23 15:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-VRAMメモリ使用量CSV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/debugger/script_editor_debugger.h` 108行目 - SAVE_VRAM_CSV列挙値定義
- E-02: `editor/debugger/script_editor_debugger.cpp` 324-330行目 - _video_mem_export()メソッド実装
- E-03: `editor/debugger/script_editor_debugger.cpp` 228-257行目 - _file_selected()のSAVE_VRAM_CSVケース
- E-04: `editor/debugger/script_editor_debugger.cpp` 320-322行目 - _video_mem_request()実装
- E-05: `editor/debugger/script_editor_debugger.cpp` 237-242行目 - ヘッダー行構築処理
- E-06: `editor/debugger/script_editor_debugger.cpp` 244-256行目 - TreeItemトラバース処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SAVE_VRAM_CSV列挙値でVRAM CSV出力を識別 | E-01 | ○ |
| C-02 | _video_mem_export()がエクスポートのエントリーポイント | E-02 | ○ |
| C-03 | file_dialog_purposeをSAVE_VRAM_CSVに設定 | E-02 | ○ |
| C-04 | FILE_MODE_SAVE_FILEでファイル保存モード設定 | E-02 | ○ |
| C-05 | ACCESS_FILESYSTEMでファイルシステムアクセス設定 | E-02 | ○ |
| C-06 | _file_selected()でSAVE_VRAM_CSVケースの処理 | E-03 | ○ |
| C-07 | FileAccess::openで書き込みモードでファイルを開く | E-03 | ○ |
| C-08 | ファイルオープン失敗時ERR_PRINTでエラー出力 | E-03 | ○ |
| C-09 | vmem_tree->get_columns()でカラム数取得 | E-05 | ○ |
| C-10 | vmem_tree->get_column_title(i)でヘッダー取得 | E-05 | ○ |
| C-11 | vmem_tree->get_root()からTreeItemをトラバース | E-06 | ○ |
| C-12 | ti->get_text(i)で各セルのテキスト取得 | E-06 | ○ |
| C-13 | store_csv_line()でCSV形式で行を出力 | E-03, E-05, E-06 | ○ |
| C-14 | "servers:memory"メッセージでVRAMデータ要求 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して実装コードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SAVE_VRAM_CSV列挙値が正しく定義されているか確認（script_editor_debugger.h 108行目）
- [ ] _video_mem_export()のファイルダイアログ設定が正しいか確認（script_editor_debugger.cpp 324-330行目）
- [ ] _file_selected()でのVRAM CSV出力ロジックが正しいか確認（script_editor_debugger.cpp 228-257行目）
- [ ] vmem_treeからのデータ取得が正しいか確認
