---
generated_at: 2026-01-23 15:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-スクリプトプロファイラーCSV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/debugger/editor_profiler.h` 182行目 - get_data_as_csv()メソッド宣言
- E-02: `editor/debugger/editor_profiler.cpp` 600-667行目 - get_data_as_csv()実装
- E-03: `editor/debugger/editor_profiler.cpp` 603-605行目 - frame_metrics空チェック
- E-04: `editor/debugger/editor_profiler.cpp` 608-620行目 - possible_signaturesへのシグネチャ収集
- E-05: `editor/debugger/editor_profiler.cpp` 623-632行目 - sig_mapとヘッダー行構築
- E-06: `editor/debugger/editor_profiler.cpp` 637-664行目 - フレームデータ出力ループ
- E-07: `editor/debugger/script_editor_debugger.cpp` 223行目 - get_data_as_csv()呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_data_as_csv()がVector<Vector<String>>を返却 | E-01 | ○ |
| C-02 | frame_metricsが空の場合は空のVectorを返却 | E-03 | ○ |
| C-03 | 全フレームからシグネチャを収集してpossible_signaturesに格納 | E-04 | ○ |
| C-04 | category_ptrsからシグネチャを収集 | E-04 | ○ |
| C-05 | item_ptrsからシグネチャを収集 | E-04 | ○ |
| C-06 | sig_mapでシグネチャからインデックスへのマッピングを構築 | E-05 | ○ |
| C-07 | signaturesをヘッダー行としてresに追加 | E-05 | ○ |
| C-08 | last_metricから循環的にフレームデータを出力 | E-06 | ○ |
| C-09 | Metric::validがfalseのフレームはスキップ | E-06 | ○ |
| C-10 | category_ptrs経由でtotal_timeを取得 | E-06 | ○ |
| C-11 | item_ptrs経由でtotalを取得 | E-06 | ○ |
| C-12 | String::num_realで実数を文字列化 | E-06 | ○ |
| C-13 | パフォーマンスモニターCSVの一部として出力 | E-07 | ○ |
| C-14 | profiler->get_data_as_csv()で呼び出される | E-07 | ○ |
| C-15 | 空のセルは対応シグネチャがそのフレームに存在しなかったことを示す | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して実装コードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] get_data_as_csv()の戻り値型が正しいか確認（editor_profiler.h 182行目）
- [ ] frame_metrics空チェックが正しいか確認（editor_profiler.cpp 603-605行目）
- [ ] シグネチャ収集ロジックが正しいか確認（editor_profiler.cpp 608-620行目）
- [ ] フレームデータ出力ループが正しいか確認（editor_profiler.cpp 637-664行目）
