---
generated_at: 2026-01-23 16:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-翻訳テンプレートPOT

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/translations/template_generator.cpp` 102-124行目 - generate()メソッド実装
- E-02: `editor/translations/template_generator.cpp` 37-99行目 - parse()メソッド実装
- E-03: `editor/translations/template_generator.cpp` 152-214行目 - _write_to_pot()メソッド実装
- E-04: `editor/translations/template_generator.cpp` 103-104行目 - プロジェクト設定取得
- E-05: `editor/translations/template_generator.cpp` 153-174行目 - POTヘッダー生成
- E-06: `editor/translations/template_generator.cpp` 176-213行目 - エントリ出力ループ
- E-07: `editor/translations/template_generator.cpp` 107-110行目 - map空チェックと警告
- E-08: `editor/translations/template_generator.cpp` 44-46行目 - EditorTranslationParser使用
- E-09: `editor/translations/template_generator.cpp` 64-68行目 - 組み込み文字列追加

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | generate()がエントリーポイント | E-01 | ○ |
| C-02 | GLOBAL_GETでtranslations_pot_files取得 | E-04 | ○ |
| C-03 | GLOBAL_GETでtranslation_add_builtin_strings_to_pot取得 | E-04 | ○ |
| C-04 | parse()でファイルを解析しMessageMapを構築 | E-02 | ○ |
| C-05 | EditorTranslationParser経由でファイル解析 | E-08 | ○ |
| C-06 | add_builtinフラグで組み込み文字列追加 | E-09 | ○ |
| C-07 | map空時にWARN_PRINT_ED出力 | E-07 | ○ |
| C-08 | 拡張子.potで_write_to_pot()呼び出し | E-01 | ○ |
| C-09 | POTヘッダーにProject-Id-Versionを出力 | E-05 | ○ |
| C-10 | #. TRANSLATORS:形式でコメント出力 | E-06 | ○ |
| C-11 | #:形式でファイル位置出力 | E-06 | ○ |
| C-12 | msgctxtでコンテキスト出力 | E-06 | ○ |
| C-13 | msgidで原文出力 | E-06 | ○ |
| C-14 | plural存在時にmsgid_plural出力 | E-06 | ○ |
| C-15 | plural存在時にmsgstr[0]/msgstr[1]出力 | E-06 | ○ |
| C-16 | plural非存在時にmsgstr出力 | E-06 | ○ |
| C-17 | json_escape()でエスケープ処理 | E-03, E-06 | ○ |
| C-18 | 複数形定義が異なる場合は警告出力 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して実装コードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] generate()のファイル処理フローが正しいか確認（template_generator.cpp 102-124行目）
- [ ] parse()のファイル解析ロジックが正しいか確認（template_generator.cpp 37-99行目）
- [ ] _write_to_pot()のPOT出力形式が正しいか確認（template_generator.cpp 152-214行目）
- [ ] POTヘッダーの形式がGettext仕様に準拠しているか確認
