---
generated_at: 2026-01-23 16:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-翻訳テンプレートCSV

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/translations/template_generator.cpp` 229-283行目 - _write_to_csv()メソッド実装
- E-02: `editor/translations/template_generator.cpp` 231-250行目 - カラム使用判定ループ
- E-03: `editor/translations/template_generator.cpp` 252-264行目 - ヘッダー行構築
- E-04: `editor/translations/template_generator.cpp` 267-281行目 - データ行ループ
- E-05: `editor/translations/template_generator.cpp` 216-227行目 - _join_strings()実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _write_to_csv()でCSV出力を実行 | E-01 | ○ |
| C-02 | 使用カラムを判定するループ処理がある | E-02 | ○ |
| C-03 | context_usedフラグでコンテキスト列の有無を判定 | E-02 | ○ |
| C-04 | plural_usedフラグで複数形列の有無を判定 | E-02 | ○ |
| C-05 | comments_usedフラグでコメント列の有無を判定 | E-02 | ○ |
| C-06 | locations_usedフラグで位置情報列の有無を判定 | E-02 | ○ |
| C-07 | ヘッダー行は"key"から始まる | E-03 | ○ |
| C-08 | context使用時に"?context"を追加 | E-03 | ○ |
| C-09 | plural使用時に"?plural"を追加 | E-03 | ○ |
| C-10 | comments使用時に"_comments"を追加 | E-03 | ○ |
| C-11 | locations使用時に"_locations"を追加 | E-03 | ○ |
| C-12 | store_csv_line()でヘッダーとデータ行を出力 | E-01, E-04 | ○ |
| C-13 | _join_strings()で複数文字列を改行結合 | E-05 | ○ |
| C-14 | カラムは使用されている場合のみ出力 | E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して実装コードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] _write_to_csv()のカラム判定ロジックが正しいか確認（template_generator.cpp 231-250行目）
- [ ] ヘッダー行構築が正しいか確認（template_generator.cpp 252-264行目）
- [ ] データ行ループが正しいか確認（template_generator.cpp 267-281行目）
- [ ] _join_strings()の結合処理が正しいか確認（template_generator.cpp 216-227行目）
