---
generated_at: 2026-01-23 16:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-GDExtension API JSON

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `main/main.cpp` 4161-4166行目 - dump_extension_apiフラグ処理
- E-02: `main/main.cpp` 4163行目 - generate_extension_json_file()呼び出し
- E-03: `core/extension/extension_api_dump.cpp` 1331-1340行目 - generate_extension_json_file()実装
- E-04: `core/extension/extension_api_dump.cpp` 103-1328行目 - generate_extension_api()実装
- E-05: `core/extension/extension_api_dump.cpp` 106-127行目 - ヘッダー情報生成
- E-06: `core/extension/extension_api_dump.cpp` 135-277行目 - 組み込み型サイズ情報
- E-07: `core/extension/extension_api_dump.cpp` 1336行目 - JSON::stringify()呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --dump-extension-apiコマンドライン引数で出力 | E-01 | ○ |
| C-02 | Engine::set_editor_hint(true)が設定される | E-01 | ○ |
| C-03 | generate_extension_json_file()が呼び出される | E-02 | ○ |
| C-04 | 出力ファイル名はextension_api.json | E-02 | ○ |
| C-05 | generate_extension_api()でDictionary生成 | E-03, E-04 | ○ |
| C-06 | JSON::stringify()でJSON文字列化 | E-07 | ○ |
| C-07 | ヘッダーにGODOT_VERSION_*情報を含む | E-05 | ○ |
| C-08 | precision情報（single/double）を含む | E-05 | ○ |
| C-09 | builtin_class_sizes情報を生成 | E-06 | ○ |
| C-10 | type_size_array[]から型サイズを取得 | E-06 | ○ |
| C-11 | ビルド構成（float_32等）で型サイズが異なる | E-06 | ○ |
| C-12 | FileAccess::openでファイル出力 | E-03 | ○ |
| C-13 | store_string()でJSON文字列を書き込み | E-03 | ○ |
| C-14 | インデントはタブ（\t） | E-07 | ○ |
| C-15 | p_include_docsでドキュメント含有を制御 | E-04 | ○ |
| C-16 | ファイルオープン失敗時ERR_FAIL_COND_MSG | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して実装コードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] main.cppでのdump_extension_api処理が正しいか確認（main.cpp 4161-4166行目）
- [ ] generate_extension_json_file()のファイル出力が正しいか確認（extension_api_dump.cpp 1331-1340行目）
- [ ] generate_extension_api()のAPI情報収集が正しいか確認
- [ ] JSON出力形式が仕様通りか確認
