---
generated_at: 2026-01-23 16:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-3DシーンGLTF/GLB

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` 51-80行目 - コンストラクタ実装
- E-02: `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` 95-109行目 - _popup_gltf_export_dialog()
- E-03: `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` 82-93行目 - _popup_gltf_settings_dialog()
- E-04: `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` 111-130行目 - _export_scene_as_gltf()
- E-05: `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` 60-61行目 - .glb/.gltfフィルター追加
- E-06: `modules/gltf/editor/editor_scene_exporter_gltf_plugin.cpp` 121-128行目 - append_from_scene/write_to_filesystem

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでGLTFDocumentをinstantiate | E-01 | ○ |
| C-02 | ファイルダイアログに.glb/.gltfフィルター追加 | E-05 | ○ |
| C-03 | メニューに「glTF 2.0 Scene...」追加 | E-01 | ○ |
| C-04 | _popup_gltf_export_dialog()がエクスポートダイアログ表示 | E-02 | ○ |
| C-05 | シーン未開時に警告表示 | E-02 | ○ |
| C-06 | ファイル名をシーン名から設定 | E-02 | ○ |
| C-07 | _popup_gltf_settings_dialog()で設定ダイアログ表示 | E-03 | ○ |
| C-08 | _export_scene_as_gltf()でエクスポート実行 | E-04 | ○ |
| C-09 | GLTFState::instantiate()でステート初期化 | E-04 | ○ |
| C-10 | state->set_copyright()で著作権設定 | E-04 | ○ |
| C-11 | state->set_bake_fps()でFPS設定 | E-04 | ○ |
| C-12 | GLTFDocument::append_from_scene()でシーン解析 | E-06 | ○ |
| C-13 | GLTFDocument::write_to_filesystem()でファイル出力 | E-06 | ○ |
| C-14 | エラー時にERR_PRINT出力 | E-04 | ○ |
| C-15 | EditorFileSystem::scan_changes()でファイルシステム更新 | E-04 | ○ |
| C-16 | IMPORT_USE_NAMED_SKIN_BINDSフラグを設定 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張に対して実装コードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] コンストラクタのファイルダイアログ設定が正しいか確認（editor_scene_exporter_gltf_plugin.cpp 51-80行目）
- [ ] _popup_gltf_export_dialog()のシーンチェックが正しいか確認（editor_scene_exporter_gltf_plugin.cpp 95-109行目）
- [ ] _export_scene_as_gltf()のエクスポート処理が正しいか確認（editor_scene_exporter_gltf_plugin.cpp 111-130行目）
- [ ] GLTFDocument::append_from_scene()とwrite_to_filesystem()の呼び出しが正しいか確認
